/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.equivalence.Equivalence;
import org.infinispan.container.DataContainer;
import org.infinispan.container.DefaultDataContainer;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.eviction.EvictionThreadPolicy;
import org.infinispan.factories.AbstractNamedCacheComponentFactory;
import org.infinispan.factories.AutoInstantiableFactory;
import org.infinispan.factories.annotations.DefaultFactoryFor;

@DefaultFactoryFor(classes={DataContainer.class})
public class DataContainerFactory
extends AbstractNamedCacheComponentFactory
implements AutoInstantiableFactory {
    @Override
    public <T> T construct(Class<T> componentType) {
        if (this.configuration.dataContainer().dataContainer() != null) {
            return (T)this.configuration.dataContainer().dataContainer();
        }
        EvictionStrategy st = this.configuration.eviction().strategy();
        int level = this.configuration.locking().concurrencyLevel();
        Equivalence keyEquivalence = this.configuration.dataContainer().keyEquivalence();
        switch (st) {
            case NONE: {
                return (T)DefaultDataContainer.unBoundedDataContainer(level, keyEquivalence);
            }
            case UNORDERED: 
            case LRU: 
            case FIFO: 
            case LIRS: {
                int maxEntries = this.configuration.eviction().maxEntries();
                if (maxEntries < 0) {
                    return (T)DefaultDataContainer.unBoundedDataContainer(level, keyEquivalence);
                }
                EvictionThreadPolicy policy = this.configuration.eviction().threadPolicy();
                return (T)DefaultDataContainer.boundedDataContainer(level, maxEntries, st, policy, keyEquivalence);
            }
        }
        throw new CacheConfigurationException("Unknown eviction strategy " + (Object)((Object)this.configuration.eviction().strategy()));
    }
}

