/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.topology;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.util.InfinispanCollections;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class CacheTopology {
    private static Log log = LogFactory.getLog(CacheTopology.class);
    private static final boolean trace = log.isTraceEnabled();
    private final int topologyId;
    private final int rebalanceId;
    private final ConsistentHash currentCH;
    private final ConsistentHash pendingCH;
    private final transient ConsistentHash unionCH;

    public CacheTopology(int topologyId, int rebalanceId, ConsistentHash currentCH, ConsistentHash pendingCH) {
        this(topologyId, rebalanceId, currentCH, pendingCH, null);
    }

    public CacheTopology(int topologyId, int rebalanceId, ConsistentHash currentCH, ConsistentHash pendingCH, ConsistentHash unionCH) {
        if (pendingCH != null && !pendingCH.getMembers().containsAll(currentCH.getMembers())) {
            throw new IllegalArgumentException("A cache topology's pending consistent hash must contain all the current consistent hash's members");
        }
        this.topologyId = topologyId;
        this.currentCH = currentCH;
        this.pendingCH = pendingCH;
        this.unionCH = unionCH;
        this.rebalanceId = rebalanceId;
    }

    public int getTopologyId() {
        return this.topologyId;
    }

    public ConsistentHash getCurrentCH() {
        return this.currentCH;
    }

    public ConsistentHash getPendingCH() {
        return this.pendingCH;
    }

    public ConsistentHash getUnionCH() {
        return this.unionCH;
    }

    public int getRebalanceId() {
        return this.rebalanceId;
    }

    public List<Address> getMembers() {
        if (this.pendingCH != null) {
            return this.pendingCH.getMembers();
        }
        if (this.currentCH != null) {
            return this.currentCH.getMembers();
        }
        return InfinispanCollections.emptyList();
    }

    public ConsistentHash getReadConsistentHash() {
        return this.currentCH;
    }

    public ConsistentHash getWriteConsistentHash() {
        if (this.pendingCH != null) {
            if (this.unionCH == null) {
                throw new IllegalStateException("Need a union CH when a pending CH is set");
            }
            return this.unionCH;
        }
        return this.currentCH;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CacheTopology that = (CacheTopology)o;
        if (this.topologyId != that.topologyId) {
            return false;
        }
        if (this.rebalanceId != that.rebalanceId) {
            return false;
        }
        if (this.currentCH != null ? !this.currentCH.equals(that.currentCH) : that.currentCH != null) {
            return false;
        }
        if (this.pendingCH != null ? !this.pendingCH.equals(that.pendingCH) : that.pendingCH != null) {
            return false;
        }
        return !(this.unionCH != null ? !this.unionCH.equals(that.unionCH) : that.unionCH != null);
    }

    public int hashCode() {
        int result = this.topologyId;
        result = 31 * result + this.rebalanceId;
        result = 31 * result + (this.currentCH != null ? this.currentCH.hashCode() : 0);
        result = 31 * result + (this.pendingCH != null ? this.pendingCH.hashCode() : 0);
        result = 31 * result + (this.unionCH != null ? this.unionCH.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "CacheTopology{id=" + this.topologyId + ", rebalanceId=" + this.rebalanceId + ", currentCH=" + this.currentCH + ", pendingCH=" + this.pendingCH + ", unionCH=" + this.unionCH + '}';
    }

    public final void logRoutingTableInformation() {
        if (trace) {
            log.tracef("Current consistent hash's routing table: %s", this.currentCH.getRoutingTableAsString());
            if (this.pendingCH != null) {
                log.tracef("Pending consistent hash's routing table: %s", this.pendingCH.getRoutingTableAsString());
            }
            if (this.unionCH != null) {
                log.tracef("Union consistent hash's routing table: %s", this.unionCH.getRoutingTableAsString());
            }
        }
    }

    public static class Externalizer
    extends AbstractExternalizer<CacheTopology> {
        public void writeObject(ObjectOutput output, CacheTopology cacheTopology) throws IOException {
            output.writeInt(cacheTopology.topologyId);
            output.writeInt(cacheTopology.rebalanceId);
            output.writeObject(cacheTopology.currentCH);
            output.writeObject(cacheTopology.pendingCH);
            output.writeObject(cacheTopology.unionCH);
        }

        public CacheTopology readObject(ObjectInput unmarshaller) throws IOException, ClassNotFoundException {
            int topologyId = unmarshaller.readInt();
            int rebalanceId = unmarshaller.readInt();
            ConsistentHash currentCH = (ConsistentHash)unmarshaller.readObject();
            ConsistentHash pendingCH = (ConsistentHash)unmarshaller.readObject();
            ConsistentHash unionCH = (ConsistentHash)unmarshaller.readObject();
            return new CacheTopology(topologyId, rebalanceId, currentCH, pendingCH, unionCH);
        }

        public Integer getId() {
            return 75;
        }

        public Set<Class<? extends CacheTopology>> getTypeClasses() {
            return Collections.singleton(CacheTopology.class);
        }
    }
}

