/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.TransactionSynchronizationRegistry;
import net.jcip.annotations.GuardedBy;
import org.infinispan.Cache;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.equivalence.AnyEquivalence;
import org.infinispan.commons.equivalence.Equivalence;
import org.infinispan.commons.equivalence.IdentityEquivalence;
import org.infinispan.commons.util.CollectionFactory;
import org.infinispan.commons.util.InfinispanCollections;
import org.infinispan.commons.util.Util;
import org.infinispan.commons.util.concurrent.jdk8backported.EquivalentConcurrentHashMapV8;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.Configurations;
import org.infinispan.context.InvocationContextFactory;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.interceptors.InterceptorChain;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.notifications.cachelistener.annotation.TopologyChanged;
import org.infinispan.notifications.cachelistener.event.TopologyChangedEvent;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.topology.CacheTopology;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.impl.LocalTransaction;
import org.infinispan.transaction.impl.RemoteTransaction;
import org.infinispan.transaction.impl.TransactionCoordinator;
import org.infinispan.transaction.synchronization.SyncLocalTransaction;
import org.infinispan.transaction.synchronization.SynchronizationAdapter;
import org.infinispan.transaction.xa.CacheTransaction;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.transaction.xa.TransactionFactory;
import org.infinispan.util.TimeService;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Listener
public class TransactionTable
implements org.infinispan.transaction.TransactionTable {
    public static final int CACHE_STOPPED_TOPOLOGY_ID = -1;
    private volatile int minTxTopologyId = -1;
    private volatile int currentTopologyId = -1;
    private static final Log log = LogFactory.getLog(TransactionTable.class);
    protected Configuration configuration;
    protected InvocationContextFactory icf;
    protected TransactionCoordinator txCoordinator;
    protected TransactionFactory txFactory;
    protected RpcManager rpcManager;
    protected CommandsFactory commandsFactory;
    protected ClusteringDependentLogic clusteringLogic;
    protected boolean clustered = false;
    private ConcurrentMap<Transaction, LocalTransaction> localTransactions;
    private ConcurrentMap<GlobalTransaction, LocalTransaction> globalToLocalTransactions;
    private ConcurrentMap<GlobalTransaction, RemoteTransaction> remoteTransactions;
    private InterceptorChain invoker;
    private CacheNotifier notifier;
    private TransactionSynchronizationRegistry transactionSynchronizationRegistry;
    private Lock minTopologyRecalculationLock;
    private CompletedTransactionsInfo completedTransactionsInfo;
    private ScheduledExecutorService executorService;
    private String cacheName;
    private TimeService timeService;

    @Inject
    public void initialize(RpcManager rpcManager, Configuration configuration, InvocationContextFactory icf, InterceptorChain invoker, CacheNotifier notifier, TransactionFactory gtf, TransactionCoordinator txCoordinator, TransactionSynchronizationRegistry transactionSynchronizationRegistry, CommandsFactory commandsFactory, ClusteringDependentLogic clusteringDependentLogic, Cache cache, TimeService timeService) {
        this.rpcManager = rpcManager;
        this.configuration = configuration;
        this.icf = icf;
        this.invoker = invoker;
        this.notifier = notifier;
        this.txFactory = gtf;
        this.txCoordinator = txCoordinator;
        this.transactionSynchronizationRegistry = transactionSynchronizationRegistry;
        this.commandsFactory = commandsFactory;
        this.clusteringLogic = clusteringDependentLogic;
        this.cacheName = cache.getName();
        this.timeService = timeService;
    }

    @Start(priority=9)
    public void start() {
        int concurrencyLevel = this.configuration.locking().concurrencyLevel();
        this.localTransactions = CollectionFactory.makeConcurrentMap((int)concurrencyLevel, (float)0.75f, (int)concurrencyLevel, (Equivalence)new IdentityEquivalence(), (Equivalence)AnyEquivalence.getInstance());
        this.globalToLocalTransactions = CollectionFactory.makeConcurrentMap((int)concurrencyLevel, (float)0.75f, (int)concurrencyLevel);
        if (this.configuration.clustering().cacheMode().isClustered()) {
            this.minTopologyRecalculationLock = new ReentrantLock();
            this.remoteTransactions = CollectionFactory.makeConcurrentMap((int)concurrencyLevel, (float)0.75f, (int)concurrencyLevel);
            this.notifier.addListener(this);
            this.clustered = true;
        }
        boolean transactional = this.configuration.transaction().transactionMode().isTransactional();
        boolean totalOrder = this.configuration.transaction().transactionProtocol().isTotalOrder();
        if (this.clustered && transactional && !totalOrder) {
            this.completedTransactionsInfo = new CompletedTransactionsInfo();
            ThreadFactory tf = new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    String address = TransactionTable.this.rpcManager != null ? TransactionTable.this.rpcManager.getTransport().getAddress().toString() : "local";
                    Thread th = new Thread(r, "TxCleanupService," + TransactionTable.this.cacheName + "," + address);
                    th.setDaemon(true);
                    return th;
                }
            };
            this.executorService = Executors.newSingleThreadScheduledExecutor(tf);
            long interval = this.configuration.transaction().reaperWakeUpInterval();
            this.executorService.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    TransactionTable.this.completedTransactionsInfo.cleanupCompletedTransactions();
                }
            }, interval, interval, TimeUnit.MILLISECONDS);
            this.executorService.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    TransactionTable.this.cleanupTimedOutTransactions();
                }
            }, interval, interval, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public GlobalTransaction getGlobalTransaction(Transaction transaction) {
        if (transaction == null) {
            throw new NullPointerException("Transaction must not be null.");
        }
        LocalTransaction localTransaction = (LocalTransaction)this.localTransactions.get(transaction);
        return localTransaction != null ? localTransaction.getGlobalTransaction() : null;
    }

    @Override
    public Collection<GlobalTransaction> getLocalGlobalTransaction() {
        return Collections.unmodifiableCollection(this.globalToLocalTransactions.keySet());
    }

    @Override
    public Collection<GlobalTransaction> getRemoteGlobalTransaction() {
        return Collections.unmodifiableCollection(this.remoteTransactions.keySet());
    }

    @Stop
    private void stop() {
        if (this.executorService != null) {
            this.executorService.shutdownNow();
        }
        if (this.clustered) {
            this.notifier.removeListener(this);
            this.currentTopologyId = -1;
        }
        this.shutDownGracefully();
    }

    public Set<Object> getLockedKeysForRemoteTransaction(GlobalTransaction gtx) {
        RemoteTransaction transaction = (RemoteTransaction)this.remoteTransactions.get(gtx);
        if (transaction == null) {
            return InfinispanCollections.emptySet();
        }
        return transaction.getLockedKeys();
    }

    public void remoteTransactionPrepared(GlobalTransaction gtx) {
    }

    public void localTransactionPrepared(LocalTransaction localTransaction) {
    }

    public void enlist(Transaction transaction, LocalTransaction localTransaction) {
        if (!localTransaction.isEnlisted()) {
            SynchronizationAdapter sync = new SynchronizationAdapter(localTransaction, this.txCoordinator, this.commandsFactory, this.rpcManager, this, this.clusteringLogic, this.configuration);
            if (this.transactionSynchronizationRegistry != null) {
                try {
                    this.transactionSynchronizationRegistry.registerInterposedSynchronization((Synchronization)sync);
                }
                catch (Exception e) {
                    log.failedSynchronizationRegistration(e);
                    throw new CacheException((Throwable)e);
                }
            }
            try {
                transaction.registerSynchronization((Synchronization)sync);
            }
            catch (Exception e) {
                log.failedSynchronizationRegistration(e);
                throw new CacheException((Throwable)e);
            }
            ((SyncLocalTransaction)localTransaction).setEnlisted(true);
        }
    }

    public void failureCompletingTransaction(Transaction tx) {
        LocalTransaction localTransaction = (LocalTransaction)this.localTransactions.get(tx);
        if (localTransaction != null) {
            this.removeLocalTransaction(localTransaction);
        }
    }

    public boolean containsLocalTx(Transaction tx) {
        return tx != null && this.localTransactions.containsKey(tx);
    }

    public int getMinTopologyId() {
        return this.minTxTopologyId;
    }

    public void cleanupLeaverTransactions(CacheTopology cacheTopology) {
        int topologyId = cacheTopology.getTopologyId();
        List<Address> members = cacheTopology.getMembers();
        if (this.getMinTopologyId() >= topologyId) {
            return;
        }
        log.tracef("Checking for transactions originated on leavers. Current members are %s, remote transactions: %d", members, this.remoteTransactions.size());
        ArrayList<GlobalTransaction> toKill = new ArrayList<GlobalTransaction>();
        for (Map.Entry e : this.remoteTransactions.entrySet()) {
            GlobalTransaction gt = (GlobalTransaction)e.getKey();
            RemoteTransaction remoteTx = (RemoteTransaction)e.getValue();
            log.tracef("Checking transaction %s", gt);
            if (remoteTx.getTopologyId() >= topologyId || members.contains(gt.getAddress())) continue;
            toKill.add(gt);
        }
        if (toKill.isEmpty()) {
            log.tracef("No remote transactions pertain to originator(s) who have left the cluster.", new Object[0]);
        } else {
            log.debugf("The originating node left the cluster for %d remote transactions", toKill.size());
        }
        for (GlobalTransaction gtx : toKill) {
            log.debugf("Rolling back transaction %s because originator %s left the cluster", gtx, gtx.getAddress());
            this.killTransaction(gtx);
        }
        log.tracef("Completed cleaning transactions originating on leavers. Remote transactions remaining: %d", this.remoteTransactions.size());
    }

    public void cleanupTimedOutTransactions() {
        log.tracef("About to cleanup remote transactions older than %d ms", this.configuration.transaction().completedTxTimeout());
        long beginning = this.timeService.time();
        long cutoffCreationTime = beginning - TimeUnit.MILLISECONDS.toNanos(this.configuration.transaction().completedTxTimeout());
        ArrayList<GlobalTransaction> toKill = new ArrayList<GlobalTransaction>();
        for (Map.Entry e : this.remoteTransactions.entrySet()) {
            GlobalTransaction gtx = (GlobalTransaction)e.getKey();
            RemoteTransaction remoteTx = (RemoteTransaction)e.getValue();
            if (remoteTx == null) continue;
            log.tracef("Checking transaction %s", gtx);
            if (remoteTx.getCreationTime() - cutoffCreationTime >= 0L) continue;
            long duration = this.timeService.timeDuration(remoteTx.getCreationTime(), beginning, TimeUnit.MILLISECONDS);
            log.remoteTransactionTimeout(gtx, duration);
            toKill.add(gtx);
        }
        for (GlobalTransaction gtx : toKill) {
            this.killTransaction(gtx);
        }
    }

    private void killTransaction(GlobalTransaction gtx) {
        RollbackCommand rc = new RollbackCommand(this.cacheName, gtx);
        rc.init(this.invoker, this.icf, this);
        try {
            rc.perform(null);
            log.tracef("Rollback of transaction %s complete.", gtx);
        }
        catch (Throwable e) {
            log.unableToRollbackGlobalTx(gtx, e);
        }
    }

    public RemoteTransaction getRemoteTransaction(GlobalTransaction txId) {
        return (RemoteTransaction)this.remoteTransactions.get(txId);
    }

    public void remoteTransactionRollback(GlobalTransaction gtx) {
        RemoteTransaction remove = this.removeRemoteTransaction(gtx);
        log.tracef("Removed local transaction %s? %b", gtx, remove);
    }

    public RemoteTransaction getOrCreateRemoteTransaction(GlobalTransaction globalTx, WriteCommand[] modifications) {
        return this.getOrCreateRemoteTransaction(globalTx, modifications, this.currentTopologyId);
    }

    private RemoteTransaction getOrCreateRemoteTransaction(GlobalTransaction globalTx, WriteCommand[] modifications, int topologyId) {
        RemoteTransaction remoteTransaction = (RemoteTransaction)this.remoteTransactions.get(globalTx);
        if (remoteTransaction != null) {
            return remoteTransaction;
        }
        remoteTransaction = modifications == null ? this.txFactory.newRemoteTransaction(globalTx, topologyId) : this.txFactory.newRemoteTransaction(modifications, globalTx, topologyId);
        RemoteTransaction existing = this.remoteTransactions.putIfAbsent(globalTx, remoteTransaction);
        if (existing != null) {
            log.tracef("Remote transaction already registered: %s", existing);
            return existing;
        }
        log.tracef("Created and registered remote transaction %s", remoteTransaction);
        if (remoteTransaction.getTopologyId() < this.minTxTopologyId) {
            log.tracef("Changing minimum topology ID from %d to %d", this.minTxTopologyId, remoteTransaction.getTopologyId());
            this.minTxTopologyId = remoteTransaction.getTopologyId();
        }
        return remoteTransaction;
    }

    public LocalTransaction getOrCreateLocalTransaction(Transaction transaction, boolean implicitTransaction) {
        LocalTransaction current = (LocalTransaction)this.localTransactions.get(transaction);
        if (current == null) {
            Address localAddress = this.rpcManager != null ? this.rpcManager.getTransport().getAddress() : null;
            GlobalTransaction tx = this.txFactory.newGlobalTransaction(localAddress, false);
            current = this.txFactory.newLocalTransaction(transaction, tx, implicitTransaction, this.currentTopologyId);
            log.tracef("Created a new local transaction: %s", current);
            this.localTransactions.put(transaction, current);
            this.globalToLocalTransactions.put(current.getGlobalTransaction(), current);
            this.notifier.notifyTransactionRegistered(tx, true);
        }
        return current;
    }

    public boolean removeLocalTransaction(LocalTransaction localTransaction) {
        return localTransaction != null && this.removeLocalTransactionInternal(localTransaction.getTransaction()) != null;
    }

    protected final LocalTransaction removeLocalTransactionInternal(Transaction tx) {
        LocalTransaction localTx = (LocalTransaction)this.localTransactions.get(tx);
        if (localTx != null) {
            this.globalToLocalTransactions.remove(localTx.getGlobalTransaction());
            this.localTransactions.remove(tx);
            this.releaseResources(localTx);
        }
        return localTx;
    }

    private void releaseResources(CacheTransaction cacheTransaction) {
        if (cacheTransaction != null) {
            if (this.clustered) {
                this.recalculateMinTopologyIdIfNeeded(cacheTransaction);
            }
            log.tracef("Removed %s from transaction table.", cacheTransaction);
            cacheTransaction.notifyOnTransactionFinished();
        }
    }

    public void remoteTransactionCommitted(GlobalTransaction gtx, boolean onePc) {
        boolean optimisticWih1Pc;
        boolean bl = optimisticWih1Pc = onePc && this.configuration.transaction().lockingMode() == LockingMode.OPTIMISTIC;
        if (Configurations.isSecondPhaseAsync(this.configuration) || this.configuration.transaction().transactionProtocol().isTotalOrder() || optimisticWih1Pc) {
            this.removeRemoteTransaction(gtx);
        }
    }

    public final RemoteTransaction removeRemoteTransaction(GlobalTransaction txId) {
        RemoteTransaction removed = (RemoteTransaction)this.remoteTransactions.remove(txId);
        log.tracef("Removed remote transaction %s ? %s", txId, removed);
        this.releaseResources(removed);
        return removed;
    }

    public int getRemoteTxCount() {
        return this.remoteTransactions.size();
    }

    public int getLocalTxCount() {
        return this.localTransactions.size();
    }

    public LocalTransaction getLocalTransaction(GlobalTransaction txId) {
        return (LocalTransaction)this.globalToLocalTransactions.get(txId);
    }

    public boolean containsLocalTx(GlobalTransaction globalTransaction) {
        return this.globalToLocalTransactions.containsKey(globalTransaction);
    }

    public LocalTransaction getLocalTransaction(Transaction tx) {
        return (LocalTransaction)this.localTransactions.get(tx);
    }

    public boolean containRemoteTx(GlobalTransaction globalTransaction) {
        return this.remoteTransactions.containsKey(globalTransaction);
    }

    public Collection<RemoteTransaction> getRemoteTransactions() {
        return this.remoteTransactions.values();
    }

    public Collection<LocalTransaction> getLocalTransactions() {
        return this.localTransactions.values();
    }

    protected final void recalculateMinTopologyIdIfNeeded(CacheTransaction removedTransaction) {
        if (removedTransaction == null) {
            throw new IllegalArgumentException("Transaction cannot be null!");
        }
        if (this.currentTopologyId != -1) {
            int removedTransactionTopologyId = removedTransaction.getTopologyId();
            if (removedTransactionTopologyId < this.minTxTopologyId) {
                log.tracef("A transaction has a topology ID (%s) that is smaller than the smallest transaction topology ID (%s) this node knows about!  This can happen if a concurrent thread recalculates the minimum topology ID after the current transaction has been removed from the transaction table.", removedTransactionTopologyId, this.minTxTopologyId);
            } else if (removedTransactionTopologyId == this.minTxTopologyId && removedTransactionTopologyId < this.currentTopologyId) {
                this.calculateMinTopologyId(removedTransactionTopologyId);
            }
        }
    }

    @TopologyChanged
    public void onTopologyChange(TopologyChangedEvent<?, ?> tce) {
        if (this.clustered) {
            if (tce.isPre()) {
                this.currentTopologyId = tce.getNewTopologyId();
            } else {
                log.debugf("Topology changed, recalculating minTopologyId", new Object[0]);
                this.calculateMinTopologyId(-1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value="minTopologyRecalculationLock")
    private void calculateMinTopologyId(int idOfRemovedTransaction) {
        this.minTopologyRecalculationLock.lock();
        try {
            if (idOfRemovedTransaction == -1 || idOfRemovedTransaction == this.minTxTopologyId && idOfRemovedTransaction < this.currentTopologyId) {
                int topologyId;
                int minTopologyIdFound = this.currentTopologyId;
                for (CacheTransaction ct : this.localTransactions.values()) {
                    topologyId = ct.getTopologyId();
                    if (topologyId >= minTopologyIdFound) continue;
                    minTopologyIdFound = topologyId;
                }
                for (CacheTransaction ct : this.remoteTransactions.values()) {
                    topologyId = ct.getTopologyId();
                    if (topologyId >= minTopologyIdFound) continue;
                    minTopologyIdFound = topologyId;
                }
                if (minTopologyIdFound != this.minTxTopologyId) {
                    log.tracef("Changing minimum topology ID from %s to %s", this.minTxTopologyId, minTopologyIdFound);
                    this.minTxTopologyId = minTopologyIdFound;
                } else {
                    log.tracef("Minimum topology ID still is %s; nothing to change", minTopologyIdFound);
                }
            }
        }
        finally {
            this.minTopologyRecalculationLock.unlock();
        }
    }

    private boolean areTxsOnGoing() {
        return !this.localTransactions.isEmpty() || this.remoteTransactions != null && !this.remoteTransactions.isEmpty();
    }

    private void shutDownGracefully() {
        if (log.isDebugEnabled()) {
            log.debugf("Wait for on-going transactions to finish for %s.", Util.prettyPrintTime((long)this.configuration.transaction().cacheStopTimeout(), (TimeUnit)TimeUnit.MILLISECONDS));
        }
        long failTime = this.timeService.expectedEndTime(this.configuration.transaction().cacheStopTimeout(), TimeUnit.MILLISECONDS);
        boolean txsOnGoing = this.areTxsOnGoing();
        while (txsOnGoing && !this.timeService.isTimeExpired(failTime)) {
            try {
                Thread.sleep(30L);
                txsOnGoing = this.areTxsOnGoing();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                if (this.clustered) {
                    log.debugf("Interrupted waiting for on-going transactions to finish. %s local transactions and %s remote transactions", this.localTransactions.size(), this.remoteTransactions.size());
                    continue;
                }
                log.debugf("Interrupted waiting for %s on-going transactions to finish.", this.localTransactions.size());
            }
        }
        if (txsOnGoing) {
            log.unfinishedTransactionsRemain(this.localTransactions == null ? 0 : this.localTransactions.size(), this.remoteTransactions == null ? 0 : this.remoteTransactions.size());
        } else {
            log.debug("All transactions terminated");
        }
    }

    public void markTransactionCompleted(GlobalTransaction gtx) {
        if (this.completedTransactionsInfo != null) {
            this.completedTransactionsInfo.markTransactionCompleted(gtx);
        }
    }

    public boolean isTransactionCompleted(GlobalTransaction gtx) {
        if (this.completedTransactionsInfo == null) {
            return false;
        }
        return this.completedTransactionsInfo.isTransactionCompleted(gtx);
    }

    private class CompletedTransactionsInfo {
        final EquivalentConcurrentHashMapV8<Address, Long> nodeMaxPrunedTxIds = new EquivalentConcurrentHashMapV8((Equivalence)AnyEquivalence.getInstance(), (Equivalence)AnyEquivalence.getInstance());
        final EquivalentConcurrentHashMapV8<GlobalTransaction, Long> completedTransactions = new EquivalentConcurrentHashMapV8((Equivalence)AnyEquivalence.getInstance(), (Equivalence)AnyEquivalence.getInstance());
        volatile long globalMaxPrunedTxId = -1L;

        public void markTransactionCompleted(GlobalTransaction globalTx) {
            log.tracef("Marking transaction %s as completed", globalTx);
            this.completedTransactions.put((Object)globalTx, (Object)TransactionTable.this.timeService.time());
        }

        public boolean isTransactionCompleted(GlobalTransaction gtx) {
            if (TransactionTable.this.completedTransactionsInfo == null) {
                return false;
            }
            if (this.completedTransactions.containsKey((Object)gtx)) {
                return true;
            }
            if (gtx.getId() > this.globalMaxPrunedTxId) {
                return false;
            }
            Long nodeMaxPrunedTxId = (Long)this.nodeMaxPrunedTxIds.get((Object)gtx.getAddress());
            return nodeMaxPrunedTxId != null && gtx.getId() <= nodeMaxPrunedTxId;
        }

        public void cleanupCompletedTransactions() {
            if (this.completedTransactions.isEmpty()) {
                return;
            }
            try {
                log.tracef("About to cleanup completed transaction. Initial size is %d", this.completedTransactions.size());
                long beginning = TransactionTable.this.timeService.time();
                long minCompleteTimestamp = TransactionTable.this.timeService.time() - TimeUnit.MILLISECONDS.toNanos(TransactionTable.this.configuration.transaction().completedTxTimeout());
                int removedEntries = 0;
                HashSet leavers = new HashSet();
                for (Map.Entry e : this.nodeMaxPrunedTxIds.entrySet()) {
                    if (TransactionTable.this.rpcManager.getMembers().contains(e.getKey())) continue;
                    leavers.add(e.getKey());
                }
                Iterator txIterator = this.completedTransactions.entrySet().iterator();
                while (txIterator.hasNext()) {
                    Map.Entry e;
                    e = (Map.Entry)txIterator.next();
                    long completedTime = (Long)e.getValue();
                    if (minCompleteTimestamp - completedTime > 0L) {
                        long txId = ((GlobalTransaction)e.getKey()).getId();
                        Address address = ((GlobalTransaction)e.getKey()).getAddress();
                        this.updateLastPrunedTxId(txId, address);
                        txIterator.remove();
                        ++removedEntries;
                        continue;
                    }
                    leavers.remove(((GlobalTransaction)e.getKey()).getAddress());
                }
                for (Address e : leavers) {
                    this.nodeMaxPrunedTxIds.remove((Object)e);
                }
                long duration = TransactionTable.this.timeService.timeDuration(beginning, TimeUnit.MILLISECONDS);
                log.tracef("Finished cleaning up completed transactions. %d transactions were removed, total duration was %d millis, current number of completed transactions is %d", removedEntries, duration, this.completedTransactions.size());
            }
            catch (Exception e) {
                log.errorf(e, "Failed to cleanup completed transactions: %s", e.getMessage());
            }
        }

        private void updateLastPrunedTxId(final long txId, Address address) {
            if (txId > this.globalMaxPrunedTxId) {
                this.globalMaxPrunedTxId = txId;
            }
            this.nodeMaxPrunedTxIds.compute((Object)address, (EquivalentConcurrentHashMapV8.BiFun)new EquivalentConcurrentHashMapV8.BiFun<Address, Long, Long>(){

                public Long apply(Address address, Long nodeMaxPrunedTxId) {
                    if (nodeMaxPrunedTxId != null && txId <= nodeMaxPrunedTxId) {
                        return nodeMaxPrunedTxId;
                    }
                    return txId;
                }
            });
        }
    }
}

