/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.factory;

import java.util.ArrayList;
import java.util.List;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.persistence.factory.CacheStoreFactory;
import org.infinispan.persistence.factory.LocalClassLoaderCacheStoreFactory;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Scope(value=Scopes.GLOBAL)
public class CacheStoreFactoryRegistry {
    private static final Log log = LogFactory.getLog(CacheStoreFactoryRegistry.class);
    private List<CacheStoreFactory> factories = new ArrayList<CacheStoreFactory>();

    public CacheStoreFactoryRegistry() {
        this.factories.add(new LocalClassLoaderCacheStoreFactory());
    }

    public Object createInstance(StoreConfiguration storeConfiguration) {
        for (CacheStoreFactory factory : this.factories) {
            Object instance = factory.createInstance(storeConfiguration);
            if (instance == null) continue;
            return instance;
        }
        throw log.unableToInstantiateClass(storeConfiguration.getClass());
    }

    public StoreConfiguration processStoreConfiguration(StoreConfiguration storeConfiguration) {
        for (CacheStoreFactory factory : this.factories) {
            StoreConfiguration processedConfiguration = factory.processConfiguration(storeConfiguration);
            if (processedConfiguration == null) continue;
            return processedConfiguration;
        }
        return storeConfiguration;
    }

    public void addCacheStoreFactory(CacheStoreFactory cacheStoreFactory) {
        this.factories.add(0, cacheStoreFactory);
    }

    public void clearFactories() {
        this.factories.clear();
    }
}

