/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.remote;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.infinispan.commands.AbstractFlagAffectedCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.distribution.group.GroupFilter;
import org.infinispan.distribution.group.GroupManager;
import org.infinispan.lifecycle.ComponentStatus;

public class GetKeysInGroupCommand
extends AbstractFlagAffectedCommand
implements VisitableCommand {
    public static final byte COMMAND_ID = 43;
    private String groupName;
    private transient boolean isGroupOwner;
    private transient GroupManager groupManager;

    public GetKeysInGroupCommand(Set<Flag> flags, String groupName) {
        this.groupName = groupName;
        this.setFlags(flags);
    }

    public GetKeysInGroupCommand() {
    }

    public GetKeysInGroupCommand setGroupManager(GroupManager groupManager) {
        this.groupManager = groupManager;
        return this;
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        KeyValueCollector collector = ctx.isOriginLocal() ? new LocalContextKeyValueCollector() : new RemoteContextKeyValueCollector();
        GroupFilter filter = new GroupFilter(this.getGroupName(), this.groupManager);
        for (CacheEntry entry : ctx.getLookedUpEntries().values()) {
            if (entry.isRemoved() || !filter.accept(entry.getKey())) continue;
            collector.addCacheEntry(entry);
        }
        return collector.getResult();
    }

    @Override
    public byte getCommandId() {
        return 43;
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.groupName, this.flags};
    }

    @Override
    public void setParameters(int commandId, Object[] parameters) {
        if (commandId != 43) {
            throw new IllegalArgumentException("Wrong command id");
        }
        this.groupName = (String)parameters[0];
        this.flags = (Set)parameters[1];
    }

    @Override
    public boolean isReturnValueExpected() {
        return true;
    }

    @Override
    public boolean canBlock() {
        return false;
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitGetKeysInGroupCommand(ctx, this);
    }

    @Override
    public boolean shouldInvoke(InvocationContext ctx) {
        return true;
    }

    @Override
    public boolean ignoreCommandOnStatus(ComponentStatus status) {
        return false;
    }

    @Override
    public boolean readsExistingValues() {
        return true;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public String toString() {
        return "GetKeysInGroupCommand{groupName='" + this.groupName + '\'' + '}';
    }

    public boolean isGroupOwner() {
        return this.isGroupOwner;
    }

    public void setGroupOwner(boolean isGroupOwner) {
        this.isGroupOwner = isGroupOwner;
    }

    private static class RemoteContextKeyValueCollector
    implements KeyValueCollector {
        private final List<CacheEntry> list = new LinkedList<CacheEntry>();

        private RemoteContextKeyValueCollector() {
        }

        @Override
        public void addCacheEntry(CacheEntry entry) {
            this.list.add(entry);
        }

        @Override
        public Object getResult() {
            return this.list;
        }
    }

    private static class LocalContextKeyValueCollector
    implements KeyValueCollector {
        private final Map<Object, Object> map = new HashMap<Object, Object>();

        private LocalContextKeyValueCollector() {
        }

        @Override
        public void addCacheEntry(CacheEntry entry) {
            this.map.put(entry.getKey(), entry.getValue());
        }

        @Override
        public Object getResult() {
            return this.map;
        }
    }

    private static interface KeyValueCollector {
        public void addCacheEntry(CacheEntry var1);

        public Object getResult();
    }
}

