/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.expiration.impl;

import org.infinispan.commands.AbstractVisitor;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.expiration.impl.ExpirationInterceptor;

public class OptimisticTxExpirationInterceptor<K, V>
extends ExpirationInterceptor<K, V> {
    private final RegisterInterceptor registerInterceptor = new RegisterInterceptor();
    private final UnregisterInterceptor unregisterInterceptor = new UnregisterInterceptor();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        for (WriteCommand cmd : command.getModifications()) {
            cmd.acceptVisitor(ctx, this.registerInterceptor);
        }
        try {
            Object object = super.visitPrepareCommand(ctx, command);
            return object;
        }
        finally {
            for (WriteCommand cmd : command.getModifications()) {
                cmd.acceptVisitor(ctx, this.unregisterInterceptor);
            }
        }
    }

    private class UnregisterInterceptor
    extends ExpirationVisitor {
        private UnregisterInterceptor() {
        }

        @Override
        protected Void handleSingleKey(K key) {
            OptimisticTxExpirationInterceptor.this.expirationManager.unregisterWrite(key);
            return null;
        }
    }

    private class RegisterInterceptor
    extends ExpirationVisitor {
        private RegisterInterceptor() {
        }

        @Override
        protected Void handleSingleKey(K key) {
            OptimisticTxExpirationInterceptor.this.expirationManager.registerWriteIncoming(key);
            return null;
        }
    }

    private abstract class ExpirationVisitor
    extends AbstractVisitor {
        private ExpirationVisitor() {
        }

        @Override
        public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
            return this.handleSingleKey(command.getKey());
        }

        @Override
        public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
            return this.handleSingleKey(command.getKey());
        }

        @Override
        public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
            command.getAffectedKeys().forEach(this::handleSingleKey);
            return null;
        }

        protected abstract Void handleSingleKey(K var1);
    }
}

