/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.cluster;

import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import org.infinispan.AdvancedCache;
import org.infinispan.commands.remote.ClusteredGetCommand;
import org.infinispan.commons.configuration.ConfiguredBy;
import org.infinispan.commons.util.InfinispanCollections;
import org.infinispan.configuration.cache.ClusterLoaderConfiguration;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.marshall.core.MarshalledEntry;
import org.infinispan.persistence.spi.CacheLoader;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.persistence.spi.LocalOnlyCacheLoader;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.remoting.responses.ClusteredGetResponseValidityFilter;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.rpc.RpcOptions;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@ConfiguredBy(value=ClusterLoaderConfiguration.class)
public class ClusterLoader
implements CacheLoader,
LocalOnlyCacheLoader {
    private static final Log log = LogFactory.getLog(ClusterLoader.class);
    private RpcManager rpcManager;
    private AdvancedCache<?, ?> cache;
    private ClusterLoaderConfiguration configuration;
    private InitializationContext ctx;

    @Override
    public void init(InitializationContext ctx) {
        this.ctx = ctx;
        this.cache = ctx.getCache().getAdvancedCache();
        this.rpcManager = this.cache.getRpcManager();
        this.configuration = (ClusterLoaderConfiguration)ctx.getConfiguration();
    }

    public MarshalledEntry load(Object key) throws PersistenceException {
        Response response;
        if (!this.isCacheReady()) {
            return null;
        }
        ClusteredGetCommand clusteredGetCommand = new ClusteredGetCommand(key, this.cache.getName(), InfinispanCollections.emptySet(), false, null, this.cache.getCacheConfiguration().dataContainer().keyEquivalence());
        Collection<Response> responses = this.doRemoteCall(clusteredGetCommand);
        if (responses.isEmpty()) {
            return null;
        }
        if (responses.size() > 1) {
            HashSet<Response> setResponses = new HashSet<Response>(responses);
            if (setResponses.size() > 1) {
                throw new PersistenceException(String.format("Responses contains more than 1 element and these elements are not equal, so can't decide which one to use: %s", setResponses));
            }
            response = (Response)setResponses.iterator().next();
        } else {
            response = responses.iterator().next();
        }
        if (response.isSuccessful() && response instanceof SuccessfulResponse) {
            InternalCacheValue value = (InternalCacheValue)((SuccessfulResponse)response).getResponseValue();
            return value == null ? null : this.ctx.getMarshalledEntryFactory().newMarshalledEntry(key, value.getValue(), null);
        }
        log.unknownResponsesFromRemoteCache(responses);
        throw new PersistenceException("Unknown responses");
    }

    @Override
    public boolean contains(Object key) {
        return this.load(key) != null;
    }

    public void start() {
    }

    public void stop() {
    }

    private Collection<Response> doRemoteCall(ClusteredGetCommand clusteredGetCommand) throws PersistenceException {
        HashSet<Address> members = new HashSet<Address>(this.rpcManager.getTransport().getMembers());
        Address self = this.rpcManager.getTransport().getAddress();
        ClusteredGetResponseValidityFilter filter = new ClusteredGetResponseValidityFilter(members, self);
        try {
            RpcOptions options = this.rpcManager.getRpcOptionsBuilder(ResponseMode.WAIT_FOR_VALID_RESPONSE).timeout(this.configuration.remoteCallTimeout(), TimeUnit.MILLISECONDS).responseFilter(filter).build();
            return this.rpcManager.invokeRemotely(null, clusteredGetCommand, options).values();
        }
        catch (Exception e) {
            log.errorDoingRemoteCall(e);
            throw new PersistenceException(e);
        }
    }

    protected boolean isCacheReady() {
        return this.cache.getStatus() == ComponentStatus.RUNNING;
    }
}

