/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream.impl.spliterators;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.CloseableSpliterator;
import org.infinispan.commons.util.Closeables;

public class IteratorAsSpliterator<T>
implements CloseableSpliterator<T> {
    private CloseableIterator<? extends T> iterator;
    private final int characteristics;
    private final int batchIncrease;
    private final int maxBatchSize;
    private long estimateRemaining;
    private int currentBatchSize;

    private IteratorAsSpliterator(Builder<T> builder) {
        this.iterator = ((Builder)builder).iterator;
        this.characteristics = ((Builder)builder).characteristics;
        this.batchIncrease = ((Builder)builder).batchIncrease;
        this.maxBatchSize = ((Builder)builder).maxBatchSize;
        this.estimateRemaining = ((Builder)builder).estimateRemaining;
    }

    public Spliterator<T> trySplit() {
        if (this.estimateRemaining > 1L && this.iterator.hasNext()) {
            int i;
            int batch = this.currentBatchSize + this.batchIncrease;
            if ((long)batch > this.estimateRemaining) {
                batch = (int)this.estimateRemaining;
            }
            if (batch > this.maxBatchSize) {
                batch = this.maxBatchSize;
            }
            Object[] array = new Object[batch];
            for (i = 0; this.iterator.hasNext() && i < batch; ++i) {
                array[i] = this.iterator.next();
            }
            this.currentBatchSize = batch;
            this.estimateRemaining -= (long)i;
            return Spliterators.spliterator(array, 0, i, this.characteristics);
        }
        return null;
    }

    public void forEachRemaining(Consumer<? super T> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        this.iterator.forEachRemaining(action);
    }

    public boolean tryAdvance(Consumer<? super T> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.iterator.hasNext()) {
            action.accept(this.iterator.next());
            return true;
        }
        return false;
    }

    public long estimateSize() {
        return this.estimateRemaining;
    }

    public int characteristics() {
        return this.characteristics;
    }

    public Comparator<? super T> getComparator() {
        if (this.hasCharacteristics(4)) {
            return null;
        }
        throw new IllegalStateException();
    }

    public void close() {
        this.iterator.close();
    }

    public static class Builder<T>
    implements Supplier<IteratorAsSpliterator<T>> {
        private final CloseableIterator<? extends T> iterator;
        private int characteristics;
        private int batchIncrease = 1024;
        private int maxBatchSize = 51200;
        private long estimateRemaining = Long.MAX_VALUE;

        public Builder(Iterator<? extends T> iterator) {
            Objects.nonNull(iterator);
            this.iterator = Closeables.iterator(iterator);
        }

        public Builder(CloseableIterator<? extends T> closeableIterator) {
            Objects.nonNull(closeableIterator);
            this.iterator = closeableIterator;
        }

        public Builder setCharacteristics(int characteristics) {
            this.characteristics = characteristics;
            return this;
        }

        public Builder setBatchIncrease(int batchIncrease) {
            if (batchIncrease <= 0) {
                throw new IllegalArgumentException("The batchIncrease " + batchIncrease + " must be greater than 0");
            }
            this.batchIncrease = batchIncrease;
            return this;
        }

        public Builder setMaxBatchSize(int maxBatchSize) {
            if (maxBatchSize <= 0) {
                throw new IllegalArgumentException("The maxBatchSize " + maxBatchSize + " must be greater than 0");
            }
            this.maxBatchSize = maxBatchSize;
            return this;
        }

        public Builder setEstimateRemaining(long estimateRemaining) {
            this.estimateRemaining = estimateRemaining;
            return this;
        }

        @Override
        public IteratorAsSpliterator<T> get() {
            if (this.iterator == null) {
                throw new IllegalArgumentException("Iterator cannot be null");
            }
            if (this.batchIncrease > this.maxBatchSize) {
                throw new IllegalArgumentException("Max batch size " + this.maxBatchSize + " cannot be larger than batchIncrease" + this.batchIncrease);
            }
            return new IteratorAsSpliterator(this);
        }
    }
}

