/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.expiration.impl;

import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.util.Util;
import org.infinispan.container.entries.ExpiryHelper;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.expiration.impl.ExpirationManagerImpl;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.marshall.core.MarshalledEntry;
import org.infinispan.metadata.InternalMetadata;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@ThreadSafe
public class ClusterExpirationManager<K, V>
extends ExpirationManagerImpl<K, V> {
    protected static final Log log = LogFactory.getLog(ClusterExpirationManager.class);
    protected static final boolean trace = log.isTraceEnabled();
    private ExecutorService asyncExecutor;
    private AdvancedCache<K, V> cache;

    @Inject
    public void inject(AdvancedCache<K, V> cache, @ComponentName(value="org.infinispan.executors.async") ExecutorService asyncExecutor) {
        this.cache = cache;
        this.asyncExecutor = asyncExecutor;
    }

    @Override
    public void processExpiration() {
        long start = 0L;
        if (!Thread.currentThread().isInterrupted()) {
            try {
                if (trace) {
                    log.trace("Purging data container of expired entries");
                    start = this.timeService.time();
                }
                long currentTimeMillis = this.timeService.wallClockTime();
                Iterator purgeCandidates = this.dataContainer.iteratorIncludingExpired();
                while (purgeCandidates.hasNext()) {
                    InternalCacheEntry e = purgeCandidates.next();
                    if (!e.canExpire()) continue;
                    if (ExpiryHelper.isExpiredMortal(e.getLifespan(), e.getCreated(), currentTimeMillis)) {
                        this.handleLifespanExpireEntry(e);
                        continue;
                    }
                    if (!ExpiryHelper.isExpiredTransient(e.getMaxIdle(), e.getLastUsed(), currentTimeMillis)) continue;
                    super.handleInMemoryExpiration(e, currentTimeMillis);
                }
                if (trace) {
                    log.tracef("Purging data container completed in %s", Util.prettyPrintTime((long)this.timeService.timeDuration(start, TimeUnit.MILLISECONDS)));
                }
            }
            catch (Exception e) {
                log.exceptionPurgingDataContainer(e);
            }
        }
        if (!Thread.currentThread().isInterrupted()) {
            this.persistenceManager.purgeExpired();
        }
    }

    void handleLifespanExpireEntry(InternalCacheEntry<K, V> entry) {
        Object key = entry.getKey();
        if (this.expiring.putIfAbsent(key, key) == null) {
            long lifespan = entry.getLifespan();
            if (trace) {
                log.tracef("Submitting expiration removal for key %s which had lifespan of %s", Util.toStr(key), lifespan);
            }
            this.asyncExecutor.submit(() -> {
                try {
                    this.removeExpired(key, entry.getValue(), lifespan);
                }
                finally {
                    this.expiring.remove(key);
                }
            });
        }
    }

    private void removeExpired(K key, V value, Long lifespan) {
        this.cache.removeExpired(key, value, lifespan);
    }

    @Override
    public void handleInMemoryExpiration(InternalCacheEntry<K, V> entry, long currentTime) {
        if (ExpiryHelper.isExpiredMortal(entry.getLifespan(), entry.getCreated(), currentTime)) {
            this.handleLifespanExpireEntry(entry);
        } else {
            super.handleInMemoryExpiration(entry, currentTime);
        }
    }

    @Override
    public void handleInStoreExpiration(K key) {
        this.expiring.put(key, key);
        try {
            this.removeExpired(key, null, null);
        }
        finally {
            this.expiring.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleInStoreExpiration(MarshalledEntry<K, V> marshalledEntry) {
        K key = marshalledEntry.getKey();
        this.expiring.put(key, key);
        try {
            InternalMetadata metadata = marshalledEntry.getMetadata();
            this.removeExpired(key, marshalledEntry.getValue(), metadata.lifespan() == -1L ? null : Long.valueOf(metadata.lifespan()));
        }
        finally {
            this.expiring.remove(key);
        }
    }
}

