/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.remote;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.read.GetCacheEntryCommand;
import org.infinispan.commands.remote.LocalFlagAffectedRpcCommand;
import org.infinispan.commons.equivalence.Equivalence;
import org.infinispan.commons.util.EnumUtil;
import org.infinispan.container.InternalEntryFactory;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.container.entries.MVCCEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.InvocationContextFactory;
import org.infinispan.interceptors.InterceptorChain;
import org.infinispan.transaction.impl.TransactionTable;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ClusteredGetCommand
extends LocalFlagAffectedRpcCommand {
    public static final byte COMMAND_ID = 16;
    private static final Log log = LogFactory.getLog(ClusteredGetCommand.class);
    private static final boolean trace = log.isTraceEnabled();
    private Object key;
    private InvocationContextFactory icf;
    private CommandsFactory commandsFactory;
    private InterceptorChain invoker;
    private boolean acquireRemoteLock;
    private GlobalTransaction gtx;
    private TransactionTable txTable;
    private InternalEntryFactory entryFactory;
    private Equivalence keyEquivalence;
    private boolean isWrite;

    private ClusteredGetCommand() {
        super(null, 0L);
    }

    public ClusteredGetCommand(String cacheName) {
        super(cacheName, 0L);
    }

    public ClusteredGetCommand(Object key, String cacheName, long flags, boolean acquireRemoteLock, GlobalTransaction gtx, Equivalence keyEquivalence) {
        super(cacheName, flags);
        this.key = key;
        this.acquireRemoteLock = acquireRemoteLock;
        this.gtx = gtx;
        this.keyEquivalence = keyEquivalence;
        this.isWrite = false;
        if (acquireRemoteLock && gtx == null) {
            throw new IllegalArgumentException("Cannot have null tx if we need to acquire locks");
        }
    }

    public void initialize(InvocationContextFactory icf, CommandsFactory commandsFactory, InternalEntryFactory entryFactory, InterceptorChain interceptorChain, TransactionTable txTable, Equivalence keyEquivalence) {
        this.icf = icf;
        this.commandsFactory = commandsFactory;
        this.invoker = interceptorChain;
        this.txTable = txTable;
        this.entryFactory = entryFactory;
        this.keyEquivalence = keyEquivalence;
    }

    @Override
    public InternalCacheValue perform(InvocationContext context) throws Throwable {
        this.acquireLocksIfNeeded();
        long flagBitSet = EnumUtil.bitSetOf((Enum)Flag.SKIP_REMOTE_LOOKUP, (Enum)Flag.CACHE_MODE_LOCAL);
        GetCacheEntryCommand command = this.commandsFactory.buildGetCacheEntryCommand(this.key, EnumUtil.mergeBitSets((long)flagBitSet, (long)this.getFlagsBitSet()));
        InvocationContext invocationContext = this.icf.createRemoteInvocationContextForCommand(command, this.getOrigin());
        CacheEntry cacheEntry = (CacheEntry)this.invoker.invoke(invocationContext, command);
        if (cacheEntry == null) {
            if (trace) {
                log.trace("Did not find anything, returning null");
            }
            return null;
        }
        if (cacheEntry instanceof MVCCEntry) {
            if (trace) {
                log.trace("Handling an internal cache entry...");
            }
            MVCCEntry mvccEntry = (MVCCEntry)cacheEntry;
            return this.entryFactory.createValue(mvccEntry);
        }
        InternalCacheEntry internalCacheEntry = (InternalCacheEntry)cacheEntry;
        return internalCacheEntry.toInternalCacheValue();
    }

    public GlobalTransaction getGlobalTransaction() {
        return this.gtx;
    }

    private void acquireLocksIfNeeded() throws Throwable {
        if (this.acquireRemoteLock) {
            LockControlCommand lockControlCommand = this.commandsFactory.buildLockControlCommand(this.key, this.getFlagsBitSet(), this.gtx);
            lockControlCommand.init(this.invoker, this.icf, this.txTable);
            lockControlCommand.perform(null);
        }
    }

    @Override
    public byte getCommandId() {
        return 16;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeObject(this.key);
        output.writeLong(Flag.copyWithoutRemotableFlags(this.getFlagsBitSet()));
        output.writeBoolean(this.acquireRemoteLock);
        if (this.acquireRemoteLock) {
            output.writeObject(this.gtx);
        }
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.key = input.readObject();
        this.setFlagsBitSet(input.readLong());
        this.acquireRemoteLock = input.readBoolean();
        if (this.acquireRemoteLock) {
            this.gtx = (GlobalTransaction)input.readObject();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) return false;
        if (this.getClass() != o.getClass()) {
            return false;
        }
        ClusteredGetCommand that = (ClusteredGetCommand)o;
        if (this.key != null) {
            if (this.keyEquivalence != null) {
                if (!this.keyEquivalence.equals(this.key, that.key)) return false;
                return true;
            }
        } else {
            if (that.key != null) return false;
            return true;
        }
        if (this.key.equals(that.key)) return true;
        return false;
    }

    public int hashCode() {
        int result = this.key != null ? (this.keyEquivalence != null ? this.keyEquivalence.hashCode(this.key) : this.key.hashCode()) : 0;
        return result;
    }

    @Override
    public String toString() {
        return "ClusteredGetCommand{key=" + this.key + ", flags=" + this.printFlags() + "}";
    }

    public boolean isWrite() {
        return this.isWrite;
    }

    public void setWrite(boolean write) {
        this.isWrite = write;
    }

    public Object getKey() {
        return this.key;
    }

    @Override
    public boolean isReturnValueExpected() {
        return true;
    }

    @Override
    public boolean canBlock() {
        return false;
    }
}

