/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.impl;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.ReentrantLock;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.util.ImmutableListCopy;
import org.infinispan.commons.util.Immutables;
import org.infinispan.commons.util.ReflectionUtil;
import org.infinispan.context.InvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.factories.components.ComponentMetadataRepo;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.interceptors.SequentialInterceptor;
import org.infinispan.interceptors.SequentialInterceptorChain;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.interceptors.impl.BaseSequentialInvocationContext;
import org.infinispan.interceptors.impl.InterceptorListNode;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Scope(value=Scopes.NAMED_CACHE)
public class SequentialInterceptorChainImpl
implements SequentialInterceptorChain {
    private static final ImmutableListCopy<SequentialInterceptor> EMPTY_INTERCEPTORS_LIST = new ImmutableListCopy((Object[])new SequentialInterceptor[0]);
    private static final Map<Class<? extends CommandInterceptor>, Class<? extends SequentialInterceptor>> replacementInterceptors = new IdentityHashMap<Class<? extends CommandInterceptor>, Class<? extends SequentialInterceptor>>();
    private static final Log log = LogFactory.getLog(SequentialInterceptorChainImpl.class);
    final ComponentMetadataRepo componentMetadataRepo;
    final ReentrantLock lock = new ReentrantLock();
    private volatile List<SequentialInterceptor> interceptors = EMPTY_INTERCEPTORS_LIST;
    private volatile InterceptorListNode firstInterceptor = null;

    public SequentialInterceptorChainImpl(ComponentMetadataRepo componentMetadataRepo) {
        this.componentMetadataRepo = componentMetadataRepo;
    }

    @Start
    private void printChainInfo() {
        if (log.isDebugEnabled()) {
            log.debugf("Interceptor chain size: %d", this.size());
            log.debugf("Interceptor chain is: %s", this.toString());
        }
    }

    private void validateCustomInterceptor(Class<? extends SequentialInterceptor> i) {
        if (!(ReflectionUtil.getAllMethodsShallow(i, Inject.class).isEmpty() && ReflectionUtil.getAllMethodsShallow(i, Start.class).isEmpty() && ReflectionUtil.getAllMethodsShallow(i, Stop.class).isEmpty() || this.componentMetadataRepo.findComponentMetadata(i.getName()) != null)) {
            log.customInterceptorExpectsInjection(i.getName());
        }
    }

    private void checkInterceptor(Class<? extends SequentialInterceptor> clazz) {
        if (replacementInterceptors.containsKey(clazz)) {
            throw new IllegalArgumentException("Cannot add deprecated interceptor " + clazz);
        }
        if (this.containsInterceptorType(clazz, false)) {
            throw new CacheConfigurationException("Detected interceptor of type [" + clazz.getName() + "] being added to the interceptor chain " + System.identityHashCode(this) + " more than once!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addInterceptor(SequentialInterceptor interceptor, int position) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Class<?> interceptorClass = interceptor.getClass();
            this.checkInterceptor(interceptorClass);
            this.validateCustomInterceptor(interceptorClass);
            this.interceptors = Immutables.immutableListAdd(this.interceptors, (int)position, (Object)interceptor);
            this.rebuildInterceptors();
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void removeInterceptor(int position) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            this.interceptors = Immutables.immutableListRemove(this.interceptors, (int)position);
            this.rebuildInterceptors();
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public int size() {
        return this.interceptors.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeInterceptor(Class<? extends SequentialInterceptor> clazz) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            for (int i = 0; i < this.interceptors.size(); ++i) {
                if (!this.interceptorMatches(this.interceptors.get(i), SequentialInterceptorChainImpl.getReplacementInterceptor(clazz))) continue;
                this.removeInterceptor(i);
                break;
            }
        }
        finally {
            lock.unlock();
        }
    }

    protected boolean interceptorMatches(SequentialInterceptor interceptor, Class<? extends SequentialInterceptor> clazz) {
        Class<?> interceptorType = interceptor.getClass();
        return clazz == interceptorType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addInterceptorAfter(SequentialInterceptor toAdd, Class<? extends SequentialInterceptor> afterInterceptor) {
        this.lock.lock();
        try {
            Class<?> interceptorClass = toAdd.getClass();
            this.checkInterceptor(interceptorClass);
            this.validateCustomInterceptor(interceptorClass);
            for (int i = 0; i < this.interceptors.size(); ++i) {
                if (!this.interceptorMatches(this.interceptors.get(i), SequentialInterceptorChainImpl.getReplacementInterceptor(afterInterceptor))) continue;
                this.interceptors = Immutables.immutableListAdd(this.interceptors, (int)(i + 1), (Object)toAdd);
                this.rebuildInterceptors();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Deprecated
    public boolean addInterceptorBefore(SequentialInterceptor toAdd, Class<? extends SequentialInterceptor> beforeInterceptor, boolean isCustom) {
        if (isCustom) {
            this.validateCustomInterceptor(toAdd.getClass());
        }
        return this.addInterceptorBefore(toAdd, beforeInterceptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addInterceptorBefore(SequentialInterceptor toAdd, Class<? extends SequentialInterceptor> beforeInterceptor) {
        this.lock.lock();
        try {
            Class<?> interceptorClass = toAdd.getClass();
            this.checkInterceptor(interceptorClass);
            this.validateCustomInterceptor(interceptorClass);
            for (int i = 0; i < this.interceptors.size(); ++i) {
                if (!this.interceptorMatches(this.interceptors.get(i), SequentialInterceptorChainImpl.getReplacementInterceptor(beforeInterceptor))) continue;
                this.interceptors = Immutables.immutableListAdd(this.interceptors, (int)i, (Object)toAdd);
                this.rebuildInterceptors();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replaceInterceptor(SequentialInterceptor replacingInterceptor, Class<? extends SequentialInterceptor> existingInterceptorType) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Class<?> interceptorClass = replacingInterceptor.getClass();
            this.checkInterceptor(interceptorClass);
            this.validateCustomInterceptor(interceptorClass);
            for (int i = 0; i < this.interceptors.size(); ++i) {
                if (!this.interceptorMatches(this.interceptors.get(i), SequentialInterceptorChainImpl.getReplacementInterceptor(existingInterceptorType))) continue;
                this.interceptors = Immutables.immutableListReplace(this.interceptors, (int)i, (Object)replacingInterceptor);
                this.rebuildInterceptors();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendInterceptor(SequentialInterceptor ci, boolean isCustom) {
        this.lock.lock();
        try {
            Class<?> interceptorClass = ci.getClass();
            if (isCustom) {
                this.validateCustomInterceptor(interceptorClass);
            }
            this.checkInterceptor(interceptorClass);
            this.interceptors = Immutables.immutableListAdd(this.interceptors, (int)this.interceptors.size(), (Object)ci);
            this.rebuildInterceptors();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public CompletableFuture<Object> invokeAsync(InvocationContext ctx, VisitableCommand command) {
        return ((BaseSequentialInvocationContext)ctx).invoke(command, this.firstInterceptor);
    }

    @Override
    public Object invoke(InvocationContext ctx, VisitableCommand command) {
        try {
            return ((BaseSequentialInvocationContext)ctx).invokeSync(command, this.firstInterceptor);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CacheException((Throwable)e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable throwable) {
            throw new CacheException(throwable);
        }
    }

    @Override
    public <T extends SequentialInterceptor> T findInterceptorExtending(Class<T> interceptorClass) {
        List<SequentialInterceptor> localInterceptors = this.interceptors;
        for (SequentialInterceptor interceptor : localInterceptors) {
            boolean isSubclass = interceptorClass.isInstance(interceptor);
            if (!isSubclass) continue;
            return (T)((SequentialInterceptor)interceptorClass.cast(interceptor));
        }
        return null;
    }

    @Override
    public <T extends SequentialInterceptor> T findInterceptorWithClass(Class<T> interceptorClass) {
        List<SequentialInterceptor> localInterceptors = this.interceptors;
        for (SequentialInterceptor interceptor : localInterceptors) {
            if (!this.interceptorMatches(interceptor, interceptorClass)) continue;
            return (T)((SequentialInterceptor)interceptorClass.cast(interceptor));
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        List<SequentialInterceptor> localInterceptors = this.interceptors;
        for (SequentialInterceptor interceptor : localInterceptors) {
            sb.append("\n\t>> ");
            sb.append(interceptor);
        }
        return sb.toString();
    }

    @Override
    public boolean containsInstance(SequentialInterceptor interceptor) {
        List<SequentialInterceptor> localInterceptors = this.interceptors;
        for (SequentialInterceptor current : localInterceptors) {
            if (current != interceptor) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsInterceptorType(Class<? extends SequentialInterceptor> interceptorType) {
        return this.containsInterceptorType(interceptorType, false);
    }

    @Override
    public boolean containsInterceptorType(Class<? extends SequentialInterceptor> interceptorType, boolean alsoMatchSubClasses) {
        List<SequentialInterceptor> localInterceptors = this.interceptors;
        for (SequentialInterceptor interceptor : localInterceptors) {
            Class<?> currentInterceptorType = interceptor.getClass();
            if (!(alsoMatchSubClasses ? SequentialInterceptorChainImpl.getReplacementInterceptor(interceptorType).isAssignableFrom(currentInterceptorType) : SequentialInterceptorChainImpl.getReplacementInterceptor(interceptorType) == currentInterceptorType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<SequentialInterceptor> getInterceptors() {
        return this.interceptors;
    }

    private void rebuildInterceptors() {
        this.firstInterceptor = null;
        ListIterator<SequentialInterceptor> it = this.interceptors.listIterator(this.interceptors.size());
        while (it.hasPrevious()) {
            this.firstInterceptor = new InterceptorListNode(it.previous(), this.firstInterceptor);
        }
    }

    static Class<? extends SequentialInterceptor> getReplacementInterceptor(Class<? extends SequentialInterceptor> oldInterceptor) {
        return replacementInterceptors.getOrDefault(oldInterceptor, oldInterceptor);
    }
}

