/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.functional;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Function;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.functional.AbstractWriteManyCommand;
import org.infinispan.commons.api.functional.EntryView;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.functional.impl.EntryViews;
import org.infinispan.functional.impl.Params;
import org.infinispan.lifecycle.ComponentStatus;

public final class ReadWriteManyCommand<K, V, R>
extends AbstractWriteManyCommand {
    public static final byte COMMAND_ID = 52;
    private Collection<? extends K> keys;
    private Function<EntryView.ReadWriteEntryView<K, V>, R> f;
    private int topologyId = -1;
    boolean isForwarded = false;

    public ReadWriteManyCommand(Collection<? extends K> keys, Function<EntryView.ReadWriteEntryView<K, V>, R> f, Params params) {
        this.keys = keys;
        this.f = f;
        this.params = params;
    }

    public ReadWriteManyCommand(ReadWriteManyCommand command) {
        this.keys = command.keys;
        this.f = command.f;
        this.params = command.params;
    }

    public ReadWriteManyCommand() {
    }

    public void setKeys(Collection<? extends K> keys) {
        this.keys = keys;
    }

    public final ReadWriteManyCommand<K, V, R> withKeys(Collection<? extends K> keys) {
        this.setKeys(keys);
        return this;
    }

    @Override
    public byte getCommandId() {
        return 52;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        MarshallUtil.marshallCollection(this.keys, (ObjectOutput)output);
        output.writeObject(this.f);
        output.writeBoolean(this.isForwarded);
        Params.writeObject(output, this.params);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.keys = MarshallUtil.unmarshallCollection((ObjectInput)input, ArrayList::new);
        this.f = (Function)input.readObject();
        this.isForwarded = input.readBoolean();
        this.params = Params.readObject(input);
    }

    @Override
    public boolean isForwarded() {
        return this.isForwarded;
    }

    @Override
    public void setForwarded(boolean forwarded) {
        this.isForwarded = forwarded;
    }

    @Override
    public boolean shouldInvoke(InvocationContext ctx) {
        return true;
    }

    @Override
    public boolean isReturnValueExpected() {
        return true;
    }

    @Override
    public int getTopologyId() {
        return this.topologyId;
    }

    @Override
    public void setTopologyId(int topologyId) {
        this.topologyId = topologyId;
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitReadWriteManyCommand(ctx, this);
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        ArrayList returns = new ArrayList(this.keys.size());
        this.keys.forEach(k -> {
            CacheEntry entry = ctx.lookupEntry(k);
            if (entry != null) {
                R r = this.f.apply(EntryViews.readWrite(entry));
                returns.add(EntryViews.snapshot(r));
            }
        });
        return returns;
    }

    @Override
    public boolean isSuccessful() {
        return true;
    }

    @Override
    public boolean isConditional() {
        return false;
    }

    @Override
    public boolean canBlock() {
        return false;
    }

    @Override
    public Collection<?> getAffectedKeys() {
        return this.keys;
    }

    @Override
    public void updateStatusFromRemoteResponse(Object remoteResponse) {
    }

    @Override
    public boolean ignoreCommandOnStatus(ComponentStatus status) {
        return false;
    }

    @Override
    public VisitableCommand.LoadType loadType() {
        return VisitableCommand.LoadType.OWNER;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ReadWriteManyCommand{");
        sb.append("keys=").append(this.keys);
        sb.append(", f=").append(this.f);
        sb.append(", isForwarded=").append(this.isForwarded);
        sb.append('}');
        return sb.toString();
    }
}

