/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.functional;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.function.BiFunction;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.functional.AbstractWriteManyCommand;
import org.infinispan.commons.api.functional.EntryView;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.functional.impl.EntryViews;
import org.infinispan.functional.impl.Params;
import org.infinispan.lifecycle.ComponentStatus;

public final class ReadWriteManyEntriesCommand<K, V, R>
extends AbstractWriteManyCommand {
    public static final byte COMMAND_ID = 53;
    private Map<? extends K, ? extends V> entries;
    private BiFunction<V, EntryView.ReadWriteEntryView<K, V>, R> f;
    private int topologyId = -1;
    boolean isForwarded = false;

    public ReadWriteManyEntriesCommand(Map<? extends K, ? extends V> entries, BiFunction<V, EntryView.ReadWriteEntryView<K, V>, R> f, Params params) {
        this.entries = entries;
        this.f = f;
        this.params = params;
    }

    public ReadWriteManyEntriesCommand() {
    }

    public ReadWriteManyEntriesCommand(ReadWriteManyEntriesCommand command) {
        this.entries = command.entries;
        this.f = command.f;
        this.params = command.params;
    }

    public Map<? extends K, ? extends V> getEntries() {
        return this.entries;
    }

    public void setEntries(Map<? extends K, ? extends V> entries) {
        this.entries = entries;
    }

    public final ReadWriteManyEntriesCommand<K, V, R> withEntries(Map<? extends K, ? extends V> entries) {
        this.setEntries(entries);
        return this;
    }

    @Override
    public byte getCommandId() {
        return 53;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeObject(this.entries);
        output.writeObject(this.f);
        output.writeBoolean(this.isForwarded);
        Params.writeObject(output, this.params);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.entries = (Map)input.readObject();
        this.f = (BiFunction)input.readObject();
        this.isForwarded = input.readBoolean();
        this.params = Params.readObject(input);
    }

    @Override
    public boolean isForwarded() {
        return this.isForwarded;
    }

    @Override
    public void setForwarded(boolean forwarded) {
        this.isForwarded = forwarded;
    }

    @Override
    public boolean isReturnValueExpected() {
        return true;
    }

    @Override
    public int getTopologyId() {
        return this.topologyId;
    }

    @Override
    public void setTopologyId(int topologyId) {
        this.topologyId = topologyId;
    }

    @Override
    public boolean shouldInvoke(InvocationContext ctx) {
        return true;
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitReadWriteManyEntriesCommand(ctx, this);
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        ArrayList returns = new ArrayList(this.entries.size());
        this.entries.forEach((k, v) -> {
            CacheEntry entry = ctx.lookupEntry(k);
            if (entry == null) {
                throw new IllegalStateException();
            }
            R r = this.f.apply(v, EntryViews.readWrite(entry));
            returns.add(EntryViews.snapshot(r));
        });
        return returns;
    }

    @Override
    public boolean isSuccessful() {
        return true;
    }

    @Override
    public boolean isConditional() {
        return false;
    }

    @Override
    public Collection<?> getAffectedKeys() {
        return this.entries.keySet();
    }

    @Override
    public void updateStatusFromRemoteResponse(Object remoteResponse) {
    }

    @Override
    public boolean canBlock() {
        return false;
    }

    @Override
    public boolean ignoreCommandOnStatus(ComponentStatus status) {
        return false;
    }

    @Override
    public VisitableCommand.LoadType loadType() {
        return VisitableCommand.LoadType.OWNER;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ReadWriteManyEntriesCommand{");
        sb.append("entries=").append(this.entries);
        sb.append(", f=").append(this.f.getClass().getName());
        sb.append(", isForwarded=").append(this.isForwarded);
        sb.append('}');
        return sb.toString();
    }
}

