/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.read;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.infinispan.commands.AbstractTopologyAffectedCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.container.InternalEntryFactory;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class GetAllCommand
extends AbstractTopologyAffectedCommand {
    public static final byte COMMAND_ID = 44;
    private static final Log log = LogFactory.getLog(GetAllCommand.class);
    private static final boolean trace = log.isTraceEnabled();
    private Collection<?> keys;
    private boolean returnEntries;
    private InternalEntryFactory entryFactory;

    public GetAllCommand(Collection<?> keys, long flagsBitSet, boolean returnEntries, InternalEntryFactory entryFactory) {
        this.keys = keys;
        this.returnEntries = returnEntries;
        this.entryFactory = entryFactory;
        this.setFlagsBitSet(flagsBitSet);
    }

    GetAllCommand() {
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitGetAllCommand(ctx, this);
    }

    @Override
    public boolean shouldInvoke(InvocationContext ctx) {
        return true;
    }

    @Override
    public boolean ignoreCommandOnStatus(ComponentStatus status) {
        return status != ComponentStatus.RUNNING && status != ComponentStatus.INITIALIZING;
    }

    @Override
    public VisitableCommand.LoadType loadType() {
        return VisitableCommand.LoadType.PRIMARY;
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        Map map = this.createMap();
        for (Object key : this.keys) {
            CacheEntry entry = ctx.lookupEntry(key);
            if (entry == null) {
                throw new IllegalStateException("Entry for key " + Util.toStr(key) + " not found");
            }
            if (entry.isNull()) {
                if (trace) {
                    log.tracef("Entry for key %s is null in current context", Util.toStr(key));
                }
                map.put(key, null);
                continue;
            }
            if (entry.isRemoved()) {
                if (trace) {
                    log.tracef("Entry for key %s has been deleted and is of type %s", Util.toStr(key), entry.getClass().getSimpleName());
                }
                map.put(key, null);
                continue;
            }
            if (this.returnEntries) {
                CacheEntry copy = ctx.isOriginLocal() ? this.entryFactory.copy(entry) : entry;
                if (trace) {
                    log.tracef("Found entry %s -> %s", Util.toStr(key), entry);
                    log.tracef("Returning copied entry %s", copy);
                }
                map.put(key, copy);
                continue;
            }
            Object value = entry.getValue();
            if (trace) {
                log.tracef("Found %s -> %s", Util.toStr(key), Util.toStr(value));
            }
            map.put(key, value);
        }
        return map;
    }

    @Override
    public byte getCommandId() {
        return 44;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        MarshallUtil.marshallCollection(this.keys, (ObjectOutput)output);
        output.writeLong(Flag.copyWithoutRemotableFlags(this.getFlagsBitSet()));
        output.writeBoolean(this.returnEntries);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.keys = MarshallUtil.unmarshallCollection((ObjectInput)input, ArrayList::new);
        this.setFlagsBitSet(input.readLong());
        this.returnEntries = input.readBoolean();
    }

    @Override
    public boolean isReturnValueExpected() {
        return true;
    }

    @Override
    public boolean canBlock() {
        return false;
    }

    public boolean isReturnEntries() {
        return this.returnEntries;
    }

    public <V> Map<Object, V> createMap() {
        return new LinkedHashMap();
    }

    private Set<Object> createSet(Object[] elements) {
        HashSet<Object> set = new HashSet<Object>(elements.length);
        for (Object element : elements) {
            set.add(element);
        }
        return set;
    }

    public Collection<?> getKeys() {
        return this.keys;
    }

    public void setKeys(Collection<?> keys) {
        this.keys = keys;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("GetAllCommand{");
        sb.append("keys=").append(Util.toStr(this.keys));
        sb.append(", returnEntries=").append(this.returnEntries);
        sb.append(", flags=").append(this.printFlags());
        sb.append('}');
        return sb.toString();
    }
}

