/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.write;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.concurrent.CompletableFuture;
import org.infinispan.commands.CommandInvocationId;
import org.infinispan.commands.TopologyAffectedCommand;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.commands.write.AbstractDataWriteCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.RemoveExpiredCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.ValueMatcher;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.util.EnumUtil;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.InvocationContextFactory;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.metadata.Metadata;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.util.ByteString;
import org.infinispan.util.concurrent.CompletableFutures;

public class BackupWriteRcpCommand
extends BaseRpcCommand
implements TopologyAffectedCommand {
    public static final byte COMMAND_ID = 61;
    private static final Operation[] CACHED_VALUES = Operation.values();
    private Operation operation;
    private CommandInvocationId commandInvocationId;
    private Object key;
    private Object value;
    private Metadata metadata;
    private int topologyId;
    private long flags;
    private InvocationContextFactory invocationContextFactory;
    private AsyncInterceptorChain interceptorChain;
    private CacheNotifier cacheNotifier;

    public BackupWriteRcpCommand() {
        super(null);
    }

    public BackupWriteRcpCommand(ByteString cacheName) {
        super(cacheName);
    }

    private static Operation valueOf(int index) {
        return CACHED_VALUES[index];
    }

    public void setWrite(CommandInvocationId id, Object key, Object value, Metadata metadata, long flags, int topologyId) {
        this.operation = Operation.WRITE;
        this.setCommonAttributes(id, key, flags, topologyId);
        this.value = value;
        this.metadata = metadata;
    }

    public void setRemove(CommandInvocationId id, Object key, long flags, int topologyId) {
        this.operation = Operation.REMOVE;
        this.setCommonAttributes(id, key, flags, topologyId);
    }

    public void setRemoveExpired(CommandInvocationId id, Object key, Object value, long flags, int topologyId) {
        this.operation = Operation.REMOVE_EXPIRED;
        this.setCommonAttributes(id, key, flags, topologyId);
        this.value = value;
    }

    public void setReplace(CommandInvocationId id, Object key, Object value, Metadata metadata, long flags, int topologyId) {
        this.operation = Operation.REPLACE;
        this.setCommonAttributes(id, key, flags, topologyId);
        this.value = value;
        this.metadata = metadata;
    }

    public void init(InvocationContextFactory invocationContextFactory, AsyncInterceptorChain interceptorChain, CacheNotifier cacheNotifier) {
        this.invocationContextFactory = invocationContextFactory;
        this.interceptorChain = interceptorChain;
        this.cacheNotifier = cacheNotifier;
    }

    @Override
    public CompletableFuture<Object> invokeAsync() throws Throwable {
        AbstractDataWriteCommand command;
        switch (this.operation) {
            case REMOVE: {
                command = new RemoveCommand(this.key, null, this.cacheNotifier, this.flags, null, this.commandInvocationId);
                break;
            }
            case REMOVE_EXPIRED: {
                command = new RemoveExpiredCommand(this.key, this.value, null, this.cacheNotifier, null, this.commandInvocationId);
                break;
            }
            case WRITE: {
                command = new PutKeyValueCommand(this.key, this.value, false, this.cacheNotifier, this.metadata, this.flags, null, this.commandInvocationId);
                break;
            }
            case REPLACE: {
                command = new ReplaceCommand(this.key, null, this.value, this.cacheNotifier, this.metadata, this.flags, null, this.commandInvocationId);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        command.addFlag(Flag.SKIP_LOCKING);
        command.setValueMatcher(ValueMatcher.MATCH_ALWAYS);
        command.setTopologyId(this.topologyId);
        InvocationContext invocationContext = this.invocationContextFactory.createRemoteInvocationContextForCommand(command, this.getOrigin());
        this.interceptorChain.invokeAsync(invocationContext, command);
        return CompletableFutures.completedNull();
    }

    public Object getKey() {
        return this.key;
    }

    @Override
    public byte getCommandId() {
        return 61;
    }

    @Override
    public boolean isReturnValueExpected() {
        return false;
    }

    @Override
    public boolean canBlock() {
        return true;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        MarshallUtil.marshallEnum((Enum)this.operation, (ObjectOutput)output);
        CommandInvocationId.writeTo(output, this.commandInvocationId);
        output.writeObject(this.key);
        switch (this.operation) {
            case WRITE: 
            case REPLACE: {
                output.writeObject(this.value);
                output.writeObject(this.metadata);
                break;
            }
            case REMOVE_EXPIRED: {
                output.writeObject(this.value);
                break;
            }
        }
        output.writeLong(Flag.copyWithoutRemotableFlags(this.flags));
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.operation = (Operation)MarshallUtil.unmarshallEnum((ObjectInput)input, BackupWriteRcpCommand::valueOf);
        this.commandInvocationId = CommandInvocationId.readFrom(input);
        this.key = input.readObject();
        switch (this.operation) {
            case WRITE: 
            case REPLACE: {
                this.value = input.readObject();
                this.metadata = (Metadata)input.readObject();
                break;
            }
            case REMOVE_EXPIRED: {
                this.value = input.readObject();
                break;
            }
        }
        this.flags = input.readLong();
    }

    @Override
    public String toString() {
        return "BackupWriteRcpCommand{operation=" + (Object)((Object)this.operation) + ", commandInvocationId=" + this.commandInvocationId + ", key=" + this.key + ", value=" + this.value + ", metadata=" + this.metadata + ", topologyId=" + this.topologyId + ", flags=" + EnumUtil.prettyPrintBitSet((long)this.flags, Flag.class) + '}';
    }

    public boolean isRemove() {
        return this.operation == Operation.REMOVE || this.operation == Operation.REMOVE_EXPIRED;
    }

    @Override
    public int getTopologyId() {
        return this.topologyId;
    }

    @Override
    public void setTopologyId(int topologyId) {
        this.topologyId = topologyId;
    }

    public Object getValue() {
        return this.value;
    }

    private void setCommonAttributes(CommandInvocationId commandInvocationId, Object key, long flags, int topologyId) {
        this.commandInvocationId = commandInvocationId;
        this.key = key;
        this.flags = flags;
        this.topologyId = topologyId;
    }

    private static enum Operation {
        WRITE,
        REMOVE,
        REMOVE_EXPIRED,
        REPLACE;

    }
}

