/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.write;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Collection;
import org.infinispan.commands.AbstractTopologyAffectedCommand;
import org.infinispan.commands.CommandInvocationId;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.write.ValueMatcher;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.util.CollectionFactory;
import org.infinispan.commons.util.Util;
import org.infinispan.container.entries.MVCCEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.util.concurrent.locks.RemoteLockCommand;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class InvalidateCommand
extends AbstractTopologyAffectedCommand
implements WriteCommand,
RemoteLockCommand {
    public static final int COMMAND_ID = 6;
    private static final Log log = LogFactory.getLog(InvalidateCommand.class);
    private static final boolean trace = log.isTraceEnabled();
    protected Object[] keys;
    protected CommandInvocationId commandInvocationId;
    protected CacheNotifier notifier;

    public InvalidateCommand() {
    }

    public InvalidateCommand(CacheNotifier notifier, long flagsBitSet, CommandInvocationId commandInvocationId, Object ... keys) {
        this.keys = keys;
        this.notifier = notifier;
        this.commandInvocationId = commandInvocationId;
        this.setFlagsBitSet(flagsBitSet);
    }

    public InvalidateCommand(CacheNotifier notifier, long flagsBitSet, Collection<Object> keys, CommandInvocationId commandInvocationId) {
        this(notifier, flagsBitSet, commandInvocationId, keys == null || keys.isEmpty() ? Util.EMPTY_OBJECT_ARRAY : keys.toArray(new Object[keys.size()]));
    }

    public void init(CacheNotifier notifier) {
        this.notifier = notifier;
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        if (trace) {
            log.tracef("Invalidating keys %s", Util.toStr(Arrays.asList(this.keys)));
        }
        for (Object key : this.keys) {
            MVCCEntry e = (MVCCEntry)ctx.lookupEntry(key);
            if (e == null) continue;
            this.notify(ctx, e, true);
            e.setChanged(true);
            e.setRemoved(true);
            e.setCreated(false);
            e.setValid(false);
        }
        return null;
    }

    protected void notify(InvocationContext ctx, MVCCEntry e, boolean pre) {
        this.notifier.notifyCacheEntryInvalidated(e.getKey(), e.getValue(), e.getMetadata(), pre, ctx, this);
    }

    @Override
    public byte getCommandId() {
        return 6;
    }

    @Override
    public boolean isReturnValueExpected() {
        return false;
    }

    @Override
    public boolean canBlock() {
        return false;
    }

    public String toString() {
        return "InvalidateCommand{keys=" + Util.toStr(Arrays.asList(this.keys)) + '}';
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        CommandInvocationId.writeTo(output, this.commandInvocationId);
        MarshallUtil.marshallArray((Object[])this.keys, (ObjectOutput)output);
        output.writeLong(this.getFlagsBitSet());
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.commandInvocationId = CommandInvocationId.readFrom(input);
        this.keys = MarshallUtil.unmarshallArray((ObjectInput)input, Object[]::new);
        this.setFlagsBitSet(input.readLong());
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitInvalidateCommand(ctx, this);
    }

    @Override
    public boolean shouldInvoke(InvocationContext ctx) {
        return true;
    }

    public Object[] getKeys() {
        return this.keys;
    }

    @Override
    public boolean isSuccessful() {
        return true;
    }

    @Override
    public boolean isConditional() {
        return false;
    }

    @Override
    public ValueMatcher getValueMatcher() {
        return ValueMatcher.MATCH_ALWAYS;
    }

    @Override
    public void setValueMatcher(ValueMatcher valueMatcher) {
    }

    @Override
    public Collection<?> getAffectedKeys() {
        return CollectionFactory.makeSet((Object[])this.keys);
    }

    @Override
    public void updateStatusFromRemoteResponse(Object remoteResponse) {
    }

    @Override
    public Collection<?> getKeysToLock() {
        return Arrays.asList(this.keys);
    }

    @Override
    public Object getKeyLockOwner() {
        return this.commandInvocationId;
    }

    @Override
    public boolean hasZeroLockAcquisition() {
        return this.hasFlag(Flag.ZERO_LOCK_ACQUISITION_TIMEOUT);
    }

    @Override
    public boolean hasSkipLocking() {
        return this.hasFlag(Flag.SKIP_LOCKING);
    }

    @Override
    public boolean ignoreCommandOnStatus(ComponentStatus status) {
        switch (status) {
            case FAILED: 
            case STOPPING: 
            case TERMINATED: {
                return true;
            }
        }
        return false;
    }

    @Override
    public VisitableCommand.LoadType loadType() {
        return VisitableCommand.LoadType.OWNER;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InvalidateCommand that = (InvalidateCommand)obj;
        if (!this.hasSameFlags(that)) {
            return false;
        }
        return Arrays.equals(this.keys, that.keys);
    }

    public int hashCode() {
        return this.keys != null ? Arrays.hashCode(this.keys) : 0;
    }
}

