/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import java.util.Arrays;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.global.AbstractGlobalConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.ThreadPoolConfigurationBuilder;
import org.infinispan.configuration.global.TransportConfiguration;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class TransportConfigurationBuilder
extends AbstractGlobalConfigurationBuilder
implements Builder<TransportConfiguration> {
    private static final Log log = LogFactory.getLog(TransportConfigurationBuilder.class);
    public static final String DEFAULT_TRANSPORT = "org.infinispan.remoting.transport.jgroups.JGroupsTransport";
    private final ThreadPoolConfigurationBuilder transportThreadPool;
    private final ThreadPoolConfigurationBuilder remoteCommandThreadPool;
    private final AttributeSet attributes = TransportConfiguration.attributeSet();

    TransportConfigurationBuilder(GlobalConfigurationBuilder globalConfig) {
        super(globalConfig);
        this.transportThreadPool = new ThreadPoolConfigurationBuilder(globalConfig);
        this.remoteCommandThreadPool = new ThreadPoolConfigurationBuilder(globalConfig);
    }

    public TransportConfigurationBuilder clusterName(String clusterName) {
        this.attributes.attribute(TransportConfiguration.CLUSTER_NAME).set((Object)clusterName);
        return this;
    }

    public TransportConfigurationBuilder machineId(String machineId) {
        this.attributes.attribute(TransportConfiguration.MACHINE_ID).set((Object)machineId);
        return this;
    }

    public TransportConfigurationBuilder rackId(String rackId) {
        this.attributes.attribute(TransportConfiguration.RACK_ID).set((Object)rackId);
        return this;
    }

    public TransportConfigurationBuilder siteId(String siteId) {
        this.attributes.attribute(TransportConfiguration.SITE_ID).set((Object)siteId);
        return this;
    }

    public TransportConfigurationBuilder distributedSyncTimeout(long distributedSyncTimeout) {
        this.attributes.attribute(TransportConfiguration.DISTRIBUTED_SYNC_TIMEOUT).set((Object)distributedSyncTimeout);
        return this;
    }

    public TransportConfigurationBuilder distributedSyncTimeout(long distributedSyncTimeout, TimeUnit unit) {
        return this.distributedSyncTimeout(unit.toMillis(distributedSyncTimeout));
    }

    public TransportConfigurationBuilder initialClusterSize(int clusterSize) {
        this.attributes.attribute(TransportConfiguration.INITIAL_CLUSTER_SIZE).set((Object)clusterSize);
        return this;
    }

    public TransportConfigurationBuilder initialClusterTimeout(long initialClusterTimeout, TimeUnit unit) {
        this.attributes.attribute(TransportConfiguration.INITIAL_CLUSTER_TIMEOUT).set((Object)unit.toMillis(initialClusterTimeout));
        return this;
    }

    public TransportConfigurationBuilder transport(Transport transport) {
        this.attributes.attribute(TransportConfiguration.TRANSPORT).set((Object)transport);
        return this;
    }

    public TransportConfigurationBuilder nodeName(String nodeName) {
        this.attributes.attribute(TransportConfiguration.NODE_NAME).set((Object)nodeName);
        return this;
    }

    public TransportConfigurationBuilder withProperties(Properties properties) {
        this.attributes.attribute(TransportConfiguration.PROPERTIES).set((Object)TypedProperties.toTypedProperties((Properties)properties));
        return this;
    }

    public TransportConfigurationBuilder clearProperties() {
        this.attributes.attribute(TransportConfiguration.PROPERTIES).set((Object)new TypedProperties());
        return this;
    }

    public TransportConfigurationBuilder addProperty(String key, String value) {
        TypedProperties properties = (TypedProperties)this.attributes.attribute(TransportConfiguration.PROPERTIES).get();
        properties.put((Object)key, (Object)value);
        this.attributes.attribute(TransportConfiguration.PROPERTIES).set((Object)properties);
        return this;
    }

    public TransportConfigurationBuilder removeProperty(String key) {
        TypedProperties properties = (TypedProperties)this.attributes.attribute(TransportConfiguration.PROPERTIES).get();
        properties.remove((Object)key);
        this.attributes.attribute(TransportConfiguration.PROPERTIES).set((Object)properties);
        return this;
    }

    public String getProperty(String key) {
        return String.valueOf(((TypedProperties)this.attributes.attribute(TransportConfiguration.PROPERTIES).get()).get((Object)key));
    }

    @Deprecated
    public TransportConfigurationBuilder strictPeerToPeer(Boolean ignored) {
        log.strictPeerToPeerDeprecated();
        return this;
    }

    public ThreadPoolConfigurationBuilder transportThreadPool() {
        return this.transportThreadPool;
    }

    public ThreadPoolConfigurationBuilder remoteCommandThreadPool() {
        return this.remoteCommandThreadPool;
    }

    public void validate() {
        Arrays.asList(this.transportThreadPool, this.remoteCommandThreadPool).forEach(Builder::validate);
        if (this.attributes.attribute(TransportConfiguration.CLUSTER_NAME).get() == null) {
            throw new CacheConfigurationException("Transport clusterName cannot be null");
        }
    }

    public TransportConfiguration create() {
        return new TransportConfiguration(this.attributes.protect(), this.transportThreadPool.create(), this.remoteCommandThreadPool.create());
    }

    public TransportConfigurationBuilder defaultTransport() {
        Transport transport = (Transport)Util.getInstance((String)DEFAULT_TRANSPORT, (ClassLoader)this.getGlobalConfig().getClassLoader());
        this.transport(transport);
        return this;
    }

    public TransportConfigurationBuilder read(TransportConfiguration template) {
        this.attributes.read(template.attributes());
        this.remoteCommandThreadPool.read(template.remoteCommandThreadPool());
        this.transportThreadPool.read(template.transportThreadPool());
        if (template.transport() != null) {
            Transport transport = (Transport)Util.getInstance((String)template.transport().getClass().getName(), (ClassLoader)template.transport().getClass().getClassLoader());
            this.transport(transport);
        }
        return this;
    }

    public Transport getTransport() {
        return (Transport)this.attributes.attribute(TransportConfiguration.TRANSPORT).get();
    }

    public String toString() {
        return "TransportConfigurationBuilder [transportThreadPool=" + this.transportThreadPool + ", remoteCommandThreadPool=" + this.remoteCommandThreadPool + ", attributes=" + this.attributes + "]";
    }
}

