/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import java.util.Collection;
import java.util.List;
import org.infinispan.distribution.Ownership;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.remoting.transport.Address;

public class DistributionInfo {
    private final Address primary;
    private final List<Address> owners;
    private final Ownership ownership;

    public DistributionInfo(Object key, ConsistentHash ch, Address self) {
        int segment = ch.getSegment(key);
        if (ch.isReplicated()) {
            this.owners = ch.getMembers();
            this.primary = ch.locatePrimaryOwnerForSegment(segment);
            this.ownership = this.primary.equals(self) ? Ownership.PRIMARY : (this.owners.contains(self) ? Ownership.BACKUP : Ownership.NON_OWNER);
        } else {
            this.owners = ch.locateOwnersForSegment(segment);
            int index = this.owners.indexOf(self);
            if (index == 0) {
                this.ownership = Ownership.PRIMARY;
                this.primary = self;
            } else if (index > 0) {
                this.ownership = Ownership.BACKUP;
                this.primary = this.owners.get(0);
            } else {
                this.ownership = Ownership.NON_OWNER;
                this.primary = this.owners.get(0);
            }
        }
    }

    public boolean isPrimary() {
        return this.ownership == Ownership.PRIMARY;
    }

    public Address primary() {
        return this.primary;
    }

    public Ownership ownership() {
        return this.ownership;
    }

    public Collection<Address> owners() {
        return this.owners;
    }

    public Collection<Address> backups() {
        return this.owners.subList(0, this.owners.size());
    }
}

