/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.distribution;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.infinispan.commands.CommandInvocationId;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.write.AbstractDataWriteCommand;
import org.infinispan.commands.write.DataWriteCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.distribution.DistributionInfo;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.BasicInvocationStage;
import org.infinispan.interceptors.distribution.NonTxDistributionInterceptor;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.transport.Address;
import org.infinispan.topology.CacheTopology;
import org.infinispan.util.concurrent.CommandAckCollector;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class TriangleDistributionInterceptor
extends NonTxDistributionInterceptor {
    private static final Log log = LogFactory.getLog(TriangleDistributionInterceptor.class);
    private static final boolean trace = log.isTraceEnabled();
    private CommandAckCollector commandAckCollector;
    private CommandsFactory commandsFactory;

    @Inject
    public void inject(CommandAckCollector commandAckCollector, CommandsFactory commandsFactory) {
        this.commandAckCollector = commandAckCollector;
        this.commandsFactory = commandsFactory;
    }

    @Override
    public BasicInvocationStage visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        return this.handleDataWriteCommand(ctx, command);
    }

    @Override
    public BasicInvocationStage visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        if (ctx.isOriginLocal()) {
            return this.handleLocalPutMapCommand(ctx, command);
        }
        return this.handleRemotePutMapCommand(ctx, command);
    }

    @Override
    public BasicInvocationStage visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        return this.handleDataWriteCommand(ctx, command);
    }

    @Override
    public BasicInvocationStage visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        return this.handleDataWriteCommand(ctx, command);
    }

    private BasicInvocationStage handleRemotePutMapCommand(InvocationContext ctx, PutMapCommand command) {
        CacheTopology cacheTopology = this.checkTopologyId(command);
        ConsistentHash ch = cacheTopology.getWriteConsistentHash();
        if (command.isForwarded() || ch.getNumOwners() == 1) {
            return this.invokeNext(ctx, command);
        }
        this.sendToBackups(command, command.getMap(), ch);
        return this.invokeNext(ctx, command);
    }

    private void sendToBackups(PutMapCommand command, Map<Object, Object> entries, ConsistentHash ch) {
        BackupOwnerClassifier filter = new BackupOwnerClassifier(ch);
        entries.entrySet().forEach(filter::add);
        for (Map.Entry entry : filter.perBackupKeyValue.entrySet()) {
            PutMapCommand copy = new PutMapCommand(command, false);
            copy.setMap((Map)entry.getValue());
            copy.setForwarded(true);
            copy.addFlag(Flag.SKIP_LOCKING);
            this.rpcManager.sendTo((Address)entry.getKey(), copy, DeliverOrder.PER_SENDER);
        }
    }

    private BasicInvocationStage handleLocalPutMapCommand(InvocationContext ctx, PutMapCommand command) {
        CacheTopology cacheTopology = this.checkTopologyId(command);
        ConsistentHash consistentHash = cacheTopology.getWriteConsistentHash();
        PrimaryOwnerClassifier filter = new PrimaryOwnerClassifier(consistentHash);
        boolean sync = this.isSynchronous(command);
        Address localAddress = this.rpcManager.getAddress();
        command.getMap().entrySet().forEach(filter::add);
        if (sync) {
            this.commandAckCollector.createMultiKeyCollector(command.getCommandInvocationId(), filter.primaries.keySet(), filter.backups, command.getTopologyId());
            Map localEntries = (Map)filter.primaries.remove(localAddress);
            this.forwardToPrimaryOwners(command, filter);
            if (localEntries != null) {
                this.sendToBackups(command, localEntries, consistentHash);
            }
            return this.invokeNext(ctx, command).compose((stage, rCtx, rCommand, rv, t) -> {
                PutMapCommand cmd = (PutMapCommand)rCommand;
                if (t != null) {
                    this.commandAckCollector.completeExceptionally(cmd.getCommandInvocationId(), t, cmd.getTopologyId());
                } else if (localEntries != null) {
                    this.commandAckCollector.multiKeyPrimaryAck(cmd.getCommandInvocationId(), localAddress, (Map)rv, cmd.getTopologyId());
                }
                return stage;
            });
        }
        Map localEntries = (Map)filter.primaries.remove(localAddress);
        this.forwardToPrimaryOwners(command, filter);
        if (localEntries != null) {
            this.sendToBackups(command, localEntries, consistentHash);
        }
        return this.invokeNext(ctx, command);
    }

    private void forwardToPrimaryOwners(PutMapCommand command, PrimaryOwnerClassifier splitter) {
        for (Map.Entry entry : splitter.primaries.entrySet()) {
            PutMapCommand copy = new PutMapCommand(command, false);
            copy.setMap((Map)entry.getValue());
            this.rpcManager.sendTo((Address)entry.getKey(), copy, DeliverOrder.NONE);
        }
    }

    private BasicInvocationStage handleDataWriteCommand(InvocationContext context, AbstractDataWriteCommand command) {
        assert (!context.isInTxScope());
        if (command.hasFlag(Flag.CACHE_MODE_LOCAL)) {
            return this.invokeNext(context, command);
        }
        CacheTopology topology = this.checkTopologyId(command);
        DistributionInfo distributionInfo = new DistributionInfo(command.getKey(), topology.getWriteConsistentHash(), this.rpcManager.getAddress());
        switch (distributionInfo.ownership()) {
            case PRIMARY: {
                assert (context.lookupEntry(command.getKey()) != null);
                return this.primaryOwnerWrite(context, command, distributionInfo);
            }
            case BACKUP: {
                if (context.isOriginLocal()) {
                    return this.localWriteInvocation(context, command, distributionInfo);
                }
                CacheEntry entry = context.lookupEntry(command.getKey());
                if (entry == null) {
                    if (command.loadType() == VisitableCommand.LoadType.OWNER) {
                        return this.invokeNextAsync(context, command, this.remoteGet(context, command, command.getKey(), true));
                    }
                    this.entryFactory.wrapExternalEntry(context, command.getKey(), null, true);
                }
                return this.invokeNext(context, command);
            }
            case NON_OWNER: {
                assert (context.isOriginLocal());
                return this.localWriteInvocation(context, command, distributionInfo);
            }
        }
        throw new IllegalStateException();
    }

    private BasicInvocationStage primaryOwnerWrite(InvocationContext context, DataWriteCommand command, DistributionInfo distributionInfo) {
        if (command.hasFlag(Flag.COMMAND_RETRY)) {
            command.setValueMatcher(command.getValueMatcher().matcherForRetry());
        }
        return this.invokeNext(context, command).thenAccept((rCtx, rCommand, rv) -> {
            DataWriteCommand dwCommand = (DataWriteCommand)rCommand;
            CommandInvocationId id = dwCommand.getCommandInvocationId();
            if (!dwCommand.isSuccessful()) {
                if (trace) {
                    log.tracef("Command %s not successful in primary owner.", id);
                }
                return;
            }
            if (distributionInfo.owners().size() > 1) {
                Collection<Address> backupOwners = distributionInfo.backups();
                if (rCtx.isOriginLocal() && (this.isSynchronous(dwCommand) || dwCommand.isReturnValueExpected())) {
                    this.commandAckCollector.create(id, rv, distributionInfo.owners(), dwCommand.getTopologyId());
                }
                if (trace) {
                    log.tracef("Command %s send to backup owner %s.", dwCommand.getCommandInvocationId(), backupOwners);
                }
                this.rpcManager.sendToMany(backupOwners, this.commandsFactory.buildBackupWriteRcpCommand(dwCommand), DeliverOrder.PER_SENDER);
            }
        });
    }

    private BasicInvocationStage localWriteInvocation(InvocationContext context, DataWriteCommand command, DistributionInfo distributionInfo) {
        assert (context.isOriginLocal());
        CommandInvocationId invocationId = command.getCommandInvocationId();
        if ((this.isSynchronous(command) || command.isReturnValueExpected()) && !command.hasFlag(Flag.PUT_FOR_EXTERNAL_READ)) {
            this.commandAckCollector.create(invocationId, distributionInfo.owners(), command.getTopologyId());
        }
        if (command.hasFlag(Flag.COMMAND_RETRY)) {
            command.setValueMatcher(command.getValueMatcher().matcherForRetry());
        }
        this.rpcManager.sendTo(distributionInfo.primary(), command, DeliverOrder.NONE);
        return this.returnWith(null);
    }

    private static class BackupOwnerClassifier {
        private final Map<Address, Map<Object, Object>> perBackupKeyValue = new HashMap<Address, Map<Object, Object>>();
        private final ConsistentHash consistentHash;

        private BackupOwnerClassifier(ConsistentHash consistentHash) {
            this.consistentHash = consistentHash;
        }

        public void add(Map.Entry<Object, Object> entry) {
            Iterator<Address> iterator = this.consistentHash.locateOwners(entry.getKey()).iterator();
            iterator.next();
            while (iterator.hasNext()) {
                this.perBackupKeyValue.computeIfAbsent(iterator.next(), address -> new HashMap()).put(entry.getKey(), entry.getValue());
            }
        }
    }

    private static class PrimaryOwnerClassifier {
        private final Map<Address, Collection<Integer>> backups = new HashMap<Address, Collection<Integer>>();
        private final Map<Address, Map<Object, Object>> primaries = new HashMap<Address, Map<Object, Object>>();
        private final ConsistentHash consistentHash;

        private PrimaryOwnerClassifier(ConsistentHash consistentHash) {
            this.consistentHash = consistentHash;
        }

        public void add(Map.Entry<Object, Object> entry) {
            int segment = this.consistentHash.getSegment(entry.getKey());
            Iterator<Address> iterator = this.consistentHash.locateOwnersForSegment(segment).iterator();
            Address primaryOwner = iterator.next();
            this.primaries.computeIfAbsent(primaryOwner, address -> new HashMap()).put(entry.getKey(), entry.getValue());
            while (iterator.hasNext()) {
                Address backup = iterator.next();
                this.backups.computeIfAbsent(backup, address -> new HashSet()).add(segment);
            }
        }
    }
}

