/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.impl;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.function.BiFunction;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.interceptors.BasicInvocationStage;
import org.infinispan.interceptors.InvocationComposeHandler;
import org.infinispan.interceptors.InvocationComposeSuccessHandler;
import org.infinispan.interceptors.InvocationExceptionHandler;
import org.infinispan.interceptors.InvocationFinallyHandler;
import org.infinispan.interceptors.InvocationReturnValueHandler;
import org.infinispan.interceptors.InvocationStage;
import org.infinispan.interceptors.InvocationSuccessHandler;
import org.infinispan.interceptors.impl.AbstractInvocationStage;
import org.infinispan.interceptors.impl.ComposedAsyncInvocationStage;
import org.infinispan.interceptors.impl.ExceptionStage;
import org.infinispan.interceptors.impl.ReturnValueStage;
import org.infinispan.interceptors.impl.Stages;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class AsyncInvocationStage
extends AbstractInvocationStage
implements InvocationStage,
BiFunction<Object, Throwable, Object> {
    private static final Log log = LogFactory.getLog(AsyncInvocationStage.class);
    private static final boolean trace = log.isTraceEnabled();
    private final InvocationComposeHandler handler;
    private CompletableFuture<Object> future;

    public AsyncInvocationStage(InvocationContext ctx, VisitableCommand command, CompletionStage<?> future) {
        super(ctx, command);
        this.handler = null;
        this.future = (CompletableFuture)future;
    }

    private AsyncInvocationStage(InvocationContext ctx, VisitableCommand command, InvocationComposeHandler handler) {
        super(ctx, command);
        this.handler = handler;
    }

    @Override
    public Object get() throws Throwable {
        try {
            return CompletableFutures.await(this.future);
        }
        catch (ExecutionException e) {
            throw e.getCause();
        }
    }

    @Override
    public boolean isDone() {
        return this.future.isDone();
    }

    @Override
    public InvocationStage compose(InvocationComposeHandler composeHandler) {
        return new ComposedAsyncInvocationStage(this.ctx, this.command, (CompletableFuture<BasicInvocationStage>)this.future.handle((T rv, U t) -> {
            AbstractInvocationStage stage = t == null ? new ReturnValueStage(this.ctx, this.command, rv) : new ExceptionStage(this.ctx, this.command, CompletableFutures.extractException(t));
            return stage.compose(composeHandler);
        }));
    }

    @Override
    public InvocationStage thenCompose(InvocationComposeSuccessHandler thenComposeHandler) {
        return this.compose(thenComposeHandler);
    }

    @Override
    public InvocationStage thenApply(InvocationReturnValueHandler returnValueHandler) {
        AsyncInvocationStage newStage = new AsyncInvocationStage(this.ctx, this.command, returnValueHandler);
        newStage.future = this.future.handle((BiFunction)newStage);
        return newStage;
    }

    @Override
    public InvocationStage thenAccept(InvocationSuccessHandler successHandler) {
        AsyncInvocationStage newStage = new AsyncInvocationStage(this.ctx, this.command, successHandler);
        newStage.future = this.future.handle((BiFunction)newStage);
        return newStage;
    }

    @Override
    public InvocationStage exceptionally(InvocationExceptionHandler exceptionHandler) {
        AsyncInvocationStage newStage = new AsyncInvocationStage(this.ctx, this.command, exceptionHandler);
        newStage.future = this.future.handle((BiFunction)newStage);
        return newStage;
    }

    @Override
    public InvocationStage handle(InvocationFinallyHandler finallyHandler) {
        AsyncInvocationStage newStage = new AsyncInvocationStage(this.ctx, this.command, finallyHandler);
        newStage.future = this.future.handle((BiFunction)newStage);
        return newStage;
    }

    @Override
    public CompletableFuture<Object> toCompletableFuture() {
        return this.future;
    }

    @Override
    public InvocationStage toInvocationStage(InvocationContext newCtx, VisitableCommand newCommand) {
        if (newCtx != this.ctx || newCommand != this.command) {
            return new AsyncInvocationStage(newCtx, newCommand, this.future);
        }
        return this;
    }

    @Override
    public Object apply(Object rv, Throwable t) {
        try {
            if (trace) {
                log.tracef("Executing invocation handler %s with command %s", Stages.className(this.handler), this.command);
            }
            if (t == null) {
                if (this.handler instanceof InvocationFinallyHandler) {
                    ((InvocationFinallyHandler)this.handler).accept(this.ctx, this.command, rv, null);
                    return rv;
                }
                if (this.handler instanceof InvocationSuccessHandler) {
                    ((InvocationSuccessHandler)this.handler).accept(this.ctx, this.command, rv);
                    return rv;
                }
                if (this.handler instanceof InvocationReturnValueHandler) {
                    return ((InvocationReturnValueHandler)this.handler).apply(this.ctx, this.command, rv);
                }
                return rv;
            }
            t = CompletableFutures.extractException(t);
            if (this.handler instanceof InvocationFinallyHandler) {
                ((InvocationFinallyHandler)this.handler).accept(this.ctx, this.command, null, t);
                throw t;
            }
            if (this.handler instanceof InvocationExceptionHandler) {
                return ((InvocationExceptionHandler)this.handler).apply(this.ctx, this.command, t);
            }
            throw t;
        }
        catch (Throwable t1) {
            if (trace) {
                log.trace("Exception from invocation handler", t1);
            }
            throw CompletableFutures.asCompletionException(t1);
        }
    }
}

