/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.impl;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.BiFunction;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.interceptors.BasicInvocationStage;
import org.infinispan.interceptors.InvocationComposeHandler;
import org.infinispan.interceptors.InvocationComposeSuccessHandler;
import org.infinispan.interceptors.InvocationExceptionHandler;
import org.infinispan.interceptors.InvocationFinallyHandler;
import org.infinispan.interceptors.InvocationReturnValueHandler;
import org.infinispan.interceptors.InvocationStage;
import org.infinispan.interceptors.InvocationSuccessHandler;
import org.infinispan.interceptors.impl.AbstractInvocationStage;
import org.infinispan.interceptors.impl.ExceptionStage;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ComposedAsyncInvocationStage
extends AbstractInvocationStage
implements InvocationStage,
BiFunction<BasicInvocationStage, Throwable, BasicInvocationStage> {
    private static final Log log = LogFactory.getLog(ComposedAsyncInvocationStage.class);
    private static final boolean trace = log.isTraceEnabled();
    private final InvocationComposeHandler handler;
    private CompletableFuture<BasicInvocationStage> stageFuture;

    public ComposedAsyncInvocationStage(InvocationContext ctx, VisitableCommand command, CompletableFuture<BasicInvocationStage> stageFuture) {
        super(ctx, command);
        this.handler = null;
        this.stageFuture = stageFuture;
    }

    private ComposedAsyncInvocationStage(InvocationContext ctx, VisitableCommand command, InvocationComposeHandler handler) {
        super(ctx, command);
        this.handler = handler;
    }

    @Override
    public Object get() throws Throwable {
        try {
            BasicInvocationStage stage = CompletableFutures.await(this.stageFuture);
            return stage.get();
        }
        catch (ExecutionException e) {
            throw e.getCause();
        }
    }

    @Override
    public boolean isDone() {
        return this.stageFuture.isDone() && this.stageFuture.join().isDone();
    }

    @Override
    public InvocationStage compose(InvocationComposeHandler composeHandler) {
        ComposedAsyncInvocationStage composedStage = new ComposedAsyncInvocationStage(this.ctx, this.command, composeHandler);
        composedStage.stageFuture = this.stageFuture.handle((BiFunction)composedStage);
        return composedStage;
    }

    @Override
    public InvocationStage thenCompose(InvocationComposeSuccessHandler thenComposeHandler) {
        return this.compose(thenComposeHandler);
    }

    @Override
    public InvocationStage thenAccept(InvocationSuccessHandler successHandler) {
        return this.compose(successHandler);
    }

    @Override
    public InvocationStage thenApply(InvocationReturnValueHandler returnValueHandler) {
        return this.compose(returnValueHandler);
    }

    @Override
    public InvocationStage exceptionally(InvocationExceptionHandler exceptionHandler) {
        return this.compose(exceptionHandler);
    }

    @Override
    public InvocationStage handle(InvocationFinallyHandler finallyHandler) {
        return this.compose(finallyHandler);
    }

    @Override
    public CompletableFuture<Object> toCompletableFuture() {
        CompletableFuture<Object> cf = new CompletableFuture<Object>();
        this.stageFuture.whenComplete((stage, t) -> {
            if (t != null) {
                cf.completeExceptionally((Throwable)t);
                return;
            }
            try {
                ((InvocationStage)stage).handle((rCtx, rCommand, rv, t1) -> {
                    if (t1 == null) {
                        cf.complete(rv);
                    } else {
                        cf.completeExceptionally(t1);
                    }
                });
            }
            catch (Throwable t12) {
                cf.complete(t12);
            }
        });
        return cf;
    }

    @Override
    public InvocationStage toInvocationStage(InvocationContext newCtx, VisitableCommand newCommand) {
        if (newCtx != this.ctx || newCommand != this.command) {
            return new ComposedAsyncInvocationStage(newCtx, newCommand, this.stageFuture);
        }
        return this;
    }

    @Override
    public BasicInvocationStage apply(BasicInvocationStage stage, Throwable t) {
        if (this.handler == null) {
            return new ExceptionStage(this.ctx, this.command, new NullPointerException("Handler must be set for apply"));
        }
        if (t != null) {
            stage = new ExceptionStage(this.ctx, this.command, CompletableFutures.extractException(t));
        }
        return stage.toInvocationStage(this.ctx, this.command).compose(this.handler);
    }
}

