/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.impl;

import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.infinispan.commands.AbstractVisitor;
import org.infinispan.commands.DataCommand;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.functional.ReadOnlyKeyCommand;
import org.infinispan.commands.functional.ReadOnlyManyCommand;
import org.infinispan.commands.functional.ReadWriteKeyCommand;
import org.infinispan.commands.functional.ReadWriteKeyValueCommand;
import org.infinispan.commands.functional.ReadWriteManyCommand;
import org.infinispan.commands.functional.ReadWriteManyEntriesCommand;
import org.infinispan.commands.functional.WriteOnlyKeyCommand;
import org.infinispan.commands.functional.WriteOnlyKeyValueCommand;
import org.infinispan.commands.functional.WriteOnlyManyCommand;
import org.infinispan.commands.functional.WriteOnlyManyEntriesCommand;
import org.infinispan.commands.read.AbstractDataCommand;
import org.infinispan.commands.read.GetAllCommand;
import org.infinispan.commands.read.GetCacheEntryCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.remote.GetKeysInGroupCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.write.AbstractDataWriteCommand;
import org.infinispan.commands.write.ApplyDeltaCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.DataWriteCommand;
import org.infinispan.commands.write.EvictCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.commands.write.InvalidateL1Command;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.util.Util;
import org.infinispan.container.DataContainer;
import org.infinispan.container.EntryFactory;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.MVCCEntry;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.container.versioning.VersionGenerator;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.SingleKeyNonTxInvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.distribution.group.GroupFilter;
import org.infinispan.distribution.group.GroupManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.filter.CollectionKeyFilter;
import org.infinispan.filter.CompositeKeyFilter;
import org.infinispan.interceptors.BasicInvocationStage;
import org.infinispan.interceptors.DDAsyncInterceptor;
import org.infinispan.interceptors.InvocationFinallyHandler;
import org.infinispan.interceptors.InvocationStage;
import org.infinispan.interceptors.InvocationSuccessHandler;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.metadata.Metadata;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.transport.Address;
import org.infinispan.statetransfer.OutdatedTopologyException;
import org.infinispan.statetransfer.StateConsumer;
import org.infinispan.statetransfer.StateTransferLock;
import org.infinispan.statetransfer.StateTransferManager;
import org.infinispan.transaction.impl.AbstractCacheTransaction;
import org.infinispan.util.concurrent.IsolationLevel;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.xsite.statetransfer.XSiteStateConsumer;

public class EntryWrappingInterceptor
extends DDAsyncInterceptor {
    private EntryFactory entryFactory;
    private DataContainer<Object, Object> dataContainer;
    protected ClusteringDependentLogic cdl;
    private VersionGenerator versionGenerator;
    private final EntryWrappingVisitor entryWrappingVisitor = new EntryWrappingVisitor();
    private boolean isInvalidation;
    private boolean isSync;
    private StateConsumer stateConsumer;
    private StateTransferLock stateTransferLock;
    private XSiteStateConsumer xSiteStateConsumer;
    private GroupManager groupManager;
    private CacheNotifier notifier;
    private StateTransferManager stateTransferManager;
    private Address localAddress;
    private boolean useRepeatableRead;
    private boolean writeSkewCheck;
    private static final Log log = LogFactory.getLog(EntryWrappingInterceptor.class);
    private static final boolean trace = log.isTraceEnabled();
    private static final EnumSet<Flag> EVICT_FLAGS = EnumSet.of(Flag.SKIP_OWNERSHIP_CHECK, Flag.CACHE_MODE_LOCAL);
    private final InvocationSuccessHandler dataReadReturnHandler = (rCtx, rCommand, rv) -> {
        AbstractDataCommand dataCommand = (AbstractDataCommand)rCommand;
        if (!rCtx.isInTxScope()) {
            this.commitContextEntries(rCtx, dataCommand, null);
        } else if (this.useRepeatableRead) {
            CacheEntry cacheEntry = rCtx.lookupEntry(dataCommand.getKey());
            cacheEntry.setSkipLookup(true);
            if (this.writeSkewCheck) {
                this.addVersionRead((TxInvocationContext)rCtx, cacheEntry, dataCommand.getKey());
            }
        }
        if (rv != null && !(rv instanceof Response)) {
            Object value = dataCommand instanceof GetCacheEntryCommand ? ((CacheEntry)rv).getValue() : rv;
            this.notifier.notifyCacheEntryVisited(dataCommand.getKey(), value, true, rCtx, dataCommand);
            this.notifier.notifyCacheEntryVisited(dataCommand.getKey(), value, false, rCtx, dataCommand);
        }
    };
    private final InvocationSuccessHandler commitEntriesSuccessHandler = (rCtx, rCommand, rv) -> this.commitContextEntries(rCtx, null, null);
    private final InvocationFinallyHandler commitEntriesFinallyHandler = (rCtx, rCommand, rv, t) -> this.commitContextEntries(rCtx, null, null);

    protected Log getLog() {
        return log;
    }

    @Inject
    public void init(EntryFactory entryFactory, DataContainer<Object, Object> dataContainer, ClusteringDependentLogic cdl, StateConsumer stateConsumer, StateTransferLock stateTransferLock, XSiteStateConsumer xSiteStateConsumer, GroupManager groupManager, CacheNotifier notifier, StateTransferManager stateTransferManager, VersionGenerator versionGenerator) {
        this.entryFactory = entryFactory;
        this.dataContainer = dataContainer;
        this.cdl = cdl;
        this.stateConsumer = stateConsumer;
        this.stateTransferLock = stateTransferLock;
        this.xSiteStateConsumer = xSiteStateConsumer;
        this.groupManager = groupManager;
        this.notifier = notifier;
        this.stateTransferManager = stateTransferManager;
        this.versionGenerator = versionGenerator;
    }

    @Start
    public void start() {
        this.isInvalidation = this.cacheConfiguration.clustering().cacheMode().isInvalidation();
        this.isSync = this.cacheConfiguration.clustering().cacheMode().isSynchronous();
        this.localAddress = this.cdl.getAddress();
        this.useRepeatableRead = this.cacheConfiguration.transaction().transactionMode().isTransactional() && this.cacheConfiguration.locking().isolationLevel() == IsolationLevel.REPEATABLE_READ;
        this.writeSkewCheck = this.cacheConfiguration.locking().writeSkewCheck();
    }

    private boolean ignoreOwnership(FlagAffectedCommand command) {
        return command.hasFlag(Flag.CACHE_MODE_LOCAL) || command.hasFlag(Flag.SKIP_OWNERSHIP_CHECK);
    }

    private boolean canRead(Object key) {
        return this.stateTransferManager == null || this.stateTransferManager.getCacheTopology().getReadConsistentHash().isKeyLocalToNode(this.localAddress, key);
    }

    @Override
    public BasicInvocationStage visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        this.wrapEntriesForPrepare(ctx, command);
        if (!this.shouldCommitDuringPrepare(command, ctx)) {
            return this.invokeNext(ctx, command);
        }
        return this.invokeNext(ctx, command).thenAccept(this.commitEntriesSuccessHandler);
    }

    @Override
    public BasicInvocationStage visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
        return this.invokeNext(ctx, command).handle(this.commitEntriesFinallyHandler);
    }

    @Override
    public final BasicInvocationStage visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        return this.visitDataReadCommand(ctx, command);
    }

    @Override
    public final BasicInvocationStage visitGetCacheEntryCommand(InvocationContext ctx, GetCacheEntryCommand command) throws Throwable {
        return this.visitDataReadCommand(ctx, command);
    }

    private BasicInvocationStage visitDataReadCommand(InvocationContext ctx, AbstractDataCommand command) {
        this.entryFactory.wrapEntryForReading(ctx, command.getKey(), this.ignoreOwnership(command) || this.canRead(command.getKey()));
        return this.invokeNext(ctx, command).thenAccept(this.dataReadReturnHandler);
    }

    @Override
    public BasicInvocationStage visitGetAllCommand(InvocationContext ctx, GetAllCommand command) throws Throwable {
        boolean ignoreOwnership = this.ignoreOwnership(command);
        for (Object key : command.getKeys()) {
            this.entryFactory.wrapEntryForReading(ctx, key, ignoreOwnership || this.canRead(key));
        }
        return this.invokeNext(ctx, command).handle((rCtx, rCommand, rv, t) -> {
            GetAllCommand getAllCommand = (GetAllCommand)rCommand;
            if (this.useRepeatableRead) {
                for (Object key : getAllCommand.getKeys()) {
                    rCtx.lookupEntry(key).setSkipLookup(true);
                }
            }
            if (t == null && rv instanceof Map) {
                log.tracef("Notifying getAll? %s; result %s", !command.hasFlag(Flag.SKIP_LISTENER_NOTIFICATION), rv);
                Map map = (Map)rv;
                if (!command.hasFlag(Flag.SKIP_LISTENER_NOTIFICATION)) {
                    for (Map.Entry entry : map.entrySet()) {
                        Object value = entry.getValue();
                        if (value == null) continue;
                        value = command.isReturnEntries() ? ((CacheEntry)value).getValue() : entry.getValue();
                        this.notifier.notifyCacheEntryVisited(entry.getKey(), value, true, rCtx, getAllCommand);
                        this.notifier.notifyCacheEntryVisited(entry.getKey(), value, false, rCtx, getAllCommand);
                    }
                }
            }
        });
    }

    @Override
    public final BasicInvocationStage visitInvalidateCommand(InvocationContext ctx, InvalidateCommand command) throws Throwable {
        if (command.getKeys() != null) {
            for (Object key : command.getKeys()) {
                this.entryFactory.wrapEntryForWriting(ctx, key, true);
            }
        }
        return this.setSkipRemoteGetsAndInvokeNextForManyEntriesCommand(ctx, command);
    }

    @Override
    public final BasicInvocationStage visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        return this.invokeNext(ctx, command).thenAccept((rCtx, rCommand, rv) -> {
            if (this.stateConsumer != null) {
                this.stateConsumer.stopApplyingState();
            }
            if (this.xSiteStateConsumer != null) {
                this.xSiteStateConsumer.endStateTransfer(null);
            }
            if (!rCtx.isInTxScope()) {
                ClearCommand clearCommand = (ClearCommand)rCommand;
                this.applyChanges(rCtx, clearCommand, null);
            }
            if (trace) {
                log.tracef("The return value is %s", rv);
            }
        });
    }

    @Override
    public BasicInvocationStage visitInvalidateL1Command(InvocationContext ctx, InvalidateL1Command command) throws Throwable {
        for (Object key : command.getKeys()) {
            this.entryFactory.wrapEntryForWriting(ctx, key, false);
            if (!trace) continue;
            log.tracef("Entry to be removed: %s", Util.toStr((Object)key));
        }
        return this.setSkipRemoteGetsAndInvokeNextForManyEntriesCommand(ctx, command);
    }

    @Override
    public final BasicInvocationStage visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        this.wrapEntryIfNeeded(ctx, command);
        return this.setSkipRemoteGetsAndInvokeNextForDataCommand(ctx, command, command.getMetadata());
    }

    private void wrapEntryIfNeeded(InvocationContext ctx, AbstractDataWriteCommand command) throws Throwable {
        if (command.hasFlag(Flag.COMMAND_RETRY)) {
            this.removeFromContextOnRetry(ctx, command.getKey());
        }
        this.entryFactory.wrapEntryForWriting(ctx, command.getKey(), this.ignoreOwnership(command) || this.canRead(command.getKey()));
    }

    private void removeFromContextOnRetry(InvocationContext ctx, Object key) {
        if (this.useRepeatableRead) {
            MVCCEntry entry = (MVCCEntry)ctx.lookupEntry(key);
            if (trace) {
                log.tracef("This is a retry - resetting previous value in entry ", entry);
            }
            entry.resetCurrentValue();
        } else {
            if (trace) {
                log.tracef("This is a retry - removing looked up entry " + ctx.lookupEntry(key), new Object[0]);
            }
            ctx.removeLookedUpEntry(key);
        }
    }

    private void removeFromContextOnRetry(InvocationContext ctx, Collection<?> keys) {
        if (this.useRepeatableRead) {
            for (Object key : keys) {
                MVCCEntry entry = (MVCCEntry)ctx.lookupEntry(key);
                if (trace) {
                    log.tracef("This is a retry - resetting previous value in entry ", entry);
                }
                entry.resetCurrentValue();
            }
        } else {
            for (Object key : keys) {
                if (trace) {
                    log.tracef("This is a retry - removing looked up entry " + ctx.lookupEntry(key), new Object[0]);
                }
                ctx.removeLookedUpEntry(key);
            }
        }
    }

    @Override
    public BasicInvocationStage visitApplyDeltaCommand(InvocationContext ctx, ApplyDeltaCommand command) throws Throwable {
        if (command.hasFlag(Flag.COMMAND_RETRY)) {
            this.removeFromContextOnRetry(ctx, command.getKey());
        }
        this.entryFactory.wrapEntryForDelta(ctx, command.getKey(), command.getDelta(), this.ignoreOwnership(command) || this.canRead(command.getKey()));
        return this.invokeNext(ctx, command);
    }

    @Override
    public final BasicInvocationStage visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        this.wrapEntryIfNeeded(ctx, command);
        return this.setSkipRemoteGetsAndInvokeNextForDataCommand(ctx, command, null);
    }

    @Override
    public final BasicInvocationStage visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        if (command.hasFlag(Flag.COMMAND_RETRY)) {
            this.removeFromContextOnRetry(ctx, command.getKey());
        }
        this.entryFactory.wrapEntryForWriting(ctx, command.getKey(), this.ignoreOwnership(command) || this.canRead(command.getKey()));
        return this.setSkipRemoteGetsAndInvokeNextForDataCommand(ctx, command, command.getMetadata());
    }

    @Override
    public BasicInvocationStage visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        boolean ignoreOwnership = this.ignoreOwnership(command);
        if (command.hasFlag(Flag.COMMAND_RETRY)) {
            this.removeFromContextOnRetry(ctx, command.getAffectedKeys());
        }
        for (Object key : command.getMap().keySet()) {
            this.entryFactory.wrapEntryForWriting(ctx, key, ignoreOwnership || this.canRead(key));
        }
        return this.setSkipRemoteGetsAndInvokeNextForManyEntriesCommand(ctx, command);
    }

    @Override
    public BasicInvocationStage visitEvictCommand(InvocationContext ctx, EvictCommand command) throws Throwable {
        command.addFlags(EVICT_FLAGS);
        return this.visitRemoveCommand(ctx, command);
    }

    @Override
    public BasicInvocationStage visitGetKeysInGroupCommand(InvocationContext ctx, GetKeysInGroupCommand command) throws Throwable {
        String groupName = command.getGroupName();
        if (command.isGroupOwner()) {
            CompositeKeyFilter keyFilter = new CompositeKeyFilter(new GroupFilter(groupName, this.groupManager), new CollectionKeyFilter<Object>(ctx.getLookedUpEntries().keySet()));
            this.dataContainer.executeTask(keyFilter, (o, internalCacheEntry) -> {
                InvocationContext invocationContext = ctx;
                synchronized (invocationContext) {
                    this.entryFactory.wrapExternalEntry(ctx, internalCacheEntry.getKey(), (CacheEntry)internalCacheEntry, false);
                }
            });
        }
        InvocationStage stage = this.invokeNext(ctx, command);
        if (ctx.isInTxScope() && this.useRepeatableRead) {
            return stage.thenAccept((rCtx, rCommand, rv) -> {
                TxInvocationContext txCtx = (TxInvocationContext)rCtx;
                for (Map.Entry<Object, CacheEntry> keyEntry : txCtx.getLookedUpEntries().entrySet()) {
                    CacheEntry cacheEntry = keyEntry.getValue();
                    cacheEntry.setSkipLookup(true);
                    if (!this.writeSkewCheck) continue;
                    this.addVersionRead(txCtx, cacheEntry, keyEntry.getKey());
                }
            });
        }
        return stage;
    }

    @Override
    public BasicInvocationStage visitReadOnlyKeyCommand(InvocationContext ctx, ReadOnlyKeyCommand command) throws Throwable {
        this.entryFactory.wrapEntryForReading(ctx, command.getKey(), this.ignoreOwnership(command) || this.canRead(command.getKey()));
        return this.invokeNext(ctx, command);
    }

    @Override
    public BasicInvocationStage visitReadOnlyManyCommand(InvocationContext ctx, ReadOnlyManyCommand command) throws Throwable {
        boolean ignoreOwnership = this.ignoreOwnership(command);
        for (Object key : command.getKeys()) {
            this.entryFactory.wrapEntryForReading(ctx, key, ignoreOwnership || this.canRead(key));
        }
        return this.invokeNext(ctx, command);
    }

    @Override
    public BasicInvocationStage visitWriteOnlyKeyCommand(InvocationContext ctx, WriteOnlyKeyCommand command) throws Throwable {
        this.wrapEntryIfNeeded(ctx, command);
        return this.setSkipRemoteGetsAndInvokeNextForDataCommand(ctx, command, null);
    }

    @Override
    public BasicInvocationStage visitReadWriteKeyValueCommand(InvocationContext ctx, ReadWriteKeyValueCommand command) throws Throwable {
        this.wrapEntryIfNeeded(ctx, command);
        return this.setSkipRemoteGetsAndInvokeNextForDataCommand(ctx, command, null);
    }

    @Override
    public BasicInvocationStage visitReadWriteKeyCommand(InvocationContext ctx, ReadWriteKeyCommand command) throws Throwable {
        this.wrapEntryIfNeeded(ctx, command);
        return this.setSkipRemoteGetsAndInvokeNextForDataCommand(ctx, command, null);
    }

    @Override
    public BasicInvocationStage visitWriteOnlyManyEntriesCommand(InvocationContext ctx, WriteOnlyManyEntriesCommand command) throws Throwable {
        if (command.hasFlag(Flag.COMMAND_RETRY)) {
            this.removeFromContextOnRetry(ctx, command.getAffectedKeys());
        }
        boolean ignoreOwnership = this.ignoreOwnership(command);
        for (Object key : command.getEntries().keySet()) {
            this.entryFactory.wrapEntryForWriting(ctx, key, ignoreOwnership || this.canRead(key));
        }
        return this.setSkipRemoteGetsAndInvokeNextForManyEntriesCommand(ctx, command);
    }

    @Override
    public BasicInvocationStage visitWriteOnlyManyCommand(InvocationContext ctx, WriteOnlyManyCommand command) throws Throwable {
        if (command.hasFlag(Flag.COMMAND_RETRY)) {
            this.removeFromContextOnRetry(ctx, command.getAffectedKeys());
        }
        boolean ignoreOwnership = this.ignoreOwnership(command);
        for (Object key : command.getAffectedKeys()) {
            this.entryFactory.wrapEntryForWriting(ctx, key, ignoreOwnership || this.canRead(key));
        }
        return this.setSkipRemoteGetsAndInvokeNextForManyEntriesCommand(ctx, command);
    }

    @Override
    public BasicInvocationStage visitWriteOnlyKeyValueCommand(InvocationContext ctx, WriteOnlyKeyValueCommand command) throws Throwable {
        this.wrapEntryIfNeeded(ctx, command);
        return this.setSkipRemoteGetsAndInvokeNextForDataCommand(ctx, command, null);
    }

    @Override
    public BasicInvocationStage visitReadWriteManyCommand(InvocationContext ctx, ReadWriteManyCommand command) throws Throwable {
        if (command.hasFlag(Flag.COMMAND_RETRY)) {
            this.removeFromContextOnRetry(ctx, command.getAffectedKeys());
        }
        boolean ignoreOwnership = this.ignoreOwnership(command);
        for (Object key : command.getAffectedKeys()) {
            this.entryFactory.wrapEntryForWriting(ctx, key, ignoreOwnership || this.canRead(key));
        }
        return this.setSkipRemoteGetsAndInvokeNextForManyEntriesCommand(ctx, command);
    }

    @Override
    public BasicInvocationStage visitReadWriteManyEntriesCommand(InvocationContext ctx, ReadWriteManyEntriesCommand command) throws Throwable {
        if (command.hasFlag(Flag.COMMAND_RETRY)) {
            this.removeFromContextOnRetry(ctx, command.getAffectedKeys());
        }
        boolean ignoreOwnership = this.ignoreOwnership(command);
        for (Object key : command.getAffectedKeys()) {
            this.entryFactory.wrapEntryForWriting(ctx, key, ignoreOwnership || this.canRead(key));
        }
        return this.setSkipRemoteGetsAndInvokeNextForManyEntriesCommand(ctx, command);
    }

    private Flag extractStateTransferFlag(InvocationContext ctx, FlagAffectedCommand command) {
        if (command == null) {
            return ctx instanceof TxInvocationContext ? ((AbstractCacheTransaction)((TxInvocationContext)ctx).getCacheTransaction()).getStateTransferFlag() : null;
        }
        if (command.hasFlag(Flag.PUT_FOR_STATE_TRANSFER)) {
            return Flag.PUT_FOR_STATE_TRANSFER;
        }
        if (command.hasFlag(Flag.PUT_FOR_X_SITE_STATE_TRANSFER)) {
            return Flag.PUT_FOR_X_SITE_STATE_TRANSFER;
        }
        return null;
    }

    protected final void commitContextEntries(InvocationContext ctx, FlagAffectedCommand command, Metadata metadata) {
        Flag stateTransferFlag = this.extractStateTransferFlag(ctx, command);
        if (ctx instanceof SingleKeyNonTxInvocationContext) {
            SingleKeyNonTxInvocationContext singleKeyCtx = (SingleKeyNonTxInvocationContext)ctx;
            this.commitEntryIfNeeded(ctx, command, singleKeyCtx.getCacheEntry(), stateTransferFlag, metadata);
        } else {
            Set<Map.Entry<Object, CacheEntry>> entries = ctx.getLookedUpEntries().entrySet();
            Iterator<Map.Entry<Object, CacheEntry>> it = entries.iterator();
            Log log = this.getLog();
            while (it.hasNext()) {
                Map.Entry<Object, CacheEntry> e = it.next();
                CacheEntry entry = e.getValue();
                if (this.commitEntryIfNeeded(ctx, command, entry, stateTransferFlag, metadata) || !trace) continue;
                if (entry == null) {
                    log.tracef("Entry for key %s is null : not calling commitUpdate", Util.toStr((Object)e.getKey()));
                    continue;
                }
                log.tracef("Entry for key %s is not changed(%s): not calling commitUpdate", Util.toStr((Object)e.getKey()), entry);
            }
        }
    }

    protected void commitContextEntry(CacheEntry entry, InvocationContext ctx, FlagAffectedCommand command, Metadata metadata, Flag stateTransferFlag, boolean l1Invalidation) {
        this.cdl.commitEntry(entry, metadata, command, ctx, stateTransferFlag, l1Invalidation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyChanges(InvocationContext ctx, WriteCommand command, Metadata metadata) {
        this.stateTransferLock.acquireSharedTopologyLock();
        try {
            if (!this.isInvalidation) {
                boolean syncRpc;
                boolean bl = syncRpc = this.isSync && !command.hasFlag(Flag.FORCE_ASYNCHRONOUS) || command.hasFlag(Flag.FORCE_SYNCHRONOUS);
                if (command.isSuccessful() && this.stateConsumer != null && this.stateConsumer.getCacheTopology() != null) {
                    int commandTopologyId = command.getTopologyId();
                    int currentTopologyId = this.stateConsumer.getCacheTopology().getTopologyId();
                    if (syncRpc && currentTopologyId != commandTopologyId && commandTopologyId != -1 && (!ctx.isOriginLocal() || !(command instanceof DataCommand) || ctx.hasLockedKey(((DataCommand)((Object)command)).getKey()))) {
                        if (trace) {
                            log.tracef("Cache topology changed while the command was executing: expected %d, got %d", commandTopologyId, currentTopologyId);
                        }
                        command.setValueMatcher(command.getValueMatcher().matcherForRetry());
                        throw new OutdatedTopologyException("Cache topology changed while the command was executing: expected " + commandTopologyId + ", got " + currentTopologyId);
                    }
                }
            }
            this.commitContextEntries(ctx, command, metadata);
        }
        finally {
            this.stateTransferLock.releaseSharedTopologyLock();
        }
    }

    private BasicInvocationStage setSkipRemoteGetsAndInvokeNextForManyEntriesCommand(InvocationContext ctx, WriteCommand command) {
        return this.invokeNext(ctx, command).thenAccept((rCtx, rCommand, rv) -> {
            WriteCommand writeCommand = (WriteCommand)rCommand;
            if (!rCtx.isInTxScope()) {
                this.applyChanges(rCtx, writeCommand, null);
                return;
            }
            if (trace) {
                log.tracef("The return value is %s", Util.toStr((Object)rv));
            }
            if (this.useRepeatableRead) {
                boolean addVersionRead = this.writeSkewCheck && writeCommand.loadType() != VisitableCommand.LoadType.DONT_LOAD;
                TxInvocationContext txCtx = (TxInvocationContext)rCtx;
                for (Object key : writeCommand.getAffectedKeys()) {
                    CacheEntry cacheEntry = rCtx.lookupEntry(key);
                    if (cacheEntry == null) continue;
                    cacheEntry.setSkipLookup(true);
                    if (addVersionRead) {
                        this.addVersionRead(txCtx, cacheEntry, key);
                    }
                    ((MVCCEntry)cacheEntry).updatePreviousValue();
                }
            }
        });
    }

    private void addVersionRead(TxInvocationContext rCtx, CacheEntry cacheEntry, Object key) {
        EntryVersion version;
        if (cacheEntry != null && cacheEntry.getMetadata() != null) {
            version = cacheEntry.getMetadata().version();
            if (trace) {
                log.tracef("Adding version read %s for key %s", version, key);
            }
        } else {
            version = this.versionGenerator.nonExistingVersion();
            if (trace) {
                log.tracef("Adding non-existent version read for key %s", key);
            }
        }
        ((AbstractCacheTransaction)rCtx.getCacheTransaction()).addVersionRead(key, version);
    }

    private BasicInvocationStage setSkipRemoteGetsAndInvokeNextForDataCommand(InvocationContext ctx, DataWriteCommand command, Metadata metadata) {
        return this.invokeNext(ctx, command).thenAccept((rCtx, rCommand, rv) -> {
            CacheEntry cacheEntry;
            DataWriteCommand dataWriteCommand = (DataWriteCommand)rCommand;
            if (!rCtx.isInTxScope()) {
                this.applyChanges(rCtx, dataWriteCommand, metadata);
                return;
            }
            if (trace) {
                log.tracef("The return value is %s", rv);
            }
            if (this.useRepeatableRead && (cacheEntry = rCtx.lookupEntry(dataWriteCommand.getKey())) != null) {
                cacheEntry.setSkipLookup(true);
                if (this.writeSkewCheck && dataWriteCommand.loadType() != VisitableCommand.LoadType.DONT_LOAD) {
                    this.addVersionRead((TxInvocationContext)rCtx, cacheEntry, dataWriteCommand.getKey());
                }
                ((MVCCEntry)cacheEntry).updatePreviousValue();
            }
        });
    }

    private boolean commitEntryIfNeeded(InvocationContext ctx, FlagAffectedCommand command, CacheEntry entry, Flag stateTransferFlag, Metadata metadata) {
        if (entry == null) {
            return false;
        }
        boolean l1Invalidation = command instanceof InvalidateL1Command;
        if (entry.isChanged()) {
            if (trace) {
                log.tracef("About to commit entry %s", entry);
            }
            this.commitContextEntry(entry, ctx, command, metadata, stateTransferFlag, l1Invalidation);
            return true;
        }
        return false;
    }

    protected boolean shouldCommitDuringPrepare(PrepareCommand command, TxInvocationContext ctx) {
        boolean isTotalOrder = this.cacheConfiguration.transaction().transactionProtocol().isTotalOrder();
        return isTotalOrder ? !(!command.isOnePhaseCommit() || ctx.isOriginLocal() && command.hasModifications()) : command.isOnePhaseCommit();
    }

    protected final void wrapEntriesForPrepare(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        if (!ctx.isOriginLocal() || command.isReplayEntryWrapping()) {
            for (WriteCommand c : command.getModifications()) {
                c.setTopologyId(command.getTopologyId());
                InvocationStage visitorStage = (InvocationStage)c.acceptVisitor(ctx, this.entryWrappingVisitor);
                if (visitorStage != null) {
                    visitorStage.get();
                }
                if (!c.hasFlag(Flag.PUT_FOR_X_SITE_STATE_TRANSFER)) continue;
                ((AbstractCacheTransaction)ctx.getCacheTransaction()).setStateTransferFlag(Flag.PUT_FOR_X_SITE_STATE_TRANSFER);
            }
        }
    }

    private final class EntryWrappingVisitor
    extends AbstractVisitor {
        private EntryWrappingVisitor() {
        }

        @Override
        public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
            boolean ignoreOwnership = EntryWrappingInterceptor.this.ignoreOwnership(command);
            for (Object key : command.getAffectedKeys()) {
                EntryWrappingInterceptor.this.entryFactory.wrapEntryForWriting(ctx, key, ignoreOwnership || EntryWrappingInterceptor.this.canRead(key));
            }
            return EntryWrappingInterceptor.this.invokeNext(ctx, command);
        }

        @Override
        public Object visitInvalidateCommand(InvocationContext ctx, InvalidateCommand command) throws Throwable {
            boolean ignoreOwnership = EntryWrappingInterceptor.this.ignoreOwnership(command);
            for (Object key : command.getAffectedKeys()) {
                EntryWrappingInterceptor.this.entryFactory.wrapEntryForWriting(ctx, key, ignoreOwnership || EntryWrappingInterceptor.this.canRead(key));
            }
            return EntryWrappingInterceptor.this.invokeNext(ctx, command);
        }

        @Override
        public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
            EntryWrappingInterceptor.this.entryFactory.wrapEntryForWriting(ctx, command.getKey(), EntryWrappingInterceptor.this.ignoreOwnership(command) || EntryWrappingInterceptor.this.canRead(command.getKey()));
            return EntryWrappingInterceptor.this.invokeNext(ctx, command);
        }

        @Override
        public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
            EntryWrappingInterceptor.this.entryFactory.wrapEntryForWriting(ctx, command.getKey(), EntryWrappingInterceptor.this.ignoreOwnership(command) || EntryWrappingInterceptor.this.canRead(command.getKey()));
            return EntryWrappingInterceptor.this.invokeNext(ctx, command);
        }

        @Override
        public Object visitApplyDeltaCommand(InvocationContext ctx, ApplyDeltaCommand command) throws Throwable {
            EntryWrappingInterceptor.this.entryFactory.wrapEntryForDelta(ctx, command.getKey(), command.getDelta(), EntryWrappingInterceptor.this.ignoreOwnership(command) || EntryWrappingInterceptor.this.canRead(command.getKey()));
            return EntryWrappingInterceptor.this.invokeNext(ctx, command);
        }

        @Override
        public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
            EntryWrappingInterceptor.this.entryFactory.wrapEntryForWriting(ctx, command.getKey(), EntryWrappingInterceptor.this.ignoreOwnership(command) || EntryWrappingInterceptor.this.canRead(command.getKey()));
            return EntryWrappingInterceptor.this.invokeNext(ctx, command);
        }
    }
}

