/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.totalorder;

import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.interceptors.BasicInvocationStage;
import org.infinispan.interceptors.InvocationStage;
import org.infinispan.interceptors.impl.BaseStateTransferInterceptor;
import org.infinispan.interceptors.totalorder.RetryPrepareException;
import org.infinispan.remoting.RemoteException;
import org.infinispan.transaction.impl.RemoteTransaction;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class TotalOrderStateTransferInterceptor
extends BaseStateTransferInterceptor {
    private static final Log log = LogFactory.getLog(TotalOrderStateTransferInterceptor.class);
    private static final boolean trace = log.isTraceEnabled();

    @Override
    public BasicInvocationStage visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        if (ctx.isOriginLocal()) {
            return this.localPrepare(ctx, command);
        }
        return this.remotePrepare(ctx, command);
    }

    private InvocationStage remotePrepare(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        int topologyId = this.currentTopologyId();
        ((RemoteTransaction)ctx.getCacheTransaction()).setLookedUpEntriesTopology(command.getTopologyId());
        if (trace) {
            log.tracef("Remote transaction received %s. Tx topology id is %s and current topology is is %s", ctx.getGlobalTransaction().globalId(), command.getTopologyId(), topologyId);
        }
        if (command.getTopologyId() < topologyId) {
            if (log.isDebugEnabled()) {
                log.debugf("Transaction %s delivered in new topology Id. Discard it because it should be retransmitted", ctx.getGlobalTransaction().globalId());
            }
            throw new RetryPrepareException();
        }
        if (command.getTopologyId() > topologyId) {
            throw new IllegalStateException("This should never happen");
        }
        return this.invokeNext(ctx, command);
    }

    private BasicInvocationStage localPrepare(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        command.setTopologyId(this.currentTopologyId());
        if (trace) {
            log.tracef("Local transaction received %s. setting topology Id to %s", command.getGlobalTransaction().globalId(), command.getTopologyId());
        }
        return this.invokeNext(ctx, command).compose(this::handleLocalPrepareReturn);
    }

    private BasicInvocationStage handleLocalPrepareReturn(BasicInvocationStage invocation, InvocationContext ctx, VisitableCommand command, Object rv, Throwable t) throws Throwable {
        if (t == null) {
            return invocation;
        }
        boolean needsToPrepare = this.needsToRePrepare(t);
        PrepareCommand prepareCommand = (PrepareCommand)command;
        if (log.isDebugEnabled()) {
            log.tracef("Exception caught while preparing transaction %s (cause = %s). Needs to retransmit? %s", prepareCommand.getGlobalTransaction().globalId(), t.getCause(), needsToPrepare);
        }
        if (!needsToPrepare) {
            throw t;
        }
        this.logRetry(command);
        prepareCommand.setTopologyId(this.currentTopologyId());
        return this.invokeNext(ctx, command).compose(this::handleLocalPrepareReturn);
    }

    private boolean needsToRePrepare(Throwable throwable) {
        return throwable instanceof RemoteException && throwable.getCause() instanceof RetryPrepareException;
    }

    @Override
    protected Log getLog() {
        return log;
    }
}

