/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.inboundhandler.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.infinispan.distribution.Ownership;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.remoting.inboundhandler.action.Action;
import org.infinispan.remoting.inboundhandler.action.ActionState;
import org.infinispan.remoting.inboundhandler.action.ActionStatus;
import org.infinispan.util.concurrent.locks.LockUtil;

public abstract class BaseLockingAction
implements Action {
    private static final AtomicReferenceFieldUpdater<BaseLockingAction, InternalState> UPDATER = AtomicReferenceFieldUpdater.newUpdater(BaseLockingAction.class, InternalState.class, "internalState");
    private final ClusteringDependentLogic clusteringDependentLogic;
    private volatile InternalState internalState;

    public BaseLockingAction(ClusteringDependentLogic clusteringDependentLogic) {
        this.clusteringDependentLogic = clusteringDependentLogic;
        this.internalState = InternalState.INIT;
    }

    @Override
    public final ActionStatus check(ActionState state) {
        switch (this.internalState) {
            case INIT: {
                return this.init(state);
            }
            case CHECKING: {
                return this.checking(state);
            }
            case MAKE_READY: {
                return ActionStatus.NOT_READY;
            }
            case READY: {
                return ActionStatus.READY;
            }
            case CANCELED: {
                return ActionStatus.CANCELED;
            }
        }
        return ActionStatus.NOT_READY;
    }

    protected abstract ActionStatus checking(ActionState var1);

    protected abstract ActionStatus init(ActionState var1);

    protected final boolean cas(InternalState expectedState, InternalState newState) {
        return UPDATER.compareAndSet(this, expectedState, newState);
    }

    private void filterByPrimaryOwner(Collection<?> keys, Collection<Object> toAdd) {
        keys.forEach(key -> {
            if (LockUtil.getLockOwnership(key, this.clusteringDependentLogic) == Ownership.PRIMARY) {
                toAdd.add(key);
            }
        });
    }

    protected final List<Object> getAndUpdateFilteredKeys(ActionState state) {
        List<Object> filteredKeys = state.getFilteredKeys();
        if (filteredKeys == null) {
            Collection<?> rawKeys = state.getCommand().getKeysToLock();
            filteredKeys = new ArrayList<Object>(rawKeys.size());
            this.filterByPrimaryOwner(rawKeys, filteredKeys);
            state.updateFilteredKeys(filteredKeys);
        }
        return filteredKeys;
    }

    @Override
    public void cleanup(ActionState state) {
    }

    protected static enum InternalState {
        INIT,
        CHECKING,
        CANCELED,
        MAKE_READY,
        READY;

    }
}

