/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport.jgroups;

import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.infinispan.remoting.responses.Response;
import org.jgroups.SuspectedException;
import org.jgroups.util.Rsp;

public class SingleResponseFuture
extends CompletableFuture<Rsp<Response>>
implements Callable<Void> {
    private final CompletableFuture<Response> request;
    private volatile Future<?> timeoutFuture = null;

    SingleResponseFuture(CompletableFuture<Response> request) {
        this.request = request;
        request.whenComplete(this::requestDone);
    }

    private void requestDone(Response response, Throwable throwable) {
        if (throwable == null) {
            this.complete(new Rsp((Object)response));
        } else if (throwable instanceof SuspectedException) {
            Rsp rsp = new Rsp();
            rsp.setSuspected();
            this.complete(rsp);
        } else {
            this.complete(new Rsp(throwable));
        }
        if (this.timeoutFuture != null) {
            this.timeoutFuture.cancel(false);
        }
    }

    public void setTimeoutFuture(Future<?> timeoutFuture) {
        this.timeoutFuture = timeoutFuture;
        if (this.isDone()) {
            timeoutFuture.cancel(false);
        }
    }

    @Override
    public Void call() throws Exception {
        this.complete(new Rsp());
        this.request.cancel(false);
        return null;
    }
}

