/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories.components;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.util.FileLookup;
import org.infinispan.commons.util.FileLookupFactory;
import org.infinispan.factories.components.ComponentMetadata;
import org.infinispan.factories.components.ModuleMetadataFileFinder;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ComponentMetadataRepo {
    private static final Log log = LogFactory.getLog(ComponentMetadataRepo.class);
    final Map<String, ComponentMetadata> componentMetadataMap = new HashMap<String, ComponentMetadata>(128);
    final Map<String, String> factories = new HashMap<String, String>(16);
    private final ComponentMetadata dependencyFreeComponent = new ComponentMetadata();

    public synchronized void readMetadata(URL metadataFile) throws IOException, ClassNotFoundException {
        Map fact;
        Map comp;
        try (InputStream inputStream = metadataFile.openStream();
             BufferedInputStream bis = new BufferedInputStream(inputStream);
             ObjectInputStream ois = new ObjectInputStream(bis);){
            comp = (Map)ois.readObject();
            fact = (Map)ois.readObject();
        }
        this.componentMetadataMap.putAll(comp);
        this.factories.putAll(fact);
        if (log.isTraceEnabled()) {
            log.tracef("Loaded metadata from '%s': %d components, %d factories", metadataFile, comp.size(), fact.size());
        }
    }

    public ComponentMetadata findComponentMetadata(Class<?> componentType) {
        ComponentMetadata md = null;
        while (md == null) {
            String componentName = componentType.getName();
            md = this.componentMetadataMap.get(componentName);
            if (md != null) continue;
            if (!componentType.equals(Object.class) && !componentType.isInterface()) {
                componentType = componentType.getSuperclass();
                continue;
            }
            md = this.dependencyFreeComponent;
        }
        return md;
    }

    public ComponentMetadata findComponentMetadata(String componentName) {
        return this.componentMetadataMap.get(componentName);
    }

    public String findFactoryForComponent(Class<?> componentType) {
        return this.factories.get(componentType.getName());
    }

    public void initialize(Iterable<ModuleMetadataFileFinder> moduleMetadataFiles, ClassLoader cl) {
        FileLookup fileLookup = FileLookupFactory.newInstance();
        try {
            this.readMetadata(fileLookup.lookupFileLocation("infinispan-core-component-metadata.dat", cl));
        }
        catch (Exception e) {
            throw new CacheException("Unable to load component metadata!", (Throwable)e);
        }
        for (ModuleMetadataFileFinder finder : moduleMetadataFiles) {
            try {
                this.readMetadata(fileLookup.lookupFileLocation(finder.getMetadataFilename(), cl));
            }
            catch (Exception e) {
                throw new CacheException("Unable to load component metadata in file " + finder.getMetadataFilename(), (Throwable)e);
            }
        }
    }

    public void injectFactoryForComponent(Class<?> componentType, Class<?> factoryType) {
        this.factories.put(componentType.getName(), factoryType.getName());
    }

    public boolean hasFactory(String name) {
        return this.factories.containsKey(name);
    }
}

