/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream.impl;

import io.reactivex.internal.queue.SpscArrayQueue;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.util.AbstractIterator;
import org.infinispan.commons.util.CloseableIterable;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class PriorityMergingProcessor<T>
implements CloseableIterable<T> {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private final Collection<PublisherIntPair<T>> pairs;

    public static <T> PriorityMergingProcessor<T> build(Publisher<T> publisher, int firstbatchSize, Publisher<T> secondPublisher, int secondBatchSize) {
        return new PriorityMergingProcessor<T>(publisher, firstbatchSize, secondPublisher, secondBatchSize);
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    private PriorityMergingProcessor(Publisher<T> publisher, int firstbatchSize, Publisher<T> secondPublisher, int secondBatchSize) {
        this.pairs = Arrays.asList(new PublisherIntPair(publisher, firstbatchSize), new PublisherIntPair(secondPublisher, secondBatchSize));
    }

    private PriorityMergingProcessor(Collection<PublisherIntPair<T>> pairs) {
        this.pairs = pairs;
    }

    public void close() {
    }

    public CloseableIterator<T> iterator() {
        MultiSubscriberIterator<T> iterator = new MultiSubscriberIterator<T>(this.pairs);
        iterator.start();
        return iterator;
    }

    static /* synthetic */ Log access$400() {
        return log;
    }

    private static final class QueueSubscriber<T>
    extends AtomicReference<Subscription>
    implements Subscriber<T>,
    AutoCloseable {
        private final Publisher<T> publisher;
        private final SpscArrayQueue<T> queue;
        private final long batchSize;
        private final long limit;
        private MultiSubscriberIterator notifier;
        private long produced;
        private volatile boolean done;

        QueueSubscriber(Publisher<T> publisher, int batchSize, MultiSubscriberIterator subscriber) {
            this.publisher = publisher;
            this.queue = new SpscArrayQueue(batchSize);
            this.batchSize = batchSize;
            this.notifier = subscriber;
            this.limit = batchSize - (batchSize >> 2);
        }

        void start() {
            this.publisher.subscribe((Subscriber)this);
        }

        public T poll() {
            Object returned = this.queue.poll();
            if (returned != null) {
                long p = this.produced + 1L;
                if (p == this.limit) {
                    this.produced = 0L;
                    ((Subscription)this.get()).request(p);
                } else {
                    this.produced = p;
                }
            }
            return (T)returned;
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.setOnce((AtomicReference)this, (Subscription)s)) {
                s.request(this.batchSize);
            }
        }

        public void onNext(T t) {
            if (!this.queue.offer(t)) {
                SubscriptionHelper.cancel((AtomicReference)this);
                this.onError(new IllegalStateException("Too many items requested, this is a bug!"));
            } else {
                this.notifier.signalConsumer();
            }
        }

        public void onError(Throwable t) {
            this.done = true;
            this.notifier.onError(t);
        }

        public void onComplete() {
            this.done = true;
            this.notifier.signalConsumer();
        }

        @Override
        public void close() {
            SubscriptionHelper.cancel((AtomicReference)this);
        }

        public boolean isDone() {
            return this.done;
        }

        @Override
        public String toString() {
            return "QueueSubscriber{queue.empty = " + this.queue.isEmpty() + ", done = " + this.done + "}";
        }
    }

    private static final class MultiSubscriberIterator<T>
    extends AbstractIterator<T>
    implements CloseableIterator<T> {
        private final QueueSubscriber<T>[] queueSubscribers;
        private final Lock lock;
        private final Condition condition;
        private final AtomicBoolean signalled;
        volatile Throwable error;

        MultiSubscriberIterator(Collection<PublisherIntPair<T>> pairs) {
            this.queueSubscribers = new QueueSubscriber[pairs.size()];
            this.signalled = new AtomicBoolean();
            this.lock = new ReentrantLock();
            this.condition = this.lock.newCondition();
            int offset = 0;
            for (PublisherIntPair<T> pair : pairs) {
                QueueSubscriber actualSubscriber = new QueueSubscriber(((PublisherIntPair)pair).publisher, ((PublisherIntPair)pair).batchSize, this);
                this.queueSubscribers[offset++] = actualSubscriber;
            }
        }

        public void start() {
            for (QueueSubscriber<T> queueSubscriber : this.queueSubscribers) {
                queueSubscriber.start();
            }
        }

        static RuntimeException wrapOrThrow(Throwable error) {
            if (!(error instanceof CacheException)) {
                return new CacheException(error);
            }
            return (CacheException)error;
        }

        public void close() {
            for (QueueSubscriber<T> queueSubscriber : this.queueSubscribers) {
                queueSubscriber.close();
            }
            this.signalConsumer();
        }

        /*
         * Exception decompiling
         */
        protected T getNext() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[DOLOOP]], but top level block is 1[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        void onError(Throwable t) {
            this.error = t;
            this.signalConsumer();
        }

        void signalConsumer() {
            this.lock.lock();
            try {
                this.signalled.set(true);
                this.condition.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public static class Builder<T> {
        Stream.Builder<PublisherIntPair<T>> current = Stream.builder();

        Builder<T> addPublisher(Publisher<T> publisher, int batchSize) {
            this.current.accept(new PublisherIntPair(publisher, batchSize));
            return this;
        }

        PriorityMergingProcessor<T> build() {
            return new PriorityMergingProcessor(this.current.build().collect(Collectors.toList()));
        }
    }

    private static class PublisherIntPair<T> {
        private final Publisher<T> publisher;
        private final int batchSize;

        private PublisherIntPair(Publisher<T> publisher, int batchSize) {
            this.publisher = Objects.requireNonNull(publisher);
            if (batchSize <= 0) {
                throw new IllegalArgumentException("batchSize must be greater than 0");
            }
            this.batchSize = batchSize;
        }
    }
}

