/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.topology;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.partitionhandling.AvailabilityMode;
import org.infinispan.remoting.responses.ExceptionResponse;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.responses.UnsuccessfulResponse;
import org.infinispan.remoting.transport.Address;
import org.infinispan.topology.CacheJoinInfo;
import org.infinispan.topology.CacheTopology;
import org.infinispan.topology.ClusterTopologyManager;
import org.infinispan.topology.LocalTopologyManager;
import org.infinispan.topology.PersistentUUID;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class CacheTopologyControlCommand
implements ReplicableCommand {
    private static final Log log = LogFactory.getLog(CacheTopologyControlCommand.class);
    public static final byte COMMAND_ID = 17;
    private transient LocalTopologyManager localTopologyManager;
    private transient ClusterTopologyManager clusterTopologyManager;
    private String cacheName;
    private Type type;
    private Address sender;
    private CacheJoinInfo joinInfo;
    private int topologyId;
    private int rebalanceId;
    private ConsistentHash currentCH;
    private ConsistentHash pendingCH;
    private CacheTopology.Phase phase;
    private AvailabilityMode availabilityMode;
    private List<Address> actualMembers;
    private List<PersistentUUID> persistentUUIDs;
    private Throwable throwable;
    private int viewId;

    public CacheTopologyControlCommand() {
        this.cacheName = null;
    }

    public CacheTopologyControlCommand(String cacheName, Type type, Address sender, int viewId) {
        this.cacheName = cacheName;
        this.type = type;
        this.sender = sender;
        this.viewId = viewId;
    }

    public CacheTopologyControlCommand(String cacheName, Type type, Address sender, CacheJoinInfo joinInfo, int viewId) {
        this.cacheName = cacheName;
        this.type = type;
        this.sender = sender;
        this.joinInfo = joinInfo;
        this.viewId = viewId;
    }

    public CacheTopologyControlCommand(String cacheName, Type type, Address sender, int topologyId, int rebalanceId, Throwable throwable, int viewId) {
        this.cacheName = cacheName;
        this.type = type;
        this.sender = sender;
        this.topologyId = topologyId;
        this.rebalanceId = rebalanceId;
        this.throwable = throwable;
        this.viewId = viewId;
    }

    public CacheTopologyControlCommand(String cacheName, Type type, Address sender, AvailabilityMode availabilityMode, int viewId) {
        this.cacheName = cacheName;
        this.type = type;
        this.sender = sender;
        this.availabilityMode = availabilityMode;
        this.viewId = viewId;
    }

    public CacheTopologyControlCommand(String cacheName, Type type, Address sender, CacheTopology cacheTopology, AvailabilityMode availabilityMode, int viewId) {
        this.cacheName = cacheName;
        this.type = type;
        this.sender = sender;
        this.topologyId = cacheTopology.getTopologyId();
        this.rebalanceId = cacheTopology.getRebalanceId();
        this.currentCH = cacheTopology.getCurrentCH();
        this.pendingCH = cacheTopology.getPendingCH();
        this.phase = cacheTopology.getPhase();
        this.availabilityMode = availabilityMode;
        this.actualMembers = cacheTopology.getActualMembers();
        this.persistentUUIDs = cacheTopology.getMembersPersistentUUIDs();
        this.viewId = viewId;
    }

    @Inject
    public void init(LocalTopologyManager localTopologyManager, ClusterTopologyManager clusterTopologyManager) {
        this.localTopologyManager = localTopologyManager;
        this.clusterTopologyManager = clusterTopologyManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Object> invokeAsync() throws Throwable {
        boolean trace = log.isTraceEnabled();
        LogFactory.pushNDC(this.cacheName, trace);
        try {
            Object responseValue = this.doPerform();
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(SuccessfulResponse.create(responseValue));
            return completableFuture;
        }
        catch (InterruptedException e) {
            log.tracef("Command execution %s was interrupted because the cache manager is shutting down", this);
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(UnsuccessfulResponse.EMPTY);
            return completableFuture;
        }
        catch (Exception t) {
            log.exceptionHandlingCommand(this, t);
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(new ExceptionResponse(t));
            return completableFuture;
        }
        finally {
            LogFactory.popNDC(trace);
        }
    }

    private Object doPerform() throws Exception {
        switch (this.type) {
            case JOIN: {
                return this.clusterTopologyManager.handleJoin(this.cacheName, this.sender, this.joinInfo, this.viewId);
            }
            case LEAVE: {
                this.clusterTopologyManager.handleLeave(this.cacheName, this.sender, this.viewId);
                return null;
            }
            case REBALANCE_PHASE_CONFIRM: {
                this.clusterTopologyManager.handleRebalancePhaseConfirm(this.cacheName, this.sender, this.topologyId, this.throwable, this.viewId);
                return null;
            }
            case SHUTDOWN_REQUEST: {
                this.clusterTopologyManager.handleShutdownRequest(this.cacheName);
                return null;
            }
            case CH_UPDATE: {
                this.localTopologyManager.handleTopologyUpdate(this.cacheName, new CacheTopology(this.topologyId, this.rebalanceId, this.currentCH, this.pendingCH, this.phase, this.actualMembers, this.persistentUUIDs), this.availabilityMode, this.viewId, this.sender);
                return null;
            }
            case STABLE_TOPOLOGY_UPDATE: {
                this.localTopologyManager.handleStableTopologyUpdate(this.cacheName, new CacheTopology(this.topologyId, this.rebalanceId, this.currentCH, this.pendingCH, CacheTopology.Phase.NO_REBALANCE, this.actualMembers, this.persistentUUIDs), this.sender, this.viewId);
                return null;
            }
            case REBALANCE_START: {
                this.localTopologyManager.handleRebalance(this.cacheName, new CacheTopology(this.topologyId, this.rebalanceId, this.currentCH, this.pendingCH, this.phase, this.actualMembers, this.persistentUUIDs), this.viewId, this.sender);
                return null;
            }
            case GET_STATUS: {
                return this.localTopologyManager.handleStatusRequest(this.viewId);
            }
            case SHUTDOWN_PERFORM: {
                this.localTopologyManager.handleCacheShutdown(this.cacheName);
                return null;
            }
            case POLICY_GET_STATUS: {
                return this.clusterTopologyManager.isRebalancingEnabled(this.cacheName);
            }
            case POLICY_ENABLE: {
                this.clusterTopologyManager.setRebalancingEnabled(this.cacheName, true);
                return true;
            }
            case POLICY_DISABLE: {
                this.clusterTopologyManager.setRebalancingEnabled(this.cacheName, false);
                return true;
            }
            case AVAILABILITY_MODE_CHANGE: {
                this.clusterTopologyManager.forceAvailabilityMode(this.cacheName, this.availabilityMode);
                return true;
            }
            case REBALANCING_GET_STATUS: {
                return this.clusterTopologyManager.getRebalancingStatus(this.cacheName);
            }
        }
        throw new CacheException("Unknown cache topology control command type " + (Object)((Object)this.type));
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public Address getOrigin() {
        return this.sender;
    }

    public Type getType() {
        return this.type;
    }

    public int getTopologyId() {
        return this.topologyId;
    }

    public ConsistentHash getCurrentCH() {
        return this.currentCH;
    }

    public ConsistentHash getPendingCH() {
        return this.pendingCH;
    }

    public AvailabilityMode getAvailabilityMode() {
        return this.availabilityMode;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public CacheTopology.Phase getPhase() {
        return this.phase;
    }

    @Override
    public byte getCommandId() {
        return 17;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        MarshallUtil.marshallString((String)this.cacheName, (ObjectOutput)output);
        MarshallUtil.marshallEnum((Enum)this.type, (ObjectOutput)output);
        switch (this.type) {
            case JOIN: {
                output.writeObject(this.sender);
                output.writeObject(this.joinInfo);
                output.writeInt(this.viewId);
                return;
            }
            case LEAVE: {
                output.writeObject(this.sender);
                output.writeInt(this.viewId);
                return;
            }
            case REBALANCE_PHASE_CONFIRM: {
                output.writeObject(this.sender);
                output.writeObject(this.throwable);
                output.writeInt(this.viewId);
                output.writeInt(this.topologyId);
                return;
            }
            case CH_UPDATE: {
                output.writeObject(this.sender);
                output.writeObject(this.currentCH);
                output.writeObject(this.pendingCH);
                MarshallUtil.marshallEnum((Enum)this.phase, (ObjectOutput)output);
                MarshallUtil.marshallCollection(this.actualMembers, (ObjectOutput)output);
                MarshallUtil.marshallCollection(this.persistentUUIDs, (ObjectOutput)output);
                MarshallUtil.marshallEnum((Enum)this.availabilityMode, (ObjectOutput)output);
                output.writeInt(this.topologyId);
                output.writeInt(this.rebalanceId);
                output.writeInt(this.viewId);
                return;
            }
            case STABLE_TOPOLOGY_UPDATE: {
                output.writeObject(this.sender);
                output.writeObject(this.currentCH);
                output.writeObject(this.pendingCH);
                MarshallUtil.marshallCollection(this.actualMembers, (ObjectOutput)output);
                MarshallUtil.marshallCollection(this.persistentUUIDs, (ObjectOutput)output);
                output.writeInt(this.topologyId);
                output.writeInt(this.rebalanceId);
                output.writeInt(this.viewId);
                return;
            }
            case REBALANCE_START: {
                output.writeObject(this.sender);
                output.writeObject(this.currentCH);
                output.writeObject(this.pendingCH);
                MarshallUtil.marshallEnum((Enum)this.phase, (ObjectOutput)output);
                MarshallUtil.marshallCollection(this.actualMembers, (ObjectOutput)output);
                MarshallUtil.marshallCollection(this.persistentUUIDs, (ObjectOutput)output);
                output.writeInt(this.topologyId);
                output.writeInt(this.rebalanceId);
                output.writeInt(this.viewId);
                return;
            }
            case GET_STATUS: {
                output.writeInt(this.viewId);
                return;
            }
            case AVAILABILITY_MODE_CHANGE: {
                MarshallUtil.marshallEnum((Enum)this.availabilityMode, (ObjectOutput)output);
                return;
            }
        }
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.cacheName = MarshallUtil.unmarshallString((ObjectInput)input);
        this.type = (Type)MarshallUtil.unmarshallEnum((ObjectInput)input, ordinal -> Type.CACHED_VALUES[ordinal]);
        switch (this.type) {
            case JOIN: {
                this.sender = (Address)input.readObject();
                this.joinInfo = (CacheJoinInfo)input.readObject();
                this.viewId = input.readInt();
                return;
            }
            case LEAVE: {
                this.sender = (Address)input.readObject();
                this.viewId = input.readInt();
                return;
            }
            case REBALANCE_PHASE_CONFIRM: {
                this.sender = (Address)input.readObject();
                this.throwable = (Throwable)input.readObject();
                this.viewId = input.readInt();
                this.topologyId = input.readInt();
                return;
            }
            case CH_UPDATE: {
                this.sender = (Address)input.readObject();
                this.currentCH = (ConsistentHash)input.readObject();
                this.pendingCH = (ConsistentHash)input.readObject();
                this.phase = (CacheTopology.Phase)MarshallUtil.unmarshallEnum((ObjectInput)input, CacheTopology.Phase::valueOf);
                this.actualMembers = (List)MarshallUtil.unmarshallCollection((ObjectInput)input, ArrayList::new);
                this.persistentUUIDs = (List)MarshallUtil.unmarshallCollection((ObjectInput)input, ArrayList::new);
                this.availabilityMode = (AvailabilityMode)MarshallUtil.unmarshallEnum((ObjectInput)input, AvailabilityMode::valueOf);
                this.topologyId = input.readInt();
                this.rebalanceId = input.readInt();
                this.viewId = input.readInt();
                return;
            }
            case STABLE_TOPOLOGY_UPDATE: {
                this.sender = (Address)input.readObject();
                this.currentCH = (ConsistentHash)input.readObject();
                this.pendingCH = (ConsistentHash)input.readObject();
                this.actualMembers = (List)MarshallUtil.unmarshallCollection((ObjectInput)input, ArrayList::new);
                this.persistentUUIDs = (List)MarshallUtil.unmarshallCollection((ObjectInput)input, ArrayList::new);
                this.topologyId = input.readInt();
                this.rebalanceId = input.readInt();
                this.viewId = input.readInt();
                return;
            }
            case REBALANCE_START: {
                this.sender = (Address)input.readObject();
                this.currentCH = (ConsistentHash)input.readObject();
                this.pendingCH = (ConsistentHash)input.readObject();
                this.phase = (CacheTopology.Phase)MarshallUtil.unmarshallEnum((ObjectInput)input, CacheTopology.Phase::valueOf);
                this.actualMembers = (List)MarshallUtil.unmarshallCollection((ObjectInput)input, ArrayList::new);
                this.persistentUUIDs = (List)MarshallUtil.unmarshallCollection((ObjectInput)input, ArrayList::new);
                this.topologyId = input.readInt();
                this.rebalanceId = input.readInt();
                this.viewId = input.readInt();
                return;
            }
            case GET_STATUS: {
                this.viewId = input.readInt();
                return;
            }
            case AVAILABILITY_MODE_CHANGE: {
                this.availabilityMode = (AvailabilityMode)MarshallUtil.unmarshallEnum((ObjectInput)input, AvailabilityMode::valueOf);
                return;
            }
        }
    }

    public String toString() {
        return "CacheTopologyControlCommand{cache=" + this.cacheName + ", type=" + (Object)((Object)this.type) + ", sender=" + this.sender + ", joinInfo=" + this.joinInfo + ", topologyId=" + this.topologyId + ", rebalanceId=" + this.rebalanceId + ", currentCH=" + this.currentCH + ", pendingCH=" + this.pendingCH + ", availabilityMode=" + (Object)((Object)this.availabilityMode) + ", phase=" + (Object)((Object)this.phase) + ", actualMembers=" + this.actualMembers + ", throwable=" + this.throwable + ", viewId=" + this.viewId + '}';
    }

    @Override
    public boolean isReturnValueExpected() {
        return true;
    }

    @Override
    public boolean canBlock() {
        return true;
    }

    public static enum Type {
        JOIN,
        LEAVE,
        REBALANCE_PHASE_CONFIRM,
        SHUTDOWN_REQUEST,
        CH_UPDATE,
        REBALANCE_START,
        GET_STATUS,
        STABLE_TOPOLOGY_UPDATE,
        SHUTDOWN_PERFORM,
        POLICY_DISABLE,
        POLICY_ENABLE,
        POLICY_GET_STATUS,
        AVAILABILITY_MODE_CHANGE,
        REBALANCING_GET_STATUS;

        private static final Type[] CACHED_VALUES;

        static {
            CACHED_VALUES = Type.values();
        }
    }
}

