/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.triangle;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.concurrent.CompletableFuture;
import org.infinispan.commands.CommandInvocationId;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.commands.write.ValueMatcher;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.InvocationContextFactory;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.util.ByteString;

public abstract class BackupWriteCommand
extends BaseRpcCommand {
    private CommandInvocationId commandInvocationId;
    private int topologyId;
    private long flags;
    private long sequence;
    private int segmentId;
    private InvocationContextFactory invocationContextFactory;
    private AsyncInterceptorChain interceptorChain;

    BackupWriteCommand(ByteString cacheName) {
        super(cacheName);
    }

    @Override
    public final CompletableFuture<Object> invokeAsync() {
        WriteCommand command = this.createWriteCommand();
        command.setFlagsBitSet(this.flags);
        command.addFlags(FlagBitSets.SKIP_LOCKING);
        command.setValueMatcher(ValueMatcher.MATCH_ALWAYS);
        command.setTopologyId(this.topologyId);
        InvocationContext invocationContext = this.createContext(command);
        return this.interceptorChain.invokeAsync(invocationContext, command);
    }

    @Override
    public final boolean isReturnValueExpected() {
        return false;
    }

    @Override
    public final boolean canBlock() {
        return true;
    }

    public final long getSequence() {
        return this.sequence;
    }

    public final void setSequence(long sequence) {
        this.sequence = sequence;
    }

    public final CommandInvocationId getCommandInvocationId() {
        return this.commandInvocationId;
    }

    public final int getTopologyId() {
        return this.topologyId;
    }

    public final long getFlags() {
        return this.flags;
    }

    public final int getSegmentId() {
        return this.segmentId;
    }

    public final void setSegmentId(int segmentId) {
        this.segmentId = segmentId;
    }

    final void writeBase(ObjectOutput output) throws IOException {
        CommandInvocationId.writeTo(output, this.commandInvocationId);
        output.writeInt(this.topologyId);
        output.writeLong(this.flags);
        output.writeLong(this.sequence);
        output.writeInt(this.segmentId);
    }

    final void readBase(ObjectInput input) throws IOException, ClassNotFoundException {
        this.commandInvocationId = CommandInvocationId.readFrom(input);
        this.topologyId = input.readInt();
        this.flags = input.readLong();
        this.sequence = input.readLong();
        this.segmentId = input.readInt();
    }

    void setCommonAttributesFromCommand(WriteCommand command) {
        this.commandInvocationId = command.getCommandInvocationId();
        this.topologyId = command.getTopologyId();
        this.flags = command.getFlagsBitSet();
    }

    abstract WriteCommand createWriteCommand();

    String toStringFields() {
        return "cacheName=" + this.cacheName + ", segment=" + this.segmentId + ", sequence=" + this.sequence + ", commandInvocationId=" + this.commandInvocationId + ", topologyId=" + this.topologyId + ", flags=" + this.flags;
    }

    final void injectDependencies(InvocationContextFactory factory, AsyncInterceptorChain chain) {
        this.invocationContextFactory = factory;
        this.interceptorChain = chain;
    }

    private InvocationContext createContext(WriteCommand command) {
        return this.invocationContextFactory.createRemoteInvocationContextForCommand(command, this.getOrigin());
    }
}

