/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.impl;

import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.VersionedCommitCommand;
import org.infinispan.commands.tx.VersionedPrepareCommand;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.container.versioning.EntryVersionsMap;
import org.infinispan.container.versioning.VersionGenerator;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.InvocationSuccessFunction;
import org.infinispan.interceptors.impl.EntryWrappingInterceptor;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.metadata.Metadata;
import org.infinispan.transaction.impl.AbstractCacheTransaction;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class VersionedEntryWrappingInterceptor
extends EntryWrappingInterceptor {
    private static final Log log = LogFactory.getLog(VersionedEntryWrappingInterceptor.class);
    @Inject
    protected VersionGenerator versionGenerator;
    private final InvocationSuccessFunction prepareHandler = this::prepareHandler;

    @Override
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        VersionedPrepareCommand versionedPrepareCommand = (VersionedPrepareCommand)command;
        if (ctx.isOriginLocal()) {
            versionedPrepareCommand.setVersionsSeen(((AbstractCacheTransaction)ctx.getCacheTransaction()).getVersionsRead());
        }
        return this.wrapEntriesForPrepareAndApply(ctx, command, this.prepareHandler);
    }

    private Object prepareHandler(InvocationContext nonTxCtx, VisitableCommand command, Object nil) {
        TxInvocationContext ctx = (TxInvocationContext)nonTxCtx;
        EntryVersionsMap originVersionData = ctx.isOriginLocal() && !((AbstractCacheTransaction)ctx.getCacheTransaction()).isFromStateTransfer() ? this.cdl.createNewVersionsAndCheckForWriteSkews(this.versionGenerator, ctx, (VersionedPrepareCommand)command) : null;
        return this.invokeNextThenApply(ctx, command, (rCtx, rCommand, rv) -> {
            TxInvocationContext txInvocationContext = (TxInvocationContext)rCtx;
            VersionedPrepareCommand versionedPrepareCommand = (VersionedPrepareCommand)rCommand;
            EntryVersionsMap newVersionData = txInvocationContext.isOriginLocal() ? originVersionData : this.cdl.createNewVersionsAndCheckForWriteSkews(this.versionGenerator, txInvocationContext, versionedPrepareCommand);
            boolean onePhaseCommit = ((PrepareCommand)rCommand).isOnePhaseCommit();
            if (onePhaseCommit) {
                ((AbstractCacheTransaction)txInvocationContext.getCacheTransaction()).setUpdatedEntryVersions(versionedPrepareCommand.getVersionsSeen());
            }
            if (onePhaseCommit) {
                this.commitContextEntries(txInvocationContext, null);
            }
            return newVersionData;
        });
    }

    @Override
    public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
        VersionedCommitCommand versionedCommitCommand = (VersionedCommitCommand)command;
        if (ctx.isOriginLocal()) {
            versionedCommitCommand.setUpdatedVersions(((AbstractCacheTransaction)ctx.getCacheTransaction()).getUpdatedEntryVersions());
        }
        return this.invokeNextAndFinally(ctx, command, (rCtx, rCommand, rv, t) -> this.doCommit(rCtx, (VersionedCommitCommand)rCommand));
    }

    private void doCommit(InvocationContext rCtx, VersionedCommitCommand versionedCommitCommand) {
        if (!rCtx.isOriginLocal()) {
            ((AbstractCacheTransaction)((TxInvocationContext)rCtx).getCacheTransaction()).setUpdatedEntryVersions(versionedCommitCommand.getUpdatedVersions());
        }
        this.commitContextEntries(rCtx, null);
    }

    @Override
    protected void commitContextEntry(CacheEntry entry, InvocationContext ctx, FlagAffectedCommand command, Flag stateTransferFlag, boolean l1Invalidation) {
        if (ctx.isInTxScope() && stateTransferFlag == null) {
            EntryVersion updatedEntryVersion = (EntryVersion)((AbstractCacheTransaction)((TxInvocationContext)ctx).getCacheTransaction()).getUpdatedEntryVersions().get(entry.getKey());
            Metadata commitMetadata = updatedEntryVersion != null ? (entry.getMetadata() == null ? new EmbeddedMetadata.Builder().version(updatedEntryVersion).build() : entry.getMetadata().builder().version(updatedEntryVersion).build()) : entry.getMetadata();
            entry.setMetadata(commitMetadata);
            this.cdl.commitEntry(entry, command, ctx, null, l1Invalidation);
        } else {
            this.cdl.commitEntry(entry, command, ctx, stateTransferFlag, l1Invalidation);
        }
    }
}

