/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.scattered.impl;

import org.infinispan.partitionhandling.AvailabilityMode;
import org.infinispan.partitionhandling.impl.PartitionHandlingManagerImpl;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ScatteredPartitionHandlingManagerImpl
extends PartitionHandlingManagerImpl {
    private static final Log log = LogFactory.getLog(ScatteredPartitionHandlingManagerImpl.class);
    private static final boolean trace = log.isTraceEnabled();

    @Override
    public void doCheck(Object key, boolean isWrite, long flagBitSet) {
        AvailabilityMode availabilityMode = this.getAvailabilityMode();
        if (trace) {
            log.tracef("Checking availability for key=%s, status=%s", key, (Object)availabilityMode);
        }
        if (this.isOperationAllowed(isWrite, flagBitSet)) {
            return;
        }
        if (trace) {
            log.tracef("Partition is in %s mode, access is not allowed for key %s", (Object)availabilityMode, key);
        }
        throw log.degradedModeKeyUnavailable(key);
    }
}

