/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.ch.impl;

import org.infinispan.configuration.cache.HashConfiguration;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.distribution.ch.impl.SingleSegmentKeyPartitioner;
import org.infinispan.distribution.group.impl.GroupManager;
import org.infinispan.distribution.group.impl.GroupingPartitioner;
import org.infinispan.factories.AbstractNamedCacheComponentFactory;
import org.infinispan.factories.AutoInstantiableFactory;
import org.infinispan.factories.annotations.DefaultFactoryFor;
import org.infinispan.factories.annotations.Inject;

@DefaultFactoryFor(classes={KeyPartitioner.class})
public class KeyPartitionerFactory
extends AbstractNamedCacheComponentFactory
implements AutoInstantiableFactory {
    @Inject
    private GroupManager groupManager;

    private KeyPartitioner getConfiguredPartitioner() {
        HashConfiguration hashConfiguration = this.configuration.clustering().hash();
        KeyPartitioner partitioner = hashConfiguration.keyPartitioner();
        partitioner.init(hashConfiguration);
        return partitioner;
    }

    @Override
    public Object construct(String componentName) {
        if (this.configuration.clustering().cacheMode().needsStateTransfer()) {
            KeyPartitioner partitioner = this.getConfiguredPartitioner();
            if (this.groupManager == null) {
                return partitioner;
            }
            this.componentRegistry.wireDependencies(partitioner);
            GroupingPartitioner groupingPartitioner = new GroupingPartitioner(partitioner, this.groupManager);
            return groupingPartitioner;
        }
        if (this.configuration.persistence().stores().stream().filter(StoreConfiguration::segmented).findFirst().isPresent()) {
            return this.getConfiguredPartitioner();
        }
        return SingleSegmentKeyPartitioner.getInstance();
    }
}

