/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream.impl.tx;

import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.infinispan.CacheStream;
import org.infinispan.commons.util.IntSet;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.impl.LocalTxInvocationContext;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.remoting.transport.Address;
import org.infinispan.stream.impl.AbstractCacheStream;
import org.infinispan.stream.impl.DistributedCacheStream;
import org.infinispan.stream.impl.DistributedDoubleCacheStream;
import org.infinispan.stream.impl.DistributedIntCacheStream;
import org.infinispan.stream.impl.DistributedLongCacheStream;
import org.infinispan.stream.impl.tx.TxClusterStreamManager;
import org.infinispan.stream.impl.tx.TxDistributedDoubleCacheStream;
import org.infinispan.stream.impl.tx.TxDistributedIntCacheStream;
import org.infinispan.stream.impl.tx.TxDistributedLongCacheStream;

public class TxDistributedCacheStream<Original, R, K, V>
extends DistributedCacheStream<Original, R> {
    private final Address localAddress;
    private final LocalTxInvocationContext ctx;
    private final ConsistentHash hash;
    private final Function<? super CacheEntry<K, V>, ? extends Original> toOriginalFunction;

    public TxDistributedCacheStream(Address localAddress, boolean parallel, DistributionManager dm, Supplier<CacheStream<R>> supplier, TxClusterStreamManager<Original, K> csm, boolean includeLoader, int distributedBatchSize, Executor executor, ComponentRegistry registry, LocalTxInvocationContext ctx, Function<? super Original, ?> toKeyFunction, Function<? super CacheEntry<K, V>, ? extends Original> toOriginalFunction) {
        super(localAddress, parallel, dm, supplier, csm, includeLoader, distributedBatchSize, executor, registry, toKeyFunction);
        this.localAddress = localAddress;
        this.hash = dm.getWriteConsistentHash();
        this.ctx = ctx;
        this.toOriginalFunction = toOriginalFunction;
    }

    TxDistributedCacheStream(AbstractCacheStream other, Address localAddress, ConsistentHash hash, LocalTxInvocationContext ctx, Function<? super CacheEntry<K, V>, ? extends Original> toOriginalFunction) {
        super(other);
        this.localAddress = localAddress;
        this.hash = hash;
        this.ctx = ctx;
        this.toOriginalFunction = toOriginalFunction;
    }

    @Override
    protected Supplier<Stream<Original>> supplierForSegments(ConsistentHash ch, IntSet targetSegments, Set<Object> excludedKeys, boolean primaryOnly) {
        return () -> {
            Supplier supplier = super.supplierForSegments(ch, targetSegments, excludedKeys, primaryOnly);
            ArrayList contextEntries = new ArrayList();
            this.ctx.forEachValue((key, entry) -> {
                if (!this.isPrimaryOwner(ch, key)) {
                    contextEntries.add(this.toOriginalFunction.apply((CacheEntry<K, V>)entry));
                }
            });
            Stream suppliedStream = supplier.get();
            if (!contextEntries.isEmpty()) {
                return Stream.concat(contextEntries.stream(), suppliedStream);
            }
            return suppliedStream;
        };
    }

    @Override
    protected DistributedDoubleCacheStream<Original> doubleCacheStream() {
        return new TxDistributedDoubleCacheStream(this, this.localAddress, this.hash, this.ctx, this.toOriginalFunction);
    }

    @Override
    protected DistributedLongCacheStream<Original> longCacheStream() {
        return new TxDistributedLongCacheStream(this, this.localAddress, this.hash, this.ctx, this.toOriginalFunction);
    }

    @Override
    protected DistributedIntCacheStream<Original> intCacheStream() {
        return new TxDistributedIntCacheStream(this, this.hash, this.ctx, this.toOriginalFunction);
    }
}

