/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.PrimitiveIterator;
import java.util.Spliterator;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.util.ConcatIterator;
import org.infinispan.commons.util.FlattenSpliterator;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IntSets;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.impl.DefaultSegmentedDataContainer;

public class L1SegmentedDataContainer<K, V>
extends DefaultSegmentedDataContainer<K, V> {
    private final ConcurrentMap<K, InternalCacheEntry<K, V>> nonOwnedEntries;

    public L1SegmentedDataContainer(Supplier<ConcurrentMap<K, InternalCacheEntry<K, V>>> mapSupplier, int numSegments) {
        super(mapSupplier, numSegments);
        this.nonOwnedEntries = mapSupplier.get();
    }

    @Override
    public void stop() {
        super.stop();
        if (this.nonOwnedEntries instanceof AutoCloseable) {
            try {
                ((AutoCloseable)((Object)this.nonOwnedEntries)).close();
            }
            catch (Exception e) {
                throw new CacheException((Throwable)e);
            }
        }
    }

    @Override
    public ConcurrentMap<K, InternalCacheEntry<K, V>> getMapForSegment(int segment) {
        ConcurrentMap map = super.getMapForSegment(segment);
        if (map == null) {
            map = this.nonOwnedEntries;
        }
        return map;
    }

    @Override
    public Iterator<InternalCacheEntry<K, V>> iteratorIncludingExpired(IntSet segments) {
        ArrayList<Collection> valueIterables = new ArrayList<Collection>(segments.size() + 1);
        PrimitiveIterator.OfInt iter = segments.iterator();
        boolean includeOthers = false;
        while (iter.hasNext()) {
            int segment = iter.nextInt();
            ConcurrentMap map = (ConcurrentMap)this.maps.get(segment);
            if (map != null) {
                valueIterables.add(map.values());
                continue;
            }
            includeOthers = true;
        }
        if (includeOthers) {
            valueIterables.add(this.nonOwnedEntries.values().stream().filter(e -> segments.contains(this.getSegmentForKey(e.getKey()))).collect(Collectors.toSet()));
        }
        return new ConcatIterator(valueIterables);
    }

    @Override
    public Iterator<InternalCacheEntry<K, V>> iteratorIncludingExpired() {
        ArrayList valueIterables = new ArrayList(this.maps.length() + 1);
        for (int i = 0; i < this.maps.length(); ++i) {
            ConcurrentMap map = (ConcurrentMap)this.maps.get(i);
            if (map == null) continue;
            valueIterables.add(map.values());
        }
        valueIterables.add(this.nonOwnedEntries.values());
        return new ConcatIterator(valueIterables);
    }

    @Override
    public Spliterator<InternalCacheEntry<K, V>> spliteratorIncludingExpired(IntSet segments) {
        int[] segmentArray = segments.toIntArray();
        AtomicBoolean usedOthers = new AtomicBoolean(false);
        return new FlattenSpliterator(i -> {
            ConcurrentMap map = (ConcurrentMap)this.maps.get(segmentArray[i]);
            if (map == null) {
                if (!usedOthers.getAndSet(true)) {
                    return this.nonOwnedEntries.values().stream().filter(e -> segments.contains(this.getSegmentForKey(e.getKey()))).collect(Collectors.toSet());
                }
                return Collections.emptyList();
            }
            return map.values();
        }, segmentArray.length, 4353);
    }

    @Override
    public Spliterator<InternalCacheEntry<K, V>> spliteratorIncludingExpired() {
        AtomicBoolean usedOthers = new AtomicBoolean(false);
        return new FlattenSpliterator(i -> {
            ConcurrentMap map = (ConcurrentMap)this.maps.get(i);
            if (map == null) {
                if (!usedOthers.getAndSet(true)) {
                    return this.nonOwnedEntries.values();
                }
                return Collections.emptyList();
            }
            return map.values();
        }, this.maps.length(), 4353);
    }

    @Override
    public void clear() {
        this.nonOwnedEntries.clear();
        super.clear();
    }

    @Override
    public void clear(IntSet segments) {
        IntSet extraSegments = null;
        PrimitiveIterator.OfInt iter = segments.iterator();
        while (iter.hasNext()) {
            int segment = iter.nextInt();
            ConcurrentMap map = (ConcurrentMap)this.maps.get(segment);
            if (map != null) {
                map.clear();
                continue;
            }
            if (extraSegments == null) {
                extraSegments = IntSets.mutableEmptySet((int)segments.size());
            }
            extraSegments.set(segment);
        }
        if (extraSegments != null) {
            IntSet finalExtraSegments = extraSegments;
            this.nonOwnedEntries.keySet().removeIf(k -> finalExtraSegments.contains(this.getSegmentForKey(k)));
        }
    }

    @Override
    public void removeSegments(IntSet segments) {
        this.nonOwnedEntries.clear();
        super.removeSegments(segments);
    }
}

