/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hibernate.search.impl;

import java.io.IOException;
import java.io.InputStream;
import org.hibernate.search.engine.service.classloading.spi.ClassLoaderService;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;

public class InfinispanConfigurationParser {
    private final ParserRegistry configurationParser;
    private final ClassLoader ispnClassLoadr = InfinispanConfigurationParser.class.getClassLoader();

    public InfinispanConfigurationParser() {
        this.configurationParser = new ParserRegistry(this.ispnClassLoadr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigurationBuilderHolder parseFile(String filename, String transportOverrideResource, ServiceManager serviceManager) throws IOException {
        ClassLoaderService classLoaderService = (ClassLoaderService)serviceManager.requestService(ClassLoaderService.class);
        try {
            ConfigurationBuilderHolder configurationBuilderHolder = this.parseFile(classLoaderService, filename, transportOverrideResource);
            return configurationBuilderHolder;
        }
        finally {
            serviceManager.releaseService(ClassLoaderService.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConfigurationBuilderHolder parseFile(ClassLoaderService classLoaderService, String filename, String transportOverrideResource) {
        InputStream is = classLoaderService.locateResourceStream(filename);
        try {
            Thread currentThread = Thread.currentThread();
            ClassLoader originalContextClassLoader = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(this.ispnClassLoadr);
                ConfigurationBuilderHolder builderHolder = this.configurationParser.parse(is);
                this.fixClassLoaders(builderHolder);
                this.patchTransportConfiguration(builderHolder, transportOverrideResource);
                ConfigurationBuilderHolder configurationBuilderHolder = builderHolder;
                currentThread.setContextClassLoader(originalContextClassLoader);
                return configurationBuilderHolder;
            }
            catch (Throwable throwable) {
                currentThread.setContextClassLoader(originalContextClassLoader);
                throw throwable;
            }
        }
        finally {
            Util.close((AutoCloseable)is);
        }
    }

    private void fixClassLoaders(ConfigurationBuilderHolder builderHolder) {
        builderHolder.getGlobalConfigurationBuilder().classLoader(this.ispnClassLoadr);
    }

    private void patchTransportConfiguration(ConfigurationBuilderHolder builderHolder, String transportOverrideResource) {
        if (transportOverrideResource != null) {
            builderHolder.getGlobalConfigurationBuilder().transport().addProperty("configurationFile", transportOverrideResource);
        }
    }
}

