package org.infinispan.hibernate.search.logging;

import java.util.Locale;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import org.hibernate.search.exception.SearchException;
import java.lang.String;
import org.jboss.logging.Logger;
import java.lang.Exception;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import javax.naming.NamingException;
import java.lang.Object;
import java.util.Arrays;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2019-06-17T17:26:11+0000")
public class Log_$logger extends DelegatingBasicLogger implements Log, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    public Log_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void unableToRetrieveCacheManagerFromJndi(final String jndiNamespace, final NamingException ne) {
        super.log.logf(FQCN, ERROR, ne, unableToRetrieveCacheManagerFromJndi$str(), jndiNamespace);
    }
    private static final String unableToRetrieveCacheManagerFromJndi = "ISPN026001: Unable to retrieve CacheManager from JNDI [%s]";
    protected String unableToRetrieveCacheManagerFromJndi$str() {
        return unableToRetrieveCacheManagerFromJndi;
    }
    @Override
    public final void unableToReleaseInitialContext(final NamingException ne) {
        super.log.logf(FQCN, ERROR, ne, unableToReleaseInitialContext$str());
    }
    private static final String unableToReleaseInitialContext = "ISPN026002: Unable to release initial context";
    protected String unableToReleaseInitialContext$str() {
        return unableToReleaseInitialContext;
    }
    @Override
    public final void interruptedWhileWaitingForAsyncDeleteFlush() {
        super.log.logf(FQCN, WARN, null, interruptedWhileWaitingForAsyncDeleteFlush$str());
    }
    private static final String interruptedWhileWaitingForAsyncDeleteFlush = "ISPN026003: Interrupted while waiting for asynchronous delete operations to be flushed on the index. Some stale segments might remain in the index.";
    protected String interruptedWhileWaitingForAsyncDeleteFlush$str() {
        return interruptedWhileWaitingForAsyncDeleteFlush;
    }
    @Override
    public final void unableToCloseLuceneDirectory(final Object directory, final Exception e) {
        super.log.logf(FQCN, ERROR, e, unableToCloseLuceneDirectory$str(), directory);
    }
    private static final String unableToCloseLuceneDirectory = "ISPN026004: Unable to properly close Lucene directory %1$s";
    protected String unableToCloseLuceneDirectory$str() {
        return unableToCloseLuceneDirectory;
    }
    private static final String configurationPropertyCantBeEmpty = "ISPN026005: Configuration property '%s' should not be empty: illegal format.";
    protected String configurationPropertyCantBeEmpty$str() {
        return configurationPropertyCantBeEmpty;
    }
    @Override
    public final SearchException configurationPropertyCantBeEmpty(final String key) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), configurationPropertyCantBeEmpty$str(), key));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String getInvalidIntegerValueException = "ISPN026006: %s";
    protected String getInvalidIntegerValueException$str() {
        return getInvalidIntegerValueException;
    }
    @Override
    public final SearchException getInvalidIntegerValueException(final String msg, final Throwable throwable) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), getInvalidIntegerValueException$str(), msg), throwable);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void missingIndexCacheConfiguration(final String metadataCacheName) {
        super.log.logf(FQCN, WARN, null, missingIndexCacheConfiguration$str(), metadataCacheName);
    }
    private static final String missingIndexCacheConfiguration = "ISPN026007: Cache '%s' required for indexing has not been configured. Using an internal default configuration.";
    protected String missingIndexCacheConfiguration$str() {
        return missingIndexCacheConfiguration;
    }
}
