/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.read;

import java.util.Map;
import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.read.AbstractCloseableIteratorCollection;
import org.infinispan.commands.read.AbstractLocalCommand;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.CloseableIteratorSet;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.ForwardingCacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.filter.AcceptAllKeyValueFilter;

public class EntrySetCommand<K, V>
extends AbstractLocalCommand
implements VisitableCommand {
    private final Cache<K, V> cache;

    public EntrySetCommand(Cache<K, V> cache, Set<Flag> flags) {
        this.setFlags(flags);
        this.cache = flags != null ? cache.getAdvancedCache().withFlags(flags.toArray(new Flag[flags.size()])) : cache;
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitEntrySetCommand(ctx, this);
    }

    @Override
    public Set<CacheEntry<K, V>> perform(InvocationContext ctx) throws Throwable {
        return new BackingEntrySet(this.cache);
    }

    public String toString() {
        return "EntrySetCommand{cache=" + this.cache.getName() + '}';
    }

    private static class EntryWrapper<K, V>
    extends ForwardingCacheEntry<K, V> {
        private final Cache<K, V> cache;
        private final CacheEntry<K, V> entry;

        public EntryWrapper(Cache<K, V> cache, CacheEntry<K, V> entry) {
            this.cache = cache;
            this.entry = entry;
        }

        @Override
        protected CacheEntry<K, V> delegate() {
            return this.entry;
        }

        @Override
        public V setValue(V value) {
            this.cache.put(this.entry.getKey(), value);
            return super.setValue(value);
        }
    }

    private static class EntryWrapperIterator<K, V>
    implements CloseableIterator<CacheEntry<K, V>> {
        private final Cache<K, V> cache;
        private final CloseableIterator<CacheEntry<K, V>> iterator;

        public EntryWrapperIterator(Cache<K, V> cache, CloseableIterator<CacheEntry<K, V>> iterator) {
            this.cache = cache;
            this.iterator = iterator;
        }

        @Override
        public void close() {
            this.iterator.close();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public CacheEntry<K, V> next() {
            CacheEntry entry = (CacheEntry)this.iterator.next();
            return new EntryWrapper<K, V>(this.cache, entry);
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }

    private static class BackingEntrySet<K, V>
    extends AbstractCloseableIteratorCollection<CacheEntry<K, V>, K, V>
    implements CloseableIteratorSet<CacheEntry<K, V>> {
        private BackingEntrySet(Cache cache) {
            super(cache);
        }

        @Override
        public CloseableIterator<CacheEntry<K, V>> iterator() {
            return new EntryWrapperIterator(this.cache, this.cache.getAdvancedCache().filterEntries(AcceptAllKeyValueFilter.getInstance()).iterator());
        }

        @Override
        public boolean contains(Object o) {
            Map.Entry<K, V> entry = this.toEntry(o);
            if (entry != null) {
                Object value = this.cache.get(entry.getKey());
                return value != null && value.equals(entry.getValue());
            }
            return false;
        }

        @Override
        public boolean remove(Object o) {
            Map.Entry<K, V> entry = this.toEntry(o);
            if (entry != null) {
                return this.cache.remove(entry.getKey(), entry.getValue());
            }
            return false;
        }

        @Override
        public boolean add(CacheEntry<K, V> internalCacheEntry) {
            V value = this.cache.put(internalCacheEntry.getKey(), internalCacheEntry.getValue());
            return value == null || !value.equals(internalCacheEntry.getValue());
        }

        private Map.Entry<K, V> toEntry(Object obj) {
            if (obj instanceof Map.Entry) {
                return (Map.Entry)obj;
            }
            return null;
        }
    }
}

