/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.concurrent.TimeUnit;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.configuration.cache.AbstractStoreConfiguration;
import org.infinispan.configuration.cache.AbstractStoreConfigurationBuilder;
import org.infinispan.configuration.cache.AbstractStoreConfigurationChildBuilder;
import org.infinispan.configuration.cache.AsyncStoreConfiguration;
import org.infinispan.configuration.global.GlobalConfiguration;

public class AsyncStoreConfigurationBuilder<S>
extends AbstractStoreConfigurationChildBuilder<S>
implements Builder<AsyncStoreConfiguration> {
    private boolean enabled = false;
    private long flushLockTimeout = 1L;
    private int modificationQueueSize = 1024;
    private long shutdownTimeout = TimeUnit.SECONDS.toMillis(25L);
    private int threadPoolSize = 1;

    AsyncStoreConfigurationBuilder(AbstractStoreConfigurationBuilder<? extends AbstractStoreConfiguration, ?> builder) {
        super(builder);
    }

    public AsyncStoreConfigurationBuilder<S> enable() {
        this.enabled = true;
        return this;
    }

    public AsyncStoreConfigurationBuilder<S> disable() {
        this.enabled = false;
        return this;
    }

    public AsyncStoreConfigurationBuilder<S> enabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public AsyncStoreConfigurationBuilder<S> flushLockTimeout(long l) {
        this.flushLockTimeout = l;
        return this;
    }

    public AsyncStoreConfigurationBuilder<S> flushLockTimeout(long l, TimeUnit unit) {
        return this.flushLockTimeout(unit.toMillis(l));
    }

    public AsyncStoreConfigurationBuilder<S> modificationQueueSize(int i) {
        this.modificationQueueSize = i;
        return this;
    }

    public AsyncStoreConfigurationBuilder<S> shutdownTimeout(long l) {
        this.shutdownTimeout = l;
        return this;
    }

    public AsyncStoreConfigurationBuilder<S> shutdownTimeout(long l, TimeUnit unit) {
        return this.shutdownTimeout(unit.toMillis(l));
    }

    public AsyncStoreConfigurationBuilder<S> threadPoolSize(int i) {
        this.threadPoolSize = i;
        return this;
    }

    @Override
    public void validate() {
    }

    @Override
    public void validate(GlobalConfiguration globalConfig) {
    }

    @Override
    public AsyncStoreConfiguration create() {
        return new AsyncStoreConfiguration(this.enabled, this.flushLockTimeout, this.modificationQueueSize, this.shutdownTimeout, this.threadPoolSize);
    }

    @Override
    public AsyncStoreConfigurationBuilder<S> read(AsyncStoreConfiguration template) {
        this.enabled = template.enabled();
        this.flushLockTimeout = template.flushLockTimeout();
        this.modificationQueueSize = template.modificationQueueSize();
        this.shutdownTimeout = template.shutdownTimeout();
        this.threadPoolSize = template.threadPoolSize();
        return this;
    }

    public String toString() {
        return "AsyncLoaderConfigurationBuilder{enabled=" + this.enabled + ", flushLockTimeout=" + this.flushLockTimeout + ", modificationQueueSize=" + this.modificationQueueSize + ", shutdownTimeout=" + this.shutdownTimeout + ", threadPoolSize=" + this.threadPoolSize + '}';
    }
}

