/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.Arrays;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.configuration.cache.AbstractConfigurationChildBuilder;
import org.infinispan.configuration.cache.AsyncConfigurationBuilder;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ClusteringConfiguration;
import org.infinispan.configuration.cache.ClusteringConfigurationChildBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.ConfigurationChildBuilder;
import org.infinispan.configuration.cache.HashConfigurationBuilder;
import org.infinispan.configuration.cache.L1ConfigurationBuilder;
import org.infinispan.configuration.cache.PartitionHandlingConfigurationBuilder;
import org.infinispan.configuration.cache.StateTransferConfigurationBuilder;
import org.infinispan.configuration.cache.SyncConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;

public class ClusteringConfigurationBuilder
extends AbstractConfigurationChildBuilder
implements ClusteringConfigurationChildBuilder,
Builder<ClusteringConfiguration> {
    private CacheMode cacheMode = CacheMode.LOCAL;
    private final AsyncConfigurationBuilder asyncConfigurationBuilder = new AsyncConfigurationBuilder(this);
    private final HashConfigurationBuilder hashConfigurationBuilder = new HashConfigurationBuilder(this);
    private final L1ConfigurationBuilder l1ConfigurationBuilder = new L1ConfigurationBuilder(this);
    private final StateTransferConfigurationBuilder stateTransferConfigurationBuilder = new StateTransferConfigurationBuilder(this);
    private final SyncConfigurationBuilder syncConfigurationBuilder = new SyncConfigurationBuilder(this);
    private final PartitionHandlingConfigurationBuilder partitionHandlingConfigurationBuilder = new PartitionHandlingConfigurationBuilder(this);

    ClusteringConfigurationBuilder(ConfigurationBuilder builder) {
        super(builder);
    }

    public ClusteringConfigurationBuilder cacheMode(CacheMode cacheMode) {
        this.cacheMode = cacheMode;
        return this;
    }

    public CacheMode cacheMode() {
        return this.cacheMode;
    }

    @Override
    public AsyncConfigurationBuilder async() {
        if (this.cacheMode.isSynchronous()) {
            throw new IllegalStateException("Cannot configure a async for an sync cache. Set the cache mode to async first.");
        }
        return this.asyncConfigurationBuilder;
    }

    @Override
    public HashConfigurationBuilder hash() {
        return this.hashConfigurationBuilder;
    }

    @Override
    public L1ConfigurationBuilder l1() {
        return this.l1ConfigurationBuilder;
    }

    @Override
    public StateTransferConfigurationBuilder stateTransfer() {
        return this.stateTransferConfigurationBuilder;
    }

    @Override
    public SyncConfigurationBuilder sync() {
        if (!this.cacheMode.isSynchronous()) {
            throw new IllegalStateException("Cannot configure a sync for an async cache. Set the cache mode to sync first.");
        }
        return this.syncConfigurationBuilder;
    }

    @Override
    public PartitionHandlingConfigurationBuilder partitionHandling() {
        return this.partitionHandlingConfigurationBuilder;
    }

    @Override
    public void validate() {
        for (Builder builder : Arrays.asList(this.asyncConfigurationBuilder, this.hashConfigurationBuilder, this.l1ConfigurationBuilder, this.syncConfigurationBuilder, this.stateTransferConfigurationBuilder, this.partitionHandlingConfigurationBuilder)) {
            builder.validate();
        }
    }

    @Override
    public void validate(GlobalConfiguration globalConfig) {
        if (this.cacheMode().isClustered() && globalConfig.transport().transport() == null) {
            throw new CacheConfigurationException("Must have a transport set in the global configuration in order to define a clustered cache");
        }
        for (ConfigurationChildBuilder configurationChildBuilder : Arrays.asList(this.asyncConfigurationBuilder, this.hashConfigurationBuilder, this.l1ConfigurationBuilder, this.syncConfigurationBuilder, this.stateTransferConfigurationBuilder, this.partitionHandlingConfigurationBuilder)) {
            configurationChildBuilder.validate(globalConfig);
        }
    }

    @Override
    public ClusteringConfiguration create() {
        return new ClusteringConfiguration(this.cacheMode, this.asyncConfigurationBuilder.create(), this.hashConfigurationBuilder.create(), this.l1ConfigurationBuilder.create(), this.stateTransferConfigurationBuilder.create(), this.syncConfigurationBuilder.create(), this.partitionHandlingConfigurationBuilder.create());
    }

    public ClusteringConfigurationBuilder read(ClusteringConfiguration template) {
        this.cacheMode = template.cacheMode();
        this.asyncConfigurationBuilder.read(template.async());
        this.hashConfigurationBuilder.read(template.hash());
        this.l1ConfigurationBuilder.read(template.l1());
        this.stateTransferConfigurationBuilder.read(template.stateTransfer());
        this.syncConfigurationBuilder.read(template.sync());
        this.partitionHandlingConfigurationBuilder.read(template.partitionHandling());
        return this;
    }

    public String toString() {
        return "ClusteringConfigurationBuilder{async=" + this.asyncConfigurationBuilder + ", cacheMode=" + (Object)((Object)this.cacheMode) + ", hash=" + this.hashConfigurationBuilder + ", l1=" + this.l1ConfigurationBuilder + ", stateTransfer=" + this.stateTransferConfigurationBuilder + ", sync=" + this.syncConfigurationBuilder + '}';
    }
}

