/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.LinkedList;
import java.util.List;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.configuration.cache.AbstractClusteringConfigurationChildBuilder;
import org.infinispan.configuration.cache.ClusteringConfigurationBuilder;
import org.infinispan.configuration.cache.GroupsConfiguration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.distribution.group.Grouper;

public class GroupsConfigurationBuilder
extends AbstractClusteringConfigurationChildBuilder
implements Builder<GroupsConfiguration> {
    private boolean enabled = false;
    private List<Grouper<?>> groupers = new LinkedList();

    protected GroupsConfigurationBuilder(ClusteringConfigurationBuilder builder) {
        super(builder);
    }

    public GroupsConfigurationBuilder enabled() {
        this.enabled = true;
        return this;
    }

    public GroupsConfigurationBuilder enabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public GroupsConfigurationBuilder disabled() {
        this.enabled = false;
        return this;
    }

    public GroupsConfigurationBuilder withGroupers(List<Grouper<?>> groupers) {
        this.groupers = groupers;
        return this;
    }

    public GroupsConfigurationBuilder clearGroupers() {
        this.groupers = new LinkedList();
        return this;
    }

    public GroupsConfigurationBuilder addGrouper(Grouper<?> grouper) {
        this.groupers.add(grouper);
        return this;
    }

    @Override
    public void validate() {
    }

    @Override
    public void validate(GlobalConfiguration globalConfig) {
    }

    @Override
    public GroupsConfiguration create() {
        return new GroupsConfiguration(this.enabled, this.groupers);
    }

    public GroupsConfigurationBuilder read(GroupsConfiguration template) {
        this.enabled = template.enabled();
        this.groupers = template.groupers();
        return this;
    }

    public String toString() {
        return "GroupsConfigurationBuilder{enabled=" + this.enabled + ", groupers=" + this.groupers + '}';
    }
}

