/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.partitionhandling.impl;

import java.util.List;
import org.infinispan.Cache;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.partitionhandling.AvailabilityMode;
import org.infinispan.partitionhandling.impl.PartitionHandlingManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.statetransfer.StateTransferManager;
import org.infinispan.topology.CacheTopology;
import org.infinispan.topology.LocalTopologyManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class PartitionHandlingManagerImpl
implements PartitionHandlingManager {
    private static final Log log = LogFactory.getLog(PartitionHandlingManagerImpl.class);
    private static final boolean trace = log.isTraceEnabled();
    private volatile AvailabilityMode availabilityMode = AvailabilityMode.AVAILABLE;
    private DistributionManager distributionManager;
    private LocalTopologyManager localTopologyManager;
    private StateTransferManager stateTransferManager;
    private String cacheName;
    private CacheNotifier notifier;

    @Inject
    void init(DistributionManager distributionManager, LocalTopologyManager localTopologyManager, StateTransferManager stateTransferManager, Cache cache, CacheNotifier notifier) {
        this.distributionManager = distributionManager;
        this.localTopologyManager = localTopologyManager;
        this.stateTransferManager = stateTransferManager;
        this.cacheName = cache.getName();
        this.notifier = notifier;
    }

    @Start
    void start() {
    }

    @Override
    public void setAvailabilityMode(AvailabilityMode availabilityMode) {
        if (availabilityMode != this.availabilityMode) {
            log.debugf("Updating availability for cache %s: %s -> %s", (Object)this.cacheName, (Object)this.availabilityMode, (Object)availabilityMode);
            this.notifier.notifyPartitionStatusChanged(availabilityMode, true);
            this.availabilityMode = availabilityMode;
            this.notifier.notifyPartitionStatusChanged(availabilityMode, false);
        }
    }

    @Override
    public AvailabilityMode getAvailabilityMode() {
        return this.availabilityMode;
    }

    @Override
    public void checkWrite(Object key) {
        this.doCheck(key);
    }

    @Override
    public void checkRead(Object key) {
        this.doCheck(key);
    }

    private void doCheck(Object key) {
        if (trace) {
            log.tracef("Checking availability for key=%s, status=%s", key, (Object)this.availabilityMode);
        }
        if (this.availabilityMode == AvailabilityMode.AVAILABLE) {
            return;
        }
        List<Address> owners = this.distributionManager.locate(key);
        List<Address> actualMembers = this.stateTransferManager.getCacheTopology().getActualMembers();
        if (!actualMembers.containsAll(owners)) {
            if (trace) {
                log.tracef("Partition is in %s mode, access is not allowed for key %s", (Object)this.availabilityMode, key);
            }
            throw log.degradedModeKeyUnavailable(key);
        }
        if (trace) {
            log.tracef("Key %s is available.", key);
        }
    }

    @Override
    public void checkClear() {
        if (this.availabilityMode != AvailabilityMode.AVAILABLE) {
            throw log.clearDisallowedWhilePartitioned();
        }
    }

    @Override
    public void checkBulkRead() {
        if (this.availabilityMode != AvailabilityMode.AVAILABLE) {
            throw log.partitionDegraded();
        }
    }

    @Override
    public CacheTopology getLastStableTopology() {
        return this.localTopologyManager.getStableCacheTopology(this.cacheName);
    }
}

