/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.protoparser;

import com.squareup.protoparser.ExtendDeclaration;
import com.squareup.protoparser.Option;
import com.squareup.protoparser.Service;
import com.squareup.protoparser.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ProtoFile {
    public static final int MIN_TAG_VALUE = 1;
    public static final int MAX_TAG_VALUE = 0x1FFFFFFF;
    private static final int RESERVED_TAG_VALUE_START = 19000;
    private static final int RESERVED_TAG_VALUE_END = 19999;
    private final String fileName;
    private final String packageName;
    private final List<String> dependencies;
    private final List<String> publicDependencies;
    private final List<Type> types;
    private final List<Service> services;
    private final List<Option> options;
    private final List<ExtendDeclaration> extendDeclarations;

    public static boolean isValidTag(int value) {
        return value >= 1 && value < 19000 || value > 19999 && value <= 0x1FFFFFFF;
    }

    public ProtoFile(String fileName, String packageName, List<String> dependencies, List<String> publicDependencies, List<Type> types, List<Service> services, List<Option> options, List<ExtendDeclaration> extendDeclarations) {
        if (fileName == null) {
            throw new NullPointerException("fileName");
        }
        if (dependencies == null) {
            throw new NullPointerException("dependencies");
        }
        if (publicDependencies == null) {
            throw new NullPointerException("publicDependencies");
        }
        if (types == null) {
            throw new NullPointerException("types");
        }
        if (services == null) {
            throw new NullPointerException("services");
        }
        if (options == null) {
            throw new NullPointerException("options");
        }
        if (extendDeclarations == null) {
            throw new NullPointerException("extendDeclarations");
        }
        this.fileName = fileName;
        this.packageName = packageName;
        this.dependencies = Collections.unmodifiableList(new ArrayList<String>(dependencies));
        this.publicDependencies = Collections.unmodifiableList(new ArrayList<String>(publicDependencies));
        this.types = Collections.unmodifiableList(new ArrayList<Type>(types));
        this.services = Collections.unmodifiableList(new ArrayList<Service>(services));
        this.options = Collections.unmodifiableList(new ArrayList<Option>(options));
        this.extendDeclarations = Collections.unmodifiableList(new ArrayList<ExtendDeclaration>(extendDeclarations));
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public List<String> getDependencies() {
        return this.dependencies;
    }

    public List<String> getPublicDependencies() {
        return this.publicDependencies;
    }

    public List<Type> getTypes() {
        return this.types;
    }

    public List<Service> getServices() {
        return this.services;
    }

    public List<Option> getOptions() {
        return this.options;
    }

    public List<ExtendDeclaration> getExtendDeclarations() {
        return this.extendDeclarations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProtoFile)) {
            return false;
        }
        ProtoFile that = (ProtoFile)o;
        return this.dependencies.equals(that.dependencies) && this.extendDeclarations.equals(that.extendDeclarations) && this.fileName.equals(that.fileName) && this.options.equals(that.options) && (this.packageName == null ? that.packageName == null : this.packageName.equals(that.packageName)) && this.publicDependencies.equals(that.publicDependencies) && this.services.equals(that.services) && this.types.equals(that.types);
    }

    public int hashCode() {
        int result = this.fileName.hashCode();
        result = 31 * result + (this.packageName != null ? this.packageName.hashCode() : 0);
        result = 31 * result + this.dependencies.hashCode();
        result = 31 * result + this.publicDependencies.hashCode();
        result = 31 * result + this.types.hashCode();
        result = 31 * result + this.services.hashCode();
        result = 31 * result + this.options.hashCode();
        result = 31 * result + this.extendDeclarations.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (!this.fileName.isEmpty()) {
            builder.append("// ").append(this.fileName).append('\n');
        }
        if (this.packageName != null) {
            builder.append("package ").append(this.packageName).append(";\n");
        }
        if (!this.dependencies.isEmpty() || !this.publicDependencies.isEmpty()) {
            builder.append('\n');
            for (String dependency : this.dependencies) {
                builder.append("import \"").append(dependency).append("\";\n");
            }
            for (String publicDependency : this.publicDependencies) {
                builder.append("import public \"").append(publicDependency).append("\";\n");
            }
        }
        if (!this.options.isEmpty()) {
            builder.append('\n');
            for (Option option : this.options) {
                builder.append(option.toDeclaration());
            }
        }
        if (!this.types.isEmpty()) {
            builder.append('\n');
            for (Type type : this.types) {
                builder.append(type);
            }
        }
        if (!this.extendDeclarations.isEmpty()) {
            builder.append('\n');
            for (ExtendDeclaration extendDeclaration : this.extendDeclarations) {
                builder.append(extendDeclaration);
            }
        }
        if (!this.services.isEmpty()) {
            builder.append('\n');
            for (Service service : this.services) {
                builder.append(service);
            }
        }
        return builder.toString();
    }
}

