/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.exceptions;

public class HotRodClientException
extends RuntimeException {
    private long messageId = -1L;
    private int errorStatusCode = -1;

    public HotRodClientException() {
    }

    public HotRodClientException(String message) {
        super(message);
    }

    public HotRodClientException(Throwable cause) {
        super(cause);
    }

    public HotRodClientException(String message, Throwable cause) {
        super(message, cause);
    }

    public HotRodClientException(String remoteMessage, long messageId, int errorStatusCode) {
        super(remoteMessage);
        this.messageId = messageId;
        this.errorStatusCode = errorStatusCode;
    }

    @Override
    public String toString() {
        String message;
        StringBuilder sb = new StringBuilder(this.getClass().getName());
        sb.append(":");
        if (this.messageId != -1L) {
            sb.append("Request for messageId=").append(this.messageId);
        }
        if (this.errorStatusCode != -1) {
            sb.append(" returned ").append(this.toErrorMsg(this.errorStatusCode));
        }
        if ((message = this.getLocalizedMessage()) != null) {
            sb.append(": ").append(message);
        }
        return sb.toString();
    }

    private String toErrorMsg(int errorStatusCode) {
        return String.format("server error (status=0x%x)", errorStatusCode);
    }
}

