/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.commons.api.BasicCache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.context.InvocationContext;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.statetransfer.StateTransferLock;
import org.infinispan.statetransfer.StateTransferManager;
import org.infinispan.topology.CacheTopology;
import org.infinispan.util.TimeService;
import org.infinispan.util.concurrent.TimeoutException;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class CreateCacheCommand
extends BaseRpcCommand {
    private static final Log log = LogFactory.getLog(CreateCacheCommand.class);
    public static final byte COMMAND_ID = 29;
    private EmbeddedCacheManager cacheManager;
    private String cacheNameToCreate;
    private String cacheConfigurationName;
    private int expectedMembers;

    private CreateCacheCommand() {
        super(null);
    }

    public CreateCacheCommand(String ownerCacheName) {
        super(ownerCacheName);
    }

    public CreateCacheCommand(String ownerCacheName, String cacheNameToCreate, String cacheConfigurationName) {
        this(ownerCacheName, cacheNameToCreate, cacheConfigurationName, 0);
    }

    public CreateCacheCommand(String cacheName, String cacheNameToCreate, String cacheConfigurationName, int expectedMembers) {
        super(cacheName);
        this.cacheNameToCreate = cacheNameToCreate;
        this.cacheConfigurationName = cacheConfigurationName;
        this.expectedMembers = expectedMembers;
    }

    public void init(EmbeddedCacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        if (this.cacheConfigurationName == null) {
            throw new NullPointerException("Cache configuration name is required");
        }
        Configuration cacheConfig = this.cacheManager.getCacheConfiguration(this.cacheConfigurationName);
        if (cacheConfig == null) {
            if ("__tmpMapReduce".equals(this.cacheConfigurationName)) {
                cacheConfig = new ConfigurationBuilder().unsafe().unreliableReturnValues(true).clustering().cacheMode(CacheMode.DIST_SYNC).hash().numOwners(2).sync().build();
                log.debugf("Using default tmp cache configuration, defined as ", (Object)this.cacheNameToCreate);
            } else {
                throw new IllegalStateException("Cache configuration " + this.cacheConfigurationName + " is not defined on node " + this.cacheManager.getAddress());
            }
        }
        this.cacheManager.defineConfiguration(this.cacheNameToCreate, cacheConfig);
        BasicCache cache = this.cacheManager.getCache(this.cacheNameToCreate);
        this.waitForCacheToStabilize((Cache<Object, Object>)cache, cacheConfig);
        log.debugf("Defined and started cache %s", (Object)this.cacheNameToCreate);
        return true;
    }

    protected void waitForCacheToStabilize(Cache<Object, Object> cache, Configuration cacheConfig) throws InterruptedException {
        ComponentRegistry componentRegistry = cache.getAdvancedCache().getComponentRegistry();
        StateTransferManager stateTransferManager = componentRegistry.getStateTransferManager();
        StateTransferLock stateTransferLock = componentRegistry.getStateTransferLock();
        TimeService timeService = componentRegistry.getTimeService();
        long endTime = timeService.expectedEndTime(cacheConfig.clustering().stateTransfer().timeout(), TimeUnit.MILLISECONDS);
        CacheTopology cacheTopology = stateTransferManager.getCacheTopology();
        while (cacheTopology.getMembers().size() < this.expectedMembers || cacheTopology.getPendingCH() != null) {
            long remainingTime = timeService.remainingTime(endTime, TimeUnit.NANOSECONDS);
            try {
                stateTransferLock.waitForTopology(cacheTopology.getTopologyId() + 1, remainingTime, TimeUnit.NANOSECONDS);
            }
            catch (TimeoutException ignored) {
                throw log.creatingTmpCacheTimedOut(this.cacheNameToCreate, this.cacheManager.getAddress());
            }
            cacheTopology = stateTransferManager.getCacheTopology();
        }
    }

    @Override
    public byte getCommandId() {
        return 29;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeUTF(this.cacheNameToCreate);
        output.writeUTF(this.cacheConfigurationName);
        output.writeInt(this.expectedMembers);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.cacheNameToCreate = input.readUTF();
        this.cacheConfigurationName = input.readUTF();
        this.expectedMembers = input.readInt();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.cacheConfigurationName == null ? 0 : this.cacheConfigurationName.hashCode());
        result = 31 * result + (this.cacheNameToCreate == null ? 0 : this.cacheNameToCreate.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCacheCommand)) {
            return false;
        }
        CreateCacheCommand other = (CreateCacheCommand)obj;
        if (this.cacheConfigurationName == null ? other.cacheConfigurationName != null : !this.cacheConfigurationName.equals(other.cacheConfigurationName)) {
            return false;
        }
        if (this.cacheNameToCreate == null ? other.cacheNameToCreate != null : !this.cacheNameToCreate.equals(other.cacheNameToCreate)) {
            return false;
        }
        return this.expectedMembers == other.expectedMembers;
    }

    @Override
    public String toString() {
        return "CreateCacheCommand{cacheManager=" + this.cacheManager + ", cacheNameToCreate='" + this.cacheNameToCreate + '\'' + ", cacheConfigurationName='" + this.cacheConfigurationName + '\'' + ", expectedMembers=" + this.expectedMembers + '}';
    }

    @Override
    public boolean isReturnValueExpected() {
        return true;
    }

    @Override
    public boolean canBlock() {
        return true;
    }
}

