/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.functional;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.functional.AbstractWriteManyCommand;
import org.infinispan.commons.api.functional.EntryView;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.functional.impl.EntryViews;
import org.infinispan.functional.impl.Params;
import org.infinispan.lifecycle.ComponentStatus;

public final class ReadWriteManyCommand<K, V, R>
extends AbstractWriteManyCommand {
    public static final byte COMMAND_ID = 52;
    private Set<? extends K> keys;
    private Function<EntryView.ReadWriteEntryView<K, V>, R> f;
    private int topologyId = -1;
    boolean isForwarded = false;
    private List<R> remoteReturns = new ArrayList<R>();

    public ReadWriteManyCommand(Set<? extends K> keys, Function<EntryView.ReadWriteEntryView<K, V>, R> f, Params params) {
        this.keys = keys;
        this.f = f;
        this.params = params;
    }

    public ReadWriteManyCommand(ReadWriteManyCommand command) {
        this.keys = command.keys;
        this.f = command.f;
        this.params = command.params;
    }

    public ReadWriteManyCommand() {
    }

    public Set<? extends K> getKeys() {
        return this.keys;
    }

    public void setKeys(Set<? extends K> keys) {
        this.keys = keys;
    }

    @Override
    public byte getCommandId() {
        return 52;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        MarshallUtil.marshallCollection(this.keys, output);
        output.writeObject(this.f);
        output.writeBoolean(this.isForwarded);
        Params.writeObject(output, this.params);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.keys = MarshallUtil.unmarshallCollection(input, size -> new HashSet());
        this.f = (Function)input.readObject();
        this.isForwarded = input.readBoolean();
        this.params = Params.readObject(input);
    }

    @Override
    public boolean isForwarded() {
        return this.isForwarded;
    }

    @Override
    public void setForwarded(boolean forwarded) {
        this.isForwarded = forwarded;
    }

    @Override
    public boolean shouldInvoke(InvocationContext ctx) {
        return true;
    }

    @Override
    public boolean isReturnValueExpected() {
        return true;
    }

    public void addAllRemoteReturns(List<R> returns) {
        this.remoteReturns.addAll(returns);
    }

    @Override
    public int getTopologyId() {
        return this.topologyId;
    }

    @Override
    public void setTopologyId(int topologyId) {
        this.topologyId = topologyId;
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitReadWriteManyCommand(ctx, this);
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        ArrayList<R> returns = new ArrayList<R>(this.remoteReturns);
        this.keys.forEach(k -> {
            CacheEntry entry = ctx.lookupEntry(k);
            if (entry != null) {
                R r = this.f.apply(EntryViews.readWrite(entry));
                returns.add(EntryViews.snapshot(r));
            }
        });
        return returns;
    }

    @Override
    public boolean isSuccessful() {
        return true;
    }

    @Override
    public boolean isConditional() {
        return false;
    }

    @Override
    public boolean canBlock() {
        return false;
    }

    @Override
    public Set<Object> getAffectedKeys() {
        return null;
    }

    @Override
    public void updateStatusFromRemoteResponse(Object remoteResponse) {
    }

    @Override
    public boolean ignoreCommandOnStatus(ComponentStatus status) {
        return false;
    }

    @Override
    public boolean readsExistingValues() {
        return true;
    }

    @Override
    public boolean alwaysReadsExistingValues() {
        return false;
    }
}

