/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util.concurrent.jdk8backported;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountedCompleter;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.DoubleBinaryOperator;
import java.util.function.Function;
import java.util.function.IntBinaryOperator;
import java.util.function.LongBinaryOperator;
import java.util.function.ToDoubleBiFunction;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntBiFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongBiFunction;
import java.util.function.ToLongFunction;
import org.infinispan.commons.equivalence.AnyEquivalence;
import org.infinispan.commons.equivalence.Equivalence;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.util.PeekableMap;
import org.infinispan.commons.util.concurrent.ParallelIterableMap;
import org.infinispan.commons.util.concurrent.jdk8backported.AbstractEntrySizeCalculatorHelper;
import org.infinispan.commons.util.concurrent.jdk8backported.EntrySizeCalculator;
import org.infinispan.commons.util.concurrent.jdk8backported.StrippedConcurrentLinkedDeque;
import sun.misc.Unsafe;

public class BoundedEquivalentConcurrentHashMapV8<K, V>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V>,
PeekableMap<K, V>,
Serializable,
ParallelIterableMap<K, V> {
    private static final long serialVersionUID = 7249069246763182397L;
    static final Object NULL_VALUE = new Object();
    static final Log log = LogFactory.getLog(BoundedEquivalentConcurrentHashMapV8.class);
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final int DEFAULT_CAPACITY = 16;
    static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    private static final int DEFAULT_CONCURRENCY_LEVEL = 16;
    private static final float LOAD_FACTOR = 0.75f;
    static final int TREEIFY_THRESHOLD = 8;
    static final int UNTREEIFY_THRESHOLD = 6;
    static final int MIN_TREEIFY_CAPACITY = 64;
    private static final int MIN_TRANSFER_STRIDE = 16;
    private static int RESIZE_STAMP_BITS = 16;
    private static final int MAX_RESIZERS = (1 << 32 - RESIZE_STAMP_BITS) - 1;
    private static final int RESIZE_STAMP_SHIFT = 32 - RESIZE_STAMP_BITS;
    static final int MOVED = -1;
    static final int TREEBIN = -2;
    static final int RESERVED = -3;
    static final int HASH_BITS = Integer.MAX_VALUE;
    static final int NCPU = Runtime.getRuntime().availableProcessors();
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("segments", Segment[].class), new ObjectStreamField("segmentMask", Integer.TYPE), new ObjectStreamField("segmentShift", Integer.TYPE)};
    volatile transient Node<K, V>[] table;
    private volatile transient Node<K, V>[] nextTable;
    private volatile transient long baseCount;
    private volatile transient int sizeCtl;
    private volatile transient int transferIndex;
    private volatile transient int cellsBusy;
    private volatile transient CounterCell[] counterCells;
    private transient KeySetView<K, V> keySet;
    private transient ValuesView<K, V> values;
    private transient EntrySetView<K, V> entrySet;
    Equivalence<? super K> keyEq;
    Equivalence<? super V> valueEq;
    transient NodeEquivalence<K, V> nodeEq;
    volatile long maxSize;
    final EvictionPolicy<K, V> evictionPolicy;
    final EvictionListener<? super K, ? super V> evictionListener;
    static final AtomicInteger counterHashCodeGenerator = new AtomicInteger();
    static final int SEED_INCREMENT = 1640531527;
    static final ThreadLocal<CounterHashCode> threadCounterHashCode = new ThreadLocal();
    private static final Unsafe U;
    private static final long SIZECTL;
    private static final long TRANSFERINDEX;
    private static final long BASECOUNT;
    private static final long CELLSBUSY;
    private static final long CELLVALUE;
    private static final long ABASE;
    private static final int ASHIFT;

    public static <K, V> EvictionListener<K, V> getNullEvictionListener() {
        return new NullEvictionListener();
    }

    static long roundUpToNearest8(long size) {
        return size + 7L & 0xFFFFFFFFFFFFFFF8L;
    }

    private void notifyEvictionListener(Collection<Node<K, V>> evicted) {
        if (evicted != null && !evicted.isEmpty()) {
            Map evictedCopy;
            if (evicted.size() == 1) {
                Node<K, V> evictedEntry = evicted.iterator().next();
                evictedCopy = Collections.singletonMap(evictedEntry.key, evictedEntry.val);
            } else {
                evictedCopy = new HashMap(evicted.size());
                for (Node<K, V> he : evicted) {
                    evictedCopy.put(he.key, he.val);
                }
                evictedCopy = Collections.unmodifiableMap(evictedCopy);
            }
            this.evictionListener.onEntryEviction(evictedCopy);
        }
    }

    static SizeAndEvicting incrementSizeEviction(AtomicReference<SizeAndEvicting> currentSize, long size, long eviction) {
        boolean replaced = false;
        SizeAndEvicting lirsSize = null;
        while (!replaced) {
            SizeAndEvicting existingSize = currentSize.get();
            long newSize = existingSize.size + size;
            long newEviction = existingSize.evicting + eviction;
            lirsSize = new SizeAndEvicting(newSize, newEviction);
            replaced = currentSize.compareAndSet(existingSize, lirsSize);
        }
        return lirsSize;
    }

    static final int spread(int h) {
        return (h ^ h >>> 16) & Integer.MAX_VALUE;
    }

    private static final int tableSizeFor(int c) {
        int n = c - 1;
        n |= n >>> 1;
        n |= n >>> 2;
        n |= n >>> 4;
        n |= n >>> 8;
        return (n |= n >>> 16) < 0 ? 1 : (n >= 0x40000000 ? 0x40000000 : n + 1);
    }

    static Class<?> comparableClassFor(Object x, Equivalence<?> eq) {
        if (eq.isComparable(x)) {
            Class<?> c = x.getClass();
            if (c == String.class) {
                return c;
            }
            Type[] ts = c.getGenericInterfaces();
            if (ts != null) {
                for (int i = 0; i < ts.length; ++i) {
                    Type[] as;
                    ParameterizedType p;
                    Type t = ts[i];
                    if (!(t instanceof ParameterizedType) || (p = (ParameterizedType)t).getRawType() != Comparable.class || (as = p.getActualTypeArguments()) == null || as.length != 1 || as[0] != c) continue;
                    return c;
                }
            }
        }
        return null;
    }

    static int compareComparables(Class<?> kc, Object k, Object x, Equivalence<Object> eq) {
        return x == null || x.getClass() != kc ? 0 : eq.compare(k, x);
    }

    static final <K, V> Node<K, V> tabAt(Node<K, V>[] tab, int i) {
        return (Node)U.getObjectVolatile(tab, ((long)i << ASHIFT) + ABASE);
    }

    static final <K, V> boolean casTabAt(Node<K, V>[] tab, int i, Node<K, V> c, Node<K, V> v) {
        return U.compareAndSwapObject(tab, ((long)i << ASHIFT) + ABASE, c, v);
    }

    static final <K, V> void setTabAt(Node<K, V>[] tab, int i, Node<K, V> v) {
        U.putObjectVolatile(tab, ((long)i << ASHIFT) + ABASE, v);
    }

    public BoundedEquivalentConcurrentHashMapV8(long maxSize, Equivalence<? super K> keyEquivalence, Equivalence<? super V> valueEquivalence) {
        if (maxSize <= 0L) {
            throw new IllegalArgumentException();
        }
        this.maxSize = maxSize;
        this.keyEq = keyEquivalence;
        this.valueEq = valueEquivalence;
        this.nodeEq = new NodeEquivalence<K, V>(this.keyEq, this.valueEq);
        this.evictionPolicy = Eviction.LRU.make(this, null, maxSize);
        this.evictionListener = new NullEvictionListener<K, V>();
    }

    public BoundedEquivalentConcurrentHashMapV8(long maxSize, Eviction evictionStrategy, EvictionListener<? super K, ? super V> evictionListener, Equivalence<? super K> keyEquivalence, Equivalence<? super V> valueEquivalence) {
        this(maxSize, evictionStrategy, evictionListener, keyEquivalence, valueEquivalence, null);
    }

    public BoundedEquivalentConcurrentHashMapV8(long maxSize, Eviction evictionStrategy, EvictionListener<? super K, ? super V> evictionListener, Equivalence<? super K> keyEquivalence, Equivalence<? super V> valueEquivalence, EntrySizeCalculator<? super K, ? super V> sizeCalculator) {
        if (maxSize <= 0L) {
            throw new IllegalArgumentException();
        }
        if (evictionStrategy == null || evictionListener == null) {
            throw new NullPointerException();
        }
        this.maxSize = maxSize;
        this.keyEq = keyEquivalence;
        this.valueEq = valueEquivalence;
        this.nodeEq = new NodeEquivalence<K, V>(this.keyEq, this.valueEq);
        this.evictionPolicy = evictionStrategy.make(this, sizeCalculator, maxSize);
        this.evictionListener = evictionListener;
    }

    public BoundedEquivalentConcurrentHashMapV8(long maxSize, int initialCapacity, Equivalence<? super K> keyEquivalence, Equivalence<? super V> valueEquivalence) {
        this(maxSize, keyEquivalence, valueEquivalence);
        int cap;
        if (initialCapacity < 0) {
            throw new IllegalArgumentException();
        }
        if ((long)initialCapacity > maxSize) {
            throw new IllegalArgumentException("initialCapacity cannot be greater than maxSize");
        }
        this.sizeCtl = cap = initialCapacity >= 0x20000000 ? 0x40000000 : BoundedEquivalentConcurrentHashMapV8.tableSizeFor(initialCapacity + (initialCapacity >>> 1) + 1);
    }

    public BoundedEquivalentConcurrentHashMapV8(long maxSize, int initialCapacity, Eviction evictionStrategy, EvictionListener<? super K, ? super V> evictionListener, Equivalence<? super K> keyEquivalence, Equivalence<? super V> valueEquivalence) {
        this(maxSize, evictionStrategy, evictionListener, keyEquivalence, valueEquivalence);
        int cap;
        if (initialCapacity < 0) {
            throw new IllegalArgumentException();
        }
        if ((long)initialCapacity > maxSize) {
            throw new IllegalArgumentException("initialCapacity cannot be greater than maxSize");
        }
        this.sizeCtl = cap = initialCapacity >= 0x20000000 ? 0x40000000 : BoundedEquivalentConcurrentHashMapV8.tableSizeFor(initialCapacity + (initialCapacity >>> 1) + 1);
    }

    public BoundedEquivalentConcurrentHashMapV8(long maxSize, Map<? extends K, ? extends V> m, Equivalence<? super K> keyEquivalence, Equivalence<? super V> valueEquivalence) {
        this(maxSize, keyEquivalence, valueEquivalence);
        this.sizeCtl = 16;
        this.putAll(m);
    }

    public BoundedEquivalentConcurrentHashMapV8(long maxSize, int initialCapacity, float loadFactor, Equivalence<? super K> keyEquivalence, Equivalence<? super V> valueEquivalence) {
        this(maxSize, initialCapacity, loadFactor, 1, Eviction.LRU, BoundedEquivalentConcurrentHashMapV8.getNullEvictionListener(), keyEquivalence, valueEquivalence);
    }

    public BoundedEquivalentConcurrentHashMapV8(long maxSize, int initialCapacity, float loadFactor, int concurrencyLevel, Eviction evictionStrategy, EvictionListener<? super K, ? super V> evictionListener, Equivalence<? super K> keyEquivalence, Equivalence<? super V> valueEquivalence) {
        this(maxSize, initialCapacity, evictionStrategy, evictionListener, keyEquivalence, valueEquivalence);
        long size;
        int cap;
        if (!(loadFactor > 0.0f) || initialCapacity < 0 || concurrencyLevel <= 0) {
            throw new IllegalArgumentException();
        }
        if (initialCapacity < concurrencyLevel) {
            initialCapacity = concurrencyLevel;
        }
        this.sizeCtl = cap = (size = (long)(1.0 + (double)((float)initialCapacity / loadFactor))) >= 0x40000000L ? 0x40000000 : BoundedEquivalentConcurrentHashMapV8.tableSizeFor((int)size);
    }

    @Override
    public int size() {
        long n = this.sumCount();
        return n < 0L ? 0 : (n > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)n);
    }

    @Override
    public boolean isEmpty() {
        return this.sumCount() <= 0L;
    }

    @Override
    public V get(Object key) {
        Node<K, V> e;
        int n;
        int h = BoundedEquivalentConcurrentHashMapV8.spread(this.keyEq.hashCode(key));
        Node<K, V>[] tab = this.table;
        if (this.table != null && (n = tab.length) > 0 && (e = BoundedEquivalentConcurrentHashMapV8.tabAt(tab, n - 1 & h)) != null) {
            Object ek;
            int eh = e.hash;
            if (eh == h) {
                ek = e.key;
                if (ek == key || ek != null && this.keyEq.equals(ek, key)) {
                    Object val = e.val;
                    if (val != NULL_VALUE) {
                        this.evictionPolicy.onEntryHitRead(e, val);
                        this.notifyEvictionListener(this.evictionPolicy.findIfEntriesNeedEvicting());
                        return val;
                    }
                    return null;
                }
            } else if (eh < 0) {
                V val;
                Node<K, V> p = e.find(h, key);
                V v = val = p != null ? (V)p.val : null;
                if (val != null && val != NULL_VALUE) {
                    this.evictionPolicy.onEntryHitRead(p, val);
                    this.notifyEvictionListener(this.evictionPolicy.findIfEntriesNeedEvicting());
                    return val;
                }
                return null;
            }
            while ((e = e.next) != null) {
                if (e.hash != h || (ek = e.key) != key && (ek == null || !this.keyEq.equals(ek, key))) continue;
                Object val = e.val;
                if (val != NULL_VALUE) {
                    this.evictionPolicy.onEntryHitRead(e, val);
                    this.notifyEvictionListener(this.evictionPolicy.findIfEntriesNeedEvicting());
                    return val;
                }
                return null;
            }
        }
        return null;
    }

    @Override
    public V peek(Object key) {
        V val = this.innerPeek(key);
        return val == NULL_VALUE ? null : (V)val;
    }

    V innerPeek(Object key) {
        Node<K, V> e;
        int n;
        int h = BoundedEquivalentConcurrentHashMapV8.spread(this.keyEq.hashCode(key));
        Node<K, V>[] tab = this.table;
        if (this.table != null && (n = tab.length) > 0 && (e = BoundedEquivalentConcurrentHashMapV8.tabAt(tab, n - 1 & h)) != null) {
            Object ek;
            int eh = e.hash;
            if (eh == h) {
                ek = e.key;
                if (ek == key || ek != null && this.keyEq.equals(ek, key)) {
                    return e.val;
                }
            } else if (eh < 0) {
                Node<K, V> p = e.find(h, key);
                V val = p != null ? (V)p.val : null;
                return val;
            }
            while ((e = e.next) != null) {
                if (e.hash != h || (ek = e.key) != key && (ek == null || !this.keyEq.equals(ek, key))) continue;
                return e.val;
            }
        }
        return null;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        Node<K, V>[] t = this.table;
        if (this.table != null) {
            Node<K, V> p;
            Traverser<K, V> it = new Traverser<K, V>(t, t.length, 0, t.length);
            while ((p = it.advance()) != null) {
                Object v = p.val;
                if (v != value && (v == null || v == NULL_VALUE || !this.valueEq.equals(v, value))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public V put(K key, V value) {
        return this.putVal(key, value, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final V putVal(K key, V value, boolean onlyIfAbsent) {
        int binCount;
        block27: {
            V oldVal;
            int i;
            if (key == null || value == null) {
                throw new NullPointerException();
            }
            int hash = BoundedEquivalentConcurrentHashMapV8.spread(this.keyEq.hashCode(key));
            binCount = 0;
            Node<K, V>[] tab = this.table;
            while (true) {
                Node<K, V> node;
                int n;
                if (tab == null || (n = tab.length) == 0) {
                    tab = this.initTable();
                    continue;
                }
                i = n - 1 & hash;
                Node<K, V> f = BoundedEquivalentConcurrentHashMapV8.tabAt(tab, i);
                if (f == null) {
                    Node<K, V> newNode = this.evictionPolicy.createNewEntry(key, hash, null, value, null);
                    node = newNode;
                    synchronized (node) {
                        if (BoundedEquivalentConcurrentHashMapV8.casTabAt(tab, i, null, newNode)) {
                            this.evictionPolicy.onEntryMiss(newNode, value);
                            this.evictionListener.onEntryActivated(key);
                            break block27;
                        }
                    }
                }
                int fh = f.hash;
                if (fh == -1) {
                    tab = this.helpTransfer(tab, f);
                    continue;
                }
                oldVal = null;
                node = f;
                synchronized (node) {
                    block28: {
                        if (BoundedEquivalentConcurrentHashMapV8.tabAt(tab, i) == f) {
                            if (fh >= 0) {
                                binCount = 1;
                                Node<K, V> e = f;
                                while (true) {
                                    Object ek;
                                    if (e.hash == hash && ((ek = e.key) == key || ek != null && this.keyEq.equals(ek, key))) {
                                        oldVal = e.val;
                                        if (!onlyIfAbsent || oldVal == NULL_VALUE) {
                                            e.val = value;
                                            if (oldVal == NULL_VALUE) {
                                                this.evictionPolicy.onEntryMiss(e, value);
                                            } else {
                                                this.evictionPolicy.onEntryHitWrite(e, value);
                                            }
                                        }
                                        break block28;
                                    }
                                    Node<K, V> pred = e;
                                    e = e.next;
                                    if (e == null) {
                                        pred.next = this.evictionPolicy.createNewEntry(key, hash, null, value, null);
                                        this.evictionPolicy.onEntryMiss(pred.next, value);
                                        this.evictionListener.onEntryActivated(key);
                                        break block28;
                                    }
                                    ++binCount;
                                }
                            }
                            if (f instanceof TreeBin) {
                                binCount = 2;
                                TreeNode<K, V> p = ((TreeBin)f).putTreeVal(hash, key, value);
                                if (p != null) {
                                    oldVal = p.val;
                                    if (!onlyIfAbsent || oldVal == NULL_VALUE) {
                                        p.val = value;
                                        if (oldVal == NULL_VALUE) {
                                            this.evictionPolicy.onEntryMiss(p, value);
                                        } else {
                                            this.evictionPolicy.onEntryHitWrite(p, value);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                if (binCount != 0) break;
            }
            if (binCount >= 8) {
                this.treeifyBin(tab, i);
            }
            if (oldVal != null && oldVal != NULL_VALUE) {
                this.notifyEvictionListener(this.evictionPolicy.findIfEntriesNeedEvicting());
                return oldVal;
            }
        }
        this.addCount(1L, binCount);
        this.notifyEvictionListener(this.evictionPolicy.findIfEntriesNeedEvicting());
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.tryPresize(m.size());
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.putVal(e.getKey(), e.getValue(), false);
        }
    }

    @Override
    public V remove(Object key) {
        return this.replaceNode(key, null, null);
    }

    final V replaceNode(Object key, V value, Object cv) {
        return this.replaceNode(key, value, cv, false);
    }

    private void notifyListenerOfRemoval(Node removedNode, boolean isEvict) {
        if (isEvict) {
            this.evictionListener.onEntryChosenForEviction(removedNode);
        } else {
            this.evictionListener.onEntryRemoved(removedNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final V replaceNode(Object key, V value, Object cv, boolean isEvict) {
        int i;
        Node<K, V> f;
        int n;
        int hash = BoundedEquivalentConcurrentHashMapV8.spread(this.keyEq.hashCode(key));
        Node<K, V>[] tab = this.table;
        while (tab != null && (n = tab.length) != 0 && (f = BoundedEquivalentConcurrentHashMapV8.tabAt(tab, i = n - 1 & hash)) != null) {
            int fh = f.hash;
            if (fh == -1) {
                tab = this.helpTransfer(tab, f);
                continue;
            }
            Object oldVal = null;
            boolean validated = false;
            Node<K, V> node = f;
            synchronized (node) {
                if (BoundedEquivalentConcurrentHashMapV8.tabAt(tab, i) == f) {
                    if (fh >= 0) {
                        validated = true;
                        Node<K, V> e = f;
                        Node<K, V> pred = null;
                        do {
                            Object ek;
                            if (e.hash == hash && ((ek = e.key) == key || ek != null && this.keyEq.equals(ek, key))) {
                                Object ev;
                                Object object = ev = e.val == NULL_VALUE ? null : (Object)e.val;
                                if (cv == null || cv == ev || ev != null && this.valueEq.equals(ev, cv)) {
                                    oldVal = ev;
                                    if (value != null) {
                                        e.val = value;
                                        if (oldVal == null) {
                                            this.evictionPolicy.onEntryMiss(e, value);
                                        } else {
                                            this.evictionPolicy.onEntryHitWrite(e, value);
                                        }
                                    } else if (pred != null) {
                                        if (!isEvict) {
                                            this.evictionPolicy.onEntryRemove(e);
                                        }
                                        if (oldVal != null) {
                                            this.notifyListenerOfRemoval(e, isEvict);
                                        }
                                        pred.next = e.next;
                                    } else {
                                        if (!isEvict) {
                                            this.evictionPolicy.onEntryRemove(e);
                                        }
                                        if (oldVal != null) {
                                            this.notifyListenerOfRemoval(e, isEvict);
                                        }
                                        BoundedEquivalentConcurrentHashMapV8.setTabAt(tab, i, e.next);
                                    }
                                }
                                break;
                            }
                            pred = e;
                        } while ((e = e.next) != null);
                    } else if (f instanceof TreeBin) {
                        TreeNode p;
                        validated = true;
                        TreeBin t = (TreeBin)f;
                        TreeNode r = t.root;
                        if (r != null && (p = r.findTreeNode(hash, key, null)) != null) {
                            Object pv;
                            Object object = pv = p.val == NULL_VALUE ? null : p.val;
                            if (cv == null || cv == pv || pv != null && this.valueEq.equals(pv, cv)) {
                                oldVal = pv;
                                if (value != null) {
                                    p.val = value;
                                    if (oldVal == null) {
                                        this.evictionPolicy.onEntryMiss(p, value);
                                    } else {
                                        this.evictionPolicy.onEntryHitWrite(p, value);
                                    }
                                } else {
                                    if (t.removeTreeNode(p)) {
                                        BoundedEquivalentConcurrentHashMapV8.setTabAt(tab, i, this.untreeify(t.first));
                                    }
                                    if (!isEvict) {
                                        this.evictionPolicy.onEntryRemove(p);
                                    }
                                    if (pv != null) {
                                        this.notifyListenerOfRemoval(p, isEvict);
                                    }
                                }
                            }
                        }
                    }
                }
            }
            if (!validated) continue;
            if (oldVal == null) break;
            if (value == null) {
                this.addCount(-1L, -1);
            }
            return (V)oldVal;
        }
        if (!isEvict) {
            this.notifyEvictionListener(this.evictionPolicy.findIfEntriesNeedEvicting());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        long delta = 0L;
        int i = 0;
        Node<K, V>[] tab = this.table;
        while (tab != null && i < tab.length) {
            Node<K, V> f = BoundedEquivalentConcurrentHashMapV8.tabAt(tab, i);
            if (f == null) {
                ++i;
                continue;
            }
            int fh = f.hash;
            if (fh == -1) {
                tab = this.helpTransfer(tab, f);
                i = 0;
                continue;
            }
            Node<K, V> node = f;
            synchronized (node) {
                if (BoundedEquivalentConcurrentHashMapV8.tabAt(tab, i) == f) {
                    Node<K, V> p;
                    Node<K, V> node2 = fh >= 0 ? f : (p = f instanceof TreeBin ? ((TreeBin)f).first : null);
                    while (p != null) {
                        if (p.val != NULL_VALUE) {
                            --delta;
                        }
                        this.evictionPolicy.onEntryRemove(p);
                        p = p.next;
                    }
                    BoundedEquivalentConcurrentHashMapV8.setTabAt(tab, i++, null);
                }
            }
        }
        if (delta != 0L) {
            this.addCount(delta, -1);
        }
    }

    public KeySetView<K, V> keySet() {
        KeySetView<K, V> ks = this.keySet;
        return ks != null ? ks : (this.keySet = new KeySetView(this, null));
    }

    @Override
    public Collection<V> values() {
        ValuesView<K, V> vs = this.values;
        return vs != null ? vs : (this.values = new ValuesView(this));
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySetView<K, V> es = this.entrySet;
        return es != null ? es : (this.entrySet = new EntrySetView(this));
    }

    @Override
    public int hashCode() {
        int h = 0;
        Node<K, V>[] t = this.table;
        if (this.table != null) {
            Node p;
            Traverser<K, V> it = new Traverser<K, V>(t, t.length, 0, t.length);
            while ((p = it.advance()) != null) {
                Object val = p.val;
                if (val == NULL_VALUE) continue;
                h += p.hashCode(p.key, val);
            }
        }
        return h;
    }

    @Override
    public String toString() {
        Node<K, V>[] t = this.table;
        int f = this.table == null ? 0 : t.length;
        Traverser<K, V> it = new Traverser<K, V>(t, f, 0, f);
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        Node<K, V> p = it.advance();
        if (p != null) {
            while (true) {
                Object k = p.key;
                Object v = p.val;
                if (v != NULL_VALUE) {
                    sb.append(k == this ? "(this Map)" : this.keyEq.toString(k));
                    sb.append('=');
                    sb.append(v == this ? "(this Map)" : this.valueEq.toString(v));
                }
                if ((p = it.advance()) == null) break;
                if (v == NULL_VALUE) continue;
                sb.append(',').append(' ');
            }
        }
        return sb.append('}').toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o != this) {
            Node<K, V> p;
            if (!(o instanceof Map)) {
                return false;
            }
            Map m = (Map)o;
            Node<K, V>[] t = this.table;
            int f = this.table == null ? 0 : t.length;
            Traverser<K, V> it = new Traverser<K, V>(t, f, 0, f);
            while ((p = it.advance()) != null) {
                Object v;
                Object val = p.val;
                if (val == NULL_VALUE || (v = m.get(p.key)) != null && (v == val || this.valueEq.equals(val, v))) continue;
                return false;
            }
            for (Map.Entry e : m.entrySet()) {
                V v;
                Object mv;
                Object mk = e.getKey();
                if (mk != null && (mv = e.getValue()) != null && (v = this.get(mk)) != null && (mv == v || this.valueEq.equals(v, mv))) continue;
                return false;
            }
        }
        return true;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        int ssize;
        int sshift = 0;
        for (ssize = 1; ssize < 16; ssize <<= 1) {
            ++sshift;
        }
        int segmentShift = 32 - sshift;
        int segmentMask = ssize - 1;
        Segment[] segments = new Segment[16];
        for (int i = 0; i < segments.length; ++i) {
            segments[i] = new Segment(0.75f);
        }
        s.putFields().put("segments", segments);
        s.putFields().put("segmentShift", segmentShift);
        s.putFields().put("segmentMask", segmentMask);
        s.writeFields();
        s.writeObject(this.keyEq);
        s.writeObject(this.valueEq);
        Node<K, V>[] t = this.table;
        if (this.table != null) {
            Node<K, V> p;
            Traverser<K, V> it = new Traverser<K, V>(t, t.length, 0, t.length);
            while ((p = it.advance()) != null) {
                Object val = p.val;
                if (val == null) continue;
                s.writeObject(p.key);
                s.writeObject(val);
            }
        }
        s.writeObject(null);
        s.writeObject(null);
        segments = null;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.sizeCtl = -1;
        s.defaultReadObject();
        this.keyEq = (Equivalence)s.readObject();
        this.valueEq = (Equivalence)s.readObject();
        this.nodeEq = new NodeEquivalence<K, V>(this.keyEq, this.valueEq);
        long size = 0L;
        Node<Object, Object> p = null;
        while (true) {
            Object k = s.readObject();
            Object v = s.readObject();
            if (k == null || v == null) break;
            p = this.evictionPolicy.createNewEntry(k, BoundedEquivalentConcurrentHashMapV8.spread(this.keyEq.hashCode(k)), p, v, null);
            this.evictionPolicy.onEntryMiss(p, v);
            size -= (long)this.evictionPolicy.findIfEntriesNeedEvicting().size();
            ++size;
        }
        if (size == 0L) {
            this.sizeCtl = 0;
        } else {
            int n;
            if (size >= 0x20000000L) {
                n = 0x40000000;
            } else {
                int sz = (int)size;
                n = BoundedEquivalentConcurrentHashMapV8.tableSizeFor(sz + (sz >>> 1) + 1);
            }
            Node[] tab = new Node[n];
            int mask = n - 1;
            long added = 0L;
            while (p != null) {
                boolean insertAtFront;
                Node next = p.next;
                int h = p.hash;
                int j = h & mask;
                Node<K, V> first = BoundedEquivalentConcurrentHashMapV8.tabAt(tab, j);
                if (first == null) {
                    insertAtFront = true;
                } else {
                    Object k = p.key;
                    if (first.hash < 0) {
                        TreeBin t = (TreeBin)first;
                        if (t.putTreeVal(h, k, p.val) == null) {
                            ++added;
                        }
                        insertAtFront = false;
                    } else {
                        int binCount = 0;
                        insertAtFront = true;
                        Node<Object, Object> q = first;
                        while (q != null) {
                            Object qk;
                            if (q.hash == h && ((qk = q.key) == k || qk != null && this.keyEq.equals(qk, k))) {
                                insertAtFront = false;
                                break;
                            }
                            ++binCount;
                            q = q.next;
                        }
                        if (insertAtFront && binCount >= 8) {
                            insertAtFront = false;
                            ++added;
                            p.next = first;
                            TreeNode<K, V> hd = null;
                            TreeNode<K, V> tl = null;
                            q = p;
                            while (q != null) {
                                TreeNode<K, V> t = this.evictionPolicy.createNewEntry(q.key, q.hash, null, null, q.val, q.eviction);
                                t.prev = tl;
                                if (t.prev == null) {
                                    hd = t;
                                } else {
                                    tl.next = t;
                                }
                                tl = t;
                                q = q.next;
                            }
                            BoundedEquivalentConcurrentHashMapV8.setTabAt(tab, j, new TreeBin(hd, this));
                        }
                    }
                }
                if (insertAtFront) {
                    ++added;
                    p.next = first;
                    BoundedEquivalentConcurrentHashMapV8.setTabAt(tab, j, p);
                }
                p = next;
            }
            this.table = tab;
            this.sizeCtl = n - (n >>> 2);
            this.baseCount = added;
        }
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return this.putVal(key, value, true);
    }

    @Override
    public boolean remove(Object key, Object value) {
        if (key == null) {
            throw new NullPointerException();
        }
        return value != null && this.replaceNode(key, null, value) != null;
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        if (key == null || oldValue == null || newValue == null) {
            throw new NullPointerException();
        }
        return this.replaceNode(key, newValue, oldValue) != null;
    }

    @Override
    public V replace(K key, V value) {
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        return this.replaceNode(key, value, null);
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        V v = this.get(key);
        return v == null ? defaultValue : v;
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        Node<K, V>[] t = this.table;
        if (this.table != null) {
            Node<K, V> p;
            Traverser<K, V> it = new Traverser<K, V>(t, t.length, 0, t.length);
            while ((p = it.advance()) != null) {
                Object val = p.val;
                if (val == NULL_VALUE) continue;
                action.accept(p.key, val);
            }
        }
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        Node<K, V>[] t = this.table;
        if (this.table != null) {
            Node<K, V> p;
            Traverser<K, V> it = new Traverser<K, V>(t, t.length, 0, t.length);
            while ((p = it.advance()) != null) {
                V newValue;
                Object oldValue = p.val;
                if (oldValue == NULL_VALUE) continue;
                Object key = p.key;
                do {
                    if ((newValue = function.apply(key, oldValue)) != null) continue;
                    throw new NullPointerException();
                } while (this.replaceNode(key, newValue, oldValue) == null && (oldValue = this.get(key)) != null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        int binCount;
        Object val;
        block31: {
            boolean added;
            int i;
            if (key == null || mappingFunction == null) {
                throw new NullPointerException();
            }
            int h = BoundedEquivalentConcurrentHashMapV8.spread(this.keyEq.hashCode(key));
            val = null;
            binCount = 0;
            Node<K, V>[] tab = this.table;
            while (true) {
                Node node;
                int n;
                if (tab == null || (n = tab.length) == 0) {
                    tab = this.initTable();
                    continue;
                }
                i = n - 1 & h;
                Node<K, V> f = BoundedEquivalentConcurrentHashMapV8.tabAt(tab, i);
                if (f == null) {
                    ReservationNode<K, V> r;
                    node = r = new ReservationNode<K, V>(this.nodeEq);
                    synchronized (node) {
                        if (BoundedEquivalentConcurrentHashMapV8.casTabAt(tab, i, null, r)) {
                            binCount = 1;
                            Node<K, Object> node2 = null;
                            try {
                                V v = mappingFunction.apply(key);
                                val = v;
                                if (v != null) {
                                    node2 = this.evictionPolicy.createNewEntry(key, h, null, val, null);
                                    this.evictionPolicy.onEntryMiss(node2, val);
                                    this.evictionListener.onEntryActivated(key);
                                }
                            }
                            finally {
                                BoundedEquivalentConcurrentHashMapV8.setTabAt(tab, i, node2);
                            }
                        }
                    }
                    if (binCount == 0) continue;
                    break block31;
                }
                int fh = f.hash;
                if (fh == -1) {
                    tab = this.helpTransfer(tab, f);
                    continue;
                }
                added = false;
                node = f;
                synchronized (node) {
                    block32: {
                        if (BoundedEquivalentConcurrentHashMapV8.tabAt(tab, i) == f) {
                            if (fh >= 0) {
                                binCount = 1;
                                Node<K, V> e = f;
                                while (true) {
                                    Object ek;
                                    if (e.hash == h && ((ek = e.key) == key || ek != null && this.keyEq.equals(ek, key))) {
                                        val = e.val;
                                        if (val == NULL_VALUE && (val = mappingFunction.apply(key)) != null) {
                                            added = true;
                                            e.val = val;
                                            this.evictionPolicy.onEntryMiss(e, val);
                                            this.evictionListener.onEntryActivated(key);
                                        }
                                        break block32;
                                    }
                                    Node<K, V> pred = e;
                                    e = e.next;
                                    if (e == null) {
                                        V v = mappingFunction.apply(key);
                                        val = v;
                                        if (v != null) {
                                            added = true;
                                            pred.next = this.evictionPolicy.createNewEntry(key, h, null, val, null);
                                            this.evictionPolicy.onEntryMiss(pred.next, val);
                                            this.evictionListener.onEntryActivated(key);
                                        }
                                        break block32;
                                    }
                                    ++binCount;
                                }
                            }
                            if (f instanceof TreeBin) {
                                TreeNode p;
                                binCount = 2;
                                TreeBin t = (TreeBin)f;
                                TreeNode r = t.root;
                                if (r != null && (p = r.findTreeNode(h, key, null)) != null) {
                                    val = p.val;
                                } else {
                                    V v = mappingFunction.apply(key);
                                    val = v;
                                    if (v != null) {
                                        added = true;
                                        t.putTreeVal(h, key, val);
                                    }
                                }
                            }
                        }
                    }
                }
                if (binCount != 0) break;
            }
            if (binCount >= 8) {
                this.treeifyBin(tab, i);
            }
            if (!added) {
                return (V)val;
            }
        }
        if (val != null) {
            this.addCount(1L, binCount);
            this.notifyEvictionListener(this.evictionPolicy.findIfEntriesNeedEvicting());
        }
        return (V)val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        if (key == null || remappingFunction == null) {
            throw new NullPointerException();
        }
        int h = BoundedEquivalentConcurrentHashMapV8.spread(this.keyEq.hashCode(key));
        Object val = null;
        int delta = 0;
        int binCount = 0;
        Node<K, V>[] tab = this.table;
        while (true) {
            int n;
            if (tab == null || (n = tab.length) == 0) {
                tab = this.initTable();
                continue;
            }
            int i = n - 1 & h;
            Node<K, V> f = BoundedEquivalentConcurrentHashMapV8.tabAt(tab, i);
            if (f == null) break;
            int fh = f.hash;
            if (fh == -1) {
                tab = this.helpTransfer(tab, f);
                continue;
            }
            Node<K, V> node = f;
            synchronized (node) {
                if (BoundedEquivalentConcurrentHashMapV8.tabAt(tab, i) == f) {
                    if (fh >= 0) {
                        binCount = 1;
                        Node<K, V> e = f;
                        Node<K, V> pred = null;
                        while (true) {
                            Object ek;
                            if (e.hash == h && ((ek = e.key) == key || ek != null && this.keyEq.equals(ek, key))) {
                                Object prevVal = e.val;
                                if (prevVal != NULL_VALUE) {
                                    val = remappingFunction.apply(key, prevVal);
                                    if (val != null) {
                                        e.val = val;
                                        this.evictionPolicy.onEntryHitWrite(e, val);
                                    } else {
                                        delta = -1;
                                        Node en = e.next;
                                        if (pred != null) {
                                            pred.next = en;
                                        } else {
                                            BoundedEquivalentConcurrentHashMapV8.setTabAt(tab, i, en);
                                        }
                                        this.evictionPolicy.onEntryRemove(e);
                                    }
                                }
                            } else {
                                pred = e;
                                e = e.next;
                                if (e != null) {
                                    ++binCount;
                                    continue;
                                }
                            }
                            break;
                        }
                    } else if (f instanceof TreeBin) {
                        TreeNode p;
                        binCount = 2;
                        TreeBin t = (TreeBin)f;
                        TreeNode r = t.root;
                        if (r != null && (p = r.findTreeNode(h, key, null)) != null) {
                            val = remappingFunction.apply(key, p.val);
                            if (val != null) {
                                p.val = val;
                                this.evictionPolicy.onEntryHitWrite(p, val);
                            } else {
                                delta = -1;
                                if (t.removeTreeNode(p)) {
                                    BoundedEquivalentConcurrentHashMapV8.setTabAt(tab, i, this.untreeify(t.first));
                                }
                                this.evictionPolicy.onEntryRemove(p);
                            }
                        }
                    }
                }
            }
            if (binCount != 0) break;
        }
        if (delta != 0) {
            this.addCount(delta, binCount);
        }
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        int binCount;
        int delta;
        Object val;
        block41: {
            int i;
            if (key == null || remappingFunction == null) {
                throw new NullPointerException();
            }
            int h = BoundedEquivalentConcurrentHashMapV8.spread(this.keyEq.hashCode(key));
            val = null;
            delta = 0;
            binCount = 0;
            Node<K, V>[] tab = this.table;
            while (true) {
                int n;
                if (tab == null || (n = tab.length) == 0) {
                    tab = this.initTable();
                    continue;
                }
                i = n - 1 & h;
                Node<K, V> f = BoundedEquivalentConcurrentHashMapV8.tabAt(tab, i);
                if (f == null) {
                    ReservationNode<K, V> r;
                    ReservationNode<K, V> reservationNode = r = new ReservationNode<K, V>(this.nodeEq);
                    synchronized (reservationNode) {
                        if (BoundedEquivalentConcurrentHashMapV8.casTabAt(tab, i, null, r)) {
                            binCount = 1;
                            Node<K, Object> node = null;
                            try {
                                V v = remappingFunction.apply(key, null);
                                val = v;
                                if (v != null) {
                                    delta = 1;
                                    node = this.evictionPolicy.createNewEntry(key, h, null, val, null);
                                    this.evictionPolicy.onEntryMiss(node, val);
                                    this.evictionListener.onEntryActivated(key);
                                }
                            }
                            finally {
                                BoundedEquivalentConcurrentHashMapV8.setTabAt(tab, i, node);
                            }
                        }
                    }
                    if (binCount == 0) continue;
                    break block41;
                }
                int fh = f.hash;
                if (fh == -1) {
                    tab = this.helpTransfer(tab, f);
                    continue;
                }
                Node<K, V> node = f;
                synchronized (node) {
                    block42: {
                        if (BoundedEquivalentConcurrentHashMapV8.tabAt(tab, i) == f) {
                            if (fh >= 0) {
                                binCount = 1;
                                Node<K, V> e = f;
                                Node<K, V> pred = null;
                                while (true) {
                                    Object ek;
                                    if (e.hash == h && ((ek = e.key) == key || ek != null && this.keyEq.equals(ek, key))) {
                                        Object oldVal = e.val == NULL_VALUE ? null : (Object)e.val;
                                        val = remappingFunction.apply(key, oldVal);
                                        if (val != null) {
                                            e.val = val;
                                            if (oldVal == null) {
                                                this.evictionPolicy.onEntryMiss(e, val);
                                            } else {
                                                this.evictionPolicy.onEntryHitWrite(e, val);
                                            }
                                        } else {
                                            delta = oldVal == null ? 0 : -1;
                                            Node en = e.next;
                                            if (pred != null) {
                                                pred.next = en;
                                            } else {
                                                BoundedEquivalentConcurrentHashMapV8.setTabAt(tab, i, en);
                                            }
                                            if (oldVal != null) {
                                                this.evictionPolicy.onEntryRemove(e);
                                            }
                                        }
                                        break block42;
                                    }
                                    pred = e;
                                    e = e.next;
                                    if (e == null) {
                                        val = remappingFunction.apply(key, null);
                                        if (val != null) {
                                            delta = 1;
                                            pred.next = this.evictionPolicy.createNewEntry(key, h, null, val, null);
                                            this.evictionPolicy.onEntryMiss(pred.next, val);
                                            this.evictionListener.onEntryActivated(key);
                                        }
                                        break block42;
                                    }
                                    ++binCount;
                                }
                            }
                            if (f instanceof TreeBin) {
                                binCount = 1;
                                TreeBin t = (TreeBin)f;
                                TreeNode r = t.root;
                                TreeNode p = r != null ? r.findTreeNode(h, key, null) : null;
                                Object pv = p == null ? null : (p.val == NULL_VALUE ? null : p.val);
                                val = remappingFunction.apply(key, pv);
                                if (val != null) {
                                    if (p != null) {
                                        delta = p.val == null ? 1 : 0;
                                        p.val = val;
                                        if (pv == null) {
                                            this.evictionPolicy.onEntryMiss(p, val);
                                        } else {
                                            this.evictionPolicy.onEntryHitWrite(p, val);
                                        }
                                    } else {
                                        delta = 1;
                                        t.putTreeVal(h, key, val);
                                    }
                                } else if (p != null) {
                                    int n2 = delta = p.val == null || p.val == NULL_VALUE ? 0 : -1;
                                    if (t.removeTreeNode(p)) {
                                        BoundedEquivalentConcurrentHashMapV8.setTabAt(tab, i, this.untreeify(t.first));
                                    }
                                    this.evictionPolicy.onEntryRemove(p);
                                }
                            }
                        }
                    }
                }
                if (binCount != 0) break;
            }
            if (binCount >= 8) {
                this.treeifyBin(tab, i);
            }
        }
        if (delta != 0) {
            this.addCount(delta, binCount);
        }
        this.notifyEvictionListener(this.evictionPolicy.findIfEntriesNeedEvicting());
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        int binCount;
        int delta;
        Object val;
        block30: {
            int i;
            if (key == null || value == null || remappingFunction == null) {
                throw new NullPointerException();
            }
            int h = BoundedEquivalentConcurrentHashMapV8.spread(this.keyEq.hashCode(key));
            val = null;
            delta = 0;
            binCount = 0;
            Node<K, V>[] tab = this.table;
            while (true) {
                int n;
                if (tab == null || (n = tab.length) == 0) {
                    tab = this.initTable();
                    continue;
                }
                i = n - 1 & h;
                Node<K, V> f = BoundedEquivalentConcurrentHashMapV8.tabAt(tab, i);
                if (f == null) {
                    Node<K, Object> newNode;
                    Node<K, Object> node = newNode = this.evictionPolicy.createNewEntry(key, h, null, val, null);
                    synchronized (node) {
                        if (BoundedEquivalentConcurrentHashMapV8.casTabAt(tab, i, null, newNode)) {
                            delta = 1;
                            val = value;
                            this.evictionPolicy.onEntryMiss(newNode, val);
                            this.evictionListener.onEntryActivated(key);
                            break block30;
                        }
                    }
                }
                int fh = f.hash;
                if (fh == -1) {
                    tab = this.helpTransfer(tab, f);
                    continue;
                }
                Node<K, V> node = f;
                synchronized (node) {
                    block31: {
                        if (BoundedEquivalentConcurrentHashMapV8.tabAt(tab, i) == f) {
                            Object prevVal;
                            if (fh >= 0) {
                                binCount = 1;
                                Node<K, V> e = f;
                                Node<K, V> pred = null;
                                while (true) {
                                    Object ek;
                                    if (e.hash == h && ((ek = e.key) == key || ek != null && this.keyEq.equals(ek, key))) {
                                        prevVal = e.val;
                                        prevVal = prevVal == NULL_VALUE ? null : prevVal;
                                        val = remappingFunction.apply(prevVal, value);
                                        if (val != null) {
                                            delta = prevVal == null ? 1 : 0;
                                            e.val = val;
                                        } else {
                                            delta = prevVal == null ? 0 : -1;
                                            Node en = e.next;
                                            if (pred != null) {
                                                pred.next = en;
                                            } else {
                                                BoundedEquivalentConcurrentHashMapV8.setTabAt(tab, i, en);
                                            }
                                        }
                                        break block31;
                                    }
                                    pred = e;
                                    e = e.next;
                                    if (e == null) {
                                        delta = 1;
                                        val = value;
                                        pred.next = this.evictionPolicy.createNewEntry(key, h, null, val, null);
                                        this.evictionPolicy.onEntryMiss(pred.next, val);
                                        this.evictionListener.onEntryActivated(key);
                                        break block31;
                                    }
                                    ++binCount;
                                }
                            }
                            if (f instanceof TreeBin) {
                                binCount = 2;
                                TreeBin t = (TreeBin)f;
                                TreeNode r = t.root;
                                TreeNode p = r == null ? null : r.findTreeNode(h, key, null);
                                prevVal = p.val;
                                prevVal = prevVal == NULL_VALUE ? null : prevVal;
                                val = p == null ? value : remappingFunction.apply(prevVal, value);
                                if (val != null) {
                                    if (p != null) {
                                        delta = prevVal == null ? 1 : 0;
                                        p.val = val;
                                    } else {
                                        delta = 1;
                                        t.putTreeVal(h, key, val);
                                    }
                                } else if (p != null) {
                                    int n2 = delta = prevVal == null ? 0 : -1;
                                    if (t.removeTreeNode(p)) {
                                        BoundedEquivalentConcurrentHashMapV8.setTabAt(tab, i, this.untreeify(t.first));
                                    }
                                }
                            }
                        }
                    }
                }
                if (binCount != 0) break;
            }
            if (binCount >= 8) {
                this.treeifyBin(tab, i);
            }
        }
        if (delta != 0) {
            this.addCount(delta, binCount);
            this.notifyEvictionListener(this.evictionPolicy.findIfEntriesNeedEvicting());
        }
        return val;
    }

    @Deprecated
    public boolean contains(Object value) {
        return this.containsValue(value);
    }

    public Enumeration<K> keys() {
        Node<K, V>[] t = this.table;
        int f = this.table == null ? 0 : t.length;
        return new KeyIterator<K, V>(t, f, 0, f, this);
    }

    public Enumeration<V> elements() {
        Node<K, V>[] t = this.table;
        int f = this.table == null ? 0 : t.length;
        return new ValueIterator<K, V>(t, f, 0, f, this);
    }

    public long mappingCount() {
        long n = this.sumCount();
        return n < 0L ? 0L : n;
    }

    public static <K> KeySetView<K, Boolean> newKeySet(int maxSize, Equivalence<K> keyEquivalence) {
        return new KeySetView<K, Boolean>(new BoundedEquivalentConcurrentHashMapV8(maxSize, keyEquivalence, AnyEquivalence.getInstance()), Boolean.TRUE);
    }

    public static <K> KeySetView<K, Boolean> newKeySet(int maxSize, int initialCapacity, Equivalence<K> keyEquivalence) {
        return new KeySetView<K, Boolean>(new BoundedEquivalentConcurrentHashMapV8((long)maxSize, initialCapacity, keyEquivalence, AnyEquivalence.getInstance()), Boolean.TRUE);
    }

    public KeySetView<K, V> keySet(V mappedValue) {
        if (mappedValue == null) {
            throw new NullPointerException();
        }
        return new KeySetView(this, mappedValue);
    }

    static final int resizeStamp(int n) {
        return Integer.numberOfLeadingZeros(n) | 1 << RESIZE_STAMP_BITS - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Node<K, V>[] initTable() {
        Node<K, V>[] tab;
        block6: {
            int sc;
            while (true) {
                tab = this.table;
                if (this.table != null && tab.length != 0) break block6;
                sc = this.sizeCtl;
                if (sc < 0) {
                    Thread.yield();
                    continue;
                }
                if (U.compareAndSwapInt(this, SIZECTL, sc, -1)) break;
            }
            try {
                tab = this.table;
                if (this.table == null || tab.length == 0) {
                    int n = sc > 0 ? sc : 16;
                    Node[] nt = new Node[n];
                    tab = nt;
                    this.table = nt;
                    sc = n - (n >>> 2);
                    this.evictionPolicy.onResize(0L, n);
                }
            }
            finally {
                this.sizeCtl = sc;
            }
        }
        return tab;
    }

    public void resize(long newSize) {
        if (newSize <= 0L) {
            throw new IllegalArgumentException();
        }
        this.maxSize = newSize;
        this.evictionPolicy.resize(newSize);
    }

    public long capacity() {
        return this.maxSize;
    }

    private final void addCount(long x, int check) {
        long s;
        long b;
        CounterCell[] as = this.counterCells;
        if (this.counterCells != null || !U.compareAndSwapLong(this, BASECOUNT, b = this.baseCount, s = b + x)) {
            long v;
            CounterCell a;
            int m;
            boolean uncontended = true;
            CounterHashCode hc = threadCounterHashCode.get();
            if (hc == null || as == null || (m = as.length - 1) < 0 || (a = as[m & hc.code]) == null || !(uncontended = U.compareAndSwapLong(a, CELLVALUE, v = a.value, v + x))) {
                this.fullAddCount(x, hc, uncontended);
                return;
            }
            if (check <= -1) {
                return;
            }
            s = this.sumCount();
        }
        if (check >= 0) {
            int sc;
            while (s >= (long)(sc = this.sizeCtl) && (double)this.sizeCtl * 0.75 < (double)this.maxSize) {
                int n;
                Node<K, V>[] tab = this.table;
                if (this.table == null || (n = tab.length) >= 0x40000000) break;
                int rs = BoundedEquivalentConcurrentHashMapV8.resizeStamp(n);
                if (sc < 0) {
                    if (sc >>> RESIZE_STAMP_SHIFT != rs || sc == rs + 1 || sc == rs + MAX_RESIZERS) break;
                    Node<K, V>[] nt = this.nextTable;
                    if (this.nextTable == null || this.transferIndex <= 0) break;
                    if (U.compareAndSwapInt(this, SIZECTL, sc, sc + 1)) {
                        this.transfer(tab, nt);
                    }
                } else if (U.compareAndSwapInt(this, SIZECTL, sc, (rs << RESIZE_STAMP_SHIFT) + 2)) {
                    this.transfer(tab, null);
                }
                s = this.sumCount();
            }
        }
    }

    final Node<K, V>[] helpTransfer(Node<K, V>[] tab, Node<K, V> f) {
        if (tab != null && f instanceof ForwardingNode) {
            Node<K, V>[] nextTab = ((ForwardingNode)f).nextTable;
            if (((ForwardingNode)f).nextTable != null) {
                int sc;
                int rs = BoundedEquivalentConcurrentHashMapV8.resizeStamp(tab.length);
                while (nextTab == this.nextTable && this.table == tab && (sc = this.sizeCtl) < 0 && sc >>> RESIZE_STAMP_SHIFT == rs && sc != rs + 1 && sc != rs + MAX_RESIZERS && this.transferIndex > 0) {
                    if (!U.compareAndSwapInt(this, SIZECTL, sc, sc + 1)) continue;
                    this.transfer(tab, nextTab);
                    break;
                }
                return nextTab;
            }
        }
        return this.table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void tryPresize(int size) {
        int sc;
        int c;
        int n = c = size >= 0x20000000 ? 0x40000000 : BoundedEquivalentConcurrentHashMapV8.tableSizeFor(size + (size >>> 1) + 1);
        while ((sc = this.sizeCtl) >= 0) {
            int n2;
            Node<K, V>[] tab = this.table;
            if (tab == null || (n2 = tab.length) == 0) {
                int n3 = n2 = sc > c ? sc : c;
                if (!U.compareAndSwapInt(this, SIZECTL, sc, -1)) continue;
                try {
                    if (this.table != tab) continue;
                    Node[] nt = new Node[n2];
                    this.table = nt;
                    sc = n2 - (n2 >>> 2);
                    this.evictionPolicy.onResize(tab.length, n2);
                    continue;
                }
                finally {
                    this.sizeCtl = sc;
                    continue;
                }
            }
            if (c <= sc || n2 >= 0x40000000) break;
            if (tab != this.table) continue;
            int rs = BoundedEquivalentConcurrentHashMapV8.resizeStamp(n2);
            if (sc < 0) {
                if (sc >>> RESIZE_STAMP_SHIFT != rs || sc == rs + 1 || sc == rs + MAX_RESIZERS) break;
                Node<K, V>[] nt = this.nextTable;
                if (this.nextTable == null || this.transferIndex <= 0) break;
                if (!U.compareAndSwapInt(this, SIZECTL, sc, sc + 1)) continue;
                this.transfer(tab, nt);
                continue;
            }
            if (!U.compareAndSwapInt(this, SIZECTL, sc, (rs << RESIZE_STAMP_SHIFT) + 2)) continue;
            this.transfer(tab, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void transfer(Node<K, V>[] tab, Node<K, V>[] nextTab) {
        int n = tab.length;
        int stride = NCPU > 1 ? (n >>> 3) / NCPU : n;
        if (stride < 16) {
            stride = 16;
        }
        if (nextTab == null) {
            try {
                Node[] nt = new Node[n << 1];
                nextTab = nt;
            }
            catch (Throwable ex) {
                this.sizeCtl = Integer.MAX_VALUE;
                return;
            }
            this.nextTable = nextTab;
            this.transferIndex = n;
        }
        int nextn = nextTab.length;
        ForwardingNode<K, V> fwd = new ForwardingNode<K, V>(nextTab, this.nodeEq);
        boolean advance = true;
        boolean finishing = false;
        int i = 0;
        int bound = 0;
        while (true) {
            if (advance) {
                if (--i >= bound || finishing) {
                    advance = false;
                    continue;
                }
                int nextIndex = this.transferIndex;
                if (nextIndex <= 0) {
                    i = -1;
                    advance = false;
                    continue;
                }
                int nextBound = nextIndex > stride ? nextIndex - stride : 0;
                if (!U.compareAndSwapInt(this, TRANSFERINDEX, nextIndex, nextBound)) continue;
                bound = nextBound;
                i = nextIndex - 1;
                advance = false;
                continue;
            }
            if (i < 0 || i >= n || i + n >= nextn) {
                if (finishing) {
                    this.nextTable = null;
                    long oldSize = this.table.length;
                    this.table = nextTab;
                    this.sizeCtl = (n << 1) - (n >>> 1);
                    this.evictionPolicy.onResize(oldSize, this.table.length);
                    return;
                }
                int sc = this.sizeCtl;
                if (!U.compareAndSwapInt(this, SIZECTL, sc, sc - 1)) continue;
                if (sc - 2 != BoundedEquivalentConcurrentHashMapV8.resizeStamp(n) << RESIZE_STAMP_SHIFT) {
                    return;
                }
                advance = true;
                finishing = true;
                i = n;
                continue;
            }
            TreeBin f = BoundedEquivalentConcurrentHashMapV8.tabAt(tab, i);
            if (f == null) {
                advance = BoundedEquivalentConcurrentHashMapV8.casTabAt(tab, i, null, fwd);
                continue;
            }
            int fh = f.hash;
            if (fh == -1) {
                advance = true;
                continue;
            }
            TreeBin treeBin = f;
            synchronized (treeBin) {
                if (BoundedEquivalentConcurrentHashMapV8.tabAt(tab, i) == f) {
                    Node hn;
                    if (fh >= 0) {
                        Node ln;
                        int runBit = fh & n;
                        TreeBin lastRun = f;
                        Node p = f.next;
                        while (p != null) {
                            int b = p.hash & n;
                            if (b != runBit) {
                                runBit = b;
                                lastRun = p;
                            }
                            p = p.next;
                        }
                        if (runBit == 0) {
                            ln = lastRun;
                            hn = null;
                        } else {
                            hn = lastRun;
                            ln = null;
                        }
                        p = f;
                        while (p != lastRun) {
                            int ph = p.hash;
                            Object pk = p.key;
                            Object pv = p.val;
                            if ((ph & n) == 0) {
                                ln = this.evictionPolicy.createNewEntry(pk, ph, ln, pv, p.eviction);
                            } else {
                                hn = this.evictionPolicy.createNewEntry(pk, ph, hn, pv, p.eviction);
                            }
                            p = p.next;
                        }
                        BoundedEquivalentConcurrentHashMapV8.setTabAt(nextTab, i, ln);
                        BoundedEquivalentConcurrentHashMapV8.setTabAt(nextTab, i + n, hn);
                        BoundedEquivalentConcurrentHashMapV8.setTabAt(tab, i, fwd);
                        advance = true;
                    } else if (f instanceof TreeBin) {
                        TreeBin ln;
                        TreeBin t = f;
                        TreeNode<K, V> lo = null;
                        TreeNode<K, V> loTail = null;
                        TreeNode<K, V> hi = null;
                        TreeNode<K, V> hiTail = null;
                        int lc = 0;
                        int hc = 0;
                        Node e = t.first;
                        while (e != null) {
                            int h = e.hash;
                            TreeNode<K, V> p = this.evictionPolicy.createNewEntry(e.key, h, null, null, e.val, e.eviction);
                            if ((h & n) == 0) {
                                p.prev = loTail;
                                if (p.prev == null) {
                                    lo = p;
                                } else {
                                    loTail.next = p;
                                }
                                loTail = p;
                                ++lc;
                            } else {
                                p.prev = hiTail;
                                if (p.prev == null) {
                                    hi = p;
                                } else {
                                    hiTail.next = p;
                                }
                                hiTail = p;
                                ++hc;
                            }
                            e = e.next;
                        }
                        TreeBin treeBin2 = lc <= 6 ? this.untreeify(lo) : (ln = hc != 0 ? new TreeBin(lo, this) : t);
                        hn = hc <= 6 ? this.untreeify(hi) : (lc != 0 ? new TreeBin(hi, this) : t);
                        BoundedEquivalentConcurrentHashMapV8.setTabAt(nextTab, i, ln);
                        BoundedEquivalentConcurrentHashMapV8.setTabAt(nextTab, i + n, hn);
                        BoundedEquivalentConcurrentHashMapV8.setTabAt(tab, i, fwd);
                        advance = true;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void treeifyBin(Node<K, V>[] tab, int index) {
        if (tab != null) {
            int n = tab.length;
            if (n < 64) {
                this.tryPresize(n << 1);
            } else {
                Node<K, V> b = BoundedEquivalentConcurrentHashMapV8.tabAt(tab, index);
                if (b != null && b.hash >= 0) {
                    Node<K, V> node = b;
                    synchronized (node) {
                        if (BoundedEquivalentConcurrentHashMapV8.tabAt(tab, index) == b) {
                            TreeNode<K, V> hd = null;
                            TreeNode<K, V> tl = null;
                            Node<K, V> e = b;
                            while (e != null) {
                                TreeNode<K, V> p = this.evictionPolicy.createNewEntry(e.key, e.hash, null, null, e.val, e.eviction);
                                p.prev = tl;
                                if (p.prev == null) {
                                    hd = p;
                                } else {
                                    tl.next = p;
                                }
                                tl = p;
                                e = e.next;
                            }
                            BoundedEquivalentConcurrentHashMapV8.setTabAt(tab, index, new TreeBin(hd, this));
                        }
                    }
                }
            }
        }
    }

    Node<K, V> untreeify(Node<K, V> b) {
        Node<K, V> hd = null;
        Node<K, V> tl = null;
        Node<K, V> q = b;
        while (q != null) {
            Node<K, V> p = this.evictionPolicy.createNewEntry(q.key, q.hash, null, q.val, q.eviction);
            if (tl == null) {
                hd = p;
            } else {
                tl.next = p;
            }
            tl = p;
            q = q.next;
        }
        return hd;
    }

    final int batchFor(long b) {
        long n;
        if (b == Long.MAX_VALUE || (n = this.sumCount()) <= 1L || n < b) {
            return 0;
        }
        int sp = ForkJoinPool.getCommonPoolParallelism() << 2;
        return b <= 0L || (n /= b) >= (long)sp ? sp : (int)n;
    }

    @Override
    public void forEach(long parallelismThreshold, BiConsumer<? super K, ? super V> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        new ForEachMappingTask<K, V>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, action).invoke();
    }

    public <U> void forEach(long parallelismThreshold, BiFunction<? super K, ? super V, ? extends U> transformer, Consumer<? super U> action) {
        if (transformer == null || action == null) {
            throw new NullPointerException();
        }
        new ForEachTransformedMappingTask<K, V, U>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, transformer, action).invoke();
    }

    public <U> U search(long parallelismThreshold, BiFunction<? super K, ? super V, ? extends U> searchFunction) {
        if (searchFunction == null) {
            throw new NullPointerException();
        }
        return (U)new SearchMappingsTask<K, V, U>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, searchFunction, new AtomicReference()).invoke();
    }

    public <U> U reduce(long parallelismThreshold, BiFunction<? super K, ? super V, ? extends U> transformer, BiFunction<? super U, ? super U, ? extends U> reducer) {
        if (transformer == null || reducer == null) {
            throw new NullPointerException();
        }
        return (U)new MapReduceMappingsTask<K, V, U>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, null, transformer, reducer).invoke();
    }

    public double reduceToDouble(long parallelismThreshold, ToDoubleBiFunction<? super K, ? super V> transformer, double basis, DoubleBinaryOperator reducer) {
        if (transformer == null || reducer == null) {
            throw new NullPointerException();
        }
        return (Double)new MapReduceMappingsToDoubleTask<K, V>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, null, transformer, basis, reducer).invoke();
    }

    public long reduceToLong(long parallelismThreshold, ToLongBiFunction<? super K, ? super V> transformer, long basis, LongBinaryOperator reducer) {
        if (transformer == null || reducer == null) {
            throw new NullPointerException();
        }
        return (Long)new MapReduceMappingsToLongTask<K, V>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, null, transformer, basis, reducer).invoke();
    }

    public int reduceToInt(long parallelismThreshold, ToIntBiFunction<? super K, ? super V> transformer, int basis, IntBinaryOperator reducer) {
        if (transformer == null || reducer == null) {
            throw new NullPointerException();
        }
        return (Integer)new MapReduceMappingsToIntTask<K, V>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, null, transformer, basis, reducer).invoke();
    }

    public void forEachKey(long parallelismThreshold, Consumer<? super K> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        new ForEachKeyTask<K, V>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, action).invoke();
    }

    public <U> void forEachKey(long parallelismThreshold, Function<? super K, ? extends U> transformer, Consumer<? super U> action) {
        if (transformer == null || action == null) {
            throw new NullPointerException();
        }
        new ForEachTransformedKeyTask<K, V, U>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, transformer, action).invoke();
    }

    public <U> U searchKeys(long parallelismThreshold, Function<? super K, ? extends U> searchFunction) {
        if (searchFunction == null) {
            throw new NullPointerException();
        }
        return (U)new SearchKeysTask<K, V, U>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, searchFunction, new AtomicReference()).invoke();
    }

    public K reduceKeys(long parallelismThreshold, BiFunction<? super K, ? super K, ? extends K> reducer) {
        if (reducer == null) {
            throw new NullPointerException();
        }
        return (K)new ReduceKeysTask<K, V>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, null, reducer).invoke();
    }

    public <U> U reduceKeys(long parallelismThreshold, Function<? super K, ? extends U> transformer, BiFunction<? super U, ? super U, ? extends U> reducer) {
        if (transformer == null || reducer == null) {
            throw new NullPointerException();
        }
        return (U)new MapReduceKeysTask<K, V, U>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, null, transformer, reducer).invoke();
    }

    public double reduceKeysToDouble(long parallelismThreshold, ToDoubleFunction<? super K> transformer, double basis, DoubleBinaryOperator reducer) {
        if (transformer == null || reducer == null) {
            throw new NullPointerException();
        }
        return (Double)new MapReduceKeysToDoubleTask<K, V>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, null, transformer, basis, reducer).invoke();
    }

    public long reduceKeysToLong(long parallelismThreshold, ToLongFunction<? super K> transformer, long basis, LongBinaryOperator reducer) {
        if (transformer == null || reducer == null) {
            throw new NullPointerException();
        }
        return (Long)new MapReduceKeysToLongTask<K, V>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, null, transformer, basis, reducer).invoke();
    }

    public int reduceKeysToInt(long parallelismThreshold, ToIntFunction<? super K> transformer, int basis, IntBinaryOperator reducer) {
        if (transformer == null || reducer == null) {
            throw new NullPointerException();
        }
        return (Integer)new MapReduceKeysToIntTask<K, V>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, null, transformer, basis, reducer).invoke();
    }

    public void forEachValue(long parallelismThreshold, Consumer<? super V> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        new ForEachValueTask<K, V>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, action).invoke();
    }

    public <U> void forEachValue(long parallelismThreshold, Function<? super V, ? extends U> transformer, Consumer<? super U> action) {
        if (transformer == null || action == null) {
            throw new NullPointerException();
        }
        new ForEachTransformedValueTask<K, V, U>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, transformer, action).invoke();
    }

    public <U> U searchValues(long parallelismThreshold, Function<? super V, ? extends U> searchFunction) {
        if (searchFunction == null) {
            throw new NullPointerException();
        }
        return (U)new SearchValuesTask<K, V, U>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, searchFunction, new AtomicReference()).invoke();
    }

    public V reduceValues(long parallelismThreshold, BiFunction<? super V, ? super V, ? extends V> reducer) {
        if (reducer == null) {
            throw new NullPointerException();
        }
        return new ReduceValuesTask<K, V>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, null, reducer).invoke();
    }

    public <U> U reduceValues(long parallelismThreshold, Function<? super V, ? extends U> transformer, BiFunction<? super U, ? super U, ? extends U> reducer) {
        if (transformer == null || reducer == null) {
            throw new NullPointerException();
        }
        return (U)new MapReduceValuesTask<K, V, U>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, null, transformer, reducer).invoke();
    }

    public double reduceValuesToDouble(long parallelismThreshold, ToDoubleFunction<? super V> transformer, double basis, DoubleBinaryOperator reducer) {
        if (transformer == null || reducer == null) {
            throw new NullPointerException();
        }
        return (Double)new MapReduceValuesToDoubleTask<K, V>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, null, transformer, basis, reducer).invoke();
    }

    public long reduceValuesToLong(long parallelismThreshold, ToLongFunction<? super V> transformer, long basis, LongBinaryOperator reducer) {
        if (transformer == null || reducer == null) {
            throw new NullPointerException();
        }
        return (Long)new MapReduceValuesToLongTask<K, V>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, null, transformer, basis, reducer).invoke();
    }

    public int reduceValuesToInt(long parallelismThreshold, ToIntFunction<? super V> transformer, int basis, IntBinaryOperator reducer) {
        if (transformer == null || reducer == null) {
            throw new NullPointerException();
        }
        return (Integer)new MapReduceValuesToIntTask<K, V>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, null, transformer, basis, reducer).invoke();
    }

    public void forEachEntry(long parallelismThreshold, Consumer<? super Map.Entry<K, V>> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        new ForEachEntryTask<K, V>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, action).invoke();
    }

    public <U> void forEachEntry(long parallelismThreshold, Function<Map.Entry<K, V>, ? extends U> transformer, Consumer<? super U> action) {
        if (transformer == null || action == null) {
            throw new NullPointerException();
        }
        new ForEachTransformedEntryTask<K, V, U>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, transformer, action).invoke();
    }

    public <U> U searchEntries(long parallelismThreshold, Function<Map.Entry<K, V>, ? extends U> searchFunction) {
        if (searchFunction == null) {
            throw new NullPointerException();
        }
        return (U)new SearchEntriesTask<K, V, U>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, searchFunction, new AtomicReference()).invoke();
    }

    public Map.Entry<K, V> reduceEntries(long parallelismThreshold, BiFunction<Map.Entry<K, V>, Map.Entry<K, V>, ? extends Map.Entry<K, V>> reducer) {
        if (reducer == null) {
            throw new NullPointerException();
        }
        return (Map.Entry)new ReduceEntriesTask<K, V>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, null, reducer).invoke();
    }

    public <U> U reduceEntries(long parallelismThreshold, Function<Map.Entry<K, V>, ? extends U> transformer, BiFunction<? super U, ? super U, ? extends U> reducer) {
        if (transformer == null || reducer == null) {
            throw new NullPointerException();
        }
        return (U)new MapReduceEntriesTask<K, V, U>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, null, transformer, reducer).invoke();
    }

    public double reduceEntriesToDouble(long parallelismThreshold, ToDoubleFunction<Map.Entry<K, V>> transformer, double basis, DoubleBinaryOperator reducer) {
        if (transformer == null || reducer == null) {
            throw new NullPointerException();
        }
        return (Double)new MapReduceEntriesToDoubleTask<K, V>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, null, transformer, basis, reducer).invoke();
    }

    public long reduceEntriesToLong(long parallelismThreshold, ToLongFunction<Map.Entry<K, V>> transformer, long basis, LongBinaryOperator reducer) {
        if (transformer == null || reducer == null) {
            throw new NullPointerException();
        }
        return (Long)new MapReduceEntriesToLongTask<K, V>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, null, transformer, basis, reducer).invoke();
    }

    public int reduceEntriesToInt(long parallelismThreshold, ToIntFunction<Map.Entry<K, V>> transformer, int basis, IntBinaryOperator reducer) {
        if (transformer == null || reducer == null) {
            throw new NullPointerException();
        }
        return (Integer)new MapReduceEntriesToIntTask<K, V>(null, this.batchFor(parallelismThreshold), 0, 0, this.table, null, transformer, basis, reducer).invoke();
    }

    final long sumCount() {
        CounterCell[] as = this.counterCells;
        long sum = this.baseCount;
        if (as != null) {
            for (int i = 0; i < as.length; ++i) {
                CounterCell a = as[i];
                if (a == null) continue;
                sum += a.value;
            }
        }
        return sum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void fullAddCount(long x, CounterHashCode hc, boolean wasUncontended) {
        int h;
        if (hc == null) {
            hc = new CounterHashCode();
            int s = counterHashCodeGenerator.addAndGet(1640531527);
            hc.code = s == 0 ? 1 : s;
            h = hc.code;
            threadCounterHashCode.set(hc);
        } else {
            h = hc.code;
        }
        boolean collide = false;
        while (true) {
            long v;
            int n;
            CounterCell[] as = this.counterCells;
            if (this.counterCells != null && (n = as.length) > 0) {
                CounterCell a = as[n - 1 & h];
                if (a == null) {
                    if (this.cellsBusy == 0) {
                        CounterCell r = new CounterCell(x);
                        if (this.cellsBusy == 0 && U.compareAndSwapInt(this, CELLSBUSY, 0, 1)) {
                            boolean created = false;
                            try {
                                int j;
                                int m;
                                CounterCell[] rs = this.counterCells;
                                if (this.counterCells != null && (m = rs.length) > 0 && rs[j = m - 1 & h] == null) {
                                    rs[j] = r;
                                    created = true;
                                }
                            }
                            finally {
                                this.cellsBusy = 0;
                            }
                            if (!created) continue;
                            break;
                        }
                    }
                    collide = false;
                } else if (!wasUncontended) {
                    wasUncontended = true;
                } else {
                    v = a.value;
                    if (U.compareAndSwapLong(a, CELLVALUE, v, v + x)) break;
                    if (this.counterCells != as || n >= NCPU) {
                        collide = false;
                    } else if (!collide) {
                        collide = true;
                    } else if (this.cellsBusy == 0 && U.compareAndSwapInt(this, CELLSBUSY, 0, 1)) {
                        try {
                            if (this.counterCells == as) {
                                CounterCell[] rs = new CounterCell[n << 1];
                                for (int i = 0; i < n; ++i) {
                                    rs[i] = as[i];
                                }
                                this.counterCells = rs;
                            }
                        }
                        finally {
                            this.cellsBusy = 0;
                        }
                        collide = false;
                        continue;
                    }
                }
                h ^= h << 13;
                h ^= h >>> 17;
                h ^= h << 5;
                continue;
            }
            if (this.cellsBusy == 0 && this.counterCells == as && U.compareAndSwapInt(this, CELLSBUSY, 0, 1)) {
                boolean init = false;
                try {
                    if (this.counterCells == as) {
                        CounterCell[] rs = new CounterCell[2];
                        rs[h & 1] = new CounterCell(x);
                        this.counterCells = rs;
                        init = true;
                    }
                }
                finally {
                    this.cellsBusy = 0;
                }
                if (!init) continue;
                break;
            }
            v = this.baseCount;
            if (U.compareAndSwapLong(this, BASECOUNT, v, v + x)) break;
        }
        hc.code = h;
    }

    static Unsafe getUnsafe() {
        try {
            return Unsafe.getUnsafe();
        }
        catch (SecurityException securityException) {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<Unsafe>(){

                    @Override
                    public Unsafe run() throws Exception {
                        Class<Unsafe> k = Unsafe.class;
                        for (Field f : k.getDeclaredFields()) {
                            f.setAccessible(true);
                            Object x = f.get(null);
                            if (!k.isInstance(x)) continue;
                            return (Unsafe)k.cast(x);
                        }
                        throw new NoSuchFieldError("the Unsafe");
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw new RuntimeException("Could not initialize intrinsics", e.getCause());
            }
        }
    }

    static {
        try {
            U = BoundedEquivalentConcurrentHashMapV8.getUnsafe();
            Class<BoundedEquivalentConcurrentHashMapV8> k = BoundedEquivalentConcurrentHashMapV8.class;
            SIZECTL = U.objectFieldOffset(k.getDeclaredField("sizeCtl"));
            TRANSFERINDEX = U.objectFieldOffset(k.getDeclaredField("transferIndex"));
            BASECOUNT = U.objectFieldOffset(k.getDeclaredField("baseCount"));
            CELLSBUSY = U.objectFieldOffset(k.getDeclaredField("cellsBusy"));
            Class<CounterCell> ck = CounterCell.class;
            CELLVALUE = U.objectFieldOffset(ck.getDeclaredField("value"));
            Class<Node[]> ak = Node[].class;
            ABASE = U.arrayBaseOffset(ak);
            int scale = U.arrayIndexScale(ak);
            if ((scale & scale - 1) != 0) {
                throw new Error("data type scale not a power of two");
            }
            ASHIFT = 31 - Integer.numberOfLeadingZeros(scale);
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    static final class CounterHashCode {
        int code;

        CounterHashCode() {
        }
    }

    static final class CounterCell {
        volatile long p0;
        volatile long p1;
        volatile long p2;
        volatile long p3;
        volatile long p4;
        volatile long p5;
        volatile long p6;
        volatile long value;
        volatile long q0;
        volatile long q1;
        volatile long q2;
        volatile long q3;
        volatile long q4;
        volatile long q5;
        volatile long q6;

        CounterCell(long x) {
            this.value = x;
        }
    }

    static final class MapReduceMappingsToIntTask<K, V>
    extends BulkTask<K, V, Integer> {
        final ToIntBiFunction<? super K, ? super V> transformer;
        final IntBinaryOperator reducer;
        final int basis;
        int result;
        MapReduceMappingsToIntTask<K, V> rights;
        MapReduceMappingsToIntTask<K, V> nextRight;

        MapReduceMappingsToIntTask(BulkTask<K, V, ?> p, int b, int i, int f, Node<K, V>[] t, MapReduceMappingsToIntTask<K, V> nextRight, ToIntBiFunction<? super K, ? super V> transformer, int basis, IntBinaryOperator reducer) {
            super(p, b, i, f, t);
            this.nextRight = nextRight;
            this.transformer = transformer;
            this.basis = basis;
            this.reducer = reducer;
        }

        @Override
        public final Integer getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            IntBinaryOperator reducer;
            ToIntBiFunction<K, V> transformer = this.transformer;
            if (transformer != null && (reducer = this.reducer) != null) {
                Node p;
                int f;
                int h;
                int r = this.basis;
                int i = this.baseIndex;
                while (this.batch > 0 && (h = (f = this.baseLimit) + i >>> 1) > i) {
                    this.addToPendingCount(1);
                    this.baseLimit = h;
                    this.rights = new MapReduceMappingsToIntTask<K, V>(this, this.batch >>>= 1, this.baseLimit, f, this.tab, this.rights, transformer, r, reducer);
                    this.rights.fork();
                }
                while ((p = this.advance()) != null) {
                    r = reducer.applyAsInt(r, transformer.applyAsInt(p.key, p.val));
                }
                this.result = r;
                for (CountedCompleter<?> c = this.firstComplete(); c != null; c = c.nextComplete()) {
                    MapReduceMappingsToIntTask t = (MapReduceMappingsToIntTask)c;
                    MapReduceMappingsToIntTask<K, V> s = t.rights;
                    while (s != null) {
                        t.result = reducer.applyAsInt(t.result, s.result);
                        s = t.rights = s.nextRight;
                    }
                }
            }
        }
    }

    static final class MapReduceEntriesToIntTask<K, V>
    extends BulkTask<K, V, Integer> {
        final ToIntFunction<Map.Entry<K, V>> transformer;
        final IntBinaryOperator reducer;
        final int basis;
        int result;
        MapReduceEntriesToIntTask<K, V> rights;
        MapReduceEntriesToIntTask<K, V> nextRight;

        MapReduceEntriesToIntTask(BulkTask<K, V, ?> p, int b, int i, int f, Node<K, V>[] t, MapReduceEntriesToIntTask<K, V> nextRight, ToIntFunction<Map.Entry<K, V>> transformer, int basis, IntBinaryOperator reducer) {
            super(p, b, i, f, t);
            this.nextRight = nextRight;
            this.transformer = transformer;
            this.basis = basis;
            this.reducer = reducer;
        }

        @Override
        public final Integer getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            IntBinaryOperator reducer;
            ToIntFunction<Map.Entry<K, V>> transformer = this.transformer;
            if (transformer != null && (reducer = this.reducer) != null) {
                Node p;
                int f;
                int h;
                int r = this.basis;
                int i = this.baseIndex;
                while (this.batch > 0 && (h = (f = this.baseLimit) + i >>> 1) > i) {
                    this.addToPendingCount(1);
                    this.baseLimit = h;
                    this.rights = new MapReduceEntriesToIntTask<K, V>(this, this.batch >>>= 1, this.baseLimit, f, this.tab, this.rights, transformer, r, reducer);
                    this.rights.fork();
                }
                while ((p = this.advance()) != null) {
                    r = reducer.applyAsInt(r, transformer.applyAsInt(p));
                }
                this.result = r;
                for (CountedCompleter<?> c = this.firstComplete(); c != null; c = c.nextComplete()) {
                    MapReduceEntriesToIntTask t = (MapReduceEntriesToIntTask)c;
                    MapReduceEntriesToIntTask<K, V> s = t.rights;
                    while (s != null) {
                        t.result = reducer.applyAsInt(t.result, s.result);
                        s = t.rights = s.nextRight;
                    }
                }
            }
        }
    }

    static final class MapReduceValuesToIntTask<K, V>
    extends BulkTask<K, V, Integer> {
        final ToIntFunction<? super V> transformer;
        final IntBinaryOperator reducer;
        final int basis;
        int result;
        MapReduceValuesToIntTask<K, V> rights;
        MapReduceValuesToIntTask<K, V> nextRight;

        MapReduceValuesToIntTask(BulkTask<K, V, ?> p, int b, int i, int f, Node<K, V>[] t, MapReduceValuesToIntTask<K, V> nextRight, ToIntFunction<? super V> transformer, int basis, IntBinaryOperator reducer) {
            super(p, b, i, f, t);
            this.nextRight = nextRight;
            this.transformer = transformer;
            this.basis = basis;
            this.reducer = reducer;
        }

        @Override
        public final Integer getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            IntBinaryOperator reducer;
            ToIntFunction<V> transformer = this.transformer;
            if (transformer != null && (reducer = this.reducer) != null) {
                Node p;
                int f;
                int h;
                int r = this.basis;
                int i = this.baseIndex;
                while (this.batch > 0 && (h = (f = this.baseLimit) + i >>> 1) > i) {
                    this.addToPendingCount(1);
                    this.baseLimit = h;
                    this.rights = new MapReduceValuesToIntTask<K, V>(this, this.batch >>>= 1, this.baseLimit, f, this.tab, this.rights, transformer, r, reducer);
                    this.rights.fork();
                }
                while ((p = this.advance()) != null) {
                    r = reducer.applyAsInt(r, transformer.applyAsInt(p.val));
                }
                this.result = r;
                for (CountedCompleter<?> c = this.firstComplete(); c != null; c = c.nextComplete()) {
                    MapReduceValuesToIntTask t = (MapReduceValuesToIntTask)c;
                    MapReduceValuesToIntTask<K, V> s = t.rights;
                    while (s != null) {
                        t.result = reducer.applyAsInt(t.result, s.result);
                        s = t.rights = s.nextRight;
                    }
                }
            }
        }
    }

    static final class MapReduceKeysToIntTask<K, V>
    extends BulkTask<K, V, Integer> {
        final ToIntFunction<? super K> transformer;
        final IntBinaryOperator reducer;
        final int basis;
        int result;
        MapReduceKeysToIntTask<K, V> rights;
        MapReduceKeysToIntTask<K, V> nextRight;

        MapReduceKeysToIntTask(BulkTask<K, V, ?> p, int b, int i, int f, Node<K, V>[] t, MapReduceKeysToIntTask<K, V> nextRight, ToIntFunction<? super K> transformer, int basis, IntBinaryOperator reducer) {
            super(p, b, i, f, t);
            this.nextRight = nextRight;
            this.transformer = transformer;
            this.basis = basis;
            this.reducer = reducer;
        }

        @Override
        public final Integer getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            IntBinaryOperator reducer;
            ToIntFunction<K> transformer = this.transformer;
            if (transformer != null && (reducer = this.reducer) != null) {
                Node p;
                int f;
                int h;
                int r = this.basis;
                int i = this.baseIndex;
                while (this.batch > 0 && (h = (f = this.baseLimit) + i >>> 1) > i) {
                    this.addToPendingCount(1);
                    this.baseLimit = h;
                    this.rights = new MapReduceKeysToIntTask<K, V>(this, this.batch >>>= 1, this.baseLimit, f, this.tab, this.rights, transformer, r, reducer);
                    this.rights.fork();
                }
                while ((p = this.advance()) != null) {
                    r = reducer.applyAsInt(r, transformer.applyAsInt(p.key));
                }
                this.result = r;
                for (CountedCompleter<?> c = this.firstComplete(); c != null; c = c.nextComplete()) {
                    MapReduceKeysToIntTask t = (MapReduceKeysToIntTask)c;
                    MapReduceKeysToIntTask<K, V> s = t.rights;
                    while (s != null) {
                        t.result = reducer.applyAsInt(t.result, s.result);
                        s = t.rights = s.nextRight;
                    }
                }
            }
        }
    }

    static final class MapReduceMappingsToLongTask<K, V>
    extends BulkTask<K, V, Long> {
        final ToLongBiFunction<? super K, ? super V> transformer;
        final LongBinaryOperator reducer;
        final long basis;
        long result;
        MapReduceMappingsToLongTask<K, V> rights;
        MapReduceMappingsToLongTask<K, V> nextRight;

        MapReduceMappingsToLongTask(BulkTask<K, V, ?> p, int b, int i, int f, Node<K, V>[] t, MapReduceMappingsToLongTask<K, V> nextRight, ToLongBiFunction<? super K, ? super V> transformer, long basis, LongBinaryOperator reducer) {
            super(p, b, i, f, t);
            this.nextRight = nextRight;
            this.transformer = transformer;
            this.basis = basis;
            this.reducer = reducer;
        }

        @Override
        public final Long getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            LongBinaryOperator reducer;
            ToLongBiFunction<K, V> transformer = this.transformer;
            if (transformer != null && (reducer = this.reducer) != null) {
                Node p;
                int f;
                int h;
                long r = this.basis;
                int i = this.baseIndex;
                while (this.batch > 0 && (h = (f = this.baseLimit) + i >>> 1) > i) {
                    this.addToPendingCount(1);
                    this.baseLimit = h;
                    this.rights = new MapReduceMappingsToLongTask<K, V>(this, this.batch >>>= 1, this.baseLimit, f, this.tab, this.rights, transformer, r, reducer);
                    this.rights.fork();
                }
                while ((p = this.advance()) != null) {
                    r = reducer.applyAsLong(r, transformer.applyAsLong(p.key, p.val));
                }
                this.result = r;
                for (CountedCompleter<?> c = this.firstComplete(); c != null; c = c.nextComplete()) {
                    MapReduceMappingsToLongTask t = (MapReduceMappingsToLongTask)c;
                    MapReduceMappingsToLongTask<K, V> s = t.rights;
                    while (s != null) {
                        t.result = reducer.applyAsLong(t.result, s.result);
                        s = t.rights = s.nextRight;
                    }
                }
            }
        }
    }

    static final class MapReduceEntriesToLongTask<K, V>
    extends BulkTask<K, V, Long> {
        final ToLongFunction<Map.Entry<K, V>> transformer;
        final LongBinaryOperator reducer;
        final long basis;
        long result;
        MapReduceEntriesToLongTask<K, V> rights;
        MapReduceEntriesToLongTask<K, V> nextRight;

        MapReduceEntriesToLongTask(BulkTask<K, V, ?> p, int b, int i, int f, Node<K, V>[] t, MapReduceEntriesToLongTask<K, V> nextRight, ToLongFunction<Map.Entry<K, V>> transformer, long basis, LongBinaryOperator reducer) {
            super(p, b, i, f, t);
            this.nextRight = nextRight;
            this.transformer = transformer;
            this.basis = basis;
            this.reducer = reducer;
        }

        @Override
        public final Long getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            LongBinaryOperator reducer;
            ToLongFunction<Map.Entry<K, V>> transformer = this.transformer;
            if (transformer != null && (reducer = this.reducer) != null) {
                Node p;
                int f;
                int h;
                long r = this.basis;
                int i = this.baseIndex;
                while (this.batch > 0 && (h = (f = this.baseLimit) + i >>> 1) > i) {
                    this.addToPendingCount(1);
                    this.baseLimit = h;
                    this.rights = new MapReduceEntriesToLongTask<K, V>(this, this.batch >>>= 1, this.baseLimit, f, this.tab, this.rights, transformer, r, reducer);
                    this.rights.fork();
                }
                while ((p = this.advance()) != null) {
                    r = reducer.applyAsLong(r, transformer.applyAsLong(p));
                }
                this.result = r;
                for (CountedCompleter<?> c = this.firstComplete(); c != null; c = c.nextComplete()) {
                    MapReduceEntriesToLongTask t = (MapReduceEntriesToLongTask)c;
                    MapReduceEntriesToLongTask<K, V> s = t.rights;
                    while (s != null) {
                        t.result = reducer.applyAsLong(t.result, s.result);
                        s = t.rights = s.nextRight;
                    }
                }
            }
        }
    }

    static final class MapReduceValuesToLongTask<K, V>
    extends BulkTask<K, V, Long> {
        final ToLongFunction<? super V> transformer;
        final LongBinaryOperator reducer;
        final long basis;
        long result;
        MapReduceValuesToLongTask<K, V> rights;
        MapReduceValuesToLongTask<K, V> nextRight;

        MapReduceValuesToLongTask(BulkTask<K, V, ?> p, int b, int i, int f, Node<K, V>[] t, MapReduceValuesToLongTask<K, V> nextRight, ToLongFunction<? super V> transformer, long basis, LongBinaryOperator reducer) {
            super(p, b, i, f, t);
            this.nextRight = nextRight;
            this.transformer = transformer;
            this.basis = basis;
            this.reducer = reducer;
        }

        @Override
        public final Long getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            LongBinaryOperator reducer;
            ToLongFunction<V> transformer = this.transformer;
            if (transformer != null && (reducer = this.reducer) != null) {
                Node p;
                int f;
                int h;
                long r = this.basis;
                int i = this.baseIndex;
                while (this.batch > 0 && (h = (f = this.baseLimit) + i >>> 1) > i) {
                    this.addToPendingCount(1);
                    this.baseLimit = h;
                    this.rights = new MapReduceValuesToLongTask<K, V>(this, this.batch >>>= 1, this.baseLimit, f, this.tab, this.rights, transformer, r, reducer);
                    this.rights.fork();
                }
                while ((p = this.advance()) != null) {
                    r = reducer.applyAsLong(r, transformer.applyAsLong(p.val));
                }
                this.result = r;
                for (CountedCompleter<?> c = this.firstComplete(); c != null; c = c.nextComplete()) {
                    MapReduceValuesToLongTask t = (MapReduceValuesToLongTask)c;
                    MapReduceValuesToLongTask<K, V> s = t.rights;
                    while (s != null) {
                        t.result = reducer.applyAsLong(t.result, s.result);
                        s = t.rights = s.nextRight;
                    }
                }
            }
        }
    }

    static final class MapReduceKeysToLongTask<K, V>
    extends BulkTask<K, V, Long> {
        final ToLongFunction<? super K> transformer;
        final LongBinaryOperator reducer;
        final long basis;
        long result;
        MapReduceKeysToLongTask<K, V> rights;
        MapReduceKeysToLongTask<K, V> nextRight;

        MapReduceKeysToLongTask(BulkTask<K, V, ?> p, int b, int i, int f, Node<K, V>[] t, MapReduceKeysToLongTask<K, V> nextRight, ToLongFunction<? super K> transformer, long basis, LongBinaryOperator reducer) {
            super(p, b, i, f, t);
            this.nextRight = nextRight;
            this.transformer = transformer;
            this.basis = basis;
            this.reducer = reducer;
        }

        @Override
        public final Long getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            LongBinaryOperator reducer;
            ToLongFunction<K> transformer = this.transformer;
            if (transformer != null && (reducer = this.reducer) != null) {
                Node p;
                int f;
                int h;
                long r = this.basis;
                int i = this.baseIndex;
                while (this.batch > 0 && (h = (f = this.baseLimit) + i >>> 1) > i) {
                    this.addToPendingCount(1);
                    this.baseLimit = h;
                    this.rights = new MapReduceKeysToLongTask<K, V>(this, this.batch >>>= 1, this.baseLimit, f, this.tab, this.rights, transformer, r, reducer);
                    this.rights.fork();
                }
                while ((p = this.advance()) != null) {
                    r = reducer.applyAsLong(r, transformer.applyAsLong(p.key));
                }
                this.result = r;
                for (CountedCompleter<?> c = this.firstComplete(); c != null; c = c.nextComplete()) {
                    MapReduceKeysToLongTask t = (MapReduceKeysToLongTask)c;
                    MapReduceKeysToLongTask<K, V> s = t.rights;
                    while (s != null) {
                        t.result = reducer.applyAsLong(t.result, s.result);
                        s = t.rights = s.nextRight;
                    }
                }
            }
        }
    }

    static final class MapReduceMappingsToDoubleTask<K, V>
    extends BulkTask<K, V, Double> {
        final ToDoubleBiFunction<? super K, ? super V> transformer;
        final DoubleBinaryOperator reducer;
        final double basis;
        double result;
        MapReduceMappingsToDoubleTask<K, V> rights;
        MapReduceMappingsToDoubleTask<K, V> nextRight;

        MapReduceMappingsToDoubleTask(BulkTask<K, V, ?> p, int b, int i, int f, Node<K, V>[] t, MapReduceMappingsToDoubleTask<K, V> nextRight, ToDoubleBiFunction<? super K, ? super V> transformer, double basis, DoubleBinaryOperator reducer) {
            super(p, b, i, f, t);
            this.nextRight = nextRight;
            this.transformer = transformer;
            this.basis = basis;
            this.reducer = reducer;
        }

        @Override
        public final Double getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            DoubleBinaryOperator reducer;
            ToDoubleBiFunction<K, V> transformer = this.transformer;
            if (transformer != null && (reducer = this.reducer) != null) {
                Node p;
                int f;
                int h;
                double r = this.basis;
                int i = this.baseIndex;
                while (this.batch > 0 && (h = (f = this.baseLimit) + i >>> 1) > i) {
                    this.addToPendingCount(1);
                    this.baseLimit = h;
                    this.rights = new MapReduceMappingsToDoubleTask<K, V>(this, this.batch >>>= 1, this.baseLimit, f, this.tab, this.rights, transformer, r, reducer);
                    this.rights.fork();
                }
                while ((p = this.advance()) != null) {
                    r = reducer.applyAsDouble(r, transformer.applyAsDouble(p.key, p.val));
                }
                this.result = r;
                for (CountedCompleter<?> c = this.firstComplete(); c != null; c = c.nextComplete()) {
                    MapReduceMappingsToDoubleTask t = (MapReduceMappingsToDoubleTask)c;
                    MapReduceMappingsToDoubleTask<K, V> s = t.rights;
                    while (s != null) {
                        t.result = reducer.applyAsDouble(t.result, s.result);
                        s = t.rights = s.nextRight;
                    }
                }
            }
        }
    }

    static final class MapReduceEntriesToDoubleTask<K, V>
    extends BulkTask<K, V, Double> {
        final ToDoubleFunction<Map.Entry<K, V>> transformer;
        final DoubleBinaryOperator reducer;
        final double basis;
        double result;
        MapReduceEntriesToDoubleTask<K, V> rights;
        MapReduceEntriesToDoubleTask<K, V> nextRight;

        MapReduceEntriesToDoubleTask(BulkTask<K, V, ?> p, int b, int i, int f, Node<K, V>[] t, MapReduceEntriesToDoubleTask<K, V> nextRight, ToDoubleFunction<Map.Entry<K, V>> transformer, double basis, DoubleBinaryOperator reducer) {
            super(p, b, i, f, t);
            this.nextRight = nextRight;
            this.transformer = transformer;
            this.basis = basis;
            this.reducer = reducer;
        }

        @Override
        public final Double getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            DoubleBinaryOperator reducer;
            ToDoubleFunction<Map.Entry<K, V>> transformer = this.transformer;
            if (transformer != null && (reducer = this.reducer) != null) {
                Node p;
                int f;
                int h;
                double r = this.basis;
                int i = this.baseIndex;
                while (this.batch > 0 && (h = (f = this.baseLimit) + i >>> 1) > i) {
                    this.addToPendingCount(1);
                    this.baseLimit = h;
                    this.rights = new MapReduceEntriesToDoubleTask<K, V>(this, this.batch >>>= 1, this.baseLimit, f, this.tab, this.rights, transformer, r, reducer);
                    this.rights.fork();
                }
                while ((p = this.advance()) != null) {
                    r = reducer.applyAsDouble(r, transformer.applyAsDouble(p));
                }
                this.result = r;
                for (CountedCompleter<?> c = this.firstComplete(); c != null; c = c.nextComplete()) {
                    MapReduceEntriesToDoubleTask t = (MapReduceEntriesToDoubleTask)c;
                    MapReduceEntriesToDoubleTask<K, V> s = t.rights;
                    while (s != null) {
                        t.result = reducer.applyAsDouble(t.result, s.result);
                        s = t.rights = s.nextRight;
                    }
                }
            }
        }
    }

    static final class MapReduceValuesToDoubleTask<K, V>
    extends BulkTask<K, V, Double> {
        final ToDoubleFunction<? super V> transformer;
        final DoubleBinaryOperator reducer;
        final double basis;
        double result;
        MapReduceValuesToDoubleTask<K, V> rights;
        MapReduceValuesToDoubleTask<K, V> nextRight;

        MapReduceValuesToDoubleTask(BulkTask<K, V, ?> p, int b, int i, int f, Node<K, V>[] t, MapReduceValuesToDoubleTask<K, V> nextRight, ToDoubleFunction<? super V> transformer, double basis, DoubleBinaryOperator reducer) {
            super(p, b, i, f, t);
            this.nextRight = nextRight;
            this.transformer = transformer;
            this.basis = basis;
            this.reducer = reducer;
        }

        @Override
        public final Double getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            DoubleBinaryOperator reducer;
            ToDoubleFunction<V> transformer = this.transformer;
            if (transformer != null && (reducer = this.reducer) != null) {
                Node p;
                int f;
                int h;
                double r = this.basis;
                int i = this.baseIndex;
                while (this.batch > 0 && (h = (f = this.baseLimit) + i >>> 1) > i) {
                    this.addToPendingCount(1);
                    this.baseLimit = h;
                    this.rights = new MapReduceValuesToDoubleTask<K, V>(this, this.batch >>>= 1, this.baseLimit, f, this.tab, this.rights, transformer, r, reducer);
                    this.rights.fork();
                }
                while ((p = this.advance()) != null) {
                    r = reducer.applyAsDouble(r, transformer.applyAsDouble(p.val));
                }
                this.result = r;
                for (CountedCompleter<?> c = this.firstComplete(); c != null; c = c.nextComplete()) {
                    MapReduceValuesToDoubleTask t = (MapReduceValuesToDoubleTask)c;
                    MapReduceValuesToDoubleTask<K, V> s = t.rights;
                    while (s != null) {
                        t.result = reducer.applyAsDouble(t.result, s.result);
                        s = t.rights = s.nextRight;
                    }
                }
            }
        }
    }

    static final class MapReduceKeysToDoubleTask<K, V>
    extends BulkTask<K, V, Double> {
        final ToDoubleFunction<? super K> transformer;
        final DoubleBinaryOperator reducer;
        final double basis;
        double result;
        MapReduceKeysToDoubleTask<K, V> rights;
        MapReduceKeysToDoubleTask<K, V> nextRight;

        MapReduceKeysToDoubleTask(BulkTask<K, V, ?> p, int b, int i, int f, Node<K, V>[] t, MapReduceKeysToDoubleTask<K, V> nextRight, ToDoubleFunction<? super K> transformer, double basis, DoubleBinaryOperator reducer) {
            super(p, b, i, f, t);
            this.nextRight = nextRight;
            this.transformer = transformer;
            this.basis = basis;
            this.reducer = reducer;
        }

        @Override
        public final Double getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            DoubleBinaryOperator reducer;
            ToDoubleFunction<K> transformer = this.transformer;
            if (transformer != null && (reducer = this.reducer) != null) {
                Node p;
                int f;
                int h;
                double r = this.basis;
                int i = this.baseIndex;
                while (this.batch > 0 && (h = (f = this.baseLimit) + i >>> 1) > i) {
                    this.addToPendingCount(1);
                    this.baseLimit = h;
                    this.rights = new MapReduceKeysToDoubleTask<K, V>(this, this.batch >>>= 1, this.baseLimit, f, this.tab, this.rights, transformer, r, reducer);
                    this.rights.fork();
                }
                while ((p = this.advance()) != null) {
                    r = reducer.applyAsDouble(r, transformer.applyAsDouble(p.key));
                }
                this.result = r;
                for (CountedCompleter<?> c = this.firstComplete(); c != null; c = c.nextComplete()) {
                    MapReduceKeysToDoubleTask t = (MapReduceKeysToDoubleTask)c;
                    MapReduceKeysToDoubleTask<K, V> s = t.rights;
                    while (s != null) {
                        t.result = reducer.applyAsDouble(t.result, s.result);
                        s = t.rights = s.nextRight;
                    }
                }
            }
        }
    }

    static final class MapReduceMappingsTask<K, V, U>
    extends BulkTask<K, V, U> {
        final BiFunction<? super K, ? super V, ? extends U> transformer;
        final BiFunction<? super U, ? super U, ? extends U> reducer;
        U result;
        MapReduceMappingsTask<K, V, U> rights;
        MapReduceMappingsTask<K, V, U> nextRight;

        MapReduceMappingsTask(BulkTask<K, V, ?> p, int b, int i, int f, Node<K, V>[] t, MapReduceMappingsTask<K, V, U> nextRight, BiFunction<? super K, ? super V, ? extends U> transformer, BiFunction<? super U, ? super U, ? extends U> reducer) {
            super(p, b, i, f, t);
            this.nextRight = nextRight;
            this.transformer = transformer;
            this.reducer = reducer;
        }

        @Override
        public final U getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            BiFunction<U, U, U> reducer;
            BiFunction transformer = this.transformer;
            if (transformer != null && (reducer = this.reducer) != null) {
                Node p;
                int f;
                int h;
                int i = this.baseIndex;
                while (this.batch > 0 && (h = (f = this.baseLimit) + i >>> 1) > i) {
                    this.addToPendingCount(1);
                    this.baseLimit = h;
                    this.rights = new MapReduceMappingsTask<K, V, U>(this, this.batch >>>= 1, this.baseLimit, f, this.tab, this.rights, transformer, reducer);
                    this.rights.fork();
                }
                Object r = null;
                while ((p = this.advance()) != null) {
                    U u;
                    Object val = p.val;
                    if (val == NULL_VALUE || (u = transformer.apply(p.key, val)) == null) continue;
                    r = r == null ? u : reducer.apply(r, u);
                }
                this.result = r;
                for (CountedCompleter<?> c = this.firstComplete(); c != null; c = c.nextComplete()) {
                    MapReduceMappingsTask t = (MapReduceMappingsTask)c;
                    MapReduceMappingsTask<K, V, U> s = t.rights;
                    while (s != null) {
                        U sr = s.result;
                        if (sr != null) {
                            U tr = t.result;
                            t.result = tr == null ? sr : reducer.apply(tr, sr);
                        }
                        s = t.rights = s.nextRight;
                    }
                }
            }
        }
    }

    static final class MapReduceEntriesTask<K, V, U>
    extends BulkTask<K, V, U> {
        final Function<Map.Entry<K, V>, ? extends U> transformer;
        final BiFunction<? super U, ? super U, ? extends U> reducer;
        U result;
        MapReduceEntriesTask<K, V, U> rights;
        MapReduceEntriesTask<K, V, U> nextRight;

        MapReduceEntriesTask(BulkTask<K, V, ?> p, int b, int i, int f, Node<K, V>[] t, MapReduceEntriesTask<K, V, U> nextRight, Function<Map.Entry<K, V>, ? extends U> transformer, BiFunction<? super U, ? super U, ? extends U> reducer) {
            super(p, b, i, f, t);
            this.nextRight = nextRight;
            this.transformer = transformer;
            this.reducer = reducer;
        }

        @Override
        public final U getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            BiFunction<U, U, U> reducer;
            Function<Map.Entry<K, V>, U> transformer = this.transformer;
            if (transformer != null && (reducer = this.reducer) != null) {
                Node p;
                int f;
                int h;
                int i = this.baseIndex;
                while (this.batch > 0 && (h = (f = this.baseLimit) + i >>> 1) > i) {
                    this.addToPendingCount(1);
                    this.baseLimit = h;
                    this.rights = new MapReduceEntriesTask<K, V, U>(this, this.batch >>>= 1, this.baseLimit, f, this.tab, this.rights, transformer, reducer);
                    this.rights.fork();
                }
                Object r = null;
                while ((p = this.advance()) != null) {
                    U u = transformer.apply(p);
                    if (u == null) continue;
                    r = r == null ? u : reducer.apply(r, u);
                }
                this.result = r;
                for (CountedCompleter<?> c = this.firstComplete(); c != null; c = c.nextComplete()) {
                    MapReduceEntriesTask t = (MapReduceEntriesTask)c;
                    MapReduceEntriesTask<K, V, U> s = t.rights;
                    while (s != null) {
                        U sr = s.result;
                        if (sr != null) {
                            U tr = t.result;
                            t.result = tr == null ? sr : reducer.apply(tr, sr);
                        }
                        s = t.rights = s.nextRight;
                    }
                }
            }
        }
    }

    static final class MapReduceValuesTask<K, V, U>
    extends BulkTask<K, V, U> {
        final Function<? super V, ? extends U> transformer;
        final BiFunction<? super U, ? super U, ? extends U> reducer;
        U result;
        MapReduceValuesTask<K, V, U> rights;
        MapReduceValuesTask<K, V, U> nextRight;

        MapReduceValuesTask(BulkTask<K, V, ?> p, int b, int i, int f, Node<K, V>[] t, MapReduceValuesTask<K, V, U> nextRight, Function<? super V, ? extends U> transformer, BiFunction<? super U, ? super U, ? extends U> reducer) {
            super(p, b, i, f, t);
            this.nextRight = nextRight;
            this.transformer = transformer;
            this.reducer = reducer;
        }

        @Override
        public final U getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            BiFunction<U, U, U> reducer;
            Function<V, U> transformer = this.transformer;
            if (transformer != null && (reducer = this.reducer) != null) {
                Node p;
                int f;
                int h;
                int i = this.baseIndex;
                while (this.batch > 0 && (h = (f = this.baseLimit) + i >>> 1) > i) {
                    this.addToPendingCount(1);
                    this.baseLimit = h;
                    this.rights = new MapReduceValuesTask<K, V, U>(this, this.batch >>>= 1, this.baseLimit, f, this.tab, this.rights, transformer, reducer);
                    this.rights.fork();
                }
                Object r = null;
                while ((p = this.advance()) != null) {
                    U u = transformer.apply(p.val);
                    if (u == null) continue;
                    r = r == null ? u : reducer.apply(r, u);
                }
                this.result = r;
                for (CountedCompleter<?> c = this.firstComplete(); c != null; c = c.nextComplete()) {
                    MapReduceValuesTask t = (MapReduceValuesTask)c;
                    MapReduceValuesTask<K, V, U> s = t.rights;
                    while (s != null) {
                        U sr = s.result;
                        if (sr != null) {
                            U tr = t.result;
                            t.result = tr == null ? sr : reducer.apply(tr, sr);
                        }
                        s = t.rights = s.nextRight;
                    }
                }
            }
        }
    }

    static final class MapReduceKeysTask<K, V, U>
    extends BulkTask<K, V, U> {
        final Function<? super K, ? extends U> transformer;
        final BiFunction<? super U, ? super U, ? extends U> reducer;
        U result;
        MapReduceKeysTask<K, V, U> rights;
        MapReduceKeysTask<K, V, U> nextRight;

        MapReduceKeysTask(BulkTask<K, V, ?> p, int b, int i, int f, Node<K, V>[] t, MapReduceKeysTask<K, V, U> nextRight, Function<? super K, ? extends U> transformer, BiFunction<? super U, ? super U, ? extends U> reducer) {
            super(p, b, i, f, t);
            this.nextRight = nextRight;
            this.transformer = transformer;
            this.reducer = reducer;
        }

        @Override
        public final U getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            BiFunction<U, U, U> reducer;
            Function<K, U> transformer = this.transformer;
            if (transformer != null && (reducer = this.reducer) != null) {
                Node p;
                int f;
                int h;
                int i = this.baseIndex;
                while (this.batch > 0 && (h = (f = this.baseLimit) + i >>> 1) > i) {
                    this.addToPendingCount(1);
                    this.baseLimit = h;
                    this.rights = new MapReduceKeysTask<K, V, U>(this, this.batch >>>= 1, this.baseLimit, f, this.tab, this.rights, transformer, reducer);
                    this.rights.fork();
                }
                Object r = null;
                while ((p = this.advance()) != null) {
                    U u = transformer.apply(p.key);
                    if (u == null) continue;
                    r = r == null ? u : reducer.apply(r, u);
                }
                this.result = r;
                for (CountedCompleter<?> c = this.firstComplete(); c != null; c = c.nextComplete()) {
                    MapReduceKeysTask t = (MapReduceKeysTask)c;
                    MapReduceKeysTask<K, V, U> s = t.rights;
                    while (s != null) {
                        U sr = s.result;
                        if (sr != null) {
                            U tr = t.result;
                            t.result = tr == null ? sr : reducer.apply(tr, sr);
                        }
                        s = t.rights = s.nextRight;
                    }
                }
            }
        }
    }

    static final class ReduceEntriesTask<K, V>
    extends BulkTask<K, V, Map.Entry<K, V>> {
        final BiFunction<Map.Entry<K, V>, Map.Entry<K, V>, ? extends Map.Entry<K, V>> reducer;
        Map.Entry<K, V> result;
        ReduceEntriesTask<K, V> rights;
        ReduceEntriesTask<K, V> nextRight;

        ReduceEntriesTask(BulkTask<K, V, ?> p, int b, int i, int f, Node<K, V>[] t, ReduceEntriesTask<K, V> nextRight, BiFunction<Map.Entry<K, V>, Map.Entry<K, V>, ? extends Map.Entry<K, V>> reducer) {
            super(p, b, i, f, t);
            this.nextRight = nextRight;
            this.reducer = reducer;
        }

        @Override
        public final Map.Entry<K, V> getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            BiFunction<Map.Entry<K, V>, Map.Entry<K, V>, Map.Entry<K, V>> reducer = this.reducer;
            if (reducer != null) {
                Node p;
                int f;
                int h;
                int i = this.baseIndex;
                while (this.batch > 0 && (h = (f = this.baseLimit) + i >>> 1) > i) {
                    this.addToPendingCount(1);
                    this.baseLimit = h;
                    this.rights = new ReduceEntriesTask<K, V>(this, this.batch >>>= 1, this.baseLimit, f, this.tab, this.rights, reducer);
                    this.rights.fork();
                }
                Node r = null;
                while ((p = this.advance()) != null) {
                    r = r == null ? p : reducer.apply(r, p);
                }
                this.result = r;
                for (CountedCompleter<?> c = this.firstComplete(); c != null; c = c.nextComplete()) {
                    ReduceEntriesTask t = (ReduceEntriesTask)c;
                    ReduceEntriesTask<K, V> s = t.rights;
                    while (s != null) {
                        Map.Entry<K, V> sr = s.result;
                        if (sr != null) {
                            Map.Entry<K, V> tr = t.result;
                            t.result = tr == null ? sr : reducer.apply(tr, sr);
                        }
                        s = t.rights = s.nextRight;
                    }
                }
            }
        }
    }

    static final class ReduceValuesTask<K, V>
    extends BulkTask<K, V, V> {
        final BiFunction<? super V, ? super V, ? extends V> reducer;
        V result;
        ReduceValuesTask<K, V> rights;
        ReduceValuesTask<K, V> nextRight;

        ReduceValuesTask(BulkTask<K, V, ?> p, int b, int i, int f, Node<K, V>[] t, ReduceValuesTask<K, V> nextRight, BiFunction<? super V, ? super V, ? extends V> reducer) {
            super(p, b, i, f, t);
            this.nextRight = nextRight;
            this.reducer = reducer;
        }

        @Override
        public final V getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            BiFunction<V, V, V> reducer = this.reducer;
            if (reducer != null) {
                Node p;
                int f;
                int h;
                int i = this.baseIndex;
                while (this.batch > 0 && (h = (f = this.baseLimit) + i >>> 1) > i) {
                    this.addToPendingCount(1);
                    this.baseLimit = h;
                    this.rights = new ReduceValuesTask<K, V>(this, this.batch >>>= 1, this.baseLimit, f, this.tab, this.rights, reducer);
                    this.rights.fork();
                }
                Object r = null;
                while ((p = this.advance()) != null) {
                    Object v = p.val;
                    r = r == null ? v : reducer.apply(r, v);
                }
                this.result = r;
                for (CountedCompleter<?> c = this.firstComplete(); c != null; c = c.nextComplete()) {
                    ReduceValuesTask t = (ReduceValuesTask)c;
                    ReduceValuesTask<K, V> s = t.rights;
                    while (s != null) {
                        V sr = s.result;
                        if (sr != null) {
                            V tr = t.result;
                            t.result = tr == null ? sr : reducer.apply(tr, sr);
                        }
                        s = t.rights = s.nextRight;
                    }
                }
            }
        }
    }

    static final class ReduceKeysTask<K, V>
    extends BulkTask<K, V, K> {
        final BiFunction<? super K, ? super K, ? extends K> reducer;
        K result;
        ReduceKeysTask<K, V> rights;
        ReduceKeysTask<K, V> nextRight;

        ReduceKeysTask(BulkTask<K, V, ?> p, int b, int i, int f, Node<K, V>[] t, ReduceKeysTask<K, V> nextRight, BiFunction<? super K, ? super K, ? extends K> reducer) {
            super(p, b, i, f, t);
            this.nextRight = nextRight;
            this.reducer = reducer;
        }

        @Override
        public final K getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            BiFunction<K, K, K> reducer = this.reducer;
            if (reducer != null) {
                Node p;
                int f;
                int h;
                int i = this.baseIndex;
                while (this.batch > 0 && (h = (f = this.baseLimit) + i >>> 1) > i) {
                    this.addToPendingCount(1);
                    this.baseLimit = h;
                    this.rights = new ReduceKeysTask<K, V>(this, this.batch >>>= 1, this.baseLimit, f, this.tab, this.rights, reducer);
                    this.rights.fork();
                }
                Object r = null;
                while ((p = this.advance()) != null) {
                    Object u = p.key;
                    r = r == null ? u : (u == null ? r : reducer.apply(r, u));
                }
                this.result = r;
                for (CountedCompleter<?> c = this.firstComplete(); c != null; c = c.nextComplete()) {
                    ReduceKeysTask t = (ReduceKeysTask)c;
                    ReduceKeysTask<K, V> s = t.rights;
                    while (s != null) {
                        K sr = s.result;
                        if (sr != null) {
                            K tr = t.result;
                            t.result = tr == null ? sr : reducer.apply(tr, sr);
                        }
                        s = t.rights = s.nextRight;
                    }
                }
            }
        }
    }

    static final class SearchMappingsTask<K, V, U>
    extends BulkTask<K, V, U> {
        final BiFunction<? super K, ? super V, ? extends U> searchFunction;
        final AtomicReference<U> result;

        SearchMappingsTask(BulkTask<K, V, ?> p, int b, int i, int f, Node<K, V>[] t, BiFunction<? super K, ? super V, ? extends U> searchFunction, AtomicReference<U> result) {
            super(p, b, i, f, t);
            this.searchFunction = searchFunction;
            this.result = result;
        }

        @Override
        public final U getRawResult() {
            return this.result.get();
        }

        @Override
        public final void compute() {
            AtomicReference<U> result;
            BiFunction searchFunction = this.searchFunction;
            if (searchFunction != null && (result = this.result) != null) {
                int f;
                int h;
                int i = this.baseIndex;
                while (this.batch > 0 && (h = (f = this.baseLimit) + i >>> 1) > i) {
                    if (result.get() != null) {
                        return;
                    }
                    this.addToPendingCount(1);
                    this.baseLimit = h;
                    new SearchMappingsTask<K, V, U>(this, this.batch >>>= 1, this.baseLimit, f, this.tab, searchFunction, result).fork();
                }
                while (result.get() == null) {
                    Node p = this.advance();
                    if (p == null) {
                        this.propagateCompletion();
                        break;
                    }
                    U u = searchFunction.apply(p.key, p.val);
                    if (u == null) continue;
                    if (!result.compareAndSet(null, u)) break;
                    this.quietlyCompleteRoot();
                    break;
                }
            }
        }
    }

    static final class SearchEntriesTask<K, V, U>
    extends BulkTask<K, V, U> {
        final Function<Map.Entry<K, V>, ? extends U> searchFunction;
        final AtomicReference<U> result;

        SearchEntriesTask(BulkTask<K, V, ?> p, int b, int i, int f, Node<K, V>[] t, Function<Map.Entry<K, V>, ? extends U> searchFunction, AtomicReference<U> result) {
            super(p, b, i, f, t);
            this.searchFunction = searchFunction;
            this.result = result;
        }

        @Override
        public final U getRawResult() {
            return this.result.get();
        }

        @Override
        public final void compute() {
            AtomicReference<U> result;
            Function<Map.Entry<K, V>, U> searchFunction = this.searchFunction;
            if (searchFunction != null && (result = this.result) != null) {
                int f;
                int h;
                int i = this.baseIndex;
                while (this.batch > 0 && (h = (f = this.baseLimit) + i >>> 1) > i) {
                    if (result.get() != null) {
                        return;
                    }
                    this.addToPendingCount(1);
                    this.baseLimit = h;
                    new SearchEntriesTask<K, V, U>(this, this.batch >>>= 1, this.baseLimit, f, this.tab, searchFunction, result).fork();
                }
                while (result.get() == null) {
                    Node p = this.advance();
                    if (p == null) {
                        this.propagateCompletion();
                        break;
                    }
                    U u = searchFunction.apply(p);
                    if (u == null) continue;
                    if (result.compareAndSet(null, u)) {
                        this.quietlyCompleteRoot();
                    }
                    return;
                }
            }
        }
    }

    static final class SearchValuesTask<K, V, U>
    extends BulkTask<K, V, U> {
        final Function<? super V, ? extends U> searchFunction;
        final AtomicReference<U> result;

        SearchValuesTask(BulkTask<K, V, ?> p, int b, int i, int f, Node<K, V>[] t, Function<? super V, ? extends U> searchFunction, AtomicReference<U> result) {
            super(p, b, i, f, t);
            this.searchFunction = searchFunction;
            this.result = result;
        }

        @Override
        public final U getRawResult() {
            return this.result.get();
        }

        @Override
        public final void compute() {
            AtomicReference<U> result;
            Function<V, U> searchFunction = this.searchFunction;
            if (searchFunction != null && (result = this.result) != null) {
                int f;
                int h;
                int i = this.baseIndex;
                while (this.batch > 0 && (h = (f = this.baseLimit) + i >>> 1) > i) {
                    if (result.get() != null) {
                        return;
                    }
                    this.addToPendingCount(1);
                    this.baseLimit = h;
                    new SearchValuesTask<K, V, U>(this, this.batch >>>= 1, this.baseLimit, f, this.tab, searchFunction, result).fork();
                }
                while (result.get() == null) {
                    Node p = this.advance();
                    if (p == null) {
                        this.propagateCompletion();
                        break;
                    }
                    U u = searchFunction.apply(p.val);
                    if (u == null) continue;
                    if (!result.compareAndSet(null, u)) break;
                    this.quietlyCompleteRoot();
                    break;
                }
            }
        }
    }

    static final class SearchKeysTask<K, V, U>
    extends BulkTask<K, V, U> {
        final Function<? super K, ? extends U> searchFunction;
        final AtomicReference<U> result;

        SearchKeysTask(BulkTask<K, V, ?> p, int b, int i, int f, Node<K, V>[] t, Function<? super K, ? extends U> searchFunction, AtomicReference<U> result) {
            super(p, b, i, f, t);
            this.searchFunction = searchFunction;
            this.result = result;
        }

        @Override
        public final U getRawResult() {
            return this.result.get();
        }

        @Override
        public final void compute() {
            AtomicReference<U> result;
            Function<K, U> searchFunction = this.searchFunction;
            if (searchFunction != null && (result = this.result) != null) {
                int f;
                int h;
                int i = this.baseIndex;
                while (this.batch > 0 && (h = (f = this.baseLimit) + i >>> 1) > i) {
                    if (result.get() != null) {
                        return;
                    }
                    this.addToPendingCount(1);
                    this.baseLimit = h;
                    new SearchKeysTask<K, V, U>(this, this.batch >>>= 1, this.baseLimit, f, this.tab, searchFunction, result).fork();
                }
                while (result.get() == null) {
                    Node p = this.advance();
                    if (p == null) {
                        this.propagateCompletion();
                        break;
                    }
                    U u = searchFunction.apply(p.key);
                    if (u == null) continue;
                    if (!result.compareAndSet(null, u)) break;
                    this.quietlyCompleteRoot();
                    break;
                }
            }
        }
    }

    static final class ForEachTransformedMappingTask<K, V, U>
    extends BulkTask<K, V, Void> {
        final BiFunction<? super K, ? super V, ? extends U> transformer;
        final Consumer<? super U> action;

        ForEachTransformedMappingTask(BulkTask<K, V, ?> p, int b, int i, int f, Node<K, V>[] t, BiFunction<? super K, ? super V, ? extends U> transformer, Consumer<? super U> action) {
            super(p, b, i, f, t);
            this.transformer = transformer;
            this.action = action;
        }

        @Override
        public final void compute() {
            Consumer<U> action;
            BiFunction transformer = this.transformer;
            if (transformer != null && (action = this.action) != null) {
                Node p;
                int f;
                int h;
                int i = this.baseIndex;
                while (this.batch > 0 && (h = (f = this.baseLimit) + i >>> 1) > i) {
                    this.addToPendingCount(1);
                    this.baseLimit = h;
                    new ForEachTransformedMappingTask<K, V, U>(this, this.batch >>>= 1, this.baseLimit, f, this.tab, transformer, action).fork();
                }
                while ((p = this.advance()) != null) {
                    U u;
                    Object val = p.val;
                    if (val == null || val == NULL_VALUE || (u = transformer.apply(p.key, val)) == null) continue;
                    action.accept(u);
                }
                this.propagateCompletion();
            }
        }
    }

    static final class ForEachTransformedEntryTask<K, V, U>
    extends BulkTask<K, V, Void> {
        final Function<Map.Entry<K, V>, ? extends U> transformer;
        final Consumer<? super U> action;

        ForEachTransformedEntryTask(BulkTask<K, V, ?> p, int b, int i, int f, Node<K, V>[] t, Function<Map.Entry<K, V>, ? extends U> transformer, Consumer<? super U> action) {
            super(p, b, i, f, t);
            this.transformer = transformer;
            this.action = action;
        }

        @Override
        public final void compute() {
            Consumer<U> action;
            Function<Map.Entry<K, V>, U> transformer = this.transformer;
            if (transformer != null && (action = this.action) != null) {
                Node p;
                int f;
                int h;
                int i = this.baseIndex;
                while (this.batch > 0 && (h = (f = this.baseLimit) + i >>> 1) > i) {
                    this.addToPendingCount(1);
                    this.baseLimit = h;
                    new ForEachTransformedEntryTask<K, V, U>(this, this.batch >>>= 1, this.baseLimit, f, this.tab, transformer, action).fork();
                }
                while ((p = this.advance()) != null) {
                    Node copy;
                    U u;
                    Object val = p.val;
                    if (val == NULL_VALUE || (u = transformer.apply(copy = new Node(p.hash, p.nodeEq, p.key, val, null))) == null) continue;
                    action.accept(u);
                }
                this.propagateCompletion();
            }
        }
    }

    static final class ForEachTransformedValueTask<K, V, U>
    extends BulkTask<K, V, Void> {
        final Function<? super V, ? extends U> transformer;
        final Consumer<? super U> action;

        ForEachTransformedValueTask(BulkTask<K, V, ?> p, int b, int i, int f, Node<K, V>[] t, Function<? super V, ? extends U> transformer, Consumer<? super U> action) {
            super(p, b, i, f, t);
            this.transformer = transformer;
            this.action = action;
        }

        @Override
        public final void compute() {
            Consumer<U> action;
            Function<V, U> transformer = this.transformer;
            if (transformer != null && (action = this.action) != null) {
                Node p;
                int f;
                int h;
                int i = this.baseIndex;
                while (this.batch > 0 && (h = (f = this.baseLimit) + i >>> 1) > i) {
                    this.addToPendingCount(1);
                    this.baseLimit = h;
                    new ForEachTransformedValueTask<K, V, U>(this, this.batch >>>= 1, this.baseLimit, f, this.tab, transformer, action).fork();
                }
                while ((p = this.advance()) != null) {
                    U u;
                    Object val = p.val;
                    if (val == NULL_VALUE || (u = transformer.apply(val)) == null) continue;
                    action.accept(u);
                }
                this.propagateCompletion();
            }
        }
    }

    static final class ForEachTransformedKeyTask<K, V, U>
    extends BulkTask<K, V, Void> {
        final Function<? super K, ? extends U> transformer;
        final Consumer<? super U> action;

        ForEachTransformedKeyTask(BulkTask<K, V, ?> p, int b, int i, int f, Node<K, V>[] t, Function<? super K, ? extends U> transformer, Consumer<? super U> action) {
            super(p, b, i, f, t);
            this.transformer = transformer;
            this.action = action;
        }

        @Override
        public final void compute() {
            Consumer<U> action;
            Function<K, U> transformer = this.transformer;
            if (transformer != null && (action = this.action) != null) {
                Node p;
                int f;
                int h;
                int i = this.baseIndex;
                while (this.batch > 0 && (h = (f = this.baseLimit) + i >>> 1) > i) {
                    this.addToPendingCount(1);
                    this.baseLimit = h;
                    new ForEachTransformedKeyTask<K, V, U>(this, this.batch >>>= 1, this.baseLimit, f, this.tab, transformer, action).fork();
                }
                while ((p = this.advance()) != null) {
                    U u;
                    if (p.val == NULL_VALUE || (u = transformer.apply(p.key)) == null) continue;
                    action.accept(u);
                }
                this.propagateCompletion();
            }
        }
    }

    static final class ForEachMappingTask<K, V>
    extends BulkTask<K, V, Void> {
        final BiConsumer<? super K, ? super V> action;

        ForEachMappingTask(BulkTask<K, V, ?> p, int b, int i, int f, Node<K, V>[] t, BiConsumer<? super K, ? super V> action) {
            super(p, b, i, f, t);
            this.action = action;
        }

        @Override
        public final void compute() {
            BiConsumer<K, V> action = this.action;
            if (action != null) {
                Node p;
                int f;
                int h;
                int i = this.baseIndex;
                while (this.batch > 0 && (h = (f = this.baseLimit) + i >>> 1) > i) {
                    this.addToPendingCount(1);
                    this.baseLimit = h;
                    new ForEachMappingTask<K, V>(this, this.batch >>>= 1, this.baseLimit, f, this.tab, action).fork();
                }
                while ((p = this.advance()) != null) {
                    Object val = p.val;
                    if (val == NULL_VALUE) continue;
                    action.accept(p.key, val);
                }
                this.propagateCompletion();
            }
        }
    }

    static final class ForEachEntryTask<K, V>
    extends BulkTask<K, V, Void> {
        final Consumer<? super Map.Entry<K, V>> action;

        ForEachEntryTask(BulkTask<K, V, ?> p, int b, int i, int f, Node<K, V>[] t, Consumer<? super Map.Entry<K, V>> action) {
            super(p, b, i, f, t);
            this.action = action;
        }

        @Override
        public final void compute() {
            Consumer<Map.Entry<K, V>> action = this.action;
            if (action != null) {
                Node p;
                int f;
                int h;
                int i = this.baseIndex;
                while (this.batch > 0 && (h = (f = this.baseLimit) + i >>> 1) > i) {
                    this.addToPendingCount(1);
                    this.baseLimit = h;
                    new ForEachEntryTask<K, V>(this, this.batch >>>= 1, this.baseLimit, f, this.tab, action).fork();
                }
                while ((p = this.advance()) != null) {
                    Object val = p.val;
                    if (val == NULL_VALUE) continue;
                    Node copy = new Node(p.hash, p.nodeEq, p.key, val, null);
                    action.accept(copy);
                }
                this.propagateCompletion();
            }
        }
    }

    static final class ForEachValueTask<K, V>
    extends BulkTask<K, V, Void> {
        final Consumer<? super V> action;

        ForEachValueTask(BulkTask<K, V, ?> p, int b, int i, int f, Node<K, V>[] t, Consumer<? super V> action) {
            super(p, b, i, f, t);
            this.action = action;
        }

        @Override
        public final void compute() {
            Consumer<V> action = this.action;
            if (action != null) {
                Node p;
                int f;
                int h;
                int i = this.baseIndex;
                while (this.batch > 0 && (h = (f = this.baseLimit) + i >>> 1) > i) {
                    this.addToPendingCount(1);
                    this.baseLimit = h;
                    new ForEachValueTask<K, V>(this, this.batch >>>= 1, this.baseLimit, f, this.tab, action).fork();
                }
                while ((p = this.advance()) != null) {
                    Object val = p.val;
                    if (val == NULL_VALUE) continue;
                    action.accept(val);
                }
                this.propagateCompletion();
            }
        }
    }

    static final class ForEachKeyTask<K, V>
    extends BulkTask<K, V, Void> {
        final Consumer<? super K> action;

        ForEachKeyTask(BulkTask<K, V, ?> p, int b, int i, int f, Node<K, V>[] t, Consumer<? super K> action) {
            super(p, b, i, f, t);
            this.action = action;
        }

        @Override
        public final void compute() {
            Consumer<K> action = this.action;
            if (action != null) {
                Node p;
                int f;
                int h;
                int i = this.baseIndex;
                while (this.batch > 0 && (h = (f = this.baseLimit) + i >>> 1) > i) {
                    this.addToPendingCount(1);
                    this.baseLimit = h;
                    new ForEachKeyTask<K, V>(this, this.batch >>>= 1, this.baseLimit, f, this.tab, action).fork();
                }
                while ((p = this.advance()) != null) {
                    if (p.val == NULL_VALUE) continue;
                    action.accept(p.key);
                }
                this.propagateCompletion();
            }
        }
    }

    static abstract class BulkTask<K, V, R>
    extends CountedCompleter<R> {
        private static final long serialVersionUID = -3076449340738586169L;
        Node<K, V>[] tab;
        Node<K, V> next;
        int index;
        int baseIndex;
        int baseLimit;
        final int baseSize;
        int batch;

        BulkTask(BulkTask<K, V, ?> par, int b, int i, int f, Node<K, V>[] t) {
            super(par);
            this.batch = b;
            this.index = this.baseIndex = i;
            this.tab = t;
            if (t == null) {
                this.baseLimit = 0;
                this.baseSize = 0;
            } else if (par == null) {
                this.baseSize = this.baseLimit = t.length;
            } else {
                this.baseLimit = f;
                this.baseSize = par.baseSize;
            }
        }

        final Node<K, V> advance() {
            Node<K, V> e = this.next;
            if (e != null) {
                e = e.next;
            }
            while (true) {
                int n;
                Node<K, V>[] t;
                block9: {
                    block8: {
                        int i;
                        if (e != null) {
                            this.next = e;
                            return this.next;
                        }
                        if (this.baseIndex >= this.baseLimit) break block8;
                        t = this.tab;
                        if (this.tab != null && (n = t.length) > (i = this.index) && i >= 0) break block9;
                    }
                    this.next = null;
                    return null;
                }
                e = BoundedEquivalentConcurrentHashMapV8.tabAt(t, this.index);
                if (e != null && e.hash < 0) {
                    if (e instanceof ForwardingNode) {
                        this.tab = ((ForwardingNode)e).nextTable;
                        e = null;
                        continue;
                    }
                    e = e instanceof TreeBin ? ((TreeBin)e).first : null;
                }
                if ((this.index += this.baseSize) < n) continue;
                this.index = ++this.baseIndex;
            }
        }
    }

    static final class EntrySetView<K, V>
    extends CollectionView<K, V, Map.Entry<K, V>>
    implements Set<Map.Entry<K, V>>,
    Serializable {
        private static final long serialVersionUID = 2249069246763182397L;

        EntrySetView(BoundedEquivalentConcurrentHashMapV8<K, V> map) {
            super(map);
        }

        @Override
        public boolean contains(Object o) {
            Object v;
            Object r;
            Map.Entry e;
            Object k;
            return o instanceof Map.Entry && (k = (e = (Map.Entry)o).getKey()) != null && (r = this.map.get(k)) != null && (v = e.getValue()) != null && (v == r || this.map.valueEq.equals(r, v));
        }

        @Override
        public boolean remove(Object o) {
            Object v;
            Map.Entry e;
            Object k;
            return o instanceof Map.Entry && (k = (e = (Map.Entry)o).getKey()) != null && (v = e.getValue()) != null && this.map.remove(k, v);
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            BoundedEquivalentConcurrentHashMapV8 m = this.map;
            Node<K, V>[] t = m.table;
            int f = m.table == null ? 0 : t.length;
            return new EntryIterator(t, f, 0, f, m);
        }

        @Override
        public boolean add(Map.Entry<K, V> e) {
            return this.map.putVal(e.getKey(), e.getValue(), false) == null;
        }

        @Override
        public boolean addAll(Collection<? extends Map.Entry<K, V>> c) {
            boolean added = false;
            for (Map.Entry<K, V> e : c) {
                if (!this.add(e)) continue;
                added = true;
            }
            return added;
        }

        @Override
        public final int hashCode() {
            int h = 0;
            Node<K, V>[] t = this.map.table;
            if (this.map.table != null) {
                Node p;
                Traverser it = new Traverser(t, t.length, 0, t.length);
                while ((p = it.advance()) != null) {
                    Object val = p.val;
                    if (val == NULL_VALUE) continue;
                    h += p.hashCode(p.key, val);
                }
            }
            return h;
        }

        @Override
        public final boolean equals(Object o) {
            Set c;
            return o instanceof Set && ((c = (Set)o) == this || this.containsAll(c) && c.containsAll(this));
        }

        public ConcurrentHashMapSpliterator<Map.Entry<K, V>> spliteratorV8() {
            BoundedEquivalentConcurrentHashMapV8 m = this.map;
            long n = m.sumCount();
            Node<K, V>[] t = m.table;
            int f = m.table == null ? 0 : t.length;
            return new EntrySpliterator(t, f, 0, f, n < 0L ? 0L : n, m);
        }

        @Override
        public void forEach(Consumer<? super Map.Entry<K, V>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            Node<K, V>[] t = this.map.table;
            if (this.map.table != null) {
                Node p;
                Traverser it = new Traverser(t, t.length, 0, t.length);
                while ((p = it.advance()) != null) {
                    Object val = p.val;
                    if (val == NULL_VALUE) continue;
                    action.accept(new MapEntry(p.key, val, this.map));
                }
            }
        }
    }

    static final class ValuesView<K, V>
    extends CollectionView<K, V, V>
    implements Collection<V>,
    Serializable {
        private static final long serialVersionUID = 2249069246763182397L;

        ValuesView(BoundedEquivalentConcurrentHashMapV8<K, V> map) {
            super(map);
        }

        @Override
        public final boolean contains(Object o) {
            return this.map.containsValue(o);
        }

        @Override
        public final boolean remove(Object o) {
            if (o != null) {
                Iterator<V> it = this.iterator();
                while (it.hasNext()) {
                    if (!this.map.valueEq.equals(it.next(), o)) continue;
                    it.remove();
                    return true;
                }
            }
            return false;
        }

        @Override
        public final Iterator<V> iterator() {
            BoundedEquivalentConcurrentHashMapV8 m = this.map;
            Node<K, V>[] t = m.table;
            int f = m.table == null ? 0 : t.length;
            return new ValueIterator(t, f, 0, f, m);
        }

        @Override
        public final boolean add(V e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean addAll(Collection<? extends V> c) {
            throw new UnsupportedOperationException();
        }

        public ConcurrentHashMapSpliterator<V> spliteratorV8() {
            BoundedEquivalentConcurrentHashMapV8 m = this.map;
            long n = m.sumCount();
            Node<K, V>[] t = m.table;
            int f = m.table == null ? 0 : t.length;
            return new ValueSpliterator(t, f, 0, f, n < 0L ? 0L : n);
        }

        @Override
        public void forEach(Consumer<? super V> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            Node<K, V>[] t = this.map.table;
            if (this.map.table != null) {
                Node p;
                Traverser it = new Traverser(t, t.length, 0, t.length);
                while ((p = it.advance()) != null) {
                    action.accept(p.val);
                }
            }
        }
    }

    public static class KeySetView<K, V>
    extends CollectionView<K, V, K>
    implements Set<K>,
    Serializable {
        private static final long serialVersionUID = 7249069246763182397L;
        private final V value;

        KeySetView(BoundedEquivalentConcurrentHashMapV8<K, V> map, V value) {
            super(map);
            this.value = value;
        }

        public V getMappedValue() {
            return this.value;
        }

        @Override
        public boolean contains(Object o) {
            return this.map.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return this.map.remove(o) != null;
        }

        @Override
        public Iterator<K> iterator() {
            BoundedEquivalentConcurrentHashMapV8 m = this.map;
            Node<K, V>[] t = m.table;
            int f = m.table == null ? 0 : t.length;
            return new KeyIterator(t, f, 0, f, m);
        }

        @Override
        public boolean add(K e) {
            V v = this.value;
            if (v == null) {
                throw new UnsupportedOperationException();
            }
            return this.map.putVal(e, v, true) == null;
        }

        @Override
        public boolean addAll(Collection<? extends K> c) {
            boolean added = false;
            V v = this.value;
            if (v == null) {
                throw new UnsupportedOperationException();
            }
            for (K e : c) {
                if (this.map.putVal(e, v, true) != null) continue;
                added = true;
            }
            return added;
        }

        @Override
        public int hashCode() {
            int h = 0;
            for (K e : this) {
                h += this.map.keyEq.hashCode(e);
            }
            return h;
        }

        @Override
        public boolean equals(Object o) {
            Set c;
            return o instanceof Set && ((c = (Set)o) == this || this.containsAll(c) && c.containsAll(this));
        }

        public ConcurrentHashMapSpliterator<K> spliteratorV8() {
            BoundedEquivalentConcurrentHashMapV8 m = this.map;
            long n = m.sumCount();
            Node<K, V>[] t = m.table;
            int f = m.table == null ? 0 : t.length;
            return new KeySpliterator(t, f, 0, f, n < 0L ? 0L : n);
        }

        @Override
        public void forEach(Consumer<? super K> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            Node<K, V>[] t = this.map.table;
            if (this.map.table != null) {
                Node p;
                Traverser it = new Traverser(t, t.length, 0, t.length);
                while ((p = it.advance()) != null) {
                    if (p.val == NULL_VALUE) continue;
                    action.accept(p.key);
                }
            }
        }
    }

    static abstract class CollectionView<K, V, E>
    implements Collection<E>,
    Serializable {
        private static final long serialVersionUID = 7249069246763182397L;
        final BoundedEquivalentConcurrentHashMapV8<K, V> map;
        private static final String oomeMsg = "Required array size too large";

        CollectionView(BoundedEquivalentConcurrentHashMapV8<K, V> map) {
            this.map = map;
        }

        public BoundedEquivalentConcurrentHashMapV8<K, V> getMap() {
            return this.map;
        }

        @Override
        public final void clear() {
            this.map.clear();
        }

        @Override
        public final int size() {
            return this.map.size();
        }

        @Override
        public final boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public abstract Iterator<E> iterator();

        @Override
        public abstract boolean contains(Object var1);

        @Override
        public abstract boolean remove(Object var1);

        @Override
        public final Object[] toArray() {
            long sz = this.map.mappingCount();
            if (sz > 0x7FFFFFF7L) {
                throw new OutOfMemoryError(oomeMsg);
            }
            int n = (int)sz;
            Object[] r = new Object[n];
            int i = 0;
            for (E e : this) {
                if (i == n) {
                    if (n >= 0x7FFFFFF7) {
                        throw new OutOfMemoryError(oomeMsg);
                    }
                    n = n >= 0x3FFFFFFB ? 0x7FFFFFF7 : (n += (n >>> 1) + 1);
                    r = Arrays.copyOf(r, n);
                }
                r[i++] = e;
            }
            return i == n ? r : Arrays.copyOf(r, i);
        }

        @Override
        public final <T> T[] toArray(T[] a) {
            long sz = this.map.mappingCount();
            if (sz > 0x7FFFFFF7L) {
                throw new OutOfMemoryError(oomeMsg);
            }
            int m = (int)sz;
            T[] r = a.length >= m ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), m);
            int n = r.length;
            int i = 0;
            for (E e : this) {
                if (i == n) {
                    if (n >= 0x7FFFFFF7) {
                        throw new OutOfMemoryError(oomeMsg);
                    }
                    n = n >= 0x3FFFFFFB ? 0x7FFFFFF7 : (n += (n >>> 1) + 1);
                    r = Arrays.copyOf(r, n);
                }
                r[i++] = e;
            }
            if (a == r && i < n) {
                r[i] = null;
                return r;
            }
            return i == n ? r : Arrays.copyOf(r, i);
        }

        public final String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            Iterator<E> it = this.iterator();
            if (it.hasNext()) {
                while (true) {
                    E e;
                    sb.append((Object)((e = it.next()) == this ? "(this Collection)" : e));
                    if (!it.hasNext()) break;
                    sb.append(',').append(' ');
                }
            }
            return sb.append(']').toString();
        }

        @Override
        public final boolean containsAll(Collection<?> c) {
            if (c != this) {
                for (Object e : c) {
                    if (e != null && this.contains(e)) continue;
                    return false;
                }
            }
            return true;
        }

        @Override
        public final boolean removeAll(Collection<?> c) {
            boolean modified = false;
            Iterator<E> it = this.iterator();
            while (it.hasNext()) {
                if (!c.contains(it.next())) continue;
                it.remove();
                modified = true;
            }
            return modified;
        }

        @Override
        public final boolean retainAll(Collection<?> c) {
            boolean modified = false;
            Iterator<E> it = this.iterator();
            while (it.hasNext()) {
                if (c.contains(it.next())) continue;
                it.remove();
                modified = true;
            }
            return modified;
        }
    }

    static final class EntrySpliterator<K, V>
    extends Traverser<K, V>
    implements ConcurrentHashMapSpliterator<Map.Entry<K, V>> {
        final BoundedEquivalentConcurrentHashMapV8<K, V> map;
        long est;

        EntrySpliterator(Node<K, V>[] tab, int size, int index, int limit, long est, BoundedEquivalentConcurrentHashMapV8<K, V> map) {
            super(tab, size, index, limit);
            this.map = map;
            this.est = est;
        }

        @Override
        public ConcurrentHashMapSpliterator<Map.Entry<K, V>> trySplit() {
            EntrySpliterator<K, V> entrySpliterator;
            int i = this.baseIndex;
            int f = this.baseLimit;
            int h = i + f >>> 1;
            if (h <= i) {
                entrySpliterator = null;
            } else {
                this.baseLimit = h;
                EntrySpliterator<K, V> entrySpliterator2 = new EntrySpliterator<K, V>(this.tab, this.baseSize, this.baseLimit, f, this.est >>>= 1, this.map);
                entrySpliterator = entrySpliterator2;
            }
            return entrySpliterator;
        }

        @Override
        public void forEachRemaining(Consumer<? super Map.Entry<K, V>> action) {
            Node p;
            if (action == null) {
                throw new NullPointerException();
            }
            while ((p = this.advance()) != null) {
                Object val = p.val;
                if (val == NULL_VALUE) continue;
                action.accept(new MapEntry(p.key, val, this.map));
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super Map.Entry<K, V>> action) {
            Node p;
            if (action == null) {
                throw new NullPointerException();
            }
            while ((p = this.advance()) != null) {
                Object val = p.val;
                if (val == NULL_VALUE) continue;
                action.accept(new MapEntry(p.key, val, this.map));
                return true;
            }
            return false;
        }

        @Override
        public long estimateSize() {
            return this.est;
        }
    }

    static final class ValueSpliterator<K, V>
    extends Traverser<K, V>
    implements ConcurrentHashMapSpliterator<V> {
        long est;

        ValueSpliterator(Node<K, V>[] tab, int size, int index, int limit, long est) {
            super(tab, size, index, limit);
            this.est = est;
        }

        @Override
        public ConcurrentHashMapSpliterator<V> trySplit() {
            ValueSpliterator<K, V> valueSpliterator;
            int i = this.baseIndex;
            int f = this.baseLimit;
            int h = i + f >>> 1;
            if (h <= i) {
                valueSpliterator = null;
            } else {
                this.baseLimit = h;
                ValueSpliterator<K, V> valueSpliterator2 = new ValueSpliterator<K, V>(this.tab, this.baseSize, this.baseLimit, f, this.est >>>= 1);
                valueSpliterator = valueSpliterator2;
            }
            return valueSpliterator;
        }

        @Override
        public void forEachRemaining(Consumer<? super V> action) {
            Node p;
            if (action == null) {
                throw new NullPointerException();
            }
            while ((p = this.advance()) != null) {
                action.accept(p.val);
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super V> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            Node p = this.advance();
            if (p == null) {
                return false;
            }
            action.accept(p.val);
            return true;
        }

        @Override
        public long estimateSize() {
            return this.est;
        }
    }

    static final class KeySpliterator<K, V>
    extends Traverser<K, V>
    implements ConcurrentHashMapSpliterator<K> {
        long est;

        KeySpliterator(Node<K, V>[] tab, int size, int index, int limit, long est) {
            super(tab, size, index, limit);
            this.est = est;
        }

        @Override
        public ConcurrentHashMapSpliterator<K> trySplit() {
            KeySpliterator<K, V> keySpliterator;
            int i = this.baseIndex;
            int f = this.baseLimit;
            int h = i + f >>> 1;
            if (h <= i) {
                keySpliterator = null;
            } else {
                this.baseLimit = h;
                KeySpliterator<K, V> keySpliterator2 = new KeySpliterator<K, V>(this.tab, this.baseSize, this.baseLimit, f, this.est >>>= 1);
                keySpliterator = keySpliterator2;
            }
            return keySpliterator;
        }

        @Override
        public void forEachRemaining(Consumer<? super K> action) {
            Node p;
            if (action == null) {
                throw new NullPointerException();
            }
            while ((p = this.advance()) != null) {
                action.accept(p.key);
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super K> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            Node p = this.advance();
            if (p == null) {
                return false;
            }
            action.accept(p.key);
            return true;
        }

        @Override
        public long estimateSize() {
            return this.est;
        }
    }

    static final class MapEntry<K, V>
    implements Map.Entry<K, V> {
        final K key;
        V val;
        final BoundedEquivalentConcurrentHashMapV8<K, V> map;

        MapEntry(K key, V val, BoundedEquivalentConcurrentHashMapV8<K, V> map) {
            this.key = key;
            this.val = val;
            this.map = map;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.val;
        }

        @Override
        public int hashCode() {
            return this.map.keyEq.hashCode(this.key) ^ this.map.valueEq.hashCode(this.val);
        }

        public String toString() {
            return this.key + "=" + this.val;
        }

        @Override
        public boolean equals(Object o) {
            Object v;
            Map.Entry e;
            Object k;
            return !(!(o instanceof Map.Entry) || (k = (e = (Map.Entry)o).getKey()) == null || (v = e.getValue()) == null || k != this.key && !this.map.keyEq.equals(this.key, k) || v != this.val && !this.map.valueEq.equals(this.val, v));
        }

        @Override
        public V setValue(V value) {
            if (value == null) {
                throw new NullPointerException();
            }
            V v = this.val;
            this.val = value;
            this.map.put(this.key, value);
            return v;
        }
    }

    static final class EntryIterator<K, V>
    extends BaseIterator<K, V>
    implements Iterator<Map.Entry<K, V>> {
        EntryIterator(Node<K, V>[] tab, int index, int size, int limit, BoundedEquivalentConcurrentHashMapV8<K, V> map) {
            super(tab, index, size, limit, map);
        }

        @Override
        public final Map.Entry<K, V> next() {
            Object k = this.key;
            if (k == null) {
                throw new NoSuchElementException();
            }
            Object v = this.value;
            this.lastKey = k;
            this.advanceUntilValidValue();
            return new MapEntry<Object, Object>(k, v, this.map);
        }
    }

    static final class ValueIterator<K, V>
    extends BaseIterator<K, V>
    implements Iterator<V>,
    Enumeration<V> {
        ValueIterator(Node<K, V>[] tab, int index, int size, int limit, BoundedEquivalentConcurrentHashMapV8<K, V> map) {
            super(tab, index, size, limit, map);
        }

        @Override
        public final V next() {
            Object k = this.key;
            if (k == null) {
                throw new NoSuchElementException();
            }
            this.lastKey = k;
            Object v = this.value;
            this.advanceUntilValidValue();
            return (V)v;
        }

        @Override
        public final V nextElement() {
            return this.next();
        }
    }

    static final class KeyIterator<K, V>
    extends BaseIterator<K, V>
    implements Iterator<K>,
    Enumeration<K> {
        KeyIterator(Node<K, V>[] tab, int index, int size, int limit, BoundedEquivalentConcurrentHashMapV8<K, V> map) {
            super(tab, index, size, limit, map);
        }

        @Override
        public final K next() {
            Object k = this.key;
            if (k == null) {
                throw new NoSuchElementException();
            }
            this.lastKey = k;
            this.advanceUntilValidValue();
            return (K)k;
        }

        @Override
        public final K nextElement() {
            return this.next();
        }
    }

    static class BaseIterator<K, V>
    extends Traverser<K, V> {
        final BoundedEquivalentConcurrentHashMapV8<K, V> map;
        K lastKey;
        K key;
        V value;

        BaseIterator(Node<K, V>[] tab, int size, int index, int limit, BoundedEquivalentConcurrentHashMapV8<K, V> map) {
            super(tab, size, index, limit);
            this.map = map;
            this.advanceUntilValidValue();
        }

        @Override
        final Node<K, V> advance() {
            throw new UnsupportedOperationException();
        }

        final void advanceUntilValidValue() {
            Node node = super.advance();
            if (node != null) {
                do {
                    this.value = node.val;
                    if (this.value != null && this.value != NULL_VALUE) {
                        this.key = node.key;
                        break;
                    }
                    this.key = null;
                } while ((node = super.advance()) != null);
            } else {
                this.key = null;
                this.value = null;
            }
        }

        public final boolean hasNext() {
            return this.key != null;
        }

        public final boolean hasMoreElements() {
            return this.key != null;
        }

        public final void remove() {
            K p = this.lastKey;
            if (p == null) {
                throw new IllegalStateException();
            }
            this.lastKey = null;
            this.map.replaceNode(p, null, null);
        }
    }

    static class Traverser<K, V> {
        Node<K, V>[] tab;
        Node<K, V> next;
        TableStack<K, V> stack;
        TableStack<K, V> spare;
        int index;
        int baseIndex;
        int baseLimit;
        final int baseSize;

        Traverser(Node<K, V>[] tab, int size, int index, int limit) {
            this.tab = tab;
            this.baseSize = size;
            this.baseIndex = this.index = index;
            this.baseLimit = limit;
            this.next = null;
        }

        Node<K, V> advance() {
            Node<K, V> e = this.next;
            if (e != null) {
                e = e.next;
            }
            while (true) {
                int i;
                int n;
                Node<K, V>[] t;
                block10: {
                    block9: {
                        if (e != null) {
                            this.next = e;
                            return this.next;
                        }
                        if (this.baseIndex >= this.baseLimit) break block9;
                        t = this.tab;
                        if (this.tab != null && (n = t.length) > (i = this.index) && i >= 0) break block10;
                    }
                    this.next = null;
                    return null;
                }
                e = BoundedEquivalentConcurrentHashMapV8.tabAt(t, i);
                if (e != null && e.hash < 0) {
                    if (e instanceof ForwardingNode) {
                        this.tab = ((ForwardingNode)e).nextTable;
                        e = null;
                        this.pushState(t, i, n);
                        continue;
                    }
                    e = e instanceof TreeBin ? ((TreeBin)e).first : null;
                }
                if (this.stack != null) {
                    this.recoverState(n);
                    continue;
                }
                this.index = i + this.baseSize;
                if (this.index < n) continue;
                this.index = ++this.baseIndex;
            }
        }

        private void pushState(Node<K, V>[] t, int i, int n) {
            TableStack<K, V> s = this.spare;
            if (s != null) {
                this.spare = s.next;
            } else {
                s = new TableStack();
            }
            s.tab = t;
            s.length = n;
            s.index = i;
            s.next = this.stack;
            this.stack = s;
        }

        private void recoverState(int n) {
            int len;
            TableStack<K, V> s;
            while ((s = this.stack) != null && (this.index += (len = s.length)) >= n) {
                n = len;
                this.index = s.index;
                this.tab = s.tab;
                s.tab = null;
                TableStack next = s.next;
                s.next = this.spare;
                this.stack = next;
                this.spare = s;
            }
            if (s == null && (this.index += this.baseSize) >= n) {
                this.index = ++this.baseIndex;
            }
        }
    }

    static final class TableStack<K, V> {
        int length;
        int index;
        Node<K, V>[] tab;
        TableStack<K, V> next;

        TableStack() {
        }
    }

    static final class TreeBin<K, V>
    extends Node<K, V> {
        final BoundedEquivalentConcurrentHashMapV8<K, V> map;
        TreeNode<K, V> root;
        volatile TreeNode<K, V> first;
        volatile Thread waiter;
        volatile int lockState;
        static final int WRITER = 1;
        static final int WAITER = 2;
        static final int READER = 4;
        private static final Unsafe U;
        private static final long LOCKSTATE;

        static int tieBreakOrder(Object a, Object b) {
            int d;
            if (a == null || b == null || (d = a.getClass().getName().compareTo(b.getClass().getName())) == 0) {
                d = System.identityHashCode(a) <= System.identityHashCode(b) ? -1 : 1;
            }
            return d;
        }

        TreeBin(TreeNode<K, V> b, BoundedEquivalentConcurrentHashMapV8<K, V> map) {
            super(-2, map.nodeEq, null, null, null);
            this.map = map;
            this.first = b;
            TreeNode r = null;
            TreeNode x = b;
            while (x != null) {
                TreeNode next = (TreeNode)x.next;
                x.right = null;
                x.left = null;
                if (r == null) {
                    x.parent = null;
                    x.red = false;
                    r = x;
                } else {
                    TreeNode xp;
                    int dir;
                    Object k = x.key;
                    int h = x.hash;
                    Class kc = null;
                    TreeNode p = r;
                    do {
                        Object pk = p.key;
                        int ph = p.hash;
                        if (ph > h) {
                            dir = -1;
                        } else if (ph < h) {
                            dir = 1;
                        } else if (kc == null && (kc = BoundedEquivalentConcurrentHashMapV8.comparableClassFor(k, this.nodeEq.keyEq)) == null || (dir = BoundedEquivalentConcurrentHashMapV8.compareComparables(kc, k, pk, this.nodeEq.keyEq)) == 0) {
                            dir = TreeBin.tieBreakOrder(k, pk);
                        }
                        xp = p;
                    } while ((p = dir <= 0 ? p.left : p.right) != null);
                    x.parent = xp;
                    if (dir <= 0) {
                        xp.left = x;
                    } else {
                        xp.right = x;
                    }
                    r = TreeBin.balanceInsertion(r, x);
                }
                x = next;
            }
            this.root = r;
        }

        private final void lockRoot() {
            if (!U.compareAndSwapInt(this, LOCKSTATE, 0, 1)) {
                this.contendedLock();
            }
        }

        private final void unlockRoot() {
            this.lockState = 0;
        }

        private final void contendedLock() {
            boolean waiting = false;
            while (true) {
                int s;
                if (((s = this.lockState) & 0xFFFFFFFD) == 0) {
                    if (!U.compareAndSwapInt(this, LOCKSTATE, s, 1)) continue;
                    if (waiting) {
                        this.waiter = null;
                    }
                    return;
                }
                if ((s & 2) == 0) {
                    if (!U.compareAndSwapInt(this, LOCKSTATE, s, s | 2)) continue;
                    waiting = true;
                    this.waiter = Thread.currentThread();
                    continue;
                }
                if (!waiting) continue;
                LockSupport.park(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        final Node<K, V> find(int h, Object k) {
            if (k != null) {
                Node e = this.first;
                while (e != null) {
                    TreeNode<K, V> p;
                    int s = this.lockState;
                    if ((s & 3) != 0) {
                        Object ek;
                        if (e.hash == h && ((ek = e.key) == k || ek != null && this.nodeEq.keyEq.equals(ek, k))) {
                            return e;
                        }
                        e = e.next;
                        continue;
                    }
                    if (!U.compareAndSwapInt(this, LOCKSTATE, s, s + 4)) continue;
                    try {
                        TreeNode<K, V> r = this.root;
                        p = r == null ? null : r.findTreeNode(h, k, null);
                    }
                    finally {
                        Thread w;
                        int ls2;
                        while (!U.compareAndSwapInt(this, LOCKSTATE, ls2 = this.lockState, ls2 - 4)) {
                        }
                        if (ls2 == 6 && (w = this.waiter) != null) {
                            LockSupport.unpark(w);
                        }
                    }
                    return p;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final TreeNode<K, V> putTreeVal(int h, K k, V v) {
            block19: {
                TreeNode<K, V> xp;
                int dir;
                Class kc = null;
                boolean searched = false;
                TreeNode<K, V> p = this.root;
                do {
                    if (p == null) {
                        this.root = this.map.evictionPolicy.createNewEntry(k, h, null, null, v, null);
                        this.first = this.root;
                        this.map.evictionPolicy.onEntryMiss(this.first, v);
                        this.map.evictionListener.onEntryActivated(k);
                        break block19;
                    }
                    int ph = p.hash;
                    if (ph > h) {
                        dir = -1;
                    } else if (ph < h) {
                        dir = 1;
                    } else {
                        Object pk = p.key;
                        if (pk == k || pk != null && this.nodeEq.keyEq.equals(pk, k)) {
                            return p;
                        }
                        if (kc == null && (kc = BoundedEquivalentConcurrentHashMapV8.comparableClassFor(k, this.nodeEq.keyEq)) == null || (dir = BoundedEquivalentConcurrentHashMapV8.compareComparables(kc, k, pk, this.nodeEq.keyEq)) == 0) {
                            if (!searched) {
                                TreeNode q;
                                searched = true;
                                TreeNode ch = p.left;
                                if (ch != null && (q = ch.findTreeNode(h, k, kc)) != null || (ch = p.right) != null && (q = ch.findTreeNode(h, k, kc)) != null) {
                                    return q;
                                }
                            }
                            dir = TreeBin.tieBreakOrder(k, pk);
                        }
                    }
                    xp = p;
                } while ((p = dir <= 0 ? p.left : p.right) != null);
                TreeNode<K, V> f = this.first;
                TreeNode x = this.map.evictionPolicy.createNewEntry(k, h, f, xp, v, null);
                this.first = x;
                this.map.evictionPolicy.onEntryMiss(this.first, v);
                this.map.evictionListener.onEntryActivated(k);
                if (f != null) {
                    f.prev = x;
                }
                if (dir <= 0) {
                    xp.left = x;
                } else {
                    xp.right = x;
                }
                if (!xp.red) {
                    x.red = true;
                } else {
                    this.lockRoot();
                    try {
                        this.root = TreeBin.balanceInsertion(this.root, x);
                    }
                    finally {
                        this.unlockRoot();
                    }
                }
            }
            assert (TreeBin.checkInvariants(this.root));
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final boolean removeTreeNode(TreeNode<K, V> p) {
            TreeNode rl;
            TreeNode next = (TreeNode)p.next;
            TreeNode pred = p.prev;
            if (pred == null) {
                this.first = next;
            } else {
                pred.next = next;
            }
            if (next != null) {
                next.prev = pred;
            }
            if (this.first == null) {
                this.root = null;
                return true;
            }
            TreeNode<K, V> r = this.root;
            if (r == null || r.right == null || (rl = r.left) == null || rl.left == null) {
                return true;
            }
            this.lockRoot();
            try {
                TreeNode pp;
                TreeNode replacement;
                TreeNode pl = p.left;
                TreeNode pr = p.right;
                if (pl != null && pr != null) {
                    TreeNode sl;
                    TreeNode s = pr;
                    while ((sl = s.left) != null) {
                        s = sl;
                    }
                    boolean c = s.red;
                    s.red = p.red;
                    p.red = c;
                    TreeNode sr = s.right;
                    TreeNode pp2 = p.parent;
                    if (s == pr) {
                        p.parent = s;
                        s.right = p;
                    } else {
                        TreeNode sp = s.parent;
                        p.parent = sp;
                        if (p.parent != null) {
                            if (s == sp.left) {
                                sp.left = p;
                            } else {
                                sp.right = p;
                            }
                        }
                        if ((s.right = pr) != null) {
                            pr.parent = s;
                        }
                    }
                    p.left = null;
                    p.right = sr;
                    if (p.right != null) {
                        sr.parent = p;
                    }
                    if ((s.left = pl) != null) {
                        pl.parent = s;
                    }
                    if ((s.parent = pp2) == null) {
                        r = s;
                    } else if (p == pp2.left) {
                        pp2.left = s;
                    } else {
                        pp2.right = s;
                    }
                    replacement = sr != null ? sr : p;
                } else {
                    replacement = pl != null ? pl : (pr != null ? pr : p);
                }
                if (replacement != p) {
                    replacement.parent = p.parent;
                    pp = replacement.parent;
                    if (pp == null) {
                        r = replacement;
                    } else if (p == pp.left) {
                        pp.left = replacement;
                    } else {
                        pp.right = replacement;
                    }
                    p.parent = null;
                    p.right = null;
                    p.left = null;
                }
                TreeNode<K, V> treeNode = this.root = p.red ? r : TreeBin.balanceDeletion(r, replacement);
                if (p == replacement && (pp = p.parent) != null) {
                    if (p == pp.left) {
                        pp.left = null;
                    } else if (p == pp.right) {
                        pp.right = null;
                    }
                    p.parent = null;
                }
            }
            finally {
                this.unlockRoot();
            }
            return false;
        }

        static <K, V> TreeNode<K, V> rotateLeft(TreeNode<K, V> root, TreeNode<K, V> p) {
            TreeNode r;
            if (p != null && (r = p.right) != null) {
                p.right = r.left;
                TreeNode rl = p.right;
                if (p.right != null) {
                    rl.parent = p;
                }
                TreeNode pp = r.parent = p.parent;
                if (r.parent == null) {
                    root = r;
                    r.red = false;
                } else if (pp.left == p) {
                    pp.left = r;
                } else {
                    pp.right = r;
                }
                r.left = p;
                p.parent = r;
            }
            return root;
        }

        static <K, V> TreeNode<K, V> rotateRight(TreeNode<K, V> root, TreeNode<K, V> p) {
            TreeNode l;
            if (p != null && (l = p.left) != null) {
                p.left = l.right;
                TreeNode lr = p.left;
                if (p.left != null) {
                    lr.parent = p;
                }
                TreeNode pp = l.parent = p.parent;
                if (l.parent == null) {
                    root = l;
                    l.red = false;
                } else if (pp.right == p) {
                    pp.right = l;
                } else {
                    pp.left = l;
                }
                l.right = p;
                p.parent = l;
            }
            return root;
        }

        static <K, V> TreeNode<K, V> balanceInsertion(TreeNode<K, V> root, TreeNode<K, V> x) {
            x.red = true;
            while (true) {
                TreeNode xpp;
                TreeNode xp;
                if ((xp = x.parent) == null) {
                    x.red = false;
                    return x;
                }
                if (!xp.red || (xpp = xp.parent) == null) {
                    return root;
                }
                TreeNode xppl = xpp.left;
                if (xp == xppl) {
                    TreeNode xppr = xpp.right;
                    if (xppr != null && xppr.red) {
                        xppr.red = false;
                        xp.red = false;
                        xpp.red = true;
                        x = xpp;
                        continue;
                    }
                    if (x == xp.right) {
                        x = xp;
                        root = TreeBin.rotateLeft(root, x);
                        xp = x.parent;
                        TreeNode treeNode = xpp = xp == null ? null : xp.parent;
                    }
                    if (xp == null) continue;
                    xp.red = false;
                    if (xpp == null) continue;
                    xpp.red = true;
                    root = TreeBin.rotateRight(root, xpp);
                    continue;
                }
                if (xppl != null && xppl.red) {
                    xppl.red = false;
                    xp.red = false;
                    xpp.red = true;
                    x = xpp;
                    continue;
                }
                if (x == xp.left) {
                    x = xp;
                    root = TreeBin.rotateRight(root, x);
                    xp = x.parent;
                    TreeNode treeNode = xpp = xp == null ? null : xp.parent;
                }
                if (xp == null) continue;
                xp.red = false;
                if (xpp == null) continue;
                xpp.red = true;
                root = TreeBin.rotateLeft(root, xpp);
            }
        }

        static <K, V> TreeNode<K, V> balanceDeletion(TreeNode<K, V> root, TreeNode<K, V> x) {
            while (x != null && x != root) {
                TreeNode sr;
                TreeNode sl;
                TreeNode xp = x.parent;
                if (xp == null) {
                    x.red = false;
                    return x;
                }
                if (x.red) {
                    x.red = false;
                    return root;
                }
                TreeNode xpl = xp.left;
                if (xpl == x) {
                    TreeNode xpr = xp.right;
                    if (xpr != null && xpr.red) {
                        xpr.red = false;
                        xp.red = true;
                        root = TreeBin.rotateLeft(root, xp);
                        xp = x.parent;
                        TreeNode treeNode = xpr = xp == null ? null : xp.right;
                    }
                    if (xpr == null) {
                        x = xp;
                        continue;
                    }
                    sl = xpr.left;
                    sr = xpr.right;
                    if (!(sr != null && sr.red || sl != null && sl.red)) {
                        xpr.red = true;
                        x = xp;
                        continue;
                    }
                    if (sr == null || !sr.red) {
                        if (sl != null) {
                            sl.red = false;
                        }
                        xpr.red = true;
                        root = TreeBin.rotateRight(root, xpr);
                        xp = x.parent;
                        TreeNode treeNode = xpr = xp == null ? null : xp.right;
                    }
                    if (xpr != null) {
                        xpr.red = xp == null ? false : xp.red;
                        sr = xpr.right;
                        if (sr != null) {
                            sr.red = false;
                        }
                    }
                    if (xp != null) {
                        xp.red = false;
                        root = TreeBin.rotateLeft(root, xp);
                    }
                    x = root;
                    continue;
                }
                if (xpl != null && xpl.red) {
                    xpl.red = false;
                    xp.red = true;
                    root = TreeBin.rotateRight(root, xp);
                    xp = x.parent;
                    TreeNode treeNode = xpl = xp == null ? null : xp.left;
                }
                if (xpl == null) {
                    x = xp;
                    continue;
                }
                sl = xpl.left;
                sr = xpl.right;
                if (!(sl != null && sl.red || sr != null && sr.red)) {
                    xpl.red = true;
                    x = xp;
                    continue;
                }
                if (sl == null || !sl.red) {
                    if (sr != null) {
                        sr.red = false;
                    }
                    xpl.red = true;
                    root = TreeBin.rotateLeft(root, xpl);
                    xp = x.parent;
                    TreeNode treeNode = xpl = xp == null ? null : xp.left;
                }
                if (xpl != null) {
                    xpl.red = xp == null ? false : xp.red;
                    sl = xpl.left;
                    if (sl != null) {
                        sl.red = false;
                    }
                }
                if (xp != null) {
                    xp.red = false;
                    root = TreeBin.rotateRight(root, xp);
                }
                x = root;
            }
            return root;
        }

        static <K, V> boolean checkInvariants(TreeNode<K, V> t) {
            TreeNode tp = t.parent;
            TreeNode tl = t.left;
            TreeNode tr = t.right;
            TreeNode tb = t.prev;
            TreeNode tn = (TreeNode)t.next;
            if (tb != null && tb.next != t) {
                return false;
            }
            if (tn != null && tn.prev != t) {
                return false;
            }
            if (tp != null && t != tp.left && t != tp.right) {
                return false;
            }
            if (tl != null && (tl.parent != t || tl.hash > t.hash)) {
                return false;
            }
            if (tr != null && (tr.parent != t || tr.hash < t.hash)) {
                return false;
            }
            if (t.red && tl != null && tl.red && tr != null && tr.red) {
                return false;
            }
            if (tl != null && !TreeBin.checkInvariants(tl)) {
                return false;
            }
            return tr == null || TreeBin.checkInvariants(tr);
        }

        static {
            try {
                U = BoundedEquivalentConcurrentHashMapV8.getUnsafe();
                Class<TreeBin> k = TreeBin.class;
                LOCKSTATE = U.objectFieldOffset(k.getDeclaredField("lockState"));
            }
            catch (Exception e) {
                throw new Error(e);
            }
        }
    }

    static final class TreeNode<K, V>
    extends Node<K, V> {
        TreeNode<K, V> parent;
        TreeNode<K, V> left;
        TreeNode<K, V> right;
        TreeNode<K, V> prev;
        boolean red;

        TreeNode(int hash, NodeEquivalence<K, V> nodeEq, K key, V val, Node<K, V> next, TreeNode<K, V> parent, EvictionEntry<K, V> evictionEntry) {
            super(hash, nodeEq, key, val, next);
            this.parent = parent;
            if (evictionEntry != null) {
                this.lazySetEviction(evictionEntry);
            }
        }

        @Override
        Node<K, V> find(int h, Object k) {
            return this.findTreeNode(h, k, null);
        }

        final TreeNode<K, V> findTreeNode(int h, Object k, Class<?> kc) {
            if (k != null) {
                TreeNode<K, V> p = this;
                do {
                    int dir;
                    TreeNode<K, V> pl = p.left;
                    TreeNode<K, V> pr = p.right;
                    int ph = p.hash;
                    if (ph > h) {
                        p = pl;
                        continue;
                    }
                    if (ph < h) {
                        p = pr;
                        continue;
                    }
                    Object pk = p.key;
                    if (pk == k || pk != null && this.nodeEq.keyEq.equals(pk, k)) {
                        return p;
                    }
                    if (pl == null) {
                        p = pr;
                        continue;
                    }
                    if (pr == null) {
                        p = pl;
                        continue;
                    }
                    if ((kc != null || (kc = BoundedEquivalentConcurrentHashMapV8.comparableClassFor(k, this.nodeEq.keyEq)) != null) && (dir = BoundedEquivalentConcurrentHashMapV8.compareComparables(kc, k, pk, this.nodeEq.keyEq)) != 0) {
                        p = dir < 0 ? pl : pr;
                        continue;
                    }
                    TreeNode<K, V> q = pr.findTreeNode(h, k, kc);
                    if (q != null) {
                        return q;
                    }
                    p = pl;
                } while (p != null);
            }
            return null;
        }

        @Override
        public String toString() {
            return "Tree" + super.toString() + " with hash " + System.identityHashCode(this);
        }
    }

    static final class ReservationNode<K, V>
    extends Node<K, V> {
        ReservationNode(NodeEquivalence<K, V> nodeEq) {
            super(-3, nodeEq, null, null, null);
        }

        @Override
        Node<K, V> find(int h, Object k) {
            return null;
        }
    }

    static final class ForwardingNode<K, V>
    extends Node<K, V> {
        final Node<K, V>[] nextTable;

        ForwardingNode(Node<K, V>[] tab, NodeEquivalence<K, V> nodeEq) {
            super(-1, nodeEq, null, null, null);
            this.nextTable = tab;
        }

        @Override
        Node<K, V> find(int h, Object k) {
            Node<K, V>[] tab = this.nextTable;
            block0: while (true) {
                Node<K, V> e;
                int n;
                if (k == null || tab == null || (n = tab.length) == 0 || (e = BoundedEquivalentConcurrentHashMapV8.tabAt(tab, n - 1 & h)) == null) {
                    return null;
                }
                do {
                    Object ek;
                    int eh;
                    if ((eh = e.hash) == h && ((ek = e.key) == k || ek != null && this.nodeEq.keyEq.equals(ek, k))) {
                        return e;
                    }
                    if (eh >= 0) continue;
                    if (e instanceof ForwardingNode) {
                        tab = ((ForwardingNode)e).nextTable;
                        continue block0;
                    }
                    return e.find(h, k);
                } while ((e = e.next) != null);
                break;
            }
            return null;
        }
    }

    static class Segment<K, V>
    extends ReentrantLock
    implements Serializable {
        private static final long serialVersionUID = 2249069246763182397L;
        final float loadFactor;

        Segment(float lf) {
            this.loadFactor = lf;
        }
    }

    static class Node<K, V>
    implements Map.Entry<K, V> {
        final int hash;
        final K key;
        final NodeEquivalence<K, V> nodeEq;
        volatile V val;
        volatile Node<K, V> next;
        volatile EvictionEntry<K, V> eviction;
        private static final Unsafe UNSAFE;
        private static final long evictionOffset;

        Node(int hash, NodeEquivalence<K, V> nodeEq, K key, V val, Node<K, V> next) {
            this.hash = hash;
            this.key = key;
            this.val = val;
            this.next = next;
            this.nodeEq = nodeEq;
        }

        public final int hashCode(K key, V value) {
            return this.nodeEq.keyEq.hashCode(key) ^ this.nodeEq.valueEq.hashCode(value);
        }

        @Override
        public final K getKey() {
            return this.key;
        }

        @Override
        public final V getValue() {
            return this.val;
        }

        @Override
        public final int hashCode() {
            throw new UnsupportedOperationException("hashCode is not supported!");
        }

        public String toString() {
            return "Node: " + this.key + "=" + this.val;
        }

        @Override
        public final V setValue(V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean equals(Object o) {
            throw new UnsupportedOperationException("equals is not supported!");
        }

        Node<K, V> find(int h, Object k) {
            Node<K, V> e = this;
            if (k != null) {
                do {
                    K ek;
                    if (e.hash != h || (ek = e.key) != k && (ek == null || !this.nodeEq.keyEq.equals(ek, k))) continue;
                    return e;
                } while ((e = e.next) != null);
            }
            return null;
        }

        void lazySetEviction(EvictionEntry<K, V> val) {
            UNSAFE.putOrderedObject(this, evictionOffset, val);
        }

        static {
            try {
                UNSAFE = BoundedEquivalentConcurrentHashMapV8.getUnsafe();
                Class<Node> k = Node.class;
                evictionOffset = UNSAFE.objectFieldOffset(k.getDeclaredField("eviction"));
            }
            catch (Exception e) {
                throw new Error(e);
            }
        }
    }

    static class NodeEquivalence<K, V> {
        final Equivalence<? super K> keyEq;
        final Equivalence<? super V> valueEq;

        NodeEquivalence(Equivalence<? super K> keyEq, Equivalence<? super V> valueEq) {
            this.keyEq = keyEq;
            this.valueEq = valueEq;
        }
    }

    public static interface ConcurrentHashMapSpliterator<T> {
        public ConcurrentHashMapSpliterator<T> trySplit();

        public long estimateSize();

        public void forEachRemaining(Consumer<? super T> var1);

        public boolean tryAdvance(Consumer<? super T> var1);
    }

    public static enum Eviction {
        NONE{

            @Override
            public <K, V> EvictionPolicy<K, V> make(BoundedEquivalentConcurrentHashMapV8<K, V> map, EntrySizeCalculator<? super K, ? super V> sizeCalculator, long capacity) {
                return new NullEvictionPolicy(map.nodeEq);
            }
        }
        ,
        LRU{

            @Override
            public <K, V> EvictionPolicy<K, V> make(BoundedEquivalentConcurrentHashMapV8<K, V> map, EntrySizeCalculator<? super K, ? super V> sizeCalculator, long capacity) {
                if (sizeCalculator == null) {
                    return new LRUEvictionPolicy<Object, Object>(map, capacity, SingleEntrySizeCalculator.SINGLETON, false);
                }
                return new LRUEvictionPolicy<K, V>(map, capacity, new NodeSizeCalculatorWrapper<K, V>(sizeCalculator), true);
            }
        }
        ,
        LIRS{

            @Override
            public <K, V> EvictionPolicy<K, V> make(BoundedEquivalentConcurrentHashMapV8<K, V> map, EntrySizeCalculator<? super K, ? super V> sizeCalculator, long capacity) {
                if (sizeCalculator != null) {
                    throw new IllegalArgumentException("LIRS does not support a size calculator!");
                }
                return new LIRSEvictionPolicy<K, V>(map, capacity);
            }
        };


        abstract <K, V> EvictionPolicy<K, V> make(BoundedEquivalentConcurrentHashMapV8<K, V> var1, EntrySizeCalculator<? super K, ? super V> var2, long var3);
    }

    static final class LIRSEvictionPolicy<K, V>
    implements EvictionPolicy<K, V> {
        private static final float L_LIRS = 0.95f;
        final BoundedEquivalentConcurrentHashMapV8<K, V> map;
        final StrippedConcurrentLinkedDeque<LIRSNode<K, V>> stack = new StrippedConcurrentLinkedDeque();
        final StrippedConcurrentLinkedDeque<LIRSNode<K, V>> queue = new StrippedConcurrentLinkedDeque();
        private volatile long maximumHotSize;
        private volatile long maximumSize;
        private final AtomicLong hotSize = new AtomicLong();
        private final AtomicLong hotDemotion = new AtomicLong();
        private final AtomicReference<SizeAndEvicting> currentSize = new AtomicReference<SizeAndEvicting>(new SizeAndEvicting(0L, 0L));
        final ThreadLocal<Collection<LIRSNode<K, V>>> nodesToEvictTL = new ThreadLocal();

        public LIRSEvictionPolicy(BoundedEquivalentConcurrentHashMapV8<K, V> map, long maxSize) {
            this.map = map;
            this.maximumSize = maxSize;
            this.maximumHotSize = LIRSEvictionPolicy.calculateLIRSize(maxSize);
        }

        private static long calculateLIRSize(long maximumSize) {
            long result = (long)(0.95f * (float)maximumSize);
            return result == maximumSize ? maximumSize - 1L : result;
        }

        @Override
        public Node<K, V> createNewEntry(K key, int hash, Node<K, V> next, V value, EvictionEntry<K, V> evictionEntry) {
            Node<K, V> node = new Node<K, V>(hash, this.map.nodeEq, key, value, next);
            if (evictionEntry == null) {
                node.lazySetEviction(new LIRSNode(key));
            } else {
                node.lazySetEviction(evictionEntry);
            }
            return node;
        }

        @Override
        public TreeNode<K, V> createNewEntry(K key, int hash, TreeNode<K, V> next, TreeNode<K, V> parent, V value, EvictionEntry<K, V> evictionEntry) {
            TreeNode treeNode;
            if (evictionEntry == null) {
                treeNode = new TreeNode(hash, this.map.nodeEq, key, value, next, parent, null);
                treeNode.lazySetEviction(new LIRSNode(key));
            } else {
                treeNode = new TreeNode(hash, this.map.nodeEq, key, value, next, parent, evictionEntry);
            }
            return treeNode;
        }

        boolean addToLIRIfNotFullHot(LIRSNode<K, V> lirsNode, boolean incrementSize) {
            long currentHotSize;
            while ((currentHotSize = this.hotSize.get()) < this.maximumHotSize) {
                if (!this.hotSize.compareAndSet(currentHotSize, currentHotSize + 1L)) continue;
                if (incrementSize) {
                    BoundedEquivalentConcurrentHashMapV8.incrementSizeEviction(this.currentSize, 1L, 0L);
                }
                StrippedConcurrentLinkedDeque.DequeNode<LIRSNode<K, V>> stackNode = new StrippedConcurrentLinkedDeque.DequeNode<LIRSNode<K, V>>(lirsNode);
                lirsNode.setStackNode(stackNode);
                lirsNode.setState(Recency.LIR_RESIDENT);
                this.stack.linkLast(stackNode);
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onEntryMiss(Node<K, V> e, V value) {
            boolean skipIncrement;
            LIRSNode lirsNode;
            long pruneLIR = 0L;
            boolean evictHIR = false;
            LIRSNode lIRSNode = lirsNode = (LIRSNode)e.eviction;
            synchronized (lIRSNode) {
                skipIncrement = lirsNode.created;
                lirsNode.created = true;
                Recency recency = lirsNode.state;
                if (recency == null) {
                    if (skipIncrement) {
                        throw new IllegalStateException("Created should always be false for anewly created evictio node!");
                    }
                    if (this.addToLIRIfNotFullHot(lirsNode, true)) {
                        return;
                    }
                    long hotDifference = this.hotSize.get() - this.maximumHotSize;
                    if (hotDifference > 0L) {
                        pruneLIR = hotDifference;
                    }
                    lirsNode.setState(Recency.HIR_RESIDENT);
                    StrippedConcurrentLinkedDeque.DequeNode stackNode = new StrippedConcurrentLinkedDeque.DequeNode(lirsNode);
                    lirsNode.setStackNode(stackNode);
                    this.stack.linkLast(stackNode);
                    StrippedConcurrentLinkedDeque.DequeNode queueNode = new StrippedConcurrentLinkedDeque.DequeNode(lirsNode);
                    lirsNode.setQueueNode(queueNode);
                    this.queue.linkLast(queueNode);
                } else if (skipIncrement) {
                    switch (recency) {
                        case HIR_NONRESIDENT: {
                            e.val = value;
                            if (this.addToLIRIfNotFullHot(lirsNode, true)) {
                                return;
                            }
                            this.promoteHIRToLIR(lirsNode);
                            pruneLIR = 1L;
                            skipIncrement = false;
                            break;
                        }
                        case EVICTING: {
                            e.val = value;
                            evictHIR = true;
                            lirsNode.setState(Recency.HIR_RESIDENT);
                            StrippedConcurrentLinkedDeque.DequeNode stackNode = new StrippedConcurrentLinkedDeque.DequeNode(lirsNode);
                            lirsNode.setStackNode(stackNode);
                            this.stack.linkLast(stackNode);
                            StrippedConcurrentLinkedDeque.DequeNode queueNode = new StrippedConcurrentLinkedDeque.DequeNode(lirsNode);
                            lirsNode.setQueueNode(queueNode);
                            this.queue.linkLast(queueNode);
                            break;
                        }
                        case REMOVED: 
                        case EVICTED: {
                            throw new IllegalStateException("Cannot have a miss on a key and then get a node in " + (Object)((Object)recency));
                        }
                    }
                }
            }
            if (pruneLIR > 0L) {
                this.hotDemotion.addAndGet(pruneLIR);
            }
            if (!skipIncrement || evictHIR) {
                BoundedEquivalentConcurrentHashMapV8.incrementSizeEviction(this.currentSize, 1L, 0L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void demoteLowestLIR() {
            boolean pruned = false;
            while (!pruned) {
                LIRSNode removedLIR;
                Object[] LIRDetails = this.pruneIncludingLIR();
                if (LIRDetails == null) {
                    return;
                }
                StrippedConcurrentLinkedDeque.DequeNode removedDequeNode = (StrippedConcurrentLinkedDeque.DequeNode)LIRDetails[0];
                LIRSNode lIRSNode = removedLIR = (LIRSNode)LIRDetails[1];
                synchronized (lIRSNode) {
                    if (removedDequeNode != removedLIR.stackNode) {
                        continue;
                    }
                    if (removedLIR.state != Recency.REMOVED) {
                        removedLIR.setState(Recency.HIR_RESIDENT);
                        removedLIR.setStackNode(null);
                        StrippedConcurrentLinkedDeque.DequeNode queueNode = new StrippedConcurrentLinkedDeque.DequeNode(removedLIR);
                        removedLIR.setQueueNode(queueNode);
                        this.queue.linkLast(queueNode);
                        pruned = true;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Object[] pruneIncludingLIR() {
            LIRSNode removedLIR = null;
            Object[] nodeDetails = new Object[2];
            block8: while (true) {
                if (!this.stack.pollFirstNode(nodeDetails)) {
                    long hot;
                    do {
                        if ((hot = this.hotSize.get()) >= 0L) continue block8;
                    } while (!this.hotSize.compareAndSet(hot, hot + 1L));
                    return null;
                }
                StrippedConcurrentLinkedDeque.DequeNode removedStackNode = (StrippedConcurrentLinkedDeque.DequeNode)nodeDetails[0];
                LIRSNode lIRSNode = removedLIR = (LIRSNode)nodeDetails[1];
                synchronized (lIRSNode) {
                    if (removedStackNode != removedLIR.stackNode) {
                        continue;
                    }
                    switch (removedLIR.state) {
                        case LIR_RESIDENT: {
                            return nodeDetails;
                        }
                        case HIR_NONRESIDENT: {
                            removedLIR.setState(Recency.EVICTING);
                            Collection<LIRSNode<K, V>> nodesToEvict = this.nodesToEvictTL.get();
                            if (nodesToEvict == null) {
                                nodesToEvict = new ArrayList<LIRSNode<K, V>>();
                                this.nodesToEvictTL.set(nodesToEvict);
                            }
                            nodesToEvict.add(removedLIR);
                        }
                        case HIR_RESIDENT: {
                            removedLIR.setStackNode(null);
                            break;
                        }
                    }
                }
            }
        }

        void promoteHIRToLIR(LIRSNode<K, V> lirsNode) {
            StrippedConcurrentLinkedDeque.DequeNode queueNode;
            StrippedConcurrentLinkedDeque.DequeNode stackNode = lirsNode.stackNode;
            if (stackNode != null) {
                LIRSNode item = (LIRSNode)stackNode.item;
                if (item != null && stackNode.casItem(item, null)) {
                    this.stack.unlink(stackNode);
                }
                lirsNode.setStackNode(null);
            }
            if ((queueNode = lirsNode.queueNode) != null) {
                LIRSNode item = (LIRSNode)queueNode.item;
                if (item != null && queueNode.casItem(item, null)) {
                    this.queue.unlink(queueNode);
                }
                lirsNode.setQueueNode(null);
            }
            lirsNode.setState(Recency.LIR_RESIDENT);
            stackNode = new StrippedConcurrentLinkedDeque.DequeNode<LIRSNode<K, V>>(lirsNode);
            lirsNode.setStackNode(stackNode);
            this.stack.linkLast(stackNode);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onEntryHitRead(Node<K, V> e, V value) {
            LIRSNode lirsNode;
            boolean reAttempt = false;
            LIRSNode lIRSNode = lirsNode = (LIRSNode)e.eviction;
            synchronized (lIRSNode) {
                Recency recency = lirsNode.state;
                if (recency == Recency.HIR_NONRESIDENT || recency == Recency.EVICTING) {
                    reAttempt = true;
                } else {
                    this.onEntryHitWrite(e, value);
                }
            }
            if (reAttempt) {
                int i;
                Node f;
                int n;
                int hash = BoundedEquivalentConcurrentHashMapV8.spread(this.map.keyEq.hashCode(lirsNode.getKey()));
                Node<K, V>[] tab = this.map.table;
                while (tab != null && (n = tab.length) != 0 && (f = BoundedEquivalentConcurrentHashMapV8.tabAt(tab, i = n - 1 & hash)) != null) {
                    if (f.hash == -1) {
                        tab = this.map.helpTransfer(tab, f);
                        continue;
                    }
                    Node node = f;
                    synchronized (node) {
                        if (BoundedEquivalentConcurrentHashMapV8.tabAt(tab, i) == f) {
                            LIRSNode lIRSNode2 = lirsNode;
                            synchronized (lIRSNode2) {
                                this.onEntryHitWrite(e, value);
                            }
                        }
                        break;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onEntryHitWrite(Node<K, V> e, V value) {
            LIRSNode lirsNode;
            boolean demoteLIR = false;
            boolean evictHIR = false;
            LIRSNode lIRSNode = lirsNode = (LIRSNode)e.eviction;
            synchronized (lIRSNode) {
                Recency recency = lirsNode.state;
                if (recency == null) {
                    if (this.addToLIRIfNotFullHot(lirsNode, false)) {
                        return;
                    }
                    recency = Recency.LIR_RESIDENT;
                    lirsNode.setState(recency);
                    demoteLIR = true;
                }
                switch (recency) {
                    case LIR_RESIDENT: {
                        LIRSNode item;
                        StrippedConcurrentLinkedDeque.DequeNode stackNode = lirsNode.stackNode;
                        if (stackNode != null && (item = (LIRSNode)stackNode.item) != null && stackNode.casItem(item, null)) {
                            this.stack.unlink(stackNode);
                        }
                        StrippedConcurrentLinkedDeque.DequeNode newStackNode = new StrippedConcurrentLinkedDeque.DequeNode(lirsNode);
                        lirsNode.setStackNode(newStackNode);
                        this.stack.linkLast(newStackNode);
                        break;
                    }
                    case HIR_NONRESIDENT: {
                        if (e.val == NULL_VALUE) {
                            e.val = value;
                            ((BoundedEquivalentConcurrentHashMapV8)this.map).addCount(1L, -1);
                        }
                        if (this.addToLIRIfNotFullHot(lirsNode, true)) {
                            return;
                        }
                        this.promoteHIRToLIR(lirsNode);
                        evictHIR = true;
                        demoteLIR = true;
                        break;
                    }
                    case EVICTED: {
                        break;
                    }
                    case EVICTING: {
                        evictHIR = true;
                        lirsNode.setState(Recency.HIR_RESIDENT);
                        if (e.val == NULL_VALUE) {
                            e.val = value;
                            ((BoundedEquivalentConcurrentHashMapV8)this.map).addCount(1L, -1);
                        }
                    }
                    case HIR_RESIDENT: {
                        LIRSNode item;
                        if (lirsNode.stackNode != null) {
                            this.promoteHIRToLIR(lirsNode);
                            demoteLIR = true;
                            break;
                        }
                        if (lirsNode.queueNode != null && (item = (LIRSNode)lirsNode.queueNode.item) != null && lirsNode.queueNode.casItem(item, null)) {
                            this.queue.unlink(lirsNode.queueNode);
                        }
                        StrippedConcurrentLinkedDeque.DequeNode newStackNode = new StrippedConcurrentLinkedDeque.DequeNode(lirsNode);
                        lirsNode.setStackNode(newStackNode);
                        this.stack.linkLast(newStackNode);
                        StrippedConcurrentLinkedDeque.DequeNode newQueueNode = new StrippedConcurrentLinkedDeque.DequeNode(lirsNode);
                        lirsNode.setQueueNode(newQueueNode);
                        this.queue.linkLast(newQueueNode);
                        break;
                    }
                }
            }
            if (demoteLIR) {
                this.hotDemotion.incrementAndGet();
            }
            if (evictHIR) {
                BoundedEquivalentConcurrentHashMapV8.incrementSizeEviction(this.currentSize, 1L, 0L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onEntryRemove(Node<K, V> e) {
            LIRSNode lirsNode;
            LIRSNode lIRSNode = lirsNode = (LIRSNode)e.eviction;
            synchronized (lIRSNode) {
                switch (lirsNode.state) {
                    case LIR_RESIDENT: {
                        this.hotSize.decrementAndGet();
                    }
                    case HIR_RESIDENT: {
                        BoundedEquivalentConcurrentHashMapV8.incrementSizeEviction(this.currentSize, -1L, 0L);
                    }
                    case HIR_NONRESIDENT: 
                    case EVICTING: {
                        lirsNode.setState(Recency.REMOVED);
                        break;
                    }
                }
                StrippedConcurrentLinkedDeque.DequeNode queueNode = lirsNode.queueNode;
                if (queueNode != null) {
                    LIRSNode item = (LIRSNode)queueNode.item;
                    if (item != null && queueNode.casItem(item, null)) {
                        this.queue.unlink(queueNode);
                    }
                    lirsNode.setQueueNode(null);
                }
                lirsNode.setQueueNode(null);
                StrippedConcurrentLinkedDeque.DequeNode stackNode = lirsNode.stackNode;
                if (stackNode != null) {
                    LIRSNode item = (LIRSNode)stackNode.item;
                    if (item != null && stackNode.casItem(item, null)) {
                        this.stack.unlink(stackNode);
                    }
                    lirsNode.setStackNode(null);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection<Node<K, V>> findIfEntriesNeedEvicting() {
            int evictCount;
            block35: {
                long evict;
                SizeAndEvicting sizeEvict;
                long size;
                long longEvictCount;
                long hotDemotions;
                while ((hotDemotions = this.hotDemotion.get()) > 0L && !this.hotDemotion.compareAndSet(hotDemotions, 0L)) {
                }
                for (long i = 0L; i < hotDemotions; ++i) {
                    this.demoteLowestLIR();
                }
                while ((longEvictCount = (size = (sizeEvict = this.currentSize.get()).size) - (evict = sizeEvict.evicting) - this.maximumSize) > 0L) {
                    evictCount = (int)longEvictCount & Integer.MAX_VALUE;
                    if (!this.currentSize.compareAndSet(sizeEvict, new SizeAndEvicting(size, evict + (long)evictCount))) continue;
                    break block35;
                }
                evictCount = 0;
            }
            Collection<LIRSNode<K, V>> tlEvicted = this.nodesToEvictTL.get();
            if (tlEvicted == null) {
                tlEvicted = Collections.emptyList();
            } else {
                this.nodesToEvictTL.remove();
            }
            if (evictCount != 0 || !tlEvicted.isEmpty()) {
                LIRSNode[] queueContents = new LIRSNode[evictCount + tlEvicted.size()];
                Iterator<LIRSNode<K, V>> tlIterator = tlEvicted.iterator();
                int offset = 0;
                while (tlIterator.hasNext()) {
                    queueContents[evictCount + offset] = tlIterator.next();
                    ++offset;
                }
                int evictedValues = evictCount;
                int decEvict = evictCount;
                Object[] hirDetails = new Object[2];
                block17: for (int i = 0; i < evictCount; ++i) {
                    boolean foundNode = false;
                    while (!foundNode) {
                        LIRSNode removedHIR;
                        if (!this.queue.pollFirstNode(hirDetails)) {
                            SizeAndEvicting newSizeEvict;
                            SizeAndEvicting sizeEvict = this.currentSize.get();
                            if (sizeEvict.size - sizeEvict.evicting < this.maximumSize && this.currentSize.compareAndSet(sizeEvict, newSizeEvict = new SizeAndEvicting(sizeEvict.size, sizeEvict.evicting - 1L))) {
                                --evictedValues;
                                --decEvict;
                                continue block17;
                            }
                            LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(10L));
                            continue;
                        }
                        StrippedConcurrentLinkedDeque.DequeNode removedDequeNode = (StrippedConcurrentLinkedDeque.DequeNode)hirDetails[0];
                        LIRSNode lIRSNode = removedHIR = (LIRSNode)hirDetails[1];
                        synchronized (lIRSNode) {
                            if (removedHIR.queueNode != removedDequeNode) {
                                continue;
                            }
                            removedHIR.setQueueNode(null);
                            switch (removedHIR.state) {
                                case HIR_RESIDENT: {
                                    if (removedHIR.stackNode != null) {
                                        removedHIR.setState(Recency.HIR_NONRESIDENT);
                                        queueContents[i] = removedHIR;
                                    } else {
                                        removedHIR.setState(Recency.EVICTING);
                                        queueContents[i] = removedHIR;
                                    }
                                    foundNode = true;
                                    break;
                                }
                                case REMOVED: {
                                    --evictedValues;
                                    foundNode = true;
                                    break;
                                }
                            }
                        }
                    }
                }
                BoundedEquivalentConcurrentHashMapV8.incrementSizeEviction(this.currentSize, -evictedValues, -decEvict);
                ArrayList<Node<K, V>> removedNodes = new ArrayList<Node<K, V>>(queueContents.length);
                for (int j = 0; j < queueContents.length; ++j) {
                    int i;
                    Node f;
                    int n;
                    LIRSNode evict = queueContents[j];
                    if (evict == null || evict.state != Recency.EVICTING && evict.state != Recency.HIR_NONRESIDENT) continue;
                    int hash = BoundedEquivalentConcurrentHashMapV8.spread(this.map.keyEq.hashCode(evict.getKey()));
                    Node<K, V>[] tab = this.map.table;
                    while (tab != null && (n = tab.length) != 0 && (f = BoundedEquivalentConcurrentHashMapV8.tabAt(tab, i = n - 1 & hash)) != null) {
                        if (f.hash == -1) {
                            tab = this.map.helpTransfer(tab, f);
                            continue;
                        }
                        Node node = f;
                        synchronized (node) {
                            if (BoundedEquivalentConcurrentHashMapV8.tabAt(tab, i) == f) {
                                LIRSNode lIRSNode = evict;
                                synchronized (lIRSNode) {
                                    if (evict.state == Recency.EVICTING) {
                                        evict.setState(Recency.EVICTED);
                                        Object prevValue = this.map.replaceNode(evict.getKey(), null, null, true);
                                        removedNodes.add(new Node(-1, null, evict.getKey(), prevValue, null));
                                    } else if (evict.state == Recency.HIR_NONRESIDENT) {
                                        Node node2 = f.find(hash, evict.getKey());
                                        Object prevValue = node2.val;
                                        if (prevValue != NULL_VALUE) {
                                            node2.val = NULL_VALUE;
                                            ((BoundedEquivalentConcurrentHashMapV8)this.map).addCount(-1L, -1);
                                            Node nonResidentNode = new Node(-1, null, evict.getKey(), prevValue, null);
                                            removedNodes.add(nonResidentNode);
                                            ((BoundedEquivalentConcurrentHashMapV8)this.map).notifyListenerOfRemoval(nonResidentNode, true);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                return removedNodes;
            }
            return Collections.emptySet();
        }

        @Override
        public void onResize(long oldSize, long newSize) {
        }

        @Override
        public void resize(long newSize) {
            this.maximumSize = newSize;
            this.maximumHotSize = LIRSEvictionPolicy.calculateLIRSize(this.maximumSize);
        }
    }

    static final class SizeAndEvicting {
        private final long size;
        private final long evicting;

        public SizeAndEvicting(long size, long evicting) {
            this.size = size;
            this.evicting = evicting;
        }

        public String toString() {
            return "SizeAndEvicting [size=" + this.size + ", evicting=" + this.evicting + "]";
        }
    }

    static final class LIRSNode<K, V>
    implements EvictionEntry<K, V> {
        Recency state;
        StrippedConcurrentLinkedDeque.DequeNode<LIRSNode<K, V>> stackNode;
        StrippedConcurrentLinkedDeque.DequeNode<LIRSNode<K, V>> queueNode;
        boolean created;
        final K key;

        public LIRSNode(K key) {
            this.key = key;
        }

        public void setState(Recency recency) {
            this.state = recency;
        }

        public void setStackNode(StrippedConcurrentLinkedDeque.DequeNode<LIRSNode<K, V>> stackNode) {
            this.stackNode = stackNode;
        }

        public void setQueueNode(StrippedConcurrentLinkedDeque.DequeNode<LIRSNode<K, V>> queueNode) {
            this.queueNode = queueNode;
        }

        public String toString() {
            return "LIRSNode [state=" + (Object)((Object)this.state) + ", stackNode=" + System.identityHashCode(this.stackNode) + ", queueNode=" + System.identityHashCode(this.queueNode) + ", key=" + this.key + "]";
        }

        @Override
        public K getKey() {
            return this.key;
        }
    }

    static interface EvictionEntry<K, V> {
        public K getKey();
    }

    static enum Recency {
        HIR_RESIDENT,
        LIR_RESIDENT,
        HIR_NONRESIDENT,
        EVICTING,
        EVICTED,
        REMOVED;

    }

    static class LRUEvictionPolicy<K, V>
    implements EvictionPolicy<K, V> {
        final BoundedEquivalentConcurrentHashMapV8<K, V> map;
        final StrippedConcurrentLinkedDeque<Node<K, V>> deque = new StrippedConcurrentLinkedDeque();
        volatile long maxSize;
        final AtomicReference<SizeAndEvicting> currentSize = new AtomicReference<SizeAndEvicting>(new SizeAndEvicting(0L, 0L));
        final EntrySizeCalculator<? super K, ? super V> sizeCalculator;
        final boolean countingMemory;
        static final long NODE_ARRAY_BASE_OFFSET = BoundedEquivalentConcurrentHashMapV8.getUnsafe().arrayBaseOffset(Node[].class);
        static final long NODE_ARRAY_OFFSET = BoundedEquivalentConcurrentHashMapV8.getUnsafe().arrayIndexScale(Node[].class);

        public LRUEvictionPolicy(BoundedEquivalentConcurrentHashMapV8<K, V> map, long maxSize, EntrySizeCalculator<? super K, ? super V> sizeCalculator, boolean countingMemory) {
            this.map = map;
            this.maxSize = maxSize;
            this.sizeCalculator = sizeCalculator;
            this.countingMemory = countingMemory;
            if (countingMemory) {
                Unsafe unsafe = BoundedEquivalentConcurrentHashMapV8.getUnsafe();
                long evictionPolicySize = Unsafe.ADDRESS_SIZE + Unsafe.ARRAY_OBJECT_INDEX_SCALE;
                evictionPolicySize += (long)(Unsafe.ARRAY_OBJECT_INDEX_SCALE * 4);
                evictionPolicySize += 9L;
                long mapSize = Unsafe.ADDRESS_SIZE + Unsafe.ARRAY_OBJECT_INDEX_SCALE;
                mapSize += NODE_ARRAY_BASE_OFFSET * 2L;
                mapSize += 28L;
                mapSize += (long)unsafe.arrayBaseOffset(CounterCell[].class);
                BoundedEquivalentConcurrentHashMapV8.incrementSizeEviction(this.currentSize, BoundedEquivalentConcurrentHashMapV8.roundUpToNearest8(evictionPolicySize) + BoundedEquivalentConcurrentHashMapV8.roundUpToNearest8(mapSize += (long)(Unsafe.ADDRESS_SIZE * 8)), 0L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onEntryHitRead(Node<K, V> e, V value) {
            LRUNode eviction;
            LRUNode lRUNode = eviction = (LRUNode)e.eviction;
            synchronized (lRUNode) {
                Node oldItem;
                if (eviction.queueNode != null && !eviction.removed && (oldItem = (Node)eviction.queueNode.item) != null && eviction.queueNode.casItem(oldItem, null)) {
                    this.deque.unlink(eviction.queueNode);
                    StrippedConcurrentLinkedDeque.DequeNode<Node<K, V>> queueNode = new StrippedConcurrentLinkedDeque.DequeNode<Node<K, V>>(e);
                    eviction.queueNode = queueNode;
                    this.deque.linkLast(queueNode);
                }
            }
        }

        @Override
        public void onEntryHitWrite(Node<K, V> e, V value) {
            this.onEntryHitRead(e, value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onEntryMiss(Node<K, V> e, V value) {
            LRUNode eviction;
            LRUNode lRUNode = eviction = (LRUNode)e.eviction;
            synchronized (lRUNode) {
                if (!eviction.removed) {
                    StrippedConcurrentLinkedDeque.DequeNode<Node<K, V>> queueNode = new StrippedConcurrentLinkedDeque.DequeNode<Node<K, V>>(e);
                    eviction.queueNode = queueNode;
                    this.deque.linkLast(queueNode);
                    BoundedEquivalentConcurrentHashMapV8.incrementSizeEviction(this.currentSize, this.sizeCalculator.calculateSize(e.key, value), 0L);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onEntryRemove(Node<K, V> e) {
            LRUNode eviction;
            LRUNode lRUNode = eviction = (LRUNode)e.eviction;
            synchronized (lRUNode) {
                if (eviction.queueNode != null) {
                    Node item = (Node)eviction.queueNode.item;
                    if (item != null && eviction.queueNode.casItem(item, null)) {
                        this.deque.unlink(eviction.queueNode);
                    }
                    eviction.queueNode = null;
                }
                if (!eviction.removed) {
                    eviction.removed = true;
                    BoundedEquivalentConcurrentHashMapV8.incrementSizeEviction(this.currentSize, -this.sizeCalculator.calculateSize(e.key, e.val), 0L);
                }
            }
        }

        @Override
        public Node<K, V> createNewEntry(K key, int hash, Node<K, V> next, V value, EvictionEntry<K, V> evictionEntry) {
            Node<K, V> node = new Node<K, V>(hash, this.map.nodeEq, key, value, next);
            if (evictionEntry == null) {
                node.lazySetEviction(new LRUNode(node));
            } else {
                node.lazySetEviction(evictionEntry);
            }
            return node;
        }

        @Override
        public TreeNode<K, V> createNewEntry(K key, int hash, TreeNode<K, V> next, TreeNode<K, V> parent, V value, EvictionEntry<K, V> evictionEntry) {
            TreeNode treeNode;
            if (evictionEntry == null) {
                treeNode = new TreeNode(hash, this.map.nodeEq, key, value, next, parent, null);
                treeNode.lazySetEviction(new LRUNode(treeNode));
            } else {
                treeNode = new TreeNode(hash, this.map.nodeEq, key, value, next, parent, evictionEntry);
            }
            return treeNode;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection<Node<K, V>> findIfEntriesNeedEvicting() {
            SizeAndEvicting newSize;
            long evicting;
            SizeAndEvicting existingSize;
            long size;
            long extra;
            while ((extra = (size = (existingSize = this.currentSize.get()).size) - (evicting = existingSize.evicting) - this.maxSize) > 0L && !this.currentSize.compareAndSet(existingSize, newSize = new SizeAndEvicting(size, evicting + extra))) {
            }
            List<Node<K, V>> evictedEntries = null;
            if (extra > 0L) {
                evictedEntries = new ArrayList<Node<K, V>>((int)extra & Integer.MAX_VALUE);
                long decCreate = 0L;
                while (decCreate < extra) {
                    Node<K, V> node = this.deque.pollFirst();
                    boolean removed = false;
                    if (node != null) {
                        LRUNode lruNode;
                        LRUNode lRUNode = lruNode = (LRUNode)node.eviction;
                        synchronized (lRUNode) {
                            if (!lruNode.removed) {
                                lruNode.removed = true;
                                removed = true;
                            }
                        }
                    }
                    if (!removed) break;
                    Object value = this.map.replaceNode(node.key, null, null, true);
                    if (value == null) continue;
                    evictedEntries.add(node);
                    decCreate += this.sizeCalculator.calculateSize(node.key, value);
                }
                BoundedEquivalentConcurrentHashMapV8.incrementSizeEviction(this.currentSize, -decCreate, -extra);
            } else {
                evictedEntries = Collections.emptyList();
            }
            return evictedEntries;
        }

        @Override
        public void onResize(long oldSize, long newSize) {
            if (this.countingMemory && newSize > oldSize) {
                BoundedEquivalentConcurrentHashMapV8.incrementSizeEviction(this.currentSize, (newSize - oldSize) * NODE_ARRAY_OFFSET, 0L);
            }
        }

        @Override
        public void resize(long newSize) {
            this.maxSize = newSize;
        }
    }

    static class LRUNode<K, V>
    implements EvictionEntry<K, V> {
        private final Node<K, V> attachedNode;
        StrippedConcurrentLinkedDeque.DequeNode<Node<K, V>> queueNode;
        boolean removed;

        public LRUNode(Node<K, V> item) {
            this.attachedNode = item;
        }

        @Override
        public K getKey() {
            return this.attachedNode.key;
        }
    }

    static class NullEvictionPolicy<K, V>
    implements EvictionPolicy<K, V> {
        private final NodeEquivalence<K, V> nodeEq;

        public NullEvictionPolicy(NodeEquivalence<K, V> nodeEq) {
            this.nodeEq = nodeEq;
        }

        @Override
        public void onEntryMiss(Node<K, V> e, V value) {
        }

        @Override
        public void onEntryRemove(Node<K, V> e) {
        }

        @Override
        public Node<K, V> createNewEntry(K key, int hash, Node<K, V> next, V value, EvictionEntry<K, V> evictionEntry) {
            return new Node<K, V>(hash, this.nodeEq, key, value, next);
        }

        @Override
        public TreeNode<K, V> createNewEntry(K key, int hash, TreeNode<K, V> next, TreeNode<K, V> parent, V value, EvictionEntry<K, V> evictionEntry) {
            return new TreeNode<K, V>(hash, this.nodeEq, key, value, next, parent, evictionEntry);
        }

        @Override
        public Set<Node<K, V>> findIfEntriesNeedEvicting() {
            return Collections.emptySet();
        }

        @Override
        public void onEntryHitRead(Node<K, V> e, V value) {
        }

        @Override
        public void onEntryHitWrite(Node<K, V> e, V value) {
        }

        @Override
        public void onResize(long oldSize, long newSize) {
        }

        @Override
        public void resize(long newSize) {
        }
    }

    public static interface EvictionPolicy<K, V> {
        public Node<K, V> createNewEntry(K var1, int var2, Node<K, V> var3, V var4, EvictionEntry<K, V> var5);

        public TreeNode<K, V> createNewEntry(K var1, int var2, TreeNode<K, V> var3, TreeNode<K, V> var4, V var5, EvictionEntry<K, V> var6);

        public void onEntryMiss(Node<K, V> var1, V var2);

        public void onEntryHitRead(Node<K, V> var1, V var2);

        public void onEntryHitWrite(Node<K, V> var1, V var2);

        public void onEntryRemove(Node<K, V> var1);

        public Collection<Node<K, V>> findIfEntriesNeedEvicting();

        public void onResize(long var1, long var3);

        public void resize(long var1);
    }

    static class NullEvictionListener<K, V>
    implements EvictionListener<K, V> {
        NullEvictionListener() {
        }

        @Override
        public void onEntryEviction(Map<K, V> evicted) {
        }

        @Override
        public void onEntryChosenForEviction(Map.Entry<K, V> entry) {
        }

        @Override
        public void onEntryActivated(Object key) {
        }

        @Override
        public void onEntryRemoved(Map.Entry<K, V> entry) {
        }
    }

    private static final class SingleEntrySizeCalculator
    implements EntrySizeCalculator<Object, Object> {
        private static final SingleEntrySizeCalculator SINGLETON = new SingleEntrySizeCalculator();

        private SingleEntrySizeCalculator() {
        }

        @Override
        public long calculateSize(Object key, Object value) {
            return 1L;
        }
    }

    public static final class NodeSizeCalculatorWrapper<K, V>
    extends AbstractEntrySizeCalculatorHelper<K, V> {
        private final EntrySizeCalculator<? super K, ? super V> calculator;
        private final long nodeAverageSize;

        public NodeSizeCalculatorWrapper(EntrySizeCalculator<? super K, ? super V> calculator) {
            this.calculator = calculator;
            long calculateNodeAverageSize = OBJECT_SIZE + POINTER_SIZE;
            calculateNodeAverageSize += (long)(5 * POINTER_SIZE);
            long lruNodeSize = this.calculateLRUNodeSize();
            this.nodeAverageSize = this.roundUpToNearest8(calculateNodeAverageSize += 4L) + lruNodeSize;
        }

        private long calculateLRUNodeSize() {
            long size = OBJECT_SIZE + POINTER_SIZE;
            size += (long)(2 * POINTER_SIZE);
            long dequeNodeSize = this.calculateDequeNodeSize();
            return this.roundUpToNearest8(++size) + dequeNodeSize;
        }

        private long calculateDequeNodeSize() {
            long size = OBJECT_SIZE + POINTER_SIZE;
            return this.roundUpToNearest8(size += (long)(3 * POINTER_SIZE));
        }

        @Override
        public long calculateSize(K key, V value) {
            long result = this.calculator.calculateSize(key, value) + this.nodeAverageSize;
            if (result < 0L) {
                throw new ArithmeticException("Size overflow!");
            }
            return result;
        }
    }

    public static interface EvictionListener<K, V> {
        public void onEntryEviction(Map<K, V> var1);

        public void onEntryChosenForEviction(Map.Entry<K, V> var1);

        public void onEntryActivated(Object var1);

        public void onEntryRemoved(Map.Entry<K, V> var1);
    }
}

