/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.global.SecurityActions;

public class GlobalStateConfiguration {
    public static final AttributeDefinition<Boolean> ENABLED = AttributeDefinition.builder("enabled", false).immutable().build();
    public static final AttributeDefinition<String> PERSISTENT_LOCATION = AttributeDefinition.builder("persistentLocation", null, String.class).initializer(() -> SecurityActions.getSystemProperty("user.dir")).immutable().build();
    public static final AttributeDefinition<String> TEMPORARY_LOCATION = AttributeDefinition.builder("temporaryLocation", null, String.class).initializer(() -> SecurityActions.getSystemProperty("java.io.tmpdir")).immutable().build();
    private final AttributeSet attributes;
    private final Attribute<Boolean> enabled;
    private Attribute<String> persistentLocation;
    private Attribute<String> temporaryLocation;

    public static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(GlobalStateConfiguration.class, ENABLED, PERSISTENT_LOCATION, TEMPORARY_LOCATION);
    }

    public GlobalStateConfiguration(AttributeSet attributes) {
        this.attributes = attributes.checkProtection();
        this.enabled = attributes.attribute(ENABLED);
        this.persistentLocation = attributes.attribute(PERSISTENT_LOCATION);
        this.temporaryLocation = attributes.attribute(TEMPORARY_LOCATION);
    }

    public boolean enabled() {
        return this.enabled.get();
    }

    public String persistentLocation() {
        return this.persistentLocation.get();
    }

    public String temporaryLocation() {
        return this.temporaryLocation.get();
    }

    AttributeSet attributes() {
        return this.attributes;
    }

    public String toString() {
        return "GlobalStateConfiguration [attributes=" + this.attributes + "]";
    }
}

