/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.functional.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import org.infinispan.commons.api.functional.EntryView;
import org.infinispan.commons.api.functional.MetaParam;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.util.Experimental;
import org.infinispan.commons.util.Util;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.functional.impl.MetaParams;
import org.infinispan.functional.impl.MetaParamsInternalMetadata;
import org.infinispan.metadata.Metadata;

@Experimental
public final class EntryViews {
    private EntryViews() {
    }

    public static <K, V> EntryView.ReadEntryView<K, V> readOnly(CacheEntry<K, V> entry) {
        return new EntryBackedReadOnlyView(entry);
    }

    public static <K, V> EntryView.ReadEntryView<K, V> readOnly(K key, V value, Metadata metadata) {
        return new ReadOnlySnapshotView(key, value, metadata);
    }

    public static <K, V> EntryView.WriteEntryView<V> writeOnly(CacheEntry<K, V> entry) {
        return new EntryBackedWriteOnlyView(entry);
    }

    public static <K, V> EntryView.ReadWriteEntryView<K, V> readWrite(CacheEntry<K, V> entry) {
        return new EntryBackedReadWriteView(entry);
    }

    public static <K, V> EntryView.ReadWriteEntryView<K, V> readWrite(CacheEntry<K, V> entry, V prevValue, Metadata prevMetadata) {
        return new EntryAndPreviousReadWriteView(entry, prevValue, prevMetadata);
    }

    public static <K, V> EntryView.ReadEntryView<K, V> noValue(K key) {
        return new NoValueReadOnlyView(key);
    }

    public static <R> R snapshot(R ret) {
        if (ret instanceof EntryBackedReadWriteView) {
            EntryBackedReadWriteView view = (EntryBackedReadWriteView)ret;
            return (R)new ReadWriteSnapshotView(view.key(), view.entry.getValue(), view.entry.getMetadata());
        }
        if (ret instanceof EntryAndPreviousReadWriteView) {
            EntryAndPreviousReadWriteView view = (EntryAndPreviousReadWriteView)ret;
            return (R)new ReadWriteSnapshotView(view.key(), view.entry.getValue(), view.entry.getMetadata());
        }
        if (ret instanceof EntryBackedReadOnlyView) {
            EntryBackedReadOnlyView view = (EntryBackedReadOnlyView)ret;
            return (R)new ReadOnlySnapshotView(view.key(), view.entry.getValue(), view.entry.getMetadata());
        }
        return ret;
    }

    private static <K, V> MetaParams updateMetaParams(CacheEntry<K, V> entry, MetaParam.Writable[] metas) {
        if (metas.length != 0) {
            MetaParams metaParams = MetaParams.empty();
            metaParams.addMany(metas);
            entry.setMetadata(MetaParamsInternalMetadata.from(metaParams));
            return metaParams;
        }
        MetaParams empty = MetaParams.empty();
        entry.setMetadata(MetaParamsInternalMetadata.from(empty));
        return empty;
    }

    private static <K, V> MetaParams extractMetaParams(CacheEntry<K, V> entry) {
        Metadata metadata = entry.getMetadata();
        if (metadata instanceof MetaParamsInternalMetadata) {
            MetaParamsInternalMetadata metaParamsMetadata = (MetaParamsInternalMetadata)metadata;
            return metaParamsMetadata.params;
        }
        return MetaParams.empty();
    }

    public static final class ReadWriteSnapshotViewExternalizer
    extends AbstractExternalizer<ReadWriteSnapshotView> {
        @Override
        public Integer getId() {
            return 157;
        }

        @Override
        public Set<Class<? extends ReadWriteSnapshotView>> getTypeClasses() {
            return Util.asSet(ReadWriteSnapshotView.class);
        }

        @Override
        public void writeObject(ObjectOutput output, ReadWriteSnapshotView obj) throws IOException {
            output.writeObject(obj.key);
            output.writeObject(obj.value);
            output.writeObject(obj.metadata);
        }

        @Override
        public ReadWriteSnapshotView readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            Object key = input.readObject();
            Object value = input.readObject();
            Metadata metadata = (Metadata)input.readObject();
            return new ReadWriteSnapshotView<Object, Object>(key, value, metadata);
        }
    }

    private static final class ReadWriteSnapshotView<K, V>
    implements EntryView.ReadWriteEntryView<K, V> {
        final K key;
        final V value;
        final Metadata metadata;

        public ReadWriteSnapshotView(K key, V value, Metadata metadata) {
            this.key = key;
            this.value = value;
            this.metadata = metadata;
        }

        @Override
        public K key() {
            return this.key;
        }

        @Override
        public V get() throws NoSuchElementException {
            if (this.value == null) {
                throw new NoSuchElementException("No value present");
            }
            return this.value;
        }

        @Override
        public Optional<V> find() {
            return Optional.ofNullable(this.value);
        }

        @Override
        public <T> Optional<T> findMetaParam(Class<T> type) {
            if (this.metadata instanceof MetaParamsInternalMetadata) {
                MetaParamsInternalMetadata metaParamsMetadata = (MetaParamsInternalMetadata)this.metadata;
                return metaParamsMetadata.findMetaParam(type);
            }
            return Optional.empty();
        }

        @Override
        public Void set(V value, MetaParam.Writable ... metas) {
            throw new IllegalStateException("A read-write entry view cannot be modified outside the scope of a lambda");
        }

        @Override
        public Void remove() {
            throw new IllegalStateException("A read-write entry view cannot be modified outside the scope of a lambda");
        }

        public String toString() {
            return "ReadWriteSnapshotView{key=" + this.key + ", value=" + this.value + ", metadata=" + this.metadata + '}';
        }
    }

    private static final class NoValueReadOnlyView<K, V>
    implements EntryView.ReadEntryView<K, V> {
        final K key;

        public NoValueReadOnlyView(K key) {
            this.key = key;
        }

        @Override
        public K key() {
            return this.key;
        }

        @Override
        public V get() throws NoSuchElementException {
            throw new NoSuchElementException("No value");
        }

        @Override
        public Optional<V> find() {
            return Optional.empty();
        }

        @Override
        public <T> Optional<T> findMetaParam(Class<T> type) {
            return Optional.empty();
        }

        public String toString() {
            return "NoValueReadOnlyView{key=" + this.key + '}';
        }
    }

    private static final class EntryAndPreviousReadWriteView<K, V>
    implements EntryView.ReadWriteEntryView<K, V> {
        final CacheEntry<K, V> entry;
        final V prevValue;
        final Metadata prevMetadata;

        private EntryAndPreviousReadWriteView(CacheEntry<K, V> entry, V prevValue, Metadata prevMetadata) {
            this.entry = entry;
            this.prevValue = prevValue;
            this.prevMetadata = prevMetadata;
        }

        @Override
        public K key() {
            return this.entry.getKey();
        }

        @Override
        public Optional<V> find() {
            return this.prevValue == null ? Optional.empty() : Optional.ofNullable(this.prevValue);
        }

        @Override
        public Void set(V value, MetaParam.Writable ... metas) {
            this.setOnly(value, metas);
            return null;
        }

        private void setOnly(V value, MetaParam.Writable[] metas) {
            this.entry.setValue(value);
            this.entry.setChanged(true);
            EntryViews.updateMetaParams(this.entry, metas);
        }

        @Override
        public Void remove() {
            if (!this.entry.isNull()) {
                this.entry.setRemoved(true);
                this.entry.setChanged(true);
            }
            return null;
        }

        @Override
        public <T> Optional<T> findMetaParam(Class<T> type) {
            Metadata metadata = this.prevMetadata;
            if (metadata instanceof MetaParamsInternalMetadata) {
                MetaParamsInternalMetadata metaParamsMetadata = (MetaParamsInternalMetadata)metadata;
                return metaParamsMetadata.findMetaParam(type);
            }
            return Optional.empty();
        }

        @Override
        public V get() throws NoSuchElementException {
            return this.prevValue;
        }

        public String toString() {
            return "EntryAndPreviousReadWriteView{entry=" + this.entry + ", prevValue=" + this.prevValue + ", prevMetadata=" + this.prevMetadata + '}';
        }
    }

    private static final class EntryBackedReadWriteView<K, V>
    implements EntryView.ReadWriteEntryView<K, V> {
        final CacheEntry<K, V> entry;

        private EntryBackedReadWriteView(CacheEntry<K, V> entry) {
            this.entry = entry;
        }

        @Override
        public K key() {
            return this.entry.getKey();
        }

        @Override
        public Optional<V> find() {
            return this.entry == null ? Optional.empty() : Optional.ofNullable(this.entry.getValue());
        }

        @Override
        public Void set(V value, MetaParam.Writable ... metas) {
            this.setOnly(value, metas);
            return null;
        }

        private void setOnly(V value, MetaParam.Writable[] metas) {
            this.entry.setValue(value);
            this.entry.setChanged(true);
            EntryViews.updateMetaParams(this.entry, metas);
        }

        @Override
        public Void remove() {
            if (!this.entry.isNull()) {
                this.entry.setRemoved(true);
                this.entry.setChanged(true);
            }
            return null;
        }

        @Override
        public <T> Optional<T> findMetaParam(Class<T> type) {
            Metadata metadata = this.entry.getMetadata();
            if (metadata instanceof MetaParamsInternalMetadata) {
                MetaParamsInternalMetadata metaParamsMetadata = (MetaParamsInternalMetadata)metadata;
                return metaParamsMetadata.findMetaParam(type);
            }
            return Optional.empty();
        }

        @Override
        public V get() throws NoSuchElementException {
            if (this.entry == null || this.entry.getValue() == null) {
                throw new NoSuchElementException("No value present");
            }
            return this.entry.getValue();
        }

        public String toString() {
            return "EntryBackedReadWriteView{entry=" + this.entry + '}';
        }
    }

    private static final class EntryBackedWriteOnlyView<K, V>
    implements EntryView.WriteEntryView<V> {
        final CacheEntry<K, V> entry;

        private EntryBackedWriteOnlyView(CacheEntry<K, V> entry) {
            this.entry = entry;
        }

        @Override
        public Void set(V value, MetaParam.Writable ... metas) {
            this.entry.setValue(value);
            this.entry.setChanged(true);
            EntryViews.updateMetaParams(this.entry, metas);
            return null;
        }

        @Override
        public Void remove() {
            this.entry.setRemoved(true);
            this.entry.setChanged(true);
            return null;
        }

        public String toString() {
            return "EntryBackedWriteOnlyView{entry=" + this.entry + '}';
        }
    }

    private static final class ReadOnlySnapshotView<K, V>
    implements EntryView.ReadEntryView<K, V> {
        final K key;
        final V value;
        final Metadata metadata;

        private ReadOnlySnapshotView(K key, V value, Metadata metadata) {
            this.key = key;
            this.value = value;
            this.metadata = metadata;
        }

        @Override
        public K key() {
            return this.key;
        }

        @Override
        public V get() throws NoSuchElementException {
            if (this.value == null) {
                throw new NoSuchElementException("No value");
            }
            return this.value;
        }

        @Override
        public Optional<V> find() {
            return Optional.ofNullable(this.value);
        }

        @Override
        public <T> Optional<T> findMetaParam(Class<T> type) {
            if (this.metadata instanceof MetaParamsInternalMetadata) {
                MetaParamsInternalMetadata metaParamsMetadata = (MetaParamsInternalMetadata)this.metadata;
                return metaParamsMetadata.findMetaParam(type);
            }
            return Optional.empty();
        }

        public String toString() {
            return "ReadOnlySnapshotView{key=" + this.key + ", value=" + this.value + ", metadata=" + this.metadata + '}';
        }
    }

    private static final class EntryBackedReadOnlyView<K, V>
    implements EntryView.ReadEntryView<K, V> {
        final CacheEntry<K, V> entry;

        private EntryBackedReadOnlyView(CacheEntry<K, V> entry) {
            this.entry = entry;
        }

        @Override
        public K key() {
            return this.entry.getKey();
        }

        @Override
        public Optional<V> find() {
            return this.entry == null ? Optional.empty() : Optional.ofNullable(this.entry.getValue());
        }

        @Override
        public V get() throws NoSuchElementException {
            if (this.entry == null || this.entry.getValue() == null) {
                throw new NoSuchElementException("No value present");
            }
            return this.entry.getValue();
        }

        @Override
        public <T> Optional<T> findMetaParam(Class<T> type) {
            Metadata metadata = this.entry.getMetadata();
            if (metadata instanceof MetaParamsInternalMetadata) {
                MetaParamsInternalMetadata metaParamsMetadata = (MetaParamsInternalMetadata)metadata;
                return metaParamsMetadata.findMetaParam(type);
            }
            return Optional.empty();
        }

        public String toString() {
            return "EntryBackedReadOnlyView{entry=" + this.entry + '}';
        }
    }
}

