/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.iteration.impl;

import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.util.CloseableIterable;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.Closeables;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.filter.CacheFilters;
import org.infinispan.filter.Converter;
import org.infinispan.filter.KeyValueFilter;
import org.infinispan.filter.KeyValueFilterConverter;
import org.infinispan.iteration.impl.RemovableEntryIterator;
import org.infinispan.util.concurrent.ConcurrentHashSet;

public class TrackingEntryIterableFromStream<K, V, C>
implements CloseableIterable<CacheEntry<K, C>> {
    protected final KeyValueFilter<? super K, ? super V> filter;
    protected final Converter<? super K, ? super V, C> converter;
    protected final AdvancedCache<K, V> cache;
    protected final AtomicBoolean closed = new AtomicBoolean(false);
    protected final Set<Stream<?>> streams = new ConcurrentHashSet();

    public TrackingEntryIterableFromStream(KeyValueFilter<? super K, ? super V> filter, Converter<? super K, ? super V, C> converter, EnumSet<Flag> flags, Cache<K, V> cache) {
        if (cache == null) {
            throw new NullPointerException("Cache cannot be null!");
        }
        if (filter == null) {
            throw new NullPointerException("Filter cannot be null!");
        }
        this.filter = filter;
        this.converter = converter;
        AdvancedCache<K, V> advancedCache = cache.getAdvancedCache();
        this.cache = flags != null ? advancedCache.withFlags(flags.toArray(new Flag[flags.size()])) : advancedCache;
    }

    @Override
    public void close() {
        this.closed.set(true);
        for (Stream<?> stream : this.streams) {
            stream.close();
        }
    }

    private Stream<CacheEntry<K, C>> applyFilterConverter(Stream<CacheEntry<K, V>> stream) {
        Stream<CacheEntry<Object, C>> resultingStream;
        if (this.filter instanceof KeyValueFilterConverter && (this.filter == this.converter || this.converter == null)) {
            resultingStream = CacheFilters.filterAndConvert(stream, (KeyValueFilterConverter)this.filter);
        } else {
            if (this.filter != null) {
                stream = stream.filter(CacheFilters.predicate(this.filter));
            }
            resultingStream = this.converter != null ? stream.map(CacheFilters.function(this.converter)) : stream;
        }
        return resultingStream;
    }

    @Override
    public CloseableIterator<CacheEntry<K, C>> iterator() {
        if (this.closed.get()) {
            throw new IllegalStateException("Iterable has been closed - cannot be reused");
        }
        Stream stream = this.cache.getAdvancedCache().cacheEntrySet().stream();
        CloseableIterator iterator = Closeables.iterator(this.applyFilterConverter(stream));
        this.streams.add(stream);
        if (this.closed.get()) {
            iterator.close();
            throw new IllegalStateException("Iterable has been closed - cannot be reused");
        }
        return new RemovableEntryIterator(iterator, this.cache, true);
    }
}

