/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.configuration;

import java.util.Map;
import java.util.Properties;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.configuration.parsing.XmlConfigHelper;
import org.infinispan.persistence.jdbc.configuration.AbstractJdbcStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.ConnectionFactoryConfiguration;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfiguration;
import org.infinispan.persistence.jdbc.configuration.ManagedConnectionFactoryConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.PooledConnectionFactoryConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.TableManipulationConfigurationBuilder;
import org.infinispan.persistence.keymappers.Key2StringMapper;

public class JdbcStringBasedStoreConfigurationBuilder
extends AbstractJdbcStoreConfigurationBuilder<JdbcStringBasedStoreConfiguration, JdbcStringBasedStoreConfigurationBuilder> {
    private StringTableManipulationConfigurationBuilder table = new StringTableManipulationConfigurationBuilder(this);

    public JdbcStringBasedStoreConfigurationBuilder(PersistenceConfigurationBuilder builder) {
        super(builder, JdbcStringBasedStoreConfiguration.attributeDefinitionSet());
    }

    @Override
    public JdbcStringBasedStoreConfigurationBuilder self() {
        return this;
    }

    public JdbcStringBasedStoreConfigurationBuilder key2StringMapper(String key2StringMapper) {
        this.attributes.attribute(JdbcStringBasedStoreConfiguration.KEY2STRING_MAPPER).set(key2StringMapper);
        return this;
    }

    public JdbcStringBasedStoreConfigurationBuilder key2StringMapper(Class<? extends Key2StringMapper> klass) {
        this.key2StringMapper(klass.getName());
        return this;
    }

    public StringTableManipulationConfigurationBuilder table() {
        return this.table;
    }

    @Override
    public JdbcStringBasedStoreConfigurationBuilder withProperties(Properties props) {
        Map<Object, Object> unrecognized = XmlConfigHelper.setAttributes(this.attributes, props, false, false);
        unrecognized = XmlConfigHelper.setAttributes(this.table.attributes(), unrecognized, false, false);
        XmlConfigHelper.showUnrecognizedAttributes(unrecognized);
        this.attributes.attribute(JdbcStringBasedStoreConfiguration.PROPERTIES).set(TypedProperties.toTypedProperties(props));
        return this;
    }

    @Override
    public JdbcStringBasedStoreConfiguration create() {
        return new JdbcStringBasedStoreConfiguration(this.attributes.protect(), this.async.create(), this.singletonStore.create(), this.connectionFactory != null ? (ConnectionFactoryConfiguration)this.connectionFactory.create() : null, this.table.create());
    }

    @Override
    public Builder<?> read(JdbcStringBasedStoreConfiguration template) {
        super.read(template);
        this.table.read(template.table());
        return this;
    }

    @Override
    public String toString() {
        return "JdbcStringBasedStoreConfigurationBuilder [table=" + this.table + ", connectionFactory=" + this.connectionFactory + ", attributes=" + this.attributes + ", async=" + this.async + ", singletonStore=" + this.singletonStore + "]";
    }

    public class StringTableManipulationConfigurationBuilder
    extends TableManipulationConfigurationBuilder<JdbcStringBasedStoreConfigurationBuilder, StringTableManipulationConfigurationBuilder> {
        StringTableManipulationConfigurationBuilder(AbstractJdbcStoreConfigurationBuilder<?, JdbcStringBasedStoreConfigurationBuilder> builder) {
            super(builder);
        }

        @Override
        public StringTableManipulationConfigurationBuilder self() {
            return this;
        }

        @Override
        public PooledConnectionFactoryConfigurationBuilder<JdbcStringBasedStoreConfigurationBuilder> connectionPool() {
            return JdbcStringBasedStoreConfigurationBuilder.this.connectionPool();
        }

        @Override
        public ManagedConnectionFactoryConfigurationBuilder<JdbcStringBasedStoreConfigurationBuilder> dataSource() {
            return JdbcStringBasedStoreConfigurationBuilder.this.dataSource();
        }
    }
}

